/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import java.util.Comparator;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.type;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;

public class SmallSet<T>
implements Destructors.ClassWithDestructor {
    private final int N;
    private SmallVector<T> Vector;
    private std.set<T> Set;

    public SmallSet(int N) {
        this(N, null);
    }

    public SmallSet(int N, Comparator<T> C) {
        this.N = N;
        this.Vector = new SmallVector(N);
        this.Set = new std.set(C);
    }

    public SmallSet(SmallSet<T> other) {
        this.N = other.N;
        this.Vector = new SmallVector<T>(other.Vector);
        this.Set = new std.set(other.Set);
    }

    public boolean empty() {
        return this.Vector.empty() && this.Set.empty();
    }

    public int size() {
        return this.isSmall() ? this.Vector.size() : this.Set.size();
    }

    public int count(T V) {
        if (this.isSmall()) {
            return Native.$noteq_iter(this.vfind(V), (abstract_iterator)this.Vector.end()) ? 1 : 0;
        }
        return this.Set.count(V) ? 1 : 0;
    }

    public boolean insert(T V) {
        if (!this.isSmall()) {
            return this.Set.insert(V).second;
        }
        SmallVectorImpl.iterator<T> I = this.vfind(V);
        if (Native.$noteq_iter(I, (abstract_iterator)this.Vector.end())) {
            return false;
        }
        if (this.Vector.size() < this.N) {
            this.Vector.push_back(V);
            return true;
        }
        while (!this.Vector.empty()) {
            this.Set.insert(this.Vector.back());
            this.Vector.pop_back();
        }
        this.Set.insert(V);
        return true;
    }

    public <IterT extends type.iterator<?, T>> void insert(IterT I, IterT E) {
        while (Native.$noteq_iter(I, E)) {
            this.insert(I.$star());
            I.$preInc();
        }
    }

    public boolean erase(T V) {
        if (!this.isSmall()) {
            return this.Set.erase(V);
        }
        Object I = this.Vector.begin();
        Object E = this.Vector.end();
        while (Native.$noteq_iter((abstract_iterator)I, (abstract_iterator)E)) {
            if (Native.$eq((Object)I, V)) {
                this.Vector.erase((SmallVectorImpl.iterator)I);
                return true;
            }
            ((SmallVectorImpl.iterator)I).$preInc();
        }
        return false;
    }

    public void clear() {
        this.Vector.clear();
        this.Set.clear();
    }

    private boolean isSmall() {
        return this.Set.empty();
    }

    private SmallVectorImpl.iterator<T> vfind(T V) {
        Object I = this.Vector.begin();
        Object E = this.Vector.end();
        while (Native.$noteq_iter((abstract_iterator)I, (abstract_iterator)E)) {
            if (Native.$eq(((SmallVectorImpl.iterator)I).$star(), V)) {
                return I;
            }
            ((SmallVectorImpl.iterator)I).$preInc();
        }
        return this.Vector.end();
    }

    public void $destroy() {
        this.Vector.$destroy();
        this.Set.$destroy();
    }
}

