/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Arrays;
import java.util.Iterator;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.JavaIterator;
import org.clank.support.aliases.type;
import org.llvm.adt.aliases.DenseMapBaseULongType;
import org.llvm.adt.aliases.DenseMapInfoULong;
import org.llvm.support.llvm;

public class DenseMapULongType<ValueT>
extends DenseMapBaseULongType<DenseMapULongType<ValueT>, ValueT>
implements Native.assignable<DenseMapULongType<ValueT>>,
Iterable<std_pair.pairULongType<ValueT>>,
Destructors.ClassWithDestructor {
    private std_pair.pairULongType<ValueT>[] Buckets;
    private int NumEntries;
    private int NumTombstones;
    private int NumBuckets;

    public DenseMapULongType(DenseMapInfoULong keyInfo, ValueT defaultValue) {
        this(keyInfo, 0, defaultValue);
    }

    public DenseMapULongType(DenseMapInfoULong keyInfo, int NumInitBuckets, ValueT defaultValue) {
        super(keyInfo, defaultValue);
        this.init(NumInitBuckets);
    }

    public DenseMapULongType(DenseMapULongType<ValueT> other) {
        super(other.keyInfoT, other.defaultValue);
        this.init(0);
        this.copyFrom(other);
    }

    public DenseMapULongType(DenseMapInfoULong keyInfo, type.iterator<?, std_pair.pairULongType<ValueT>> I, type.iterator<?, std_pair.pairULongType<ValueT>> E, ValueT defaultValue) {
        super(keyInfo, defaultValue);
        this.init(llvm.NextPowerOf2(std.distance(I, E)));
        this.insert(I, E);
    }

    public void $destroy() {
        this.destroyAll();
    }

    public void swap(DenseMapULongType<ValueT> RHS) {
        std_pair.pairULongType<ValueT>[] BucketsOther = RHS.Buckets;
        RHS.Buckets = this.Buckets;
        this.Buckets = BucketsOther;
        int NumBucketsOther = RHS.NumBuckets;
        RHS.NumBuckets = this.NumBuckets;
        this.NumBuckets = NumBucketsOther;
        int NumEntriesOther = RHS.NumEntries;
        RHS.NumEntries = this.NumEntries;
        this.NumEntries = NumEntriesOther;
        int NumTombstonesOther = RHS.NumTombstones;
        RHS.NumTombstones = this.NumTombstones;
        this.NumTombstones = NumTombstonesOther;
    }

    public DenseMapULongType<ValueT> $assign(DenseMapULongType<ValueT> other) {
        this.copyFrom(other);
        return this;
    }

    public void copyFrom(DenseMapULongType<ValueT> other) {
        this.destroyAll();
        if (this.allocateBuckets(other.NumBuckets)) {
            super.copyFrom(other);
        } else {
            this.NumEntries = 0;
            this.NumTombstones = 0;
        }
    }

    public void init(int InitBuckets) {
        if (this.allocateBuckets(InitBuckets)) {
            super.initEmpty();
        } else {
            this.NumEntries = 0;
            this.NumTombstones = 0;
        }
    }

    @Override
    public void grow(int AtLeast) {
        int OldNumBuckets = this.NumBuckets;
        std_pair.pairULongType<ValueT>[] OldBuckets = this.Buckets;
        this.allocateBuckets(std.max((int)64, (int)llvm.NextPowerOf2(AtLeast - 1)));
        if (OldBuckets == null) {
            super.initEmpty();
            return;
        }
        this.moveFromOldBuckets(OldBuckets, OldNumBuckets);
    }

    @Override
    public void shrink_and_clear() {
        int OldNumEntries = this.NumEntries;
        this.destroyAll();
        int NewNumBuckets = 0;
        if (OldNumEntries != 0) {
            NewNumBuckets = std.max((int)64, (int)(1 << llvm.Log2_32_Ceil(OldNumEntries) + 1));
        }
        if (NewNumBuckets == this.NumBuckets) {
            super.initEmpty();
            return;
        }
        this.init(NewNumBuckets);
    }

    @Override
    protected int getNumEntries() {
        return this.NumEntries;
    }

    @Override
    protected void setNumEntries(int Num) {
        this.NumEntries = Num;
    }

    @Override
    protected int getNumTombstones() {
        return this.NumTombstones;
    }

    @Override
    protected void setNumTombstones(int Num) {
        this.NumTombstones = Num;
    }

    @Override
    protected type.ptr<std_pair.pairULongType<ValueT>> getBuckets() {
        return NativePointer.create_type$ptr((Object[])this.Buckets);
    }

    @Override
    protected std_pair.pairULongType<ValueT>[] $Buckets() {
        return this.Buckets;
    }

    @Override
    protected int getNumBuckets() {
        return this.NumBuckets;
    }

    private boolean allocateBuckets(int Num) {
        this.NumBuckets = Num;
        if (this.NumBuckets == 0) {
            this.Buckets = null;
            return false;
        }
        std_pair.pairULongType[] bucketsArray = new std_pair.pairULongType[this.NumBuckets];
        for (int i = 0; i < this.NumBuckets; ++i) {
            bucketsArray[i] = new std_pair.pairULongType();
        }
        this.Buckets = bucketsArray;
        return true;
    }

    @Override
    public Iterator<std_pair.pairULongType<ValueT>> iterator() {
        return new JavaIterator(this.begin(), this.end());
    }

    public String toString() {
        return "DenseMap{Buckets=[\n" + Arrays.toString(this.Buckets) + "\n], NumEntries=" + this.NumEntries + ", NumTombstones=" + this.NumTombstones + ", NumBuckets=" + this.NumBuckets + '}';
    }
}

