/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjarproject;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.AttachingDICookie;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerDebugInfo;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarProject;
import org.netbeans.modules.j2ee.ejbjarproject.ui.customizer.EjbJarProjectProperties;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.project.BaseActionProvider;
import org.netbeans.modules.javaee.project.api.ant.ui.J2EEProjectProperties;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.project.classpath.support.ProjectClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

public class EjbJarActionProvider
extends BaseActionProvider {
    private static final String DIRECTORY_DEPLOYMENT_SUPPORTED = "directory.deployment.supported";
    private static final String COMMAND_VERIFY = "verify";
    private static final String[] supportedActions = new String[]{"build", "clean", "rebuild", "compile.single", "run", "run.single", "debug", "debug.single", "profile", "profile.single", "redeploy", "javadoc", "test", "test.single", "debug.test.single", "profile.test.single", "run.single.method", "debug.single.method", "debug.fix", "verify", "delete", "copy", "move", "rename"};
    private static final String[] platformSensitiveActions = new String[]{"build", "rebuild", "compile.single", "run.single", "debug.single", "profile.single", "javadoc", "test", "test.single", "debug.test.single", "profile.test.single", "run.single.method", "debug.single.method"};
    private final EjbJarProject project;
    private Set<String> bkgScanSensitiveActions;
    private Set<String> needJavaModelActions;
    private static final String[] actionsDisabledForQuickRun = new String[]{"compile.single", "debug.fix"};
    private Map<String, String[]> commands;

    public EjbJarActionProvider(EjbJarProject project, UpdateHelper updateHelper) {
        super((Project)project, updateHelper, project.evaluator(), project.getSourceRoots(), project.getTestSourceRoots(), project.getAntProjectHelper(), (BaseActionProvider.Callback)new CallbackImpl(new BaseActionProvider.CallbackImpl(project.getClassPathProvider()), project.getEjbModule()));
        this.project = project;
        this.commands = new HashMap<String, String[]>();
        this.commands.put("build", new String[]{"dist"});
        this.commands.put("clean", new String[]{"clean"});
        this.commands.put("rebuild", new String[]{"clean", "dist"});
        this.commands.put("compile.single", new String[]{"compile-single"});
        this.commands.put("run", new String[]{"run"});
        this.commands.put("run.single", new String[]{"run-main"});
        this.commands.put("redeploy", new String[]{"run"});
        this.commands.put("debug", new String[]{"debug"});
        this.commands.put("profile", new String[]{"profile"});
        this.commands.put("javadoc", new String[]{"javadoc"});
        this.commands.put("test", new String[]{"test"});
        this.commands.put("test.single", new String[]{"test-single"});
        this.commands.put("debug.test.single", new String[]{"debug-test"});
        this.commands.put("debug.fix", new String[]{"debug-fix"});
        this.commands.put(COMMAND_VERIFY, new String[]{COMMAND_VERIFY});
        this.commands.put("debug.single", new String[]{"debug-single"});
        this.commands.put("profile.single", new String[]{"profile-single"});
        this.bkgScanSensitiveActions = new HashSet<String>(Arrays.asList("run.single"));
        this.needJavaModelActions = new HashSet<String>(Arrays.asList("debug.fix"));
        this.setServerExecution(true);
    }

    protected String[] getPlatformSensitiveActions() {
        return platformSensitiveActions;
    }

    protected String[] getActionsDisabledForQuickRun() {
        return actionsDisabledForQuickRun;
    }

    public Map<String, String[]> getCommands() {
        return this.commands;
    }

    protected Set<String> getScanSensitiveActions() {
        return this.bkgScanSensitiveActions;
    }

    protected Set<String> getJavaModelActions() {
        return this.needJavaModelActions;
    }

    protected boolean isCompileOnSaveEnabled() {
        return Boolean.parseBoolean(this.getEvaluator().getProperty("j2ee.compile.on.save"));
    }

    public String[] getSupportedActions() {
        return (String[])supportedActions.clone();
    }

    protected void updateJavaRunnerClasspath(String command, Map<String, Object> execProperties) {
        if ("test.single".equals(command) || "debug.test.single".equals(command) || "debug.single.method".equals(command) || "run.single.method".equals(command) || "run.single".equals(command) || "debug.single".equals(command) || "profile.single".equals(command) || "profile.test.single".equals(command)) {
            String s;
            FileObject fo = (FileObject)execProperties.get("execute.file");
            ClassPath cp = this.getCallback().findClassPath(fo, "classpath/execute");
            ClassPath cp2 = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)FileUtil.toFile((FileObject)this.getProject().getProjectDirectory()), (PropertyEvaluator)this.getEvaluator(), (String[])new String[]{"j2ee.platform.classpath", "j2ee.platform.embeddableejb.classpath"}));
            cp = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{cp, cp2});
            execProperties.put("execute.classpath", cp);
            LinkedList<String> coll = (LinkedList<String>)execProperties.get("run.jvmargs");
            if (coll == null) {
                coll = new LinkedList<String>();
                execProperties.put("run.jvmargs", coll);
            }
            if ((s = this.getEvaluator().getProperty("runmain.jvmargs")) != null && s.trim().length() > 0) {
                coll.add(s);
            }
            if ((s = this.getEvaluator().getProperty("endorsed.classpath")) != null && s.trim().length() > 0) {
                ClassPath ecp = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)FileUtil.toFile((FileObject)this.getProject().getProjectDirectory()), (PropertyEvaluator)this.getEvaluator(), (String[])new String[]{"endorsed.classpath"}));
                coll.add("-Xbootclasspath/p:\"" + ecp.toString(ClassPath.PathConversionMode.WARN) + "\"");
            }
        }
    }

    public String[] getTargetNames(String command, Lookup context, Properties p, boolean doJavaChecks) throws IllegalArgumentException {
        if (command.equals("run.single") || command.equals("run") || command.equals("redeploy") || command.equals("debug") || command.equals("debug.single") || command.equals("debug.fix") || command.equals("test.single") || command.equals("debug.test.single") || command.equals("profile") || command.equals("profile.single") || command.equals("profile.test.single")) {
            this.setDirectoryDeploymentProperty(p);
        }
        if (command.equals("run.single") || command.equals("debug.single") || command.equals("profile.single") ? !this.checkSelectedServer(command.equals("debug.single"), command.equals("profile.single")) : (command.equals("profile") ? !this.checkSelectedServer(false, true) : command.equals("debug") && !this.checkSelectedServer(true, false))) {
            return null;
        }
        if (command.equals("run") || command.equals("redeploy")) {
            if (!this.checkSelectedServer(false, false)) {
                return null;
            }
            if (this.isDebugged()) {
                p.setProperty("is.debugged", "true");
            }
            if (command.equals("redeploy")) {
                p.setProperty("forceRedeploy", "true");
            } else {
                p.setProperty("forceRedeploy", "false");
            }
            return this.commands.get(command);
        }
        return super.getTargetNames(command, context, p, doJavaChecks);
    }

    private void setDirectoryDeploymentProperty(Properties p) {
        String instance = this.getAntProjectHelper().getStandardPropertyEvaluator().getProperty("j2ee.server.instance");
        if (instance != null) {
            J2eeModuleProvider jmp = (J2eeModuleProvider)this.getProject().getLookup().lookup(J2eeModuleProvider.class);
            String sdi = jmp.getServerInstanceID();
            J2eeModule mod = jmp.getJ2eeModule();
            if (sdi != null && mod != null) {
                boolean cFD = Deployment.getDefault().canFileDeploy(instance, mod);
                p.setProperty(DIRECTORY_DEPLOYMENT_SUPPORTED, "" + cFD);
            }
        }
    }

    public boolean isActionEnabled(String command, Lookup context) {
        boolean res = super.isActionEnabled(command, context);
        if (res && command.equals(COMMAND_VERIFY)) {
            return ((EjbJarProject)this.getProject()).getEjbModule().hasVerifierSupport();
        }
        return res;
    }

    private boolean isDebugged() {
        J2eeModuleProvider jmp = (J2eeModuleProvider)this.getProject().getLookup().lookup(J2eeModuleProvider.class);
        ServerDebugInfo sdi = jmp.getServerDebugInfo();
        if (sdi == null) {
            return false;
        }
        Session[] sessions = DebuggerManager.getDebuggerManager().getSessions();
        for (int i = 0; i < sessions.length; ++i) {
            Object o;
            Session s = sessions[i];
            if (s == null || (o = s.lookupFirst(null, AttachingDICookie.class)) == null) continue;
            AttachingDICookie attCookie = (AttachingDICookie)o;
            if (!("dt_shmem".equals(sdi.getTransport()) ? attCookie.getSharedMemoryName().equalsIgnoreCase(sdi.getShmemName()) : sdi.getHost() != null && sdi.getHost().equalsIgnoreCase(attCookie.getHostName()) && attCookie.getPortNumber() == sdi.getPort())) continue;
            return true;
        }
        return false;
    }

    private boolean checkSelectedServer(boolean checkDebug, boolean checkProfile) {
        return J2EEProjectProperties.checkSelectedServer((Project)this.getProject(), (AntProjectHelper)this.getAntProjectHelper(), (Profile)this.project.getAPIEjbJar().getJ2eeProfile(), (J2eeModule.Type)J2eeModule.Type.EJB, (J2EEProjectProperties.SetServerInstanceCallback)new J2EEProjectProperties.SetServerInstanceCallback(){

            public void setServerInstance(String serverInstanceId) {
                EjbJarActionProvider.this.setServerInstance(serverInstanceId);
            }
        }, (boolean)checkDebug, (boolean)checkProfile, (boolean)false);
    }

    private void setServerInstance(String serverInstanceId) {
        EjbJarProjectProperties.setServerInstance((EjbJarProject)this.getProject(), this.getAntProjectHelper(), serverInstanceId);
    }

    public static EjbJarActionProvider create(@NonNull Lookup lkp) {
        Parameters.notNull((CharSequence)"lkp", (Object)lkp);
        EjbJarProject project = (EjbJarProject)lkp.lookup(EjbJarProject.class);
        EjbJarActionProvider ejbActionProvider = new EjbJarActionProvider(project, project.getUpdateHelper());
        ejbActionProvider.startFSListener();
        return ejbActionProvider;
    }

    private static class CallbackImpl
    implements BaseActionProvider.Callback2 {
        private final BaseActionProvider.CallbackImpl impl;
        private final J2eeModuleProvider provider;

        public CallbackImpl(BaseActionProvider.CallbackImpl impl, J2eeModuleProvider provider) {
            this.impl = impl;
            this.provider = provider;
        }

        public ClassPath getProjectSourcesClassPath(String type) {
            return this.impl.getProjectSourcesClassPath(type);
        }

        public ClassPath findClassPath(FileObject file, String type) {
            return this.impl.findClassPath(file, type);
        }

        public void antTargetInvocationFailed(String command, Lookup context) {
            Deployment.getDefault().resumeDeployOnSave(this.provider);
        }

        public void antTargetInvocationFinished(String command, Lookup context, int result) {
            Deployment.getDefault().resumeDeployOnSave(this.provider);
        }

        public void antTargetInvocationStarted(String command, Lookup context) {
            Deployment.getDefault().suspendDeployOnSave(this.provider);
        }
    }
}

