/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.client;

import java.awt.Container;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.wsitconf.api.WSITConfigProvider;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityCheckerRegistry;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.websvc.wsstack.api.WSStackVersion;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class STSClientPanel
extends SectionInnerPanel {
    private Node node;
    private Binding binding;
    private boolean inSync = false;
    private JaxWsModel jaxwsmodel;
    private Project project;
    private JLabel endpointLabel;
    private JTextField endpointTextField;
    private JTextField metadataField;
    private JLabel metadataLabel;
    private JLabel namespaceLabel;
    private JTextField namespaceTextField;
    private JLabel portNameLabel;
    private JTextField portNameTextField;
    private JLabel serviceNameLabel;
    private JTextField serviceNameTextField;
    private JCheckBox shareTokenChBox;
    private JComboBox trustVersionCombo;
    private JLabel trustVersionLabel;
    private JLabel wsdlLocationLabel;
    private JTextField wsdlLocationTextField;

    public STSClientPanel(SectionView view, Node node, Binding binding, JaxWsModel jaxWsModel) {
        super(view);
        this.node = node;
        this.binding = binding;
        this.jaxwsmodel = jaxWsModel;
        FileObject fo = (FileObject)node.getLookup().lookup(FileObject.class);
        if (fo != null) {
            this.project = FileOwnerQuery.getOwner((FileObject)fo);
        }
        this.initComponents();
        this.shareTokenChBox.setToolTipText(NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_ShareToken_Tooltip"));
        this.inSync = true;
        this.trustVersionCombo.addItem(ComboConstants.TRUST_10);
        this.trustVersionCombo.addItem(ComboConstants.TRUST_13);
        this.inSync = false;
        this.addImmediateModifier(this.endpointTextField);
        this.addImmediateModifier(this.namespaceTextField);
        this.addImmediateModifier(this.portNameTextField);
        this.addImmediateModifier(this.serviceNameTextField);
        this.addImmediateModifier(this.wsdlLocationTextField);
        this.addImmediateModifier(this.metadataField);
        this.addImmediateModifier(this.trustVersionCombo);
        this.addImmediateModifier(this.shareTokenChBox);
        this.sync();
    }

    public void sync() {
        String wstVersion;
        String wsdlLocation;
        String serviceName;
        String portName;
        String namespace;
        String metadata;
        this.inSync = true;
        String endpoint = ProprietarySecurityPolicyModelHelper.getPreSTSEndpoint(this.binding);
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
        if ((metadata = ProprietarySecurityPolicyModelHelper.getPreSTSMetadata(this.binding)) != null) {
            this.setMetadata(metadata);
        }
        if ((namespace = ProprietarySecurityPolicyModelHelper.getPreSTSNamespace(this.binding)) != null) {
            this.setNamespace(namespace);
        }
        if ((portName = ProprietarySecurityPolicyModelHelper.getPreSTSPortName(this.binding)) != null) {
            this.setPortName(portName);
        }
        if ((serviceName = ProprietarySecurityPolicyModelHelper.getPreSTSServiceName(this.binding)) != null) {
            this.setServiceName(serviceName);
        }
        if ((wsdlLocation = ProprietarySecurityPolicyModelHelper.getPreSTSWsdlLocation(this.binding)) != null) {
            this.setWsdlLocation(wsdlLocation);
        }
        if ((wstVersion = ProprietarySecurityPolicyModelHelper.getPreSTSWstVersion(this.binding)) != null) {
            this.setWstVersion(wstVersion);
        }
        boolean shareToken = ProprietarySecurityPolicyModelHelper.isPreSTSShareToken(this.binding);
        this.setShareToken(shareToken);
        this.inSync = false;
    }

    private String getEndpoint() {
        return this.endpointTextField.getText();
    }

    private void setEndpoint(String url) {
        this.endpointTextField.setText(url);
    }

    private String getMetadata() {
        return this.metadataField.getText();
    }

    private void setMetadata(String url) {
        this.metadataField.setText(url);
    }

    private boolean isShareToken() {
        return this.shareTokenChBox.isSelected();
    }

    private void setShareToken(boolean shareToken) {
        this.shareTokenChBox.setSelected(shareToken);
    }

    private String getNamespace() {
        return this.namespaceTextField.getText();
    }

    private void setNamespace(String ns) {
        this.namespaceTextField.setText(ns);
    }

    private String getServiceName() {
        return this.serviceNameTextField.getText();
    }

    private void setServiceName(String sname) {
        this.serviceNameTextField.setText(sname);
    }

    private String getPortName() {
        return this.portNameTextField.getText();
    }

    private void setPortName(String pname) {
        this.portNameTextField.setText(pname);
    }

    private String getWsdlLocation() {
        return this.wsdlLocationTextField.getText();
    }

    private void setWsdlLocation(String wsdlLocation) {
        this.wsdlLocationTextField.setText(wsdlLocation);
    }

    private String getWstVersion() {
        if (ComboConstants.TRUST_13.equals(this.trustVersionCombo.getSelectedItem())) {
            return ComboConstants.TRUST_13_POLICYSTR;
        }
        return ComboConstants.TRUST_10_POLICYSTR;
    }

    private void setWstVersion(String wstVersion) {
        if (ComboConstants.TRUST_13_POLICYSTR.equals(wstVersion)) {
            this.trustVersionCombo.setSelectedItem(ComboConstants.TRUST_13);
        } else {
            this.trustVersionCombo.setSelectedItem(ComboConstants.TRUST_10);
        }
    }

    public void setValue(JComponent source, Object value) {
        if (!this.inSync) {
            Util.checkMetroLibrary(this.project);
            if (source.equals(this.endpointTextField)) {
                String endpoint = this.getEndpoint();
                if (endpoint != null && endpoint.length() == 0) {
                    ProprietarySecurityPolicyModelHelper.setPreSTSEndpoint(this.binding, null);
                } else {
                    ProprietarySecurityPolicyModelHelper.setPreSTSEndpoint(this.binding, endpoint);
                }
            }
            if (source.equals(this.metadataField)) {
                String metad = this.getMetadata();
                if (metad != null && metad.length() == 0) {
                    ProprietarySecurityPolicyModelHelper.setPreSTSMetadata(this.binding, null);
                } else {
                    ProprietarySecurityPolicyModelHelper.setPreSTSMetadata(this.binding, metad);
                }
            }
            if (source.equals(this.namespaceTextField)) {
                String ns = this.getNamespace();
                if (ns != null && ns.length() == 0) {
                    ProprietarySecurityPolicyModelHelper.setPreSTSNamespace(this.binding, null);
                } else {
                    ProprietarySecurityPolicyModelHelper.setPreSTSNamespace(this.binding, ns);
                }
            }
            if (source.equals(this.serviceNameTextField)) {
                String sname = this.getServiceName();
                if (sname != null && sname.length() == 0) {
                    ProprietarySecurityPolicyModelHelper.setPreSTSServiceName(this.binding, null);
                } else {
                    ProprietarySecurityPolicyModelHelper.setPreSTSServiceName(this.binding, sname);
                }
            }
            if (source.equals(this.portNameTextField)) {
                String pname = this.getPortName();
                if (pname != null && pname.length() == 0) {
                    ProprietarySecurityPolicyModelHelper.setPreSTSPortName(this.binding, null);
                } else {
                    ProprietarySecurityPolicyModelHelper.setPreSTSPortName(this.binding, pname);
                }
            }
            if (source.equals(this.wsdlLocationTextField)) {
                String wsdlLoc = this.getWsdlLocation();
                if (wsdlLoc != null && wsdlLoc.length() == 0) {
                    ProprietarySecurityPolicyModelHelper.setPreSTSWsdlLocation(this.binding, null);
                } else {
                    ProprietarySecurityPolicyModelHelper.setPreSTSWsdlLocation(this.binding, wsdlLoc);
                }
            }
            if (source.equals(this.trustVersionCombo)) {
                String version = this.getWstVersion();
                ProprietarySecurityPolicyModelHelper.setPreSTSWstVersion(this.binding, version);
            }
            if (source.equals(this.shareTokenChBox)) {
                ProprietarySecurityPolicyModelHelper.setPreSTSShareToken(this.binding, this.isShareToken());
            }
            this.enableDisable();
        }
    }

    public void documentChanged(JTextComponent comp, String value) {
        this.enableDisable();
    }

    public void rollbackValue(JTextComponent source) {
    }

    protected void endUIChange() {
    }

    public void linkButtonPressed(Object ddBean, String ddProperty) {
    }

    public JComponent getErrorComponent(String errorId) {
        return null;
    }

    private void enableDisable() {
        WSStackVersion wsStackVersion = WSITConfigProvider.getDefault().getHighestWSStackVersion(this.project);
        boolean cfg20 = ConfigVersion.CONFIG_2_0.isSupported(wsStackVersion);
        boolean amSec = SecurityCheckerRegistry.getDefault().isNonWsitSecurityEnabled(this.node, this.jaxwsmodel);
        this.endpointLabel.setEnabled(!amSec);
        this.endpointTextField.setEnabled(!amSec);
        this.metadataField.setEnabled(!amSec);
        this.metadataLabel.setEnabled(!amSec);
        this.namespaceLabel.setEnabled(!amSec);
        this.namespaceLabel.setEnabled(!amSec);
        this.portNameLabel.setEnabled(!amSec);
        this.portNameTextField.setEnabled(!amSec);
        this.serviceNameLabel.setEnabled(!amSec);
        this.serviceNameTextField.setEnabled(!amSec);
        this.shareTokenChBox.setEnabled(!amSec && cfg20);
        this.shareTokenChBox.setEnabled(!amSec && cfg20);
        this.wsdlLocationLabel.setEnabled(!amSec);
        this.wsdlLocationTextField.setEnabled(!amSec);
    }

    private void initComponents() {
        this.endpointLabel = new JLabel();
        this.wsdlLocationLabel = new JLabel();
        this.endpointTextField = new JTextField();
        this.wsdlLocationTextField = new JTextField();
        this.serviceNameLabel = new JLabel();
        this.serviceNameTextField = new JTextField();
        this.portNameLabel = new JLabel();
        this.namespaceLabel = new JLabel();
        this.portNameTextField = new JTextField();
        this.namespaceTextField = new JTextField();
        this.metadataLabel = new JLabel();
        this.metadataField = new JTextField();
        this.trustVersionLabel = new JLabel();
        this.trustVersionCombo = new JComboBox();
        this.shareTokenChBox = new JCheckBox();
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                STSClientPanel.this.formFocusGained(evt);
            }
        });
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorMoved(AncestorEvent evt) {
            }

            @Override
            public void ancestorAdded(AncestorEvent evt) {
                STSClientPanel.this.formAncestorAdded(evt);
            }

            @Override
            public void ancestorRemoved(AncestorEvent evt) {
            }
        });
        this.endpointLabel.setLabelFor(this.endpointTextField);
        Mnemonics.setLocalizedText((JLabel)this.endpointLabel, (String)NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_Endpoint"));
        this.endpointLabel.setToolTipText("The maximum number of seconds the time stamp remains valid.");
        this.wsdlLocationLabel.setLabelFor(this.wsdlLocationTextField);
        Mnemonics.setLocalizedText((JLabel)this.wsdlLocationLabel, (String)NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_WsdlLocation"));
        this.wsdlLocationLabel.setToolTipText("The maximum number of seconds the sending clock can deviate from the receiving clock.");
        this.endpointTextField.setHorizontalAlignment(2);
        this.wsdlLocationTextField.setHorizontalAlignment(2);
        this.serviceNameLabel.setLabelFor(this.serviceNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.serviceNameLabel, (String)NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_ServiceName"));
        this.serviceNameTextField.setHorizontalAlignment(2);
        this.portNameLabel.setLabelFor(this.portNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.portNameLabel, (String)NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_PortName"));
        this.namespaceLabel.setLabelFor(this.namespaceTextField);
        Mnemonics.setLocalizedText((JLabel)this.namespaceLabel, (String)NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_Namespace"));
        this.portNameTextField.setHorizontalAlignment(2);
        this.namespaceTextField.setHorizontalAlignment(2);
        this.metadataLabel.setLabelFor(this.metadataField);
        Mnemonics.setLocalizedText((JLabel)this.metadataLabel, (String)NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_Metadata"));
        Mnemonics.setLocalizedText((JLabel)this.trustVersionLabel, (String)NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_PolicyVersion"));
        Mnemonics.setLocalizedText((AbstractButton)this.shareTokenChBox, (String)NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_ShareToken"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.namespaceLabel).addComponent(this.endpointLabel).addComponent(this.wsdlLocationLabel).addComponent(this.metadataLabel).addComponent(this.serviceNameLabel).addComponent(this.portNameLabel).addComponent(this.trustVersionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.namespaceTextField, -1, 383, Short.MAX_VALUE).addComponent(this.portNameTextField, -1, 383, Short.MAX_VALUE).addComponent(this.serviceNameTextField, -1, 383, Short.MAX_VALUE).addComponent(this.wsdlLocationTextField, -1, 383, Short.MAX_VALUE).addComponent(this.endpointTextField, -1, 383, Short.MAX_VALUE).addComponent(this.metadataField, -1, 383, Short.MAX_VALUE).addComponent(this.trustVersionCombo, -2, 63, -2))).addComponent(this.shareTokenChBox)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.endpointLabel).addComponent(this.endpointTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.wsdlLocationLabel).addComponent(this.wsdlLocationTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.metadataLabel).addComponent(this.metadataField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.serviceNameLabel).addComponent(this.serviceNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.portNameLabel).addComponent(this.portNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.namespaceLabel).addComponent(this.namespaceTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.trustVersionLabel).addComponent(this.trustVersionCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.shareTokenChBox).addContainerGap(-1, Short.MAX_VALUE)));
        this.endpointLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_Endpoint_ACSN"));
        this.endpointLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_Endpoint_ACSD"));
        this.wsdlLocationLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_WsdlLocation_ACSN"));
        this.wsdlLocationLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_WsdlLocation_ACSD"));
        this.serviceNameLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_ServiceName_ACSN"));
        this.serviceNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_ServiceName_ACSD"));
        this.portNameLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_PortName_ACSN"));
        this.portNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_PortName_ACSD"));
        this.namespaceLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_Namespace_ACSN"));
        this.namespaceLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_Namespace_ACSD"));
        this.metadataLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_Metadata_ACSN"));
        this.metadataLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(STSClientPanel.class, (String)"LBL_STSPanel_Metadata_ACSD"));
    }

    private void formFocusGained(FocusEvent evt) {
        this.enableDisable();
    }

    private void formAncestorAdded(AncestorEvent evt) {
        this.enableDisable();
    }
}

