/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters.composite;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.basic.AbstractBasicConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;

class ComponentDefaultValueSetter {
    private final Object object;
    private final ConverterLookup lookup;
    private final ConfigurationListener listener;
    private final Method setter;

    public ComponentDefaultValueSetter(Object object, ConverterLookup lookup, ConfigurationListener listener) throws ComponentConfigurationException {
        this.object = object;
        this.lookup = lookup;
        this.listener = listener;
        this.setter = ComponentDefaultValueSetter.getDefaultSetter(object);
    }

    private static Method getDefaultSetter(Object object) {
        for (Method method : object.getClass().getMethods()) {
            if (!"set".equals(method.getName()) || method.getParameterTypes().length != 1 || Modifier.isStatic(method.getModifiers())) continue;
            return method;
        }
        return null;
    }

    public void configure(Object value, PlexusConfiguration config, ClassLoader classLoader, ExpressionEvaluator evaluator) throws ComponentConfigurationException {
        Object propertyValue;
        if (this.setter == null) {
            throw new ComponentConfigurationException(config, "Cannot configure instance of " + this.object.getClass().getName() + " from " + value);
        }
        Class<?> propertyType = this.setter.getParameterTypes()[0];
        if (propertyType.isInstance(value)) {
            propertyValue = value;
        } else {
            ConfigurationConverter converter = this.lookup.lookupConverterForType(propertyType);
            if (!(converter instanceof AbstractBasicConverter)) {
                throw new ComponentConfigurationException(config, "Cannot configure instance of " + this.object.getClass().getName() + " from " + value);
            }
            propertyValue = converter.fromConfiguration(this.lookup, config, propertyType, this.object.getClass(), classLoader, evaluator, this.listener);
        }
        if (this.listener != null) {
            this.listener.notifyFieldChangeUsingSetter("", propertyValue, this.object);
        }
        try {
            this.setter.invoke(this.object, propertyValue);
        }
        catch (IllegalAccessException e) {
            throw new ComponentConfigurationException(config, "Cannot access method " + this.setter, e);
        }
        catch (InvocationTargetException e) {
            throw new ComponentConfigurationException(config, "Could not invoke method " + this.setter + ": " + e.getCause(), e.getCause());
        }
    }
}

