/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.error;

import java.awt.event.InputEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.prefs.Preferences;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.modules.cnd.analysis.api.AnalyzerResponse;
import org.netbeans.modules.cnd.api.model.CsmErrorDirective;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.syntaxerr.AbstractCodeAudit;
import org.netbeans.modules.cnd.api.model.syntaxerr.AuditPreferences;
import org.netbeans.modules.cnd.api.model.syntaxerr.CodeAuditFactory;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorInfo;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorProvider;
import org.netbeans.modules.cnd.highlight.hints.ErrorInfoImpl;
import org.openide.util.NbBundle;

public final class IncludeErrorProvider
extends AbstractCodeAudit {
    private static final int UNRESOLVED = 1;
    private static final int UNRESOLVED_INSIDE = 2;
    private static final int RECURSIVE = 3;
    private static final int ERRIR_DIRECTIVE = 4;
    private final int kind;
    private final String message;

    private IncludeErrorProvider(String id, String name, String description, String defaultSeverity, boolean defaultEnabled, AuditPreferences preferences, int kind, String message) {
        super(id, name, description, defaultSeverity, defaultEnabled, preferences);
        this.kind = kind;
        this.message = message;
    }

    public boolean isSupportedEvent(CsmErrorProvider.EditorEvent kind) {
        return kind == CsmErrorProvider.EditorEvent.DocumentBased || kind == CsmErrorProvider.EditorEvent.FileBased;
    }

    public void doGetErrors(CsmErrorProvider.Request request, CsmErrorProvider.Response response) {
        String decoratedText;
        CsmFile file = request.getFile();
        Thread currentThread = Thread.currentThread();
        currentThread.setName("Provider " + this.getName() + " prosess " + file.getAbsolutePath());
        if (request.isCancelled()) {
            return;
        }
        if (this.kind == 3 || this.kind == 1) {
            for (CsmInclude incl : CsmFileInfoQuery.getDefault().getBrokenIncludes(file)) {
                if (request.isCancelled()) {
                    return;
                }
                if (incl.getIncludeState() == CsmInclude.IncludeState.Recursive) {
                    if (this.kind != 3) continue;
                    if (response instanceof AnalyzerResponse) {
                        decoratedText = this.getID() + "\n" + NbBundle.getMessage(IncludeErrorProvider.class, (String)this.message);
                        ((AnalyzerResponse)response).addError(AnalyzerResponse.AnalyzerSeverity.DetectedError, null, file.getFileObject(), (CsmErrorInfo)new ErrorInfoImpl("CodeAssistance", this.getID(), decoratedText, IncludeErrorProvider.toSeverity((String)this.minimalSeverity()), incl.getStartOffset(), incl.getEndOffset()));
                        continue;
                    }
                    decoratedText = IncludeErrorProvider.decorateWithExtraHyperlinkTip(NbBundle.getMessage(IncludeErrorProvider.class, (String)this.message));
                    response.addError((CsmErrorInfo)new ErrorInfoImpl("CodeAssistance", this.getID(), decoratedText, IncludeErrorProvider.toSeverity((String)this.minimalSeverity()), incl.getStartOffset(), incl.getEndOffset()));
                    continue;
                }
                if (incl.getIncludeFile() != null || this.kind != 1) continue;
                if (response instanceof AnalyzerResponse) {
                    decoratedText = this.getID() + "\n" + NbBundle.getMessage(IncludeErrorProvider.class, (String)this.message, (Object)IncludeErrorProvider.getIncludeText(incl));
                    ((AnalyzerResponse)response).addError(AnalyzerResponse.AnalyzerSeverity.DetectedError, null, file.getFileObject(), (CsmErrorInfo)new ErrorInfoImpl("CodeAssistance", this.getID(), decoratedText, IncludeErrorProvider.toSeverity((String)this.minimalSeverity()), incl.getStartOffset(), incl.getEndOffset()));
                    continue;
                }
                decoratedText = IncludeErrorProvider.decorateWithExtraHyperlinkTip(NbBundle.getMessage(IncludeErrorProvider.class, (String)this.message, (Object)IncludeErrorProvider.getIncludeText(incl)));
                response.addError((CsmErrorInfo)new ErrorInfoImpl("CodeAssistance", this.getID(), decoratedText, IncludeErrorProvider.toSeverity((String)this.minimalSeverity()), incl.getStartOffset(), incl.getEndOffset()));
            }
        }
        if (request.isCancelled()) {
            return;
        }
        if (this.kind == 4) {
            for (CsmErrorDirective error : file.getErrors()) {
                if (request.isCancelled()) {
                    return;
                }
                if (response instanceof AnalyzerResponse) {
                    decoratedText = this.getID() + "\n" + NbBundle.getMessage(IncludeErrorProvider.class, (String)this.message);
                    ((AnalyzerResponse)response).addError(AnalyzerResponse.AnalyzerSeverity.DetectedError, null, file.getFileObject(), (CsmErrorInfo)new ErrorInfoImpl("CodeAssistance", this.getID(), decoratedText, IncludeErrorProvider.toSeverity((String)this.minimalSeverity()), error.getStartOffset(), error.getEndOffset()));
                    continue;
                }
                decoratedText = NbBundle.getMessage(IncludeErrorProvider.class, (String)this.message);
                response.addError((CsmErrorInfo)new ErrorInfoImpl("CodeAssistance", this.getID(), decoratedText, IncludeErrorProvider.toSeverity((String)this.minimalSeverity()), error.getStartOffset(), error.getEndOffset()));
            }
        }
        if (request.isCancelled()) {
            return;
        }
        if (this.kind == 2) {
            HashSet<CsmFile> visited = new HashSet<CsmFile>();
            for (CsmInclude incl : file.getIncludes()) {
                String decoratedText2;
                CsmFile newFile;
                if (request.isCancelled()) {
                    return;
                }
                if (incl.getIncludeState() == CsmInclude.IncludeState.Recursive || (newFile = incl.getIncludeFile()) == null || !this.hasBrokenIncludes(newFile, visited)) continue;
                if (response instanceof AnalyzerResponse) {
                    decoratedText2 = this.getID() + "\n" + NbBundle.getMessage(IncludeErrorProvider.class, (String)this.message, (Object)IncludeErrorProvider.getIncludeText(incl));
                    ((AnalyzerResponse)response).addError(AnalyzerResponse.AnalyzerSeverity.DetectedError, null, file.getFileObject(), (CsmErrorInfo)new ErrorInfoImpl("CodeAssistance", this.getID(), decoratedText2, IncludeErrorProvider.toSeverity((String)this.minimalSeverity()), incl.getStartOffset(), incl.getEndOffset()));
                    continue;
                }
                decoratedText2 = IncludeErrorProvider.decorateWithExtraHyperlinkTip(NbBundle.getMessage(IncludeErrorProvider.class, (String)this.message, (Object)IncludeErrorProvider.getIncludeText(incl)));
                response.addError((CsmErrorInfo)new ErrorInfoImpl("CodeAssistance", this.getID(), decoratedText2, IncludeErrorProvider.toSeverity((String)this.minimalSeverity()), incl.getStartOffset(), incl.getEndOffset()));
            }
        }
    }

    private static String decorateWithExtraHyperlinkTip(String tooltip) {
        Preferences prefs = (Preferences)MimeLookup.getLookup((String)"text/x-c++").lookup(Preferences.class);
        int altShortCut = prefs.getInt("hyperlink-activation-modifiers", 128);
        return NbBundle.getMessage(IncludeErrorProvider.class, (String)"HighlightProvider_HyperlinkActionsHints", (Object)tooltip, (Object)InputEvent.getModifiersExText(altShortCut));
    }

    private static String getIncludeText(CsmInclude incl) {
        if (incl.isSystem()) {
            return "<" + incl.getIncludeName() + ">";
        }
        return "\"" + incl.getIncludeName() + "\"";
    }

    private boolean hasBrokenIncludes(CsmFile file, Collection<CsmFile> visited) {
        if (!file.isValid() || visited.contains(file)) {
            return false;
        }
        visited.add(file);
        if (CsmFileInfoQuery.getDefault().hasBrokenIncludes(file)) {
            return true;
        }
        for (CsmInclude incl : file.getIncludes()) {
            CsmFile newFile = incl.getIncludeFile();
            if (newFile == null || !this.hasBrokenIncludes(newFile, visited)) continue;
            return true;
        }
        return false;
    }

    public static final class ErrorFactory
    implements CodeAuditFactory {
        public AbstractCodeAudit create(AuditPreferences preferences) {
            String id = NbBundle.getMessage(IncludeErrorProvider.class, (String)"IncludeErrorProvider.error.name");
            String description = NbBundle.getMessage(IncludeErrorProvider.class, (String)"IncludeErrorProvider.error.description");
            String message = "IncludeErrorProvider.error.message";
            return new IncludeErrorProvider(id, id, description, "error", true, preferences, 4, message);
        }
    }

    public static final class RecursiveFactory
    implements CodeAuditFactory {
        public AbstractCodeAudit create(AuditPreferences preferences) {
            String id = NbBundle.getMessage(IncludeErrorProvider.class, (String)"IncludeErrorProvider.recursive.name");
            String description = NbBundle.getMessage(IncludeErrorProvider.class, (String)"IncludeErrorProvider.recursive.description");
            String message = "IncludeErrorProvider.recursive.message";
            return new IncludeErrorProvider(id, id, description, "warning", true, preferences, 3, message);
        }
    }

    public static final class InsideUnresolvedFactory
    implements CodeAuditFactory {
        public AbstractCodeAudit create(AuditPreferences preferences) {
            String id = NbBundle.getMessage(IncludeErrorProvider.class, (String)"IncludeErrorProvider.insideUnresolved.name");
            String description = NbBundle.getMessage(IncludeErrorProvider.class, (String)"IncludeErrorProvider.insideUnresolved.description");
            String message = "IncludeErrorProvider.insideUnresolved.message";
            return new IncludeErrorProvider(id, id, description, "warning", true, preferences, 2, message);
        }
    }

    public static final class UnresolvedFactory
    implements CodeAuditFactory {
        public AbstractCodeAudit create(AuditPreferences preferences) {
            String id = NbBundle.getMessage(IncludeErrorProvider.class, (String)"IncludeErrorProvider.unresolved.name");
            String description = NbBundle.getMessage(IncludeErrorProvider.class, (String)"IncludeErrorProvider.unresolved.description");
            String message = "IncludeErrorProvider.unresolved.message";
            return new IncludeErrorProvider(id, id, description, "error", true, preferences, 1, message);
        }
    }
}

