/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.hints.formatstring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.MissingResourceException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.analysis.api.AnalyzerResponse;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.services.CsmFileReferences;
import org.netbeans.modules.cnd.api.model.services.CsmReferenceContext;
import org.netbeans.modules.cnd.api.model.syntaxerr.AbstractCodeAudit;
import org.netbeans.modules.cnd.api.model.syntaxerr.AuditPreferences;
import org.netbeans.modules.cnd.api.model.syntaxerr.CodeAuditFactory;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorInfo;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorInfoHintProvider;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorProvider;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.highlight.hints.ErrorInfoImpl;
import org.netbeans.modules.cnd.highlight.hints.SafeFix;
import org.netbeans.modules.cnd.highlight.hints.formatstring.FormatError;
import org.netbeans.modules.cnd.highlight.hints.formatstring.FormattedPrintFunction;
import org.netbeans.modules.cnd.highlight.hints.formatstring.Parameter;
import org.netbeans.modules.cnd.highlight.hints.formatstring.Utilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class FormatStringAudit
extends AbstractCodeAudit {
    private static final boolean CHECKS_ENABLED;
    private List<FormattedPrintFunction> result;

    private FormatStringAudit(String id, String name, String description, String defaultSeverity, boolean defaultEnabled, AuditPreferences myPreferences) {
        super(id, name, description, defaultSeverity, defaultEnabled, myPreferences);
    }

    public boolean isSupportedEvent(CsmErrorProvider.EditorEvent kind) {
        return kind == CsmErrorProvider.EditorEvent.FileBased;
    }

    public void doGetErrors(CsmErrorProvider.Request request, CsmErrorProvider.Response response) {
        CsmFile file = request.getFile();
        if (file != null) {
            if (request.isCancelled()) {
                return;
            }
            Document doc_ = request.getDocument();
            if (doc_ == null) {
                CloneableEditorSupport ces = CsmUtilities.findCloneableEditorSupport((CsmFile)file);
                doc_ = CsmUtilities.openDocument((CloneableEditorSupport)ces);
            }
            Document doc = doc_;
            this.result = new LinkedList<FormattedPrintFunction>();
            CsmFileReferences.getDefault().accept((CsmScope)request.getFile(), request.getDocument(), (CsmFileReferences.Visitor)new ReferenceVisitor(request, response, doc, file), CsmReferenceKind.ANY_REFERENCE_IN_ACTIVE_CODE);
        }
    }

    static {
        String checksEnabled = System.getProperty("printf.check.enable");
        CHECKS_ENABLED = checksEnabled != null ? Boolean.parseBoolean(checksEnabled) : true;
    }

    private static final class FixFormat
    extends SafeFix {
        private final BaseDocument doc;
        private final FormatError error;
        private final Position start;
        private final Position end;
        private final String oldText;
        private final String newText;

        public FixFormat(BaseDocument doc, FormatError error, Position start, Position end) throws BadLocationException {
            this.doc = doc;
            this.error = error;
            this.start = start;
            this.end = end;
            int length = end.getOffset() - start.getOffset();
            this.oldText = doc.getText(start.getOffset(), length);
            this.newText = error.getType().equals((Object)FormatError.FormatErrorType.TYPE_MISMATCH) ? this.getAppropriateFormat(error.getFlag()) : this.oldText.replace(error.getFlag(), "");
        }

        public String getText() {
            return NbBundle.getMessage(FormatStringAudit.class, (String)"FormatStringAudit.fix.flag", (Object)this.oldText, (Object)this.newText);
        }

        @Override
        public ChangeInfo performFix() throws BadLocationException, Exception {
            int length = this.end.getOffset() - this.start.getOffset();
            this.doc.replace(this.start.getOffset(), length, this.newText, null);
            return null;
        }

        private String getAppropriateFormat(String type) {
            List<String> formats = Utilities.typeToFormat(type);
            String specifier = this.error.getSpecifier();
            if (specifier.startsWith("l")) {
                specifier = specifier.replace("l", "");
            } else if (specifier.startsWith("h")) {
                specifier = specifier.replace("h", "");
            }
            for (String format : formats) {
                if (!format.contains(specifier)) continue;
                return format;
            }
            if (formats.isEmpty()) {
                return "p";
            }
            return formats.get(0);
        }
    }

    public static final class FormatStringFixProvider
    extends CsmErrorInfoHintProvider {
        protected List<Fix> doGetFixes(CsmErrorInfo info, List<Fix> alreadyFound) {
            if (info instanceof FormatStringErrorInfoImpl) {
                alreadyFound.addAll(this.createFixes((FormatStringErrorInfoImpl)info));
            }
            return alreadyFound;
        }

        private List<? extends Fix> createFixes(FormatStringErrorInfoImpl info) {
            try {
                ArrayList<FixFormat> fixes = new ArrayList<FixFormat>();
                switch (info.error.getType()) {
                    case FLAG: 
                    case LENGTH: 
                    case TYPE_MISMATCH: {
                        fixes.add(new FixFormat(info.doc, info.error, info.startPosition, info.endPosition));
                        break;
                    }
                }
                return fixes;
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return Collections.emptyList();
            }
        }
    }

    private static final class FormatStringErrorInfoImpl
    extends ErrorInfoImpl {
        private final BaseDocument doc;
        private final Position startPosition;
        private final Position endPosition;
        private final FormatError error;

        public FormatStringErrorInfoImpl(Document doc, String providerName, String audutName, String message, CsmErrorInfo.Severity severity, FormatError error) throws BadLocationException {
            super(providerName, audutName, message, severity, error.startOffset(), error.endOffset());
            this.doc = (BaseDocument)doc;
            this.error = error;
            this.startPosition = NbDocument.createPosition((Document)doc, (int)this.error.startOffset(), (Position.Bias)Position.Bias.Forward);
            this.endPosition = NbDocument.createPosition((Document)doc, (int)this.error.endOffset(), (Position.Bias)Position.Bias.Backward);
        }
    }

    public static final class Factory
    implements CodeAuditFactory {
        public AbstractCodeAudit create(AuditPreferences preferences) {
            String id = NbBundle.getMessage(FormatStringAudit.class, (String)"FormatStringAudit.name");
            String description = NbBundle.getMessage(FormatStringAudit.class, (String)"FormatStringAudit.description");
            return new FormatStringAudit(id, id, description, "error", CHECKS_ENABLED, preferences);
        }
    }

    private static enum State {
        START,
        BEFOR_FORMAT,
        FORMAT,
        VAR_ARGS,
        VAR_ARGS_IN_BRACKETS;

    }

    private class ReferenceVisitor
    implements CsmFileReferences.Visitor {
        private final CsmErrorProvider.Request request;
        private final CsmErrorProvider.Response response;
        private final CsmFile file;
        private final Document doc;

        public ReferenceVisitor(CsmErrorProvider.Request request, CsmErrorProvider.Response response, Document doc, CsmFile file) {
            this.request = request;
            this.response = response;
            this.file = file;
            this.doc = doc;
        }

        public void visit(CsmReferenceContext context) {
            CsmReference reference = context.getReference();
            if (reference != null) {
                if (Utilities.checkPrintf(reference.getText()) == -1) {
                    return;
                }
                CsmObject object = reference.getReferencedObject();
                final int formatStringPosition = Utilities.checkFormattedPrintFunction(object);
                if (formatStringPosition > -1) {
                    final int startOffset = reference.getStartOffset();
                    this.doc.render(new Runnable(){

                        @Override
                        public void run() {
                            TokenSequence docTokenSequence = CndLexerUtilities.getCppTokenSequence((Document)ReferenceVisitor.this.doc, (int)startOffset, (boolean)false, (boolean)true);
                            if (docTokenSequence == null) {
                                return;
                            }
                            CsmReferenceResolver rr = CsmReferenceResolver.getDefault();
                            State state = State.START;
                            int formatStringOffset = -1;
                            int innerBracketsCounter = 0;
                            int parameterPosition = 0;
                            int parameterOffset = -1;
                            boolean containsMacros = false;
                            StringBuilder formatString = null;
                            ArrayList<Parameter> parameters = new ArrayList<Parameter>();
                            StringBuilder parameterBuffer = new StringBuilder();
                            while (docTokenSequence.moveNext()) {
                                Token token = docTokenSequence.token();
                                TokenId tokenId = token.id();
                                if (state == State.START && tokenId.equals(CppTokenId.LPAREN)) {
                                    state = State.BEFOR_FORMAT;
                                    continue;
                                }
                                if (tokenId.equals(CppTokenId.COMMA)) {
                                    ++parameterPosition;
                                    if (state == State.FORMAT) {
                                        state = State.VAR_ARGS;
                                        continue;
                                    }
                                    if (state != State.VAR_ARGS) continue;
                                    parameters.add(new Parameter(parameterBuffer.toString(), parameterOffset, !containsMacros));
                                    assert (innerBracketsCounter == 0);
                                    containsMacros = false;
                                    parameterOffset = -1;
                                    parameterBuffer = new StringBuilder();
                                    continue;
                                }
                                if (state == State.BEFOR_FORMAT && parameterPosition == formatStringPosition) {
                                    state = State.FORMAT;
                                    formatString = new StringBuilder();
                                    if (tokenId.equals(CppTokenId.STRING_LITERAL)) {
                                        formatStringOffset = docTokenSequence.offset();
                                        formatString.append(token.text().toString());
                                        continue;
                                    }
                                    return;
                                }
                                if (state == State.FORMAT && tokenId.equals(CppTokenId.STRING_LITERAL)) {
                                    formatString.append(token.text().toString());
                                    continue;
                                }
                                if (!(state != State.FORMAT || tokenId.equals(CppTokenId.STRING_LITERAL) || tokenId.equals(CppTokenId.RPAREN) || tokenId.primaryCategory().equals("whitespace") || tokenId.primaryCategory().equals("comment"))) {
                                    return;
                                }
                                if (!(state != State.VAR_ARGS && state != State.VAR_ARGS_IN_BRACKETS || tokenId.equals(CppTokenId.LPAREN) || tokenId.equals(CppTokenId.RPAREN) || tokenId.primaryCategory().equals("whitespace") || tokenId.primaryCategory().equals("comment"))) {
                                    CsmReference ref;
                                    parameterBuffer.append(token.text());
                                    if (parameterOffset == -1) {
                                        parameterOffset = docTokenSequence.offset();
                                    }
                                    if ((ref = rr.findReference(ReferenceVisitor.this.file, ReferenceVisitor.this.doc, docTokenSequence.offset())) == null || !CsmKindUtilities.isMacro((CsmObject)ref.getReferencedObject())) continue;
                                    containsMacros = true;
                                    continue;
                                }
                                if (state == State.VAR_ARGS && tokenId.equals(CppTokenId.LPAREN)) {
                                    ++innerBracketsCounter;
                                    state = State.VAR_ARGS_IN_BRACKETS;
                                    parameterBuffer.append(token.text());
                                    if (parameterOffset != -1) continue;
                                    parameterOffset = docTokenSequence.offset();
                                    continue;
                                }
                                if (state == State.VAR_ARGS_IN_BRACKETS && tokenId.equals(CppTokenId.LPAREN)) {
                                    ++innerBracketsCounter;
                                    parameterBuffer.append(token.text());
                                    if (parameterOffset != -1) continue;
                                    parameterOffset = docTokenSequence.offset();
                                    continue;
                                }
                                if (state == State.VAR_ARGS_IN_BRACKETS && tokenId.equals(CppTokenId.RPAREN)) {
                                    if (--innerBracketsCounter == 0) {
                                        state = State.VAR_ARGS;
                                    }
                                    parameterBuffer.append(token.text());
                                    if (parameterOffset != -1) continue;
                                    parameterOffset = docTokenSequence.offset();
                                    continue;
                                }
                                if (state != State.VAR_ARGS && state != State.FORMAT || !tokenId.equals(CppTokenId.RPAREN)) continue;
                                if (parameterBuffer.length() > 0) {
                                    parameters.add(new Parameter(parameterBuffer.toString(), parameterOffset, !containsMacros));
                                }
                                ReferenceVisitor.this.addMessage(new FormattedPrintFunction(ReferenceVisitor.this.file, formatStringOffset, formatString == null ? "" : formatString.toString(), parameters));
                                return;
                            }
                        }
                    });
                }
            }
        }

        private void addMessage(FormattedPrintFunction function) throws MissingResourceException {
            LinkedList<FormatError> errors = new LinkedList<FormatError>(function.validate());
            for (FormatError error : errors) {
                CsmErrorInfo.Severity severity = AbstractCodeAudit.toSeverity((String)FormatStringAudit.this.minimalSeverity());
                try {
                    if (this.response instanceof AnalyzerResponse) {
                        ((AnalyzerResponse)this.response).addError(AnalyzerResponse.AnalyzerSeverity.DetectedError, null, this.file.getFileObject(), (CsmErrorInfo)new FormatStringErrorInfoImpl(this.doc, "General", FormatStringAudit.this.getID(), FormatStringAudit.this.getName() + "\n" + Utilities.getMessageForError(error), severity, error));
                        continue;
                    }
                    this.response.addError((CsmErrorInfo)new FormatStringErrorInfoImpl(this.doc, "General", FormatStringAudit.this.getID(), Utilities.getMessageForError(error), severity, error));
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }

        public boolean cancelled() {
            return this.request.isCancelled();
        }
    }
}

