/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.hints.formatstring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.services.CsmExpressionResolver;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.support.CsmClassifierResolver;
import org.netbeans.modules.cnd.highlight.hints.formatstring.FormatError;
import org.netbeans.modules.cnd.highlight.hints.formatstring.Parameter;
import org.netbeans.modules.cnd.highlight.hints.formatstring.Utilities;

class FormattedPrintFunction {
    private final CsmFile file;
    private final ArrayList<Parameter> parameters;
    private final String formatString;
    private final int offset;
    private static final boolean STRICT_TYPE_CHECKS;

    public FormattedPrintFunction(CsmFile file, int offset, String formatString, ArrayList<Parameter> parameters) {
        this.file = file;
        this.offset = offset;
        this.formatString = formatString;
        this.parameters = parameters;
    }

    public List<FormatError> validate() {
        ArrayList<FormatInfo> formatInfoList = this.processFormatString(this.formatString, this.offset);
        LinkedList<FormatError> result = new LinkedList<FormatError>();
        if (this.getParametersFromFormat(formatInfoList) != this.parameters.size()) {
            int line = CsmFileInfoQuery.getDefault().getLineColumnByOffset(this.file, this.offset)[0];
            int start = (int)CsmFileInfoQuery.getDefault().getOffset(this.file, line, 1);
            int end = (int)CsmFileInfoQuery.getDefault().getOffset(this.file, line + 1, 1) - 1;
            result.add(new FormatError(FormatError.FormatErrorType.ARGS, null, null, start, end));
        } else {
            int limit = formatInfoList.size();
            int pIndex = 0;
            for (int i = 0; i < limit; ++i) {
                FormatInfo info = formatInfoList.get(i);
                List<FormatError> list = info.validateFormat();
                if (list.isEmpty() && !info.specifier().equals("%")) {
                    String wType = null;
                    String pType = null;
                    String type = null;
                    if (pIndex < this.parameters.size() && info.hasWidthWildcard()) {
                        wType = this.getParameterType(this.parameters.get(pIndex).getValue(), this.parameters.get(pIndex).getOffset(), this.file);
                        if (wType != null && !wType.equals("int")) {
                            result.add(new FormatError(FormatError.FormatErrorType.TYPE_WILDCARD, "Width", null, info.startOffset, info.endOffset));
                        }
                        ++pIndex;
                    }
                    if (pIndex < this.parameters.size() && info.hasPrecisionWildcard()) {
                        pType = this.getParameterType(this.parameters.get(pIndex).getValue(), this.parameters.get(pIndex).getOffset(), this.file);
                        if (pType != null && !pType.equals("int")) {
                            result.add(new FormatError(FormatError.FormatErrorType.TYPE_WILDCARD, "Precision", null, info.startOffset, info.endOffset));
                        }
                        ++pIndex;
                    }
                    if (pIndex < this.parameters.size() && this.parameters.get(pIndex).resolveType() && (type = this.getParameterType(this.parameters.get(pIndex).getValue(), this.parameters.get(pIndex).getOffset(), this.file)) != null) {
                        String fType = info.getFullType();
                        List<String> validFlags = Utilities.typeToFormat(type);
                        if (!validFlags.isEmpty() && !validFlags.contains(fType)) {
                            result.add(new FormatError(FormatError.FormatErrorType.TYPE_MISMATCH, type, fType, info.startOffset, info.endOffset));
                        } else if (validFlags.isEmpty() && !fType.equals("p") && STRICT_TYPE_CHECKS) {
                            result.add(new FormatError(FormatError.FormatErrorType.TYPE_MISMATCH, type, fType, info.startOffset, info.endOffset));
                        }
                    }
                    ++pIndex;
                    continue;
                }
                if (list.isEmpty()) continue;
                result.addAll(list);
                ++pIndex;
            }
        }
        return result;
    }

    private ArrayList<FormatInfo> processFormatString(String format, int offset) {
        ArrayList<FormatInfo> result = new ArrayList<FormatInfo>();
        FormatInfo info = new FormatInfo();
        ConversionState state = ConversionState.DEFAULT;
        int startOffset = 0;
        int endOffset = 0;
        int limit = format.length();
        for (int i = 0; i < limit; ++i) {
            ++startOffset;
            ++endOffset;
            if (format.charAt(i) == '%' && state == ConversionState.DEFAULT) {
                state = ConversionState.START;
                info = new FormatInfo();
                info.setStartOffset(offset + startOffset);
                continue;
            }
            if ((state == ConversionState.START || state == ConversionState.FLAGS) && format.charAt(i) == FormatFlag.APOSTROPHE.character()) {
                state = ConversionState.FLAGS;
                info.addFormatFlag(FormatFlag.APOSTROPHE);
                continue;
            }
            if ((state == ConversionState.START || state == ConversionState.FLAGS) && format.charAt(i) == FormatFlag.HASH.character()) {
                state = ConversionState.FLAGS;
                info.addFormatFlag(FormatFlag.HASH);
                continue;
            }
            if ((state == ConversionState.START || state == ConversionState.FLAGS) && format.charAt(i) == FormatFlag.ZERO.character()) {
                state = ConversionState.FLAGS;
                info.addFormatFlag(FormatFlag.ZERO);
                continue;
            }
            if ((state == ConversionState.START || state == ConversionState.FLAGS) && format.substring(i, i + 1).matches("-|\\+|\\s")) {
                state = ConversionState.FLAGS;
                continue;
            }
            if ((state == ConversionState.START || state == ConversionState.FLAGS) && format.substring(i, i + 1).matches("[0-9]|\\*")) {
                state = ConversionState.WIDTH;
                if (format.charAt(i) != '*') continue;
                info.setWidthWildcardFlag(true);
                continue;
            }
            if (state == ConversionState.WIDTH && Character.isDigit(format.charAt(i))) continue;
            if ((state == ConversionState.START || state == ConversionState.FLAGS || state == ConversionState.WIDTH) && format.charAt(i) == '.') {
                state = ConversionState.PRECISION;
                continue;
            }
            if (state == ConversionState.PRECISION && format.substring(i, i + 1).matches("[0-9]|\\*")) {
                if (format.charAt(i) != '*') continue;
                info.setPrecisionWildcardFlag(true);
                continue;
            }
            if (state == ConversionState.DEFAULT) continue;
            if (i + 2 < format.length() && format.substring(i, i + 2).equals("hh")) {
                ++startOffset;
                ++endOffset;
                info.setLengthFlag(LengthFlag.hh);
                ++i;
                continue;
            }
            if (format.charAt(i) == 'h') {
                info.setLengthFlag(LengthFlag.h);
                continue;
            }
            if (format.charAt(i) == 'j') {
                info.setLengthFlag(LengthFlag.j);
                continue;
            }
            if (format.charAt(i) == 'z') {
                info.setLengthFlag(LengthFlag.z);
                continue;
            }
            if (format.charAt(i) == 't') {
                info.setLengthFlag(LengthFlag.t);
                continue;
            }
            if (i + 2 < format.length() && format.substring(i, i + 2).equals("ll")) {
                ++startOffset;
                ++endOffset;
                info.setLengthFlag(LengthFlag.ll);
                ++i;
                continue;
            }
            if (format.charAt(i) == 'l') {
                info.setLengthFlag(LengthFlag.l);
                continue;
            }
            if (format.charAt(i) == 'L') {
                info.setLengthFlag(LengthFlag.L);
                continue;
            }
            info.setSpecifier(String.valueOf(format.charAt(i)));
            info.setEndOffset(offset + endOffset);
            result.add(info);
            state = ConversionState.DEFAULT;
        }
        return result;
    }

    private int getParametersFromFormat(Collection<FormatInfo> info) {
        int result = 0;
        for (FormatInfo i : info) {
            if (!i.specifier().equals("%")) {
                ++result;
            }
            if (i.hasPrecisionWildcard()) {
                ++result;
            }
            if (!i.hasWidthWildcard()) continue;
            ++result;
        }
        return result;
    }

    private String getParameterType(String value, int offset, CsmFile file) {
        DummyResolvedTypeHandler handler = new DummyResolvedTypeHandler();
        CsmExpressionResolver.resolveType((CharSequence)value, (CsmFile)file, (int)offset, null, (CsmExpressionResolver.ResolvedTypeHandler)handler);
        if (handler.type != null) {
            CsmDeclaration.Kind kind;
            CsmClassifier handlerClassifier = null;
            CsmType handlerType = handler.type;
            CsmClassifier clsf = handlerType.getClassifier();
            if (clsf != null && (kind = clsf.getKind()) != null && kind.equals((Object)CsmDeclaration.Kind.TYPEDEF)) {
                switch (handlerType.getCanonicalText().toString()) {
                    case "intmax_t": 
                    case "intmax_t*": 
                    case "uintmax_t": 
                    case "uintmax_t*": 
                    case "size_t": 
                    case "size_t*": 
                    case "ptrdiff_t": 
                    case "ptrdiff_t*": 
                    case "wint_t": 
                    case "wint_t*": 
                    case "wchar_t": 
                    case "wchar_t*": {
                        break;
                    }
                    default: {
                        handlerClassifier = CsmClassifierResolver.getDefault().getTypeClassifier(handlerType, file, offset, true);
                    }
                }
            }
            if (handlerClassifier == null) {
                handlerClassifier = handlerType.getClassifier();
            }
            StringBuilder result = new StringBuilder(handlerClassifier.getName().toString().replace("const", "").replace("&", ""));
            int limit = Math.max(handlerType.getArrayDepth(), handlerType.getPointerDepth());
            for (int i = 0; i < limit; ++i) {
                result.append("*");
            }
            return result.toString();
        }
        return null;
    }

    static {
        String doStrictCheck = System.getProperty("printf.check.strict");
        STRICT_TYPE_CHECKS = doStrictCheck != null ? Boolean.parseBoolean(doStrictCheck) : false;
    }

    private static class FormatInfo {
        private static final List<String> conversionCharacters = Arrays.asList("d", "i", "o", "u", "x", "X", "f", "F", "e", "E", "g", "G", "a", "A", "c", "s", "p", "n", "C", "S", "%");
        private final List<FormatFlag> formatFlags = new LinkedList<FormatFlag>();
        private LengthFlag lengthFlag;
        private String specifier;
        private boolean hasWidthWildcard = false;
        private boolean hasPrecisionWildcard = false;
        private int startOffset;
        private int endOffset;

        public boolean hasWidthWildcard() {
            return this.hasWidthWildcard;
        }

        public boolean hasPrecisionWildcard() {
            return this.hasPrecisionWildcard;
        }

        public void setSpecifier(String specifier) {
            this.specifier = specifier;
        }

        public void setLengthFlag(LengthFlag lengthFlag) {
            this.lengthFlag = lengthFlag;
        }

        public void addFormatFlag(FormatFlag flag) {
            this.formatFlags.add(flag);
        }

        public void setWidthWildcardFlag(boolean flag) {
            this.hasWidthWildcard = flag;
        }

        public void setPrecisionWildcardFlag(boolean flag) {
            this.hasPrecisionWildcard = flag;
        }

        public void setStartOffset(int startOffset) {
            this.startOffset = startOffset;
        }

        public void setEndOffset(int endOffset) {
            this.endOffset = endOffset;
        }

        public int startOffset() {
            return this.startOffset;
        }

        public int endOffset() {
            return this.endOffset;
        }

        public String specifier() {
            return this.specifier;
        }

        public String getFullType() {
            StringBuilder result = new StringBuilder();
            if (this.lengthFlag != null) {
                result.append((Object)this.lengthFlag);
            }
            result.append(this.specifier);
            return result.toString();
        }

        public List<FormatError> validateFormat() {
            if (!conversionCharacters.contains(this.specifier)) {
                return Collections.singletonList(new FormatError(FormatError.FormatErrorType.TYPE_NOTEXIST, null, this.specifier, this.startOffset, this.endOffset));
            }
            LinkedList<FormatError> result = new LinkedList<FormatError>();
            block0: for (FormatFlag flag : this.formatFlags) {
                int filter = 0x100000;
                int limit = conversionCharacters.size();
                for (int i = 0; i < limit; ++i) {
                    if ((flag.getMask() & filter) == 0 && this.specifier.equals(conversionCharacters.get(i))) {
                        result.add(new FormatError(FormatError.FormatErrorType.FLAG, String.valueOf(flag.character()), this.specifier, this.startOffset, this.endOffset));
                        continue block0;
                    }
                    filter >>= 1;
                }
            }
            if (this.lengthFlag != null) {
                int filter = 0x100000;
                int limit = conversionCharacters.size();
                for (int i = 0; i < limit; ++i) {
                    if ((this.lengthFlag.getMask() & filter) == 0 && this.specifier.equals(conversionCharacters.get(i))) {
                        result.add(new FormatError(FormatError.FormatErrorType.LENGTH, this.lengthFlag.toString(), this.specifier, this.startOffset, this.endOffset));
                        break;
                    }
                    filter >>= 1;
                }
            }
            return result;
        }
    }

    private static enum LengthFlag {
        h("h", 2064392),
        hh("hh", 2064392),
        l("l", 2097128),
        ll("ll", 0x1FFF88),
        j("j", 2064392),
        z("z", 2064392),
        t("t", 2064392),
        L("L", 32640);

        private final String flag;
        private final int mask;

        private LengthFlag(String flag, int mask) {
            this.flag = flag;
            this.mask = mask;
        }

        public String toString() {
            return this.flag;
        }

        public int getMask() {
            return this.mask;
        }
    }

    private static enum FormatFlag {
        APOSTROPHE('\'', 1730432),
        MINUS('-', 0x1FFFFF),
        PLUS('+', 0x1FFFFF),
        SPACE(' ', 0x1FFFFF),
        HASH('#', 393088),
        ZERO('0', 2097024);

        private final char flag;
        private final int mask;

        private FormatFlag(char flag, int mask) {
            this.flag = flag;
            this.mask = mask;
        }

        public char character() {
            return this.flag;
        }

        public int getMask() {
            return this.mask;
        }
    }

    private static enum ConversionState {
        DEFAULT,
        START,
        FLAGS,
        WIDTH,
        PRECISION,
        CONVERSION;

    }

    private static class DummyResolvedTypeHandler
    implements CsmExpressionResolver.ResolvedTypeHandler {
        public CsmType type;

        private DummyResolvedTypeHandler() {
        }

        public void process(CsmType resolvedType) {
            this.type = resolvedType;
        }
    }
}

