/*
 * Decompiled with CFR 0.152.
 */
package org.clank.java.stdimpl.aliases;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.NativeType;
import org.clank.support.aliases.JavaIterator;
import org.clank.support.aliases.type$iterator;
import org.clank.support.aliases.type$ptr;
import org.clank.support.aliases.type$ref;

public abstract class StdVector<T>
implements Native.assignable<std.vector<T>>,
NativeCloneable<std.vector<T>>,
Native.NativeComparable<std.vector<T>>,
Native.ComparableLower,
NativeType.SizeofCapable,
Iterable<T>,
Destructors.ClassWithDestructor {
    protected final T defaultValue;
    protected T[] array;
    private static final Object[] EMPTY = new Object[0];
    protected int end;

    protected StdVector(T defaultValue) {
        this.array = EMPTY;
        this.end = 0;
        this.defaultValue = defaultValue;
    }

    protected StdVector(int initialSize, T defaultValue) {
        this(defaultValue);
        this.assign(initialSize, defaultValue);
    }

    protected StdVector(T[] array2, int length, T defaultValue) {
        this.array = array2;
        this.end = length;
        this.defaultValue = defaultValue;
    }

    protected StdVector(type$iterator<?, T> iter, int length, T defaultValue) {
        this(iter, (type$iterator)iter.$add(length), defaultValue);
    }

    protected StdVector(type$iterator<?, T> begin, type$iterator<?, T> end, T defaultValue) {
        this(defaultValue);
        this.append(begin, end);
    }

    protected StdVector(std.vector<T> other) {
        this(other.defaultValue);
        this.append(other.begin(), other.end());
    }

    protected StdVector(JavaDifferentiators.JD.Move _dparam, std.vector<T> other) {
        this(null);
        this.$assignMove(other);
    }

    @Override
    public std.vector<T> $assign(std.vector<T> other) {
        this.array = other.array;
        this.end = other.end;
        return (std.vector)this;
    }

    public std.vector<T> $assignMove(std.vector<T> other) {
        T[] tmpArray = this.array;
        int tmpEnd = this.end;
        this.array = other.array;
        this.end = other.end;
        other.array = tmpArray;
        other.end = tmpEnd;
        return (std.vector)this;
    }

    public void clear() {
        this.destroy_range(0, this.size());
        this.setEnd(0);
    }

    public void resize(int newSize) {
        this.resize(newSize, this.defaultValue);
    }

    public void resize(int newSize, T defaultValue) {
        if (newSize < this.end) {
            this.destroy_range(newSize, this.end);
        } else if (newSize > this.end) {
            if (this.capacity() < newSize) {
                this.grow(newSize);
            }
            for (int i = this.end; i < newSize; ++i) {
                this.array[i] = Native.$tryClone(defaultValue);
            }
        }
        this.setEnd(newSize);
    }

    public void reserve(int N) {
        if (this.capacity() < N) {
            this.grow(N);
        }
    }

    public void assign(int NumElts, T Elt) {
        this.clear();
        if (this.capacity() < NumElts) {
            this.grow(NumElts);
        }
        this.setEnd(NumElts);
        for (int i = 0; i < this.size(); ++i) {
            this.$set(i, Elt);
        }
    }

    public void assign(type$iterator<?, T> __first, type$iterator<?, T> __last) {
        this.clear();
        this.append(__first, __last);
    }

    public void swap(StdVector<T> RHS) {
        T[] arrTmp = this.array;
        this.array = RHS.array;
        RHS.array = arrTmp;
        int endTmp = this.end;
        this.end = RHS.end;
        RHS.end = endTmp;
    }

    public final int find(Object elem) {
        return this.find(elem, 0);
    }

    public final int find(Object elem, int from) {
        boolean isDataPointerLike = this.isDataPointerLike();
        for (int i = from; i < this.end; ++i) {
            if (!Native.$eq(this.array[i], elem, isDataPointerLike)) continue;
            return i;
        }
        return std.string.npos;
    }

    public final boolean contains(Object elem) {
        return this.find(elem) != std.string.npos;
    }

    public final boolean erase(Object elem) {
        int index = this.find(elem);
        if (index == std.string.npos) {
            return false;
        }
        this.destroy_range(index, index + 1);
        --this.end;
        if (index < this.end) {
            std.copy(this.array, index + 1, this.end - index, this.array, index);
        }
        this.$set(this.end, this.defaultValue);
        return true;
    }

    public iterator erase(iterator I) {
        assert (I.$greatereq(this.begin())) : "Iterator to erase is out of bounds.";
        assert (I.$less(this.end())) : "Erasing at past-the-end iterator.";
        iterator N = I;
        std.copy(I.$add(1), this.end(), I);
        this.pop_back();
        return N;
    }

    public iterator erase(iterator S, iterator E) {
        assert (S.$greatereq(this.begin())) : "Range to erase is out of bounds.";
        assert (S.$lesseq(E)) : "Trying to erase invalid range.";
        assert (E.$lesseq(this.end())) : "Trying to erase past the end.";
        iterator N = S;
        iterator I = std.copy(E, this.end(), S);
        this.destroy_range(I, this.end());
        this.setEnd(I);
        return N;
    }

    public iterator insert(iterator I, T Elt) {
        if (((iterator)I).$eq(this.end())) {
            this.push_back(Elt);
            return this.end().$sub(1);
        }
        assert (((iterator)I).$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (((iterator)I).$lesseq(this.end())) : "Inserting past the end of the vector.";
        if (this.size() >= this.capacity()) {
            int EltNo = ((iterator)I).$sub(this.begin());
            this.grow();
            I = this.begin().$add(EltNo);
        }
        assert (this.size() < this.capacity());
        this.setEnd(this.size() + 1);
        std.copy_backward(I, this.end().$sub(1), this.end());
        ((iterator)I).star$ref().$set(Elt);
        return I;
    }

    public iterator insert(iterator I, int NumToInsert, T Elt) {
        assert (NumToInsert >= 0);
        int InsertElt = I.$sub(this.begin());
        if (I.$eq(this.end())) {
            this.append(NumToInsert, Elt);
            return this.begin().$add(InsertElt);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        this.reserve(this.size() + NumToInsert);
        I = this.begin().$add(InsertElt);
        if (this.end().$sub((iterator<T>)I) >= NumToInsert) {
            iterator<T> OldEnd = this.end();
            this.append((type$iterator<?, T>)this.end().$sub(NumToInsert), (type$iterator<?, T>)this.end());
            std.copy_backward(I, OldEnd.$sub(NumToInsert), OldEnd);
            std.fill_n(I, NumToInsert, Elt);
            return I;
        }
        iterator<T> OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        int NumOverwritten = OldEnd.$sub((iterator<T>)I);
        std.copy(I, OldEnd, this.end().$sub(NumOverwritten));
        std.fill_n(I, NumOverwritten, Elt);
        std.fill_n(OldEnd, NumToInsert - NumOverwritten, Elt);
        return I;
    }

    public iterator insert(iterator I, type$iterator<?, T> From, type$iterator<?, T> To) {
        int NumOverwritten;
        int InsertElt = ((iterator)I).$sub(this.begin());
        if (((iterator)I).$eq(this.end())) {
            this.append(From, To);
            return this.begin().$add(InsertElt);
        }
        assert (((iterator)I).$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (((iterator)I).$lesseq(this.end())) : "Inserting past the end of the vector.";
        int NumToInsert = std.distance(From, To);
        this.reserve(this.size() + NumToInsert);
        I = this.begin().$add(InsertElt);
        if (this.end().$sub(I) >= NumToInsert) {
            iterator<T> OldEnd = this.end();
            this.append((type$iterator<?, T>)this.end().$sub(NumToInsert), (type$iterator<?, T>)this.end());
            std.copy_backward(I, OldEnd.$sub(NumToInsert), OldEnd);
            std.copy(From, To, I);
            return I;
        }
        iterator OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        std.copy(I, OldEnd, this.end().$sub(NumOverwritten));
        From = Native.$tryClone(From);
        Object J = ((iterator)I).clone();
        for (NumOverwritten = OldEnd.$sub(I); NumOverwritten > 0; --NumOverwritten) {
            ((iterator)J).star$ref().$set(From.$star());
            ((iterator)J).$preInc();
            From.$preInc();
        }
        std.copy(From, To, OldEnd);
        return I;
    }

    public void append(type$iterator<?, T> in_start, type$iterator<?, T> in_end) {
        int NumInputs = std.distance(in_start, in_end);
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        type$iterator iter = (type$iterator)in_start.clone();
        while (!iter.$eq(in_end)) {
            this.$set(this.end, iter.$star());
            ++this.end;
            iter.$preInc();
        }
    }

    public void append(int NumInputs, T Elt) {
        assert (NumInputs >= 0);
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        for (int i = 0; i < NumInputs; ++i) {
            this.$set(this.end, Elt);
            ++this.end;
        }
    }

    @Override
    public boolean $eq(std.vector<T> RHS) {
        if (this.size() != RHS.size()) {
            return false;
        }
        return std.equal(this.begin(), this.end(), RHS.begin());
    }

    @Override
    public boolean $noteq(std.vector<T> RHS) {
        return !this.$eq(RHS);
    }

    @Override
    public boolean $less(Object obj) {
        return std.lexicographical_compare(this.begin(), this.end(), ((StdVector)obj).begin(), ((StdVector)obj).end());
    }

    @Override
    public boolean $lesseq(Object obj) {
        return this.$less(obj) || this.$eq((std.vector)obj);
    }

    public type$ref<T> ref$at(int idx) {
        return NativePointer.create_type$ref(this.array, idx);
    }

    public T $at(int idx) {
        return this.array[idx];
    }

    public T $set(int idx, T value) {
        this.array[idx] = this.defaultValue == null ? value : Native.$tryAssign(this.array[idx], value, this.isDataPointerLike());
        return value;
    }

    public boolean empty() {
        return this.size() == 0;
    }

    @Override
    public void $destroy() {
        this.destroy_range(0, this.size());
        this.setEnd(0);
    }

    public void push_back(T val) {
        if (this.size() >= this.capacity()) {
            this.grow(2 * this.capacity() + 1);
        }
        this.$set(this.size(), val);
        this.setEnd(this.size() + 1);
    }

    public void emplace_back() {
        this.push_back(this.defaultValue);
    }

    public void emplace_back(T value) {
        this.push_back(value);
    }

    public void pop_back() {
        this.destroy_range(this.size() - 1, this.size());
        this.setEnd(this.size() - 1);
    }

    public T pop_back_val() {
        T val = this.back();
        this.setEnd(this.end - 1);
        return val;
    }

    public final iterator<T> begin() {
        return new iterator(this, 0, false);
    }

    public final iterator<T> end() {
        return new iterator(this, this.end, false);
    }

    public std.reverse_iterator<T> rbegin() {
        return new std.reverse_iterator(NativePointer.create_type$ptr(this.array, this.end));
    }

    public std.reverse_iterator<T> rend() {
        return new std.reverse_iterator(NativePointer.create_type$ptr(this.array));
    }

    public type$ptr<T> data() {
        return NativePointer.create_type$ptr(this.array);
    }

    public T front() {
        return this.array[0];
    }

    public T back() {
        return this.array[this.end - 1];
    }

    public type$ref<T> ref$front() {
        return new type$ref<T>(){
            private final T stored;
            private final int index = 0;
            {
                this.stored = StdVector.this.array[0];
                this.index = 0;
            }

            @Override
            public T $deref() {
                return this.stored;
            }

            @Override
            public T $set(T value) {
                if (this.stored instanceof Native.assignable) {
                    ((Native.assignable)this.stored).$assign(value);
                } else {
                    StdVector.this.array[0] = Native.$tryClone(value);
                }
                return value;
            }

            @Override
            public type$ptr<T> deref$ptr() {
                return (type$ptr)StdVector.this.data().$add(0);
            }
        };
    }

    public type$ref<T> ref$back() {
        return new type$ref<T>(){
            private final T stored;
            private final int index;
            {
                this.stored = StdVector.this.array[StdVector.this.end - 1];
                this.index = StdVector.this.end - 1;
            }

            @Override
            public T $deref() {
                return this.stored;
            }

            @Override
            public T $set(T value) {
                if (this.stored instanceof Native.assignable) {
                    ((Native.assignable)this.stored).$assign(value);
                } else {
                    StdVector.this.array[this.index] = Native.$tryClone(value);
                }
                return value;
            }

            @Override
            public type$ptr<T> deref$ptr() {
                return (type$ptr)StdVector.this.data().$add(this.index);
            }
        };
    }

    public int size() {
        return this.end;
    }

    public int max_size() {
        return Integer.MAX_VALUE;
    }

    public int capacity() {
        return this.array.length;
    }

    @Override
    public int $sizeof() {
        int oneElemSize = NativeType.sizeof(this.defaultValue);
        for (T elem : this.array) {
            if (elem == this.defaultValue) continue;
            oneElemSize = NativeType.sizeof(elem);
            break;
        }
        return this.capacity() * oneElemSize;
    }

    public type$ptr<T> ptr$at(int idx) {
        return NativePointer.create_type$ptr(this.array, idx);
    }

    @Override
    public std.vector<T> clone() {
        return new std.vector((std.vector)this);
    }

    public void set_size(int N) {
        assert (N >= 0);
        assert (N <= this.capacity());
        this.setEnd(N);
    }

    private void destroy_range(int from, int to) {
        for (int i = from; i < to; ++i) {
            if (this.defaultValue == null) {
                this.array[i] = null;
                continue;
            }
            Native.destroy(this.array[i]);
        }
    }

    private void destroy_range(iterator _from, iterator _to) {
        this.destroy_range(_from.$sub(this.begin()), _to.$sub(this.begin()));
    }

    private void grow(int newSize) {
        this.array = NativePointer.copyOf$Object(this.array, newSize);
    }

    private void grow() {
        this.grow(this.capacity() > 0 ? this.capacity() * 2 : 1);
    }

    private void setEnd(int to) {
        this.end = to;
    }

    private void setEnd(iterator to) {
        this.setEnd(to.$sub(this.begin()));
    }

    @Override
    public Iterator<T> iterator() {
        return new JavaIterator(this.begin(), this.end());
    }

    public boolean isDataPointerLike() {
        return this.defaultValue == null;
    }

    public String toString() {
        if (this.end == 0) {
            return "<EMPTY>";
        }
        StringBuilder out = new StringBuilder("\n").append(this.getClass().getSimpleName()).append("{\nend = " + this.end + '\n');
        String fmt = "%" + (int)Math.ceil(Math.log10(this.end + 1)) + "d";
        for (int i = 0; i < this.end; ++i) {
            T element = this.array[i];
            out.append("[").append(String.format(fmt, i)).append("]");
            out.append(element).append('\n');
        }
        out.append("}").append(this.getClass().getSimpleName()).append("}\n");
        return out.toString();
    }

    public static final class iterator<T>
    implements type$iterator<iterator<T>, T>,
    Native.assignable<iterator<T>>,
    Native.ComparableLowerGreater {
        private final boolean _const;
        private final StdVector<T> delegate;
        private int index;

        public iterator(StdVector<T> delegate, int index, boolean makeConst) {
            this.delegate = delegate;
            this.index = index;
            this._const = makeConst;
        }

        public iterator(iterator<T> other) {
            this.delegate = other.delegate;
            this.index = other.index;
            this._const = other._const;
        }

        public iterator(JavaDifferentiators.JD.Move _dparam, iterator<T> other) {
            this.delegate = other.delegate;
            this.index = other.index;
            this._const = other._const;
        }

        @Override
        public iterator<T> $assign(iterator<T> other) {
            assert (this.delegate == other.delegate);
            this.index = other.index;
            return this;
        }

        @Override
        public T $arrow() {
            return this.$at(0);
        }

        @Override
        public T $star() {
            return this.$at(0);
        }

        @Override
        public type$ref<T> star$ref() {
            return this.ref$at(0);
        }

        @Override
        public int $sub(iterator<T> iter) {
            assert (this.delegate == iter.delegate);
            return this.index - iter.index;
        }

        @Override
        public iterator<T> $preInc() {
            assert (!this._const);
            ++this.index;
            return this;
        }

        @Override
        public iterator<T> $preDec() {
            assert (!this._const);
            --this.index;
            return this;
        }

        @Override
        public iterator<T> $postInc() {
            assert (!this._const);
            iterator<T> cloned = new iterator<T>(this.delegate, this.index, false);
            ++this.index;
            return cloned;
        }

        @Override
        public iterator<T> $postDec() {
            assert (!this._const);
            iterator<T> cloned = new iterator<T>(this.delegate, this.index, false);
            --this.index;
            return cloned;
        }

        @Override
        public iterator<T> $inc(int amount) {
            assert (!this._const);
            this.index += amount;
            return this;
        }

        @Override
        public iterator<T> $dec(int amount) {
            assert (!this._const);
            this.index -= amount;
            return this;
        }

        @Override
        public iterator<T> $add(int amount) {
            return new iterator<T>(this.delegate, this.index + amount, false);
        }

        @Override
        public iterator<T> $sub(int amount) {
            return new iterator<T>(this.delegate, this.index - amount, false);
        }

        public boolean $noteq(Object other) {
            assert (this.delegate == ((iterator)other).delegate);
            return this.index != ((iterator)other).index;
        }

        public boolean $eq(Object other) {
            assert (this.delegate == ((iterator)other).delegate);
            return this.index == ((iterator)other).index;
        }

        @Override
        public iterator<T> clone() {
            return new iterator<T>(this.delegate, this.index, false);
        }

        @Override
        public iterator<T> const_clone() {
            return new iterator<T>(this.delegate, this.index, true);
        }

        @Override
        public boolean $less(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index < ((iterator)obj).index;
        }

        @Override
        public boolean $lesseq(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index <= ((iterator)obj).index;
        }

        @Override
        public boolean $greater(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index > ((iterator)obj).index;
        }

        @Override
        public boolean $greatereq(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index >= ((iterator)obj).index;
        }

        public T $at(int index) {
            return this.delegate.$at(this.index + index);
        }

        public type$ref<T> ref$at(int index) {
            return this.delegate.ref$at(this.index + index);
        }

        public type$ptr<T> toPointer() {
            return NativePointer.create_type$ptr(this.delegate.array, this.index);
        }

        public int $index() {
            return this.index;
        }

        public String toString() {
            return "[" + this.index + "] from\n" + this.delegate.toString();
        }
    }
}

