/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.api.restricted;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.netbeans.modules.j2ee.sun.api.ServerInterface;
import org.netbeans.modules.j2ee.sun.api.restricted.ResourceUtils;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.AdminObjectResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.ConnectorConnectionPool;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.ConnectorResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.JdbcConnectionPool;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.JdbcResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.MailResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.Resources;

public class RegistrationUtils {
    private static String POOL_EXTENSION = "_Base";
    private static String DELETE_POOL = "deleteJdbcConnectionPool";
    private static String DELETE_JDBC = "deleteJdbcResource";
    private static String DELETE_MAIL = "deleteMailResource";
    private static String DELETE_CONNECTOR = "deleteConnectorResource";
    private static String DELETE_CONNECTORPOOL = "deleteConnectorConnectionPool";
    private static String DELETE_ADMINOBJECT = "deleteAdminObjectResource";
    private static String DAS_SERVER_NAME = "server";
    private static final Logger LOG = Logger.getLogger(RegistrationUtils.class.getName());

    public static void checkUpdateServerResources(ServerInterface mejb, File primaryFile) {
        Resources resources = ResourceUtils.getResourcesGraph(primaryFile);
        RegistrationUtils.updateJDBCResourcesAndPools(resources, mejb);
        RegistrationUtils.updateMailResources(resources, mejb);
        RegistrationUtils.updateJMSResources(resources, mejb);
    }

    private static void updateJDBCResourcesAndPools(Resources resources, ServerInterface mejb) {
        HashMap serverPools = RegistrationUtils.getServerConnectionPools(mejb, "getJdbcConnectionPool");
        HashMap serverDatasources = RegistrationUtils.getServerResources(mejb, "getJdbcResource");
        JdbcConnectionPool[] pools = resources.getJdbcConnectionPool();
        JdbcResource[] dataSources = resources.getJdbcResource();
        HashMap dupJdbcResources = RegistrationUtils.getProjectDatasources(serverDatasources, dataSources);
        RegistrationUtils.deleteServerResources(dupJdbcResources, mejb, DELETE_JDBC);
        for (int i = 0; i < pools.length; ++i) {
            JdbcConnectionPool connectionPoolBean = pools[i];
            String newPoolName = connectionPoolBean.getName();
            if (serverPools.containsKey(newPoolName)) {
                HashMap serverJdbcResources = RegistrationUtils.getReferringResources(newPoolName, serverDatasources, mejb);
                if (serverJdbcResources.size() > 0) {
                    RegistrationUtils.copyServerPool(serverPools, newPoolName, "createJdbcConnectionPool", mejb);
                    RegistrationUtils.updateExternalResource(serverJdbcResources, newPoolName, mejb);
                }
                RegistrationUtils.deleteOldServerPool(newPoolName, DELETE_POOL, mejb);
                continue;
            }
            RegistrationUtils.deleteOldServerPool(newPoolName, DELETE_POOL, mejb);
        }
    }

    private static void updateMailResources(Resources resources, ServerInterface mejb) {
        HashMap serverMailResources = RegistrationUtils.getServerResources(mejb, "getMailResource");
        MailResource[] mails = resources.getMailResource();
        HashMap dupMailResources = RegistrationUtils.getProjectMailResources(serverMailResources, mails);
        RegistrationUtils.deleteServerResources(dupMailResources, mejb, DELETE_MAIL);
    }

    private static void updateJMSResources(Resources resources, ServerInterface mejb) {
        RegistrationUtils.updateAdminObjects(resources, mejb);
        RegistrationUtils.updateConnectorsAndPools(resources, mejb);
    }

    private static void updateAdminObjects(Resources resources, ServerInterface mejb) {
        HashMap serverAdminObjects = RegistrationUtils.getServerResources(mejb, "getAdminObjectResource");
        AdminObjectResource[] adminObjects = resources.getAdminObjectResource();
        HashMap dupAdminObjects = RegistrationUtils.getProjectAdminObjects(serverAdminObjects, adminObjects);
        RegistrationUtils.deleteServerResources(dupAdminObjects, mejb, DELETE_ADMINOBJECT);
    }

    private static void updateConnectorsAndPools(Resources resources, ServerInterface mejb) {
        HashMap serverConnectorPools = RegistrationUtils.getServerConnectionPools(mejb, "getConnectorConnectionPool");
        HashMap serverConnectors = RegistrationUtils.getServerResources(mejb, "getConnectorResource");
        ConnectorConnectionPool[] connectorPools = resources.getConnectorConnectionPool();
        ConnectorResource[] connectors = resources.getConnectorResource();
        HashMap dupConnectors = RegistrationUtils.getProjectConnectors(serverConnectors, connectors);
        RegistrationUtils.deleteServerResources(dupConnectors, mejb, DELETE_CONNECTOR);
        for (int i = 0; i < connectorPools.length; ++i) {
            ConnectorConnectionPool connectorPoolBean = connectorPools[i];
            String newPoolName = connectorPoolBean.getName();
            if (serverConnectorPools.containsKey(newPoolName)) {
                HashMap serverConnectorResources = RegistrationUtils.getReferringResources(newPoolName, serverConnectors, mejb);
                if (serverConnectorResources.size() > 0) {
                    RegistrationUtils.copyServerPool(serverConnectorPools, newPoolName, "createConnectorConnectionPool", mejb);
                    RegistrationUtils.updateExternalResource(serverConnectorResources, newPoolName, mejb);
                }
                RegistrationUtils.deleteOldServerPool(newPoolName, DELETE_CONNECTORPOOL, mejb);
                continue;
            }
            RegistrationUtils.deleteOldServerPool(newPoolName, DELETE_CONNECTORPOOL, mejb);
        }
    }

    public static HashMap getServerConnectionPools(ServerInterface mejb, String operationName) {
        HashMap<String, ObjectName> pools = new HashMap<String, ObjectName>();
        try {
            ObjectName configObjName = new ObjectName("com.sun.appserv:type=resources,category=config");
            ObjectName[] resourceObjects = (ObjectName[])mejb.invoke(configObjName, operationName, null, null);
            for (int i = 0; i < resourceObjects.length; ++i) {
                ObjectName objName = resourceObjects[i];
                String poolName = (String)mejb.getAttribute(objName, "name");
                pools.put(poolName, objName);
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Unable to get server connection pools", ex);
        }
        return pools;
    }

    public static HashMap getReferringResources(String poolName, HashMap serverResources, ServerInterface mejb) {
        HashMap<String, ObjectName> referringResources = new HashMap<String, ObjectName>();
        try {
            for (String resourceName : serverResources.keySet()) {
                ObjectName objName = (ObjectName)serverResources.get(resourceName);
                String connpoolName = (String)mejb.getAttribute(objName, "pool-name");
                if (!connpoolName.equals(poolName)) continue;
                referringResources.put(resourceName, objName);
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Unable to get referring resources", ex);
        }
        return referringResources;
    }

    public static HashMap getProjectDatasources(HashMap serverJdbcResources, JdbcResource[] dataSources) {
        HashMap<String, ObjectName> datasources = new HashMap<String, ObjectName>();
        for (int i = 0; i < dataSources.length; ++i) {
            JdbcResource dsResource = dataSources[i];
            String dsName = dsResource.getJndiName();
            if (!serverJdbcResources.containsKey(dsName)) continue;
            datasources.put(dsName, (ObjectName)serverJdbcResources.get(dsName));
        }
        return datasources;
    }

    public static HashMap getProjectMailResources(HashMap serverMailResources, MailResource[] mails) {
        HashMap<String, ObjectName> mailResources = new HashMap<String, ObjectName>();
        for (int i = 0; i < mails.length; ++i) {
            MailResource mailResource = mails[i];
            String mailName = mailResource.getJndiName();
            if (!serverMailResources.containsKey(mailName)) continue;
            mailResources.put(mailName, (ObjectName)serverMailResources.get(mailName));
        }
        return mailResources;
    }

    public static HashMap getProjectAdminObjects(HashMap serverAdminObjects, AdminObjectResource[] adminObjects) {
        HashMap<String, ObjectName> adminObjectResources = new HashMap<String, ObjectName>();
        for (int i = 0; i < adminObjects.length; ++i) {
            AdminObjectResource aoResource = adminObjects[i];
            String jndiName = aoResource.getJndiName();
            if (!serverAdminObjects.containsKey(jndiName)) continue;
            adminObjectResources.put(jndiName, (ObjectName)serverAdminObjects.get(jndiName));
        }
        return adminObjectResources;
    }

    public static HashMap getProjectConnectors(HashMap serverConnectors, ConnectorResource[] connectors) {
        HashMap<String, ObjectName> connectorResources = new HashMap<String, ObjectName>();
        for (int i = 0; i < connectors.length; ++i) {
            ConnectorResource connResource = connectors[i];
            String jndiName = connResource.getJndiName();
            if (!serverConnectors.containsKey(jndiName)) continue;
            connectorResources.put(jndiName, (ObjectName)serverConnectors.get(jndiName));
        }
        return connectorResources;
    }

    public static void updateExternalResource(HashMap serverResources, String newPoolName, ServerInterface mejb) {
        try {
            String updatedPoolName = newPoolName + POOL_EXTENSION;
            for (ObjectName dsObjName : serverResources.values()) {
                Attribute poolNameAttr = new Attribute("pool-name", updatedPoolName);
                mejb.setAttribute(dsObjName, poolNameAttr);
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getLocalizedMessage());
        }
    }

    public static void copyServerPool(HashMap serverPools, String newPoolName, String operationName, ServerInterface mejb) {
        try {
            String updatedPoolName = newPoolName + POOL_EXTENSION;
            if (!serverPools.containsKey(updatedPoolName)) {
                ObjectName serverPoolObj = (ObjectName)serverPools.get(newPoolName);
                Map attributeInfos = ResourceUtils.getResourceAttributeNames(serverPoolObj, mejb);
                attributeInfos.remove("name");
                String[] attrNames = attributeInfos.keySet().toArray(new String[attributeInfos.size()]);
                AttributeList attrList = mejb.getAttributes(serverPoolObj, attrNames);
                Attribute nameAttr = new Attribute("name", updatedPoolName);
                attrList.add(nameAttr);
                Properties props = new Properties();
                AttributeList propsList = (AttributeList)mejb.invoke(serverPoolObj, "getProperties", null, null);
                for (int i = 0; i < propsList.size(); ++i) {
                    Attribute propAttr = (Attribute)propsList.get(i);
                    String propName = propAttr.getName();
                    Object propValue = propAttr.getValue();
                    if (propValue == null) continue;
                    props.put(propName, propValue);
                }
                Object[] params = new Object[]{attrList, props, null};
                ResourceUtils.createResource(operationName, params, mejb);
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getLocalizedMessage());
        }
    }

    public static void deleteOldServerPool(String newPoolName, String operationName, ServerInterface mejb) {
        try {
            ObjectName objName = new ObjectName("com.sun.appserv:type=resources,category=config");
            mejb.invoke(objName, operationName, new Object[]{newPoolName, DAS_SERVER_NAME}, new String[]{"java.lang.String", "java.lang.String"});
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Unable to clean up existing duplicate pools", ex);
        }
    }

    public static void deleteServerResources(HashMap serverResources, ServerInterface mejb, String operationName) {
        try {
            ObjectName objName = new ObjectName("com.sun.appserv:type=resources,category=config");
            for (String jdbcName : serverResources.keySet()) {
                mejb.invoke(objName, operationName, new Object[]{jdbcName, DAS_SERVER_NAME}, new String[]{"java.lang.String", "java.lang.String"});
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Unable to clean up existing duplicate datasources", ex);
        }
    }

    public static HashMap getServerResources(ServerInterface mejb, String operationName) {
        HashMap<String, ObjectName> serverResources = new HashMap<String, ObjectName>();
        try {
            ObjectName configObjName = new ObjectName("com.sun.appserv:type=resources,category=config");
            ObjectName[] resourceObjects = (ObjectName[])mejb.invoke(configObjName, operationName, null, null);
            for (int i = 0; i < resourceObjects.length; ++i) {
                ObjectName objName = resourceObjects[i];
                String jndiName = (String)mejb.getAttribute(objName, "jndi-name");
                serverResources.put(jndiName, objName);
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Unable to get server datasources", ex);
        }
        return serverResources;
    }
}

