/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makefile.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import org.netbeans.modules.cnd.api.makefile.MakefileElement;
import org.netbeans.modules.cnd.api.makefile.MakefileRule;
import org.netbeans.modules.cnd.makefile.parser.MakefileParseResult;
import org.netbeans.modules.cnd.makefile.parser.MakefileUtils;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.api.StructureScanner;
import org.netbeans.modules.csl.spi.ParserResult;
import org.openide.util.ImageUtilities;

public final class MakefileStructureScanner
implements StructureScanner {
    public List<? extends StructureItem> scan(ParserResult parseResult) {
        if (parseResult instanceof MakefileParseResult) {
            MakefileParseResult makefileParseResult = (MakefileParseResult)parseResult;
            ArrayList<MakefileTargetItem> list = new ArrayList<MakefileTargetItem>();
            for (MakefileElement element : makefileParseResult.getElements()) {
                if (element.getKind() != MakefileElement.Kind.RULE) continue;
                MakefileRule rule = (MakefileRule)element;
                for (String target : rule.getTargets()) {
                    list.add(new MakefileTargetItem(target, rule));
                }
            }
            return list;
        }
        return Collections.emptyList();
    }

    public Map<String, List<OffsetRange>> folds(ParserResult info) {
        return Collections.emptyMap();
    }

    public StructureScanner.Configuration getConfiguration() {
        return new StructureScanner.Configuration(true, false);
    }

    private static class MakefileTargetItem
    implements StructureItem {
        private static final ImageIcon ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/script/resources/TargetIcon.gif", (boolean)false);
        private final String target;
        private final MakefileRule rule;

        public MakefileTargetItem(String target, MakefileRule rule) {
            this.target = target;
            this.rule = rule;
        }

        public String getName() {
            return this.target;
        }

        public String getSortText() {
            return this.target;
        }

        public String getHtml(HtmlFormatter formatter) {
            boolean shaded;
            boolean bold = MakefileUtils.isPreferredTarget(this.target);
            boolean bl = shaded = !MakefileUtils.isRunnableTarget(this.target);
            if (bold) {
                formatter.emphasis(true);
            }
            if (shaded) {
                formatter.appendHtml("<font color=\"");
                formatter.appendHtml("!textInactiveText");
                formatter.appendHtml("\">");
            }
            formatter.appendText(this.target);
            if (shaded) {
                formatter.appendHtml("</font>");
            }
            if (bold) {
                formatter.emphasis(false);
            }
            return formatter.getText();
        }

        public ElementHandle getElementHandle() {
            return null;
        }

        public ElementKind getKind() {
            return ElementKind.RULE;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean isLeaf() {
            return true;
        }

        public List<? extends StructureItem> getNestedItems() {
            return Collections.emptyList();
        }

        public long getPosition() {
            return this.rule.getStartOffset();
        }

        public long getEndPosition() {
            return this.rule.getEndOffset();
        }

        public ImageIcon getCustomIcon() {
            return ICON;
        }
    }
}

