/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makefile.wizard;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import org.netbeans.modules.cnd.makefile.utils.FortranParser;
import org.netbeans.modules.cnd.makefile.wizard.CompilerFlags;
import org.netbeans.modules.cnd.makefile.wizard.MakefileData;
import org.netbeans.modules.cnd.makefile.wizard.StdLibFlags;
import org.netbeans.modules.cnd.makefile.wizard.TargetData;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.MIMESupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class MakefileGenerator {
    private MakefileData md;
    private File fmakefile;
    private BufferedWriter out;
    private MakeVarName var;
    private boolean status;
    private boolean doComplex;
    private boolean doC;
    private boolean doCpp;
    private boolean doFortran;
    private boolean doXd;
    private boolean doAssembly;
    private StringBuffer buf;
    private ResourceBundle bundle;
    private static final int OK = 0;
    private static final int BAD = 1;
    private static final String LINE1 = new String("## -*- Makefile -*-");
    private static final String BLANKCOMMENT = new String("##");
    private static final String LINE_PREFIX = new String("## ");
    private static final String SUFFIX_LIST = new String(".o .c .c~ .cc .cc~ .y .y~ .l .l~ .s .s~ .sh .sh~ .S .S~ .ln .h .h~ .f .f~ .F .F~ .p .p~ .r .r~ .f90 .f90~ .ftn .ftn~ .cps .cps~ .C .C~ .Y .Y~ .L .L~ .java .java~ .class");

    public MakefileGenerator(MakefileData md) {
        this.md = md;
        this.bundle = null;
        this.out = null;
        this.doComplex = false;
        this.doCpp = false;
        this.doC = false;
        this.doFortran = false;
        this.doXd = false;
        this.doAssembly = false;
        this.buf = new StringBuffer(1024);
        this.var = new MakeVarName();
    }

    public boolean generate() {
        this.status = false;
        if (this.initialize()) {
            try {
                this.prolog();
                this.compilerSetup();
                this.generateTargetDirectories();
                this.defaultTarget();
                List<TargetData> tlist = this.md.getTargetList();
                for (int i = 0; i < tlist.size(); ++i) {
                    this.generateTarget(tlist.get(i));
                }
                this.finale();
            }
            catch (MakefileGenerationException ex) {
                return false;
            }
            catch (IOException ex) {
                if (CndPathUtilities.IfdefDiagnostics) {
                    System.out.println("Failure in Makefile Generation");
                }
                this.fmakefile.delete();
                String msg = this.getString("MSG_MakefileOutputError");
                String title = this.getString("TITLE_MakefileOutputError");
                NotifyDescriptor nd = new NotifyDescriptor((Object)msg, title, 2, 0, new Object[]{NotifyDescriptor.OK_OPTION, NotifyDescriptor.CANCEL_OPTION}, NotifyDescriptor.OK_OPTION);
                Object ret = DialogDisplayer.getDefault().notify(nd);
                return !ret.equals(NotifyDescriptor.OK_OPTION);
            }
        }
        return this.status;
    }

    private boolean initialize() {
        String msg;
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle(MakefileGenerator.class);
        }
        String title = this.getString("DLG_ErrorDialogTitle");
        this.checkTargetFlags();
        if (this.validateOrCreateCwd() != 0 || this.validateOrCreateMakefileDir() != 0) {
            return false;
        }
        if (this.fmakefile.exists() && this.fmakefile.length() > 0L) {
            if (this.fmakefile.canRead()) {
                msg = null;
                if (!MakefileGenerator.generatedMakefile(this.fmakefile)) {
                    msg = MessageFormat.format(this.getString("MSG_NonGeneratedMakefile"), this.md.getMakefileName());
                }
            } else {
                msg = MessageFormat.format(this.getString("MSG_CannotReadMakefile"), this.md.getMakefileName());
            }
            if (msg != null) {
                NotifyDescriptor nd = new NotifyDescriptor((Object)msg, title, -1, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
                DialogDisplayer.getDefault().notify(nd);
                return false;
            }
        }
        if (this.targetIsIncomplete()) {
            msg = MessageFormat.format(this.getString("MSG_TargetIsIncomplete"), this.md.getMakefileName());
            NotifyDescriptor nd = new NotifyDescriptor((Object)msg, title, -1, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
            DialogDisplayer.getDefault().notify(nd);
            return false;
        }
        try {
            this.out = new BufferedWriter(new FileWriter(this.fmakefile));
        }
        catch (IOException e) {
            msg = MessageFormat.format(this.getString("MSG_CannotCreateMakefile"), this.md.getMakefileName());
            NotifyDescriptor nd = new NotifyDescriptor((Object)msg, title, -1, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
            DialogDisplayer.getDefault().notify(nd);
            return false;
        }
        return true;
    }

    private void compilerSetup() throws IOException {
        if (this.out != null && (this.doC || this.doXd || this.doCpp || this.doFortran || this.doAssembly)) {
            String line = this.getString("MFG_CompilerFlags");
            this.out.write(line, 0, line.length());
            if (this.doC || this.doXd || this.doAssembly) {
                this.buf.delete(0, this.buf.length());
                this.appendToolsetDepMacro("CC", this.md.getCCompilerSun(), this.md.getCCompilerGNU());
                this.out.write(this.buf.toString(), 0, this.buf.length());
            }
            if (this.doCpp || this.doXd) {
                this.buf.delete(0, this.buf.length());
                this.appendMacro("CCC", this.md.getCppCompiler(this.md.getToolset()));
                this.appendMacro("CXX", this.md.getCppCompiler(this.md.getToolset()));
                this.out.write(this.buf.toString(), 0, this.buf.length());
            }
            if (this.doFortran) {
                this.buf.delete(0, this.buf.length());
                this.appendToolsetDepMacro("FC", this.md.getFCompilerSun(), this.md.getFCompilerGNU());
                this.out.write(this.buf.toString(), 0, this.buf.length());
            }
            if (this.doAssembly) {
                this.buf.replace(0, this.buf.length(), "AS=");
                this.buf.append(this.md.getAsmPath());
                this.buf.append('\n');
                this.out.write(this.buf.toString(), 0, this.buf.length());
            }
            CompilerFlags copts = this.md.getCompilerFlags();
            if (this.doC || this.doCpp || this.doFortran) {
                this.buf.delete(0, this.buf.length());
                this.appendToolsetDepMacro("BASICOPTS", copts.getBasicOptionsSun(), copts.getBasicOptionsGNU());
                this.out.write(this.buf.toString(), 0, this.buf.length());
            }
            if (this.doC) {
                this.buf.delete(0, this.buf.length());
                String flagsSun = copts.getCFlagsSun();
                String flagsGNU = copts.getCFlagsGNU();
                this.appendToolsetDepMacro("CFLAGS", flagsSun, flagsGNU);
                this.out.write(this.buf.toString(), 0, this.buf.length());
            }
            if (this.doCpp) {
                this.buf.delete(0, this.buf.length());
                String flags = copts.getCcFlags(this.md.getToolset());
                this.appendMacro("CCFLAGS", flags);
                this.appendMacro("CXXFLAGS", flags);
                this.out.write(this.buf.toString(), 0, this.buf.length());
                this.buf.delete(0, this.buf.length());
                this.appendToolsetDepMacro("CCADMIN", "CCadmin -clean", "");
                this.out.write(this.buf.toString(), 0, this.buf.length());
            }
            if (this.doXd) {
                this.buf.replace(0, this.buf.length(), "XDESIGNER=xdesigner");
                this.buf.append(" -xrm \"xdesigner.cDebugFlags: $(CFLAGS)\" ");
                this.buf.append("-xrm \"xdesigner.cppDebugFlags: $(CCFLAGS)\"\n");
                this.buf.append("XDROOT=");
                this.buf.append(System.getProperty("netbeans.home"));
                this.buf.append("/platform/$(OSVARIANT)/prod");
                this.buf.append("\nXDFLAGS = $(MAKEFLAGS) ");
                this.buf.append("XDROOT=$(XDROOT) CC=$(CC) CCC=$(CCC) ");
                if (this.md.getConformLevelCppSun() != 0) {
                    this.buf.append("ABICCFLAGS=-features=no%conststrings");
                }
                this.out.write(this.buf.toString(), 0, this.buf.length());
                this.out.newLine();
            }
            if (this.doFortran) {
                this.buf.delete(0, this.buf.length());
                this.appendMacro("FFLAGS", copts.getF90Flags());
                this.out.write(this.buf.toString(), 0, this.buf.length());
            }
            this.out.newLine();
            this.out.newLine();
        }
    }

    private void defaultTarget() throws IOException {
        if (this.out != null) {
            List<TargetData> tlist = this.md.getTargetList();
            this.buf.replace(0, this.buf.length(), "all:");
            for (int i = 0; i < tlist.size(); ++i) {
                TargetData t = tlist.get(i);
                this.buf.append(" ");
                String dir = this.getOutputDirectory(t);
                if (t.isCompilable() && dir.length() > 0 && !dir.equals(".")) {
                    this.var.setTargetName(t.getName());
                    this.buf.append(this.var.makeRef("TARGETDIR_"));
                    this.buf.append("/");
                } else if (t.getName().compareTo("all") == 0) {
                    this.buf.delete(0, this.buf.length());
                    return;
                }
                this.buf.append(t.getName());
            }
            this.out.write(this.buf.toString(), 0, this.buf.length());
            this.out.newLine();
            this.out.newLine();
        }
    }

    private void prolog() throws IOException {
        if (this.out != null) {
            int toolset;
            this.out.write(LINE1, 0, LINE1.length());
            this.out.newLine();
            this.out.write(BLANKCOMMENT, 0, BLANKCOMMENT.length());
            this.out.newLine();
            this.buf.replace(0, this.buf.length(), this.getString("MFG_User"));
            this.buf.append(this.getUserName());
            this.buf.append('\n');
            this.out.write(this.buf.toString(), 0, this.buf.length());
            this.buf.replace(0, this.buf.length(), this.getString("MFG_Time"));
            this.buf.append(this.getTimestamp());
            this.buf.append('\n');
            this.out.write(this.buf.toString(), 0, this.buf.length());
            this.buf.replace(0, this.buf.length(), this.getString("MFG_CreateMsg"));
            this.out.write(this.buf.toString(), 0, this.buf.length());
            this.out.write(BLANKCOMMENT, 0, BLANKCOMMENT.length());
            this.out.newLine();
            this.buf.replace(0, this.buf.length(), this.getString("MFG_DoNotEditMsg"));
            this.out.write(this.buf.toString(), 0, this.buf.length());
            this.out.write(BLANKCOMMENT, 0, BLANKCOMMENT.length());
            this.out.newLine();
            if (this.doFortran) {
                this.buf.replace(0, this.buf.length(), this.getString("MFG_SuffixList"));
                this.buf.append(".SUFFIXES\n");
                this.buf.append(".SUFFIXES: ");
                this.buf.append(SUFFIX_LIST);
                this.out.newLine();
                this.out.write(this.buf.toString(), 0, this.buf.length());
                this.out.newLine();
            }
            if (this.md.getToolset() == 2) {
                this.buf = new StringBuffer(1024);
                this.buf.append("# Type of makefile: SUN, GNU, ...\n");
                this.buf.append("TOOLSET\t= $(shell echo \"GNU\")\n");
                this.buf.append("TOOLSET:sh\t= echo `echo \"SUN\"`\n");
                this.out.newLine();
                this.out.write(this.buf.toString(), 0, this.buf.length());
            }
            List<TargetData> tlist = this.md.getTargetList();
            boolean usingGenericPlatform = false;
            boolean usingSharedLib = false;
            for (int i = 0; i < tlist.size(); ++i) {
                TargetData t = tlist.get(i);
                if (t.getOutputDirectory().equals(this.getString("OutputDirectoryPlatform"))) {
                    usingGenericPlatform = true;
                }
                if (t.getTargetType() != 3 && t.getTargetType() != 7) continue;
                usingSharedLib = true;
            }
            if (usingGenericPlatform || usingSharedLib && this.md.getMakefileOS() == 2) {
                this.buf = new StringBuffer(1024);
                this.buf.append("# OS: SunOS, Linux, ...`\n");
                toolset = this.md.getToolset();
                if (toolset == 1 || toolset == 2) {
                    this.buf.append("OS\t\t= $(shell /bin/uname)\n");
                }
                if (toolset == 0 || toolset == 2) {
                    this.buf.append("OS:sh\t\t= echo `/bin/uname`\n");
                }
                this.out.newLine();
                this.out.write(this.buf.toString(), 0, this.buf.length());
            }
            if (usingGenericPlatform) {
                this.buf = new StringBuffer(1024);
                this.buf.append("# Processor type: sparc, i686, ...\n");
                toolset = this.md.getToolset();
                if (toolset == 1 || toolset == 2) {
                    this.buf.append("PROCESSOR\t= $(shell /bin/uname -p)\n");
                }
                if (toolset == 0 || toolset == 2) {
                    this.buf.append("PROCESSOR:sh\t= echo `/bin/uname -p``\n");
                }
                this.out.newLine();
                this.out.write(this.buf.toString(), 0, this.buf.length());
                this.buf = new StringBuffer(1024);
                this.buf.append("# Platform\n");
                this.buf.append("PLATFORM\t= $(OS)-$(PROCESSOR)\n");
                this.out.newLine();
                this.out.write(this.buf.toString(), 0, this.buf.length());
            }
            this.out.newLine();
            this.out.newLine();
        }
    }

    private void generateTargetDirectories() throws IOException {
        List<TargetData> tlist = this.md.getTargetList();
        if (this.doC || this.doXd || this.doCpp || this.doFortran || this.doAssembly) {
            String com = this.getString("MFG_TargetDirectories");
            this.out.write(com, 0, com.length());
            for (int i = 0; i < tlist.size(); ++i) {
                TargetData t = tlist.get(i);
                if (!t.isCompilable()) continue;
                String tdir = this.getOutputDirectory(t);
                String cwd = this.md.getBaseDirectory(true);
                this.buf.replace(0, this.buf.length(), "TARGETDIR_");
                this.buf.append(t.getName());
                this.buf.append("=");
                String targetDir = this.getOutputDirectory(t);
                if (targetDir.length() == 0 || targetDir.equals(cwd) || targetDir.length() == 1 && targetDir.charAt(0) == '.') {
                    this.buf.append(new String(".\n"));
                } else {
                    this.buf.append(targetDir);
                    this.buf.append('\n');
                }
                this.out.write(this.buf.toString(), 0, this.buf.length());
            }
            this.out.newLine();
            this.out.newLine();
        }
    }

    private void generateTarget(TargetData t) throws IOException, MakefileGenerationException {
        if (this.out != null) {
            this.var.setTargetName(t.getName());
            this.buf.replace(0, this.buf.length(), this.getString("MFG_Target"));
            this.buf.append(t.getName());
            this.buf.append('\n');
            this.out.write(this.buf.toString(), 0, this.buf.length());
            if (t.isCompilable()) {
                this.targetSetup(t);
                this.linkOrArchive(t);
                this.explicitRules(t);
            } else {
                this.makeTarget(t);
            }
        }
    }

    private void finale() throws IOException {
        if (this.out != null) {
            String com;
            List<TargetData> tlist = this.md.getTargetList();
            String cwd = this.md.getBaseDirectory(true);
            HashSet<TargetData> mkhash = new HashSet<TargetData>(tlist.size(), 1.0f);
            StringBuilder cb = new StringBuilder(1024);
            boolean wasClean = false;
            for (int i = 0; i < tlist.size(); ++i) {
                TargetData t = tlist.get(i);
                this.var.setTargetName(t.getName());
                String dir = this.getOutputDirectory(t);
                if (t.isCompilable() && dir.length() > 0 && !dir.equals(".") && !dir.equals(cwd)) {
                    mkhash.add(t);
                }
                if (t.getTargetType() != 8 && t.getTargetType() != 9) {
                    cb.append(" \\\n\t\t");
                    cb.append(this.var.makeRef("TARGETDIR_"));
                    cb.append('/');
                    cb.append(t.getName());
                    String[] srcs = t.getSourcesList();
                    for (int j = 0; j < srcs.length; ++j) {
                        String newobj;
                        if (t.isHdrFile(srcs[j]) || t.isXdFile(srcs[j]) || (newobj = this.objectOf(srcs[j])) == null) continue;
                        cb.append(" \\\n\t\t");
                        cb.append(this.var.makeRef("TARGETDIR_"));
                        cb.append('/');
                        cb.append(newobj);
                    }
                    continue;
                }
                if (t.getName().compareTo("clean") != 0) continue;
                wasClean = true;
            }
            boolean doClean = false;
            if (cb.length() > 0) {
                doClean = true;
                com = this.getString("MFG_CleanTarget");
                this.out.write(com, 0, com.length());
                this.buf.replace(0, this.buf.length(), "clean:\n\trm -f");
                this.out.write(this.buf.toString(), 0, this.buf.length());
                this.out.write(cb.toString(), 0, cb.length());
                this.out.write(10);
            }
            if (mkhash.size() > 0) {
                if (doClean && this.doCpp) {
                    this.buf.replace(0, this.buf.length(), "\t$(CCADMIN)\n");
                    this.out.write(this.buf.toString(), 0, this.buf.length());
                }
                cb.delete(0, cb.length());
                if (doClean && this.doFortran) {
                    this.buf.replace(0, this.buf.length(), "\trm -f *.mod\n");
                    this.out.write(this.buf.toString(), 0, this.buf.length());
                }
                this.buf.replace(0, this.buf.length(), this.getString("MFG_CreateTargetDir"));
                for (TargetData t : mkhash) {
                    this.var.setTargetName(t.getName());
                    cb.append("\trm -f -r ");
                    cb.append(this.var.makeRef("TARGETDIR_"));
                    cb.append('\n');
                    this.buf.append(this.var.makeRef("TARGETDIR_"));
                    this.buf.append(":\n\tmkdir -p ");
                    this.buf.append(this.var.makeRef("TARGETDIR_"));
                    this.buf.append("\n");
                }
                if (doClean) {
                    cb.append("\n\n");
                    this.out.write(cb.toString(), 0, cb.length());
                }
                this.buf.append("\n\n");
                this.out.write(this.buf.toString(), 0, this.buf.length());
            }
            if (!doClean && !wasClean) {
                com = this.getString("MFG_CleanTarget");
                this.out.write(com, 0, com.length());
                this.buf.replace(0, this.buf.length(), "clean:\n\n");
                this.out.write(this.buf.toString(), 0, this.buf.length());
            }
            this.buf.replace(0, this.buf.length(), this.getString("MFG_KeepState"));
            this.buf.append(".KEEP_STATE:\n");
            this.buf.append(".KEEP_STATE_FILE:.make.state." + this.md.defaultOutputDirectory() + "\n");
            this.buf.append("\n");
            this.out.write(this.buf.toString(), 0, this.buf.length());
            this.status = true;
            this.out.close();
            this.out = null;
        }
    }

    private void targetSetup(TargetData t) throws IOException, MakefileGenerationException {
        if (this.out != null) {
            String[] includesList;
            String tname = t.getName();
            String flags = this.generateTargetFlags(t);
            if (flags.length() > 0) {
                this.out.write(flags, 0, flags.length());
            }
            if ((includesList = t.getIncludesList()) != null && includesList.length > 0) {
                String incs = this.doList(this.var.makeName("CPPFLAGS_"), "-I", includesList);
                this.out.write(incs, 0, incs.length());
            }
            StringBuilder lbuf = new StringBuilder(80);
            lbuf.append(" \\\n\t");
            lbuf.append(this.var.makeRef("TARGETDIR_"));
            lbuf.append('/');
            String tdir = lbuf.toString();
            this.buf.replace(0, this.buf.length(), this.var.makeName("OBJS_"));
            this.buf.append(" = ");
            String[] srcs = this.doFortran && this.md.isModuleEnabled() ? this.getOrderedSources(t) : t.getSourcesList();
            for (int i = 0; i < srcs.length; ++i) {
                String newobj;
                if (t.isHdrFile(srcs[i]) || t.isXdFile(srcs[i]) || (newobj = this.objectOf(srcs[i])) == null) continue;
                this.buf.append(tdir);
                this.buf.append(newobj);
            }
            this.buf.append('\n');
            this.out.write(this.buf.toString(), 0, this.buf.length());
            if (t.isLinked() && (t.isComplex() || t.containsXdFiles())) {
                String deplibs;
                String userlibs;
                boolean needLDLIBS = false;
                String syslibs = this.getSysLibs(t);
                if (syslibs.length() > 0) {
                    this.out.write(syslibs, 0, syslibs.length());
                    needLDLIBS = true;
                }
                if ((userlibs = this.getUserLibs(t)).length() > 0) {
                    this.out.write(userlibs, 0, userlibs.length());
                    needLDLIBS = true;
                }
                if ((deplibs = this.getDependLibs(t)).length() > 0) {
                    this.out.write(deplibs, 0, deplibs.length());
                }
                if (needLDLIBS) {
                    this.buf.replace(0, this.buf.length(), this.var.makeName("LDLIBS_"));
                    this.buf.append(" = ");
                    this.buf.append(this.var.makeRef("USERLIBS_"));
                    this.buf.append('\n');
                    this.out.write(this.buf.toString(), 0, this.buf.length());
                }
            }
            this.out.newLine();
            this.out.newLine();
            if (t.containsXdFiles()) {
                String vtargs = this.generateXdTargetVars(t);
                this.out.write(vtargs, 0, vtargs.length());
                this.out.newLine();
            }
        }
    }

    private String generateXdTargetVars(TargetData t) {
        this.buf.replace(0, this.buf.length(), this.getString("MFG_XDesignerTargetVars"));
        String[] srcs = t.getSourcesList();
        for (int i = 0; i < srcs.length; ++i) {
            if (!t.isXdFile(srcs[i])) continue;
            this.xdTargetFile(t, srcs[i]);
        }
        return this.buf.toString();
    }

    private void xdTargetFile(TargetData t, String file) {
        String vname = this.getXdTargetName(t, file);
        this.buf.append("XDMAKEFILE_");
        this.buf.append(vname);
        this.buf.append(" = ");
        this.buf.append(vname);
        this.buf.append("_Makefile\nXD_OBJS_FILE_");
        this.buf.append(vname);
        this.buf.append(" = xd_objs_");
        this.buf.append(vname);
        this.buf.append("\nXD_OBJS_");
        this.buf.append(vname);
        this.buf.append(" = `/bin/cat -s ");
        this.buf.append(this.getOutputDirectory(t));
        this.buf.append("/xd_objs_");
        this.buf.append(vname);
        this.buf.append(" | \\\n\tawk 'BEGIN { RS=\" \"} {if (NF > 0) { print \"");
        this.buf.append(this.var.makeRef("TARGETDIR_"));
        this.buf.append("/\" $$0 }}'`\nXD_LINK_ARGS_FILE_");
        this.buf.append(vname);
        this.buf.append(" = xd_link_args_");
        this.buf.append(vname);
        this.buf.append("\nXD_LINK_ARGS_");
        this.buf.append(vname);
        this.buf.append(" = `/bin/cat -s ");
        this.buf.append(this.getOutputDirectory(t));
        this.buf.append("/xd_link_args_");
        this.buf.append(vname);
        this.buf.append("; exit 0`\nXDFLAGS_");
        this.buf.append(vname);
        this.buf.append(" = -f $(XDMAKEFILE_");
        this.buf.append(vname);
        this.buf.append(") $(XDFLAGS)\n\n");
    }

    private String getXdTargetName(TargetData t, String file) {
        StringBuffer name = new StringBuffer(256);
        name.append(t.getName());
        name.append('_');
        for (int i = 0; i < file.length(); ++i) {
            if (file.charAt(i) == '.' || file.charAt(i) == '/') {
                name.append('_');
                continue;
            }
            name.append(file.charAt(i));
        }
        return name.toString();
    }

    private void linkOrArchive(TargetData t) throws IOException {
        int type = t.getTargetType();
        if (this.out != null && type != 8 && type != 9) {
            this.out.write(this.getString("MFG_LinkOrArchive"));
            this.buf.replace(0, this.buf.length(), this.var.makeRef("TARGETDIR_"));
            this.buf.append('/');
            this.buf.append(t.getName());
            this.buf.append(": ");
            this.buf.append(this.var.makeRef("TARGETDIR_"));
            this.buf.append(' ');
            this.buf.append(this.var.makeRef("OBJS_"));
            if (type == 5 || type == 7) {
                this.buf.append(' ');
                this.buf.append(this.var.makeRef("DEPLIBS_"));
            }
            if (t.containsXdFiles()) {
                this.buf.append(this.xdLinkDependencies(t));
            }
            this.buf.append('\n');
            this.buf.append('\t');
            switch (type) {
                case 1: 
                case 5: {
                    this.buf.append(this.linkLine(t, 1));
                    break;
                }
                case 2: 
                case 6: {
                    if (t.containsCppFiles()) {
                        StringBuffer bufx = new StringBuffer(1024);
                        this.appendToolsetDepMacro(bufx, "ARCPP", "$(CCC) -xar -o $@ ", "$(AR) $(ARFLAGS) $@ ");
                        this.out.write(bufx.toString(), 0, bufx.length());
                        this.buf.append("$(ARCPP) ");
                    } else {
                        this.buf.append("$(AR) $(ARFLAGS) $@ ");
                    }
                    this.buf.append(this.var.makeRef("OBJS_"));
                    this.buf.append('\n');
                    break;
                }
                case 3: 
                case 7: {
                    this.buf.append(this.linkLine(t, type));
                }
            }
            this.out.write(this.buf.toString(), 0, this.buf.length());
            this.out.newLine();
            this.out.newLine();
        }
    }

    private void explicitRules(TargetData t) throws IOException {
        if (this.out != null) {
            int i;
            String msg = this.getString("MFG_CompileRuleComment");
            this.out.write(msg, 0, msg.length());
            String[] srcs = t.getSourcesList();
            for (i = 0; i < srcs.length; ++i) {
                this.compileLine(t, srcs[i]);
            }
            this.out.newLine();
            this.out.newLine();
            if (t.containsXdFiles()) {
                msg = this.getString("MFG_XDesignerCompileRule");
                this.out.write(msg, 0, msg.length());
                this.buf.delete(0, this.buf.length());
                for (i = 0; i < srcs.length; ++i) {
                    if (!t.isXdFile(srcs[i])) continue;
                    this.buf.append(this.xdCompile(t, srcs[i]));
                }
                this.out.write(this.buf.toString(), 0, this.buf.length());
                this.out.newLine();
                this.out.newLine();
            }
        }
    }

    private String xdCompile(TargetData t, String file) {
        String vname = this.getXdTargetName(t, file);
        String l1 = MessageFormat.format("$(TARGETDIR_{0})/$(XDMAKEFILE_{1}): $(TARGETDIR_{0}) {2}\n\t$(XDESIGNER) -m $(TARGETDIR_{0})/$(XDMAKEFILE_{1}) {2}\n\n", t.getName(), vname, file);
        String l2 = MessageFormat.format("$(TARGETDIR_{0})/$(XD_OBJS_FILE_{1}): $(TARGETDIR_{0}) $(TARGETDIR_{0})/$(XDMAKEFILE_{1}) {2}\n\t$(XDESIGNER) -G $(TARGETDIR_{0}) {2}\n", t.getName(), vname, file);
        String l3 = MessageFormat.format("\tcd $(TARGETDIR_{0}); $(MAKE) $(XDFLAGS_{1}) info-objects > $(XD_OBJS_FILE_{1})\n\tcd $(TARGETDIR_{0}); $(MAKE) $(XDFLAGS_{1}) info-link > $(XD_LINK_ARGS_FILE_{1})\n\tcd $(TARGETDIR_{0}); $(MAKE) $(XDFLAGS_{1}) all-objects\ntest::\n\n", t.getName(), vname, file);
        return new StringBuilder(1024).append(l1).append(l2).append(l3).toString();
    }

    private void makeTarget(TargetData t) throws IOException {
        this.buf.replace(0, this.buf.length(), t.getName());
        this.buf.append(": ");
        String dependsOn = t.getDependsOn();
        if (dependsOn != null && dependsOn.length() > 0) {
            this.buf.append(dependsOn);
        }
        this.buf.append('\n');
        if (t.getTargetType() == 8) {
            String target;
            String dir = t.getSubdirectory();
            if (dir != null && dir.length() > 0) {
                this.buf.append("\tcd ");
                this.buf.append(dir);
                this.buf.append("; $(MAKE) ");
            } else {
                this.buf.append("\t$(MAKE) ");
            }
            String mflags = t.getMakeFlags();
            if (mflags != null && mflags.length() > 0) {
                this.buf.append(mflags);
                this.buf.append(' ');
            }
            if ((target = t.getTargetName()) != null && target.length() > 0) {
                this.buf.append(target);
            }
            this.buf.append('\n');
        } else {
            String line;
            ArrayList actions = t.getActions();
            for (int i = 0; i < actions.size() && (line = actions.get(i).toString().trim()).length() != 0; ++i) {
                this.buf.append('\t');
                this.buf.append(line);
                this.buf.append('\n');
            }
        }
        this.buf.append("\n\n");
        this.out.write(this.buf.toString(), 0, this.buf.length());
    }

    private void compileLine(TargetData t, String src) throws IOException {
        String flagBase;
        String compiler;
        if (t.isCppFile(src)) {
            compiler = "$(COMPILE.cc)";
            flagBase = "CCFLAGS_";
        } else if (t.isCFile(src)) {
            compiler = "$(COMPILE.c)";
            flagBase = "CFLAGS_";
        } else if (t.isFortranFile(src)) {
            compiler = "$(COMPILE.f)";
            flagBase = "FFLAGS_";
        } else {
            if (t.isHdrFile(src)) {
                return;
            }
            if (t.isXdFile(src)) {
                return;
            }
            if (t.isAssemblyFile(src)) {
                compiler = "$(AS)";
                flagBase = "ASFLAGS_";
            } else {
                if (CndPathUtilities.IfdefDiagnostics) {
                    System.out.println("Generator: Can't determine language of " + src);
                }
                return;
            }
        }
        String newobj = this.objectOf(src);
        if (newobj == null) {
            return;
        }
        this.buf.replace(0, this.buf.length(), this.var.makeRef("TARGETDIR_"));
        this.buf.append('/');
        this.buf.append(newobj);
        this.buf.append(": ");
        this.buf.append(this.var.makeRef("TARGETDIR_"));
        this.buf.append(' ');
        this.buf.append(src);
        this.buf.append("\n\t");
        this.buf.append(compiler);
        this.buf.append(' ');
        this.buf.append(this.var.makeRef(flagBase));
        this.buf.append(' ');
        this.buf.append(this.var.makeRef("CPPFLAGS_"));
        this.buf.append(" -o $@ ");
        this.buf.append(src);
        this.buf.append("\n\n");
        this.out.write(this.buf.toString(), 0, this.buf.length());
    }

    /*
     * WARNING - void declaration
     */
    private String[] getOrderedSources(TargetData t) throws MakefileGenerationException {
        String[] old = t.getSourcesList();
        ArrayList<Object> neu = new ArrayList<Object>();
        LinkedList<FortranFile> flist = new LinkedList<FortranFile>();
        String options = this.md.getCompilerFlags().getF90Flags();
        HashMap<String, void> moduleList = new HashMap<String, void>();
        boolean firstTime = true;
        boolean nidx = false;
        for (int i = 0; i < old.length; ++i) {
            String string = old[i];
            if (this.isFortranFile(string)) {
                void var10_11;
                FortranParser parser;
                ArrayList<String> list;
                if (string.charAt(0) != '/') {
                    String string2 = this.md.getBaseDirectory() + File.separator + string;
                }
                if ((list = (parser = new FortranParser((String)var10_11, options, true, true)).parser()) == null) {
                    if (firstTime) {
                        firstTime = false;
                        String title = this.getString("DLG_ErrorDialogTitle");
                        String msg = this.getString("MSG_ModuleDependencyError");
                        NotifyDescriptor nd = new NotifyDescriptor((Object)msg, title, -1, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
                        DialogDisplayer.getDefault().notify(nd);
                    }
                    return old;
                }
                if (list.size() == 0) {
                    neu.add(var10_11);
                    continue;
                }
                flist.add(new FortranFile((String)var10_11, list));
                for (int j = 0; j < list.size(); ++j) {
                    String entry = list.get(j).toString();
                    if (entry.charAt(0) != 'M') continue;
                    Object o = moduleList.get(entry.substring(1));
                    if (o != null) {
                        if (!firstTime) continue;
                        firstTime = false;
                        String title = this.getString("DLG_ErrorDialogTitle");
                        String msg = MessageFormat.format(this.getString("MSG_DuplicateModuleError"), entry.substring(1), t.getName(), var10_11, o.toString());
                        NotifyDescriptor nd = new NotifyDescriptor((Object)msg, title, -1, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
                        DialogDisplayer.getDefault().notify(nd);
                        throw new MakefileGenerationException();
                    }
                    moduleList.put(entry.substring(1), var10_11);
                }
                continue;
            }
            neu.add(string);
        }
        for (FortranFile fortranFile : flist) {
            ArrayList list = fortranFile.getRawList();
            for (int j = 0; j < list.size(); ++j) {
                String dep;
                String entry = list.get(j).toString();
                if (entry.charAt(0) != 'U' || (dep = (String)moduleList.get(entry.substring(1))) == null || dep.equals(fortranFile.getName())) continue;
                fortranFile.addDependsOn(dep);
            }
        }
        while (flist.size() > 0) {
            FortranFile file;
            boolean bl = false;
            Iterator iter = flist.iterator();
            while (iter.hasNext()) {
                file = (FortranFile)iter.next();
                if (file.getDependsOn() != null) continue;
                neu.add(file.getName());
                iter.remove();
                this.remove(flist.iterator(), file.getName());
                bl = true;
                break;
            }
            if (bl) continue;
            if (firstTime) {
                firstTime = false;
                String title = this.getString("DLG_ErrorDialogTitle");
                String msg = this.getString("MSG_CircularDependency");
                NotifyDescriptor nd = new NotifyDescriptor((Object)msg, title, -1, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
                DialogDisplayer.getDefault().notify(nd);
            }
            iter = flist.iterator();
            file = (FortranFile)iter.next();
            this.remove(flist.iterator(), null);
        }
        return neu.toArray(new String[neu.size()]);
    }

    private void remove(Iterator iter, String name) {
        block0: while (iter.hasNext()) {
            FortranFile file = (FortranFile)iter.next();
            ArrayList deps = file.getDependsOn();
            if (deps == null) continue;
            for (int i = 0; i < deps.size(); ++i) {
                if (name != null && !name.equals(deps.get(i))) continue;
                deps.remove(i);
                if (deps.size() != 0) continue block0;
                file.setDependsOn(null);
                continue block0;
            }
        }
    }

    private boolean isFortranFile(String file) {
        return "text/x-fortran".equals(MIMESupport.getKnownSourceFileMIMETypeByExtension((String)file));
    }

    private String objectOf(String file) {
        StringBuilder obj = new StringBuilder(80);
        int start = file.lastIndexOf(47) + 1;
        int dot = file.substring(start).lastIndexOf(46);
        if (dot >= 0) {
            obj.append(file.substring(start, start + dot + 1));
            obj.append('o');
            return obj.toString();
        }
        return null;
    }

    private void sharedLibFlags(TargetData t) throws IOException {
        StringBuffer bufx = new StringBuffer(1024);
        this.appendOSDepMacro(bufx, this.var.makeName("SHAREDLIB_FLAGS_"), "-G -norunpath -h " + t.getName() + " ", "-shared ", "-dynamiclib -install_name " + t.getName());
        this.out.write(bufx.toString(), 0, bufx.length());
    }

    private String linkLine(TargetData t, int type) throws IOException {
        String flags;
        String linker;
        StringBuilder lbuf = new StringBuilder(256);
        if (t.containsCppFiles()) {
            linker = "$(LINK.cc) ";
            flags = "CCFLAGS_";
        } else if (t.containsFortranFiles()) {
            linker = "$(LINK.f) ";
            flags = "FFLAGS_";
        } else {
            linker = "$(LINK.c) ";
            flags = "CFLAGS_";
        }
        lbuf.append(linker);
        lbuf.append(this.var.makeRef(flags));
        lbuf.append(' ');
        lbuf.append(this.var.makeRef("CPPFLAGS_"));
        lbuf.append(" -o $@ ");
        lbuf.append(this.var.makeRef("OBJS_"));
        lbuf.append(' ');
        if (type == 3 || type == 7) {
            this.sharedLibFlags(t);
            lbuf.append("$(" + this.var.makeName("SHAREDLIB_FLAGS_") + ") ");
        }
        lbuf.append(this.var.makeRef("LDLIBS_"));
        if (t.containsXdFiles()) {
            lbuf.append(this.xdLinkMagic(t));
        }
        lbuf.append('\n');
        return lbuf.toString();
    }

    private String xdLinkMagic(TargetData t) {
        StringBuilder lbuf = new StringBuilder(256);
        String[] srcs = t.getSourcesList();
        for (int i = 0; i < srcs.length; ++i) {
            String file = srcs[i];
            if (!t.isXdFile(srcs[i])) continue;
            String vname = this.getXdTargetName(t, file);
            lbuf.append(" \\\n\t\t");
            lbuf.append("$(XD_OBJS_");
            lbuf.append(vname);
            lbuf.append(") $(XD_LINK_ARGS_");
            lbuf.append(vname);
            lbuf.append(')');
        }
        return lbuf.toString();
    }

    private String xdLinkDependencies(TargetData t) {
        StringBuilder lbuf = new StringBuilder(256);
        String[] srcs = t.getSourcesList();
        for (int i = 0; i < srcs.length; ++i) {
            String file = srcs[i];
            if (!t.isXdFile(srcs[i])) continue;
            String vname = this.getXdTargetName(t, file);
            lbuf.append(" \\\n\t\t");
            lbuf.append(this.var.makeRef("TARGETDIR_"));
            lbuf.append("/$(XD_OBJS_FILE_");
            lbuf.append(vname);
            lbuf.append(") $(TARGETDIR_");
            lbuf.append(t.getName());
            lbuf.append(")/$(XD_LINK_ARGS_FILE_");
            lbuf.append(vname);
            lbuf.append(')');
        }
        return lbuf.toString();
    }

    private String getSysLibs(TargetData t) {
        StdLibFlags flags = t.getStdLibFlags();
        this.buf.delete(0, this.buf.length());
        this.buf.append(flags.getSysLibFlags(this.md.getToolset(), this.md.getMakefileOS(), this.md.getCompilerFlags().is64Bit(), t));
        if (this.buf.length() > 0) {
            this.buf.insert(0, " = ");
            this.buf.insert(0, this.var.makeName("SYSLIBS_"));
            this.buf.append('\n');
        }
        return this.buf.toString();
    }

    private String getUserLibs(TargetData t) {
        String[] ulibs = t.getUserLibsList();
        this.buf.delete(0, this.buf.length());
        if (ulibs != null) {
            for (int i = 0; i < ulibs.length; ++i) {
                String lib = ulibs[i];
                this.buf.append(lib);
                this.buf.append(' ');
            }
        }
        if (this.buf.length() > 0) {
            this.buf.insert(0, " = ");
            this.buf.insert(0, this.var.makeName("USERLIBS_"));
            this.buf.append('\n');
        }
        return this.buf.toString();
    }

    private String getDependLibs(TargetData t) {
        String[] ulibs = t.getUserLibsList();
        this.buf.delete(0, this.buf.length());
        if (ulibs != null) {
            for (int i = 0; i < ulibs.length; ++i) {
                String lib = ulibs[i];
                if (lib.charAt(0) != '-' && lib.charAt(0) != '/' && (lib.endsWith(".a") || lib.endsWith(".so") || lib.endsWith(".dylib") || lib.endsWith(".dll"))) {
                    this.buf.append(lib);
                    this.buf.append(' ');
                }
                this.buf.append(' ');
            }
        }
        if (this.buf.length() > 0) {
            this.buf.insert(0, " = ");
            this.buf.insert(0, this.var.makeName("DEPLIBS_"));
            this.buf.append('\n');
        }
        return this.buf.toString();
    }

    private String doList(String var, String prefix, String[] list) {
        StringBuilder lbuf = new StringBuilder(256);
        prefix = prefix == null ? " \\\n\t" : " \\\n\t" + prefix;
        lbuf.append(var);
        lbuf.append(" =");
        for (int i = 0; i < list.length; ++i) {
            lbuf.append(prefix);
            lbuf.append(list[i]);
        }
        lbuf.append('\n');
        return lbuf.toString();
    }

    private String generateTargetFlags(TargetData t) {
        StringBuilder flagsSun = new StringBuilder(80);
        if (t.getTargetType() == 7 || t.getTargetType() == 3) {
            flagsSun.append("-Kpic ");
        }
        this.buf.delete(0, this.buf.length());
        if (flagsSun.length() > 0) {
            int toolset = this.md.getToolset();
            if (t.containsCFiles()) {
                this.appendToolsetDepMacro(this.var.makeName("CFLAGS_"), flagsSun.toString(), "");
            }
            if (t.containsCppFiles()) {
                this.appendToolsetDepMacro(this.var.makeName("CCFLAGS_"), flagsSun.toString(), "");
            }
            if (t.containsFortranFiles()) {
                this.appendToolsetDepMacro(this.var.makeName("FFLAGS_"), flagsSun.toString(), "");
            }
        }
        return this.buf.toString();
    }

    private String[] getObjectList(String[] srcs) {
        String[] objs = new String[srcs.length];
        for (int i = 0; i < srcs.length; ++i) {
            int dot = srcs[i].lastIndexOf(46);
            if (dot < 0) continue;
            StringBuilder obj = new StringBuilder(srcs[i].substring(0, dot + 1));
            obj.append('o');
            objs[i] = new String(obj);
        }
        return objs;
    }

    private boolean targetIsIncomplete() {
        List<TargetData> tlist = this.md.getTargetList();
        for (int i = 0; i < tlist.size(); ++i) {
            TargetData t = tlist.get(i);
            if (!t.isCompilable() || t.getSourcesList() != null && t.getSourcesList().length != 0) continue;
            return true;
        }
        return false;
    }

    private void completeTargets() {
        List<TargetData> tlist = this.md.getTargetList();
        for (int i = 0; i < tlist.size(); ++i) {
        }
    }

    public static boolean generatedMakefile(File mf) {
        String[] line = new String[3];
        int i = 0;
        try {
            BufferedReader in = new BufferedReader(new FileReader(mf));
            line[i++] = in.readLine();
            line[i++] = in.readLine();
            line[i++] = in.readLine();
            in.close();
        }
        catch (IOException ex) {
            return false;
        }
        return line[2] != null && line[0].equals(LINE1) && line[1].equals(BLANKCOMMENT) && line[2].startsWith(LINE_PREFIX);
    }

    private int validateOrCreateCwd() {
        String cwd = this.md.getBaseDirectory(true);
        File fcwd = new File(cwd);
        return this.validateOrCreateDir(cwd, fcwd, this.getString("MSG_CwdNotDir"));
    }

    private int validateOrCreateMakefileDir() {
        String makefile = this.md.getMakefileName();
        this.fmakefile = makefile.charAt(0) == File.separatorChar ? new File(makefile) : new File(this.md.getBaseDirectory(true), makefile);
        String parent = this.fmakefile.getParent();
        File fparent = this.fmakefile.getParentFile();
        return this.validateOrCreateDir(parent, fparent, this.getString("MSG_MakefileDirNotDir"));
    }

    private int validateOrCreateDir(String dir, File fdir, String msg) {
        if (fdir.exists() && !fdir.isDirectory()) {
            String s = MessageFormat.format(msg, dir);
            String title = this.getString("DLG_ErrorDialogTitle");
            NotifyDescriptor nd = new NotifyDescriptor((Object)s, title, -1, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
            DialogDisplayer.getDefault().notify(nd);
            return 1;
        }
        if (!fdir.exists()) {
            String s = MessageFormat.format(this.getString("MSG_CreateDirectory"), dir);
            String title = this.getString("DLG_QuestionDialogTitle");
            NotifyDescriptor nd = new NotifyDescriptor((Object)s, title, 0, 3, null, NotifyDescriptor.YES_OPTION);
            Object ret = DialogDisplayer.getDefault().notify(nd);
            if (ret == NotifyDescriptor.NO_OPTION || !this.mkdirs(dir, fdir)) {
                return 1;
            }
        }
        return 0;
    }

    private String getTimestamp() {
        Date date = new Date();
        StringBuilder timestamp = new StringBuilder(80);
        timestamp.append(DateFormat.getDateInstance().format(date));
        timestamp.append(" ");
        timestamp.append(DateFormat.getTimeInstance().format(date));
        return timestamp.toString();
    }

    private String getUserName() {
        String user = System.getProperty("Env-USER");
        if (user == null && (user = System.getProperty("Env-LOGNAME")) == null && (user = System.getProperty("user.name")) == null) {
            user = this.getString("UNKNOWN_USER");
        }
        return user;
    }

    private boolean mkdirs(String name, File file) {
        if (!file.mkdirs()) {
            String msg = MessageFormat.format(this.getString("MSG_CannotCreateDirectory"), name);
            String title = this.getString("DLG_ErrorDialogTitle");
            NotifyDescriptor nd = new NotifyDescriptor((Object)msg, title, -1, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
            DialogDisplayer.getDefault().notify(nd);
            return false;
        }
        return true;
    }

    private void checkTargetFlags() {
        List<TargetData> tlist = this.md.getTargetList();
        for (int i = 0; i < tlist.size(); ++i) {
            TargetData t = tlist.get(i);
            if (t.isComplex()) {
                this.doComplex = true;
            }
            if (t.containsCppFiles()) {
                this.doCpp = true;
            }
            if (t.containsCFiles()) {
                this.doC = true;
            }
            if (t.containsFortranFiles()) {
                this.doFortran = true;
            }
            if (t.containsXdFiles()) {
                this.doXd = true;
                this.doC = true;
                this.doCpp = true;
            }
            if (!t.containsAssemblyFiles()) continue;
            this.doAssembly = true;
        }
    }

    protected String getString(String s) {
        return this.bundle.getString(s);
    }

    private String getOutputDirectory(TargetData t) {
        String outputDirectory = t.getOutputDirectory();
        if (outputDirectory.equals(this.getString("OutputDirectoryPlatform"))) {
            return "$(PLATFORM)";
        }
        return outputDirectory;
    }

    private void appendToolsetDepMacro(String macro, String sunVal, String gnuVal) {
        this.appendToolsetDepMacro(this.buf, macro, sunVal, gnuVal);
    }

    private void appendToolsetDepMacro(StringBuffer sbuf, String macro, String sunVal, String gnuVal) {
        int toolset = this.md.getToolset();
        if (toolset == 0) {
            sbuf.append(macro);
            sbuf.append(" = ");
            sbuf.append(sunVal);
            sbuf.append('\n');
        } else if (toolset == 1) {
            sbuf.append(macro);
            sbuf.append(" = ");
            sbuf.append(gnuVal);
            sbuf.append('\n');
        } else if (toolset == 2) {
            sbuf.append(macro + "-SUN");
            sbuf.append(" = ");
            sbuf.append(sunVal);
            sbuf.append('\n');
            sbuf.append(macro + "-GNU");
            sbuf.append(" = ");
            sbuf.append(gnuVal);
            sbuf.append('\n');
            sbuf.append(macro + " = $(" + macro + "-$(TOOLSET))");
            sbuf.append('\n');
        }
    }

    private void appendToolsetDepMacro(String sunMacro, String sunVal, String gnuMacro, String gnuVal) {
        this.appendToolsetDepMacro(this.buf, sunMacro, sunVal, gnuMacro, gnuVal);
    }

    private void appendToolsetDepMacro(StringBuffer sbuf, String sunMacro, String sunVal, String gnuMacro, String gnuVal) {
        int toolset = this.md.getToolset();
        if (toolset == 0 || toolset == 2) {
            sbuf.append(sunMacro);
            sbuf.append(" = ");
            sbuf.append(sunVal);
            sbuf.append('\n');
        }
        if (toolset == 1 || toolset == 2) {
            sbuf.append(gnuMacro);
            sbuf.append(" = ");
            sbuf.append(gnuVal);
            sbuf.append('\n');
        }
    }

    private void appendMacro(String macro, String val) {
        this.appendMacro(this.buf, macro, val);
    }

    private void appendMacro(StringBuffer sbuf, String macro, String val) {
        sbuf.append(macro);
        sbuf.append(" = ");
        sbuf.append(val);
        sbuf.append('\n');
    }

    private void appendOSDepMacro(String macro, String sunVal, String gnuVal, String macosxVal) {
        this.appendOSDepMacro(this.buf, macro, sunVal, gnuVal, macosxVal);
    }

    private void appendOSDepMacro(StringBuffer sbuf, String macro, String sunVal, String gnuVal, String macosxVal) {
        int os = this.md.getMakefileOS();
        if (os == 0) {
            sbuf.append(macro);
            sbuf.append(" = ");
            sbuf.append(sunVal);
            sbuf.append('\n');
        } else if (os == 1) {
            sbuf.append(macro);
            sbuf.append(" = ");
            sbuf.append(gnuVal);
            sbuf.append('\n');
        } else if (os == 4) {
            sbuf.append(macro);
            sbuf.append(" = ");
            sbuf.append(macosxVal);
            sbuf.append('\n');
        } else if (os == 2) {
            sbuf.append(macro + "-SunOS");
            sbuf.append(" = ");
            sbuf.append(sunVal);
            sbuf.append('\n');
            sbuf.append(macro + "-Linux");
            sbuf.append(" = ");
            sbuf.append(gnuVal);
            sbuf.append('\n');
            sbuf.append(macro + " = $(" + macro + "-$(OS))");
            sbuf.append('\n');
        }
    }

    private static final class MakefileGenerationException
    extends Exception {
        public MakefileGenerationException() {
        }

        public MakefileGenerationException(String s) {
            super(s);
        }
    }

    private static final class MakeVarName {
        private String targetName = null;
        private StringBuffer lastName;
        private StringBuffer lastRef;
        private StringBuffer lastSuffix;
        private StringBuffer buffer = new StringBuffer(80);

        public MakeVarName() {
            this.lastName = new StringBuffer(80);
            this.lastRef = new StringBuffer(80);
            this.lastSuffix = new StringBuffer(20);
        }

        public void setTargetName(String targetName) {
            this.targetName = targetName;
            this.lastName.delete(0, this.lastName.length());
            this.lastRef.delete(0, this.lastRef.length());
            this.lastSuffix.delete(0, this.lastSuffix.length());
        }

        public String makeName(String suffix) {
            if (suffix.equals(this.lastSuffix.toString())) {
                return this.lastName.toString();
            }
            this.buffer.replace(0, this.buffer.length(), suffix);
            this.buffer.append(this.targetName);
            this.lastName.replace(0, this.lastName.length(), this.buffer.toString());
            return this.buffer.toString();
        }

        public String makeName(String suffix, String extra) {
            if (suffix.equals(this.lastSuffix.toString())) {
                return this.lastName.toString();
            }
            this.buffer.replace(0, this.buffer.length(), suffix);
            this.buffer.append(this.targetName);
            this.buffer.append("_");
            this.buffer.append(extra);
            this.lastName.replace(0, this.lastName.length(), this.buffer.toString());
            return this.buffer.toString();
        }

        public String makeRef(String suffix) {
            if (suffix.equals(this.lastSuffix.toString())) {
                return this.lastRef.toString();
            }
            this.buffer.replace(0, this.buffer.length(), "$(");
            this.buffer.append(suffix);
            this.buffer.append(this.targetName);
            this.buffer.append(")");
            this.lastRef.replace(0, this.lastRef.length(), this.buffer.toString());
            return this.buffer.toString();
        }

        public String makeRef(String suffix, String extra) {
            if (suffix.equals(this.lastSuffix.toString())) {
                return this.lastRef.toString();
            }
            this.buffer.replace(0, this.buffer.length(), "$(");
            this.buffer.append(suffix);
            this.buffer.append(this.targetName);
            this.buffer.append("_");
            this.buffer.append(extra);
            this.buffer.append(")");
            this.lastRef.replace(0, this.lastRef.length(), this.buffer.toString());
            return this.buffer.toString();
        }

        public String lastName() {
            return this.lastName.toString();
        }

        public String lastRef() {
            return this.lastRef.toString();
        }
    }

    private static class FortranFile {
        private String name;
        private ArrayList rawList;
        private ArrayList<String> dependsOn;

        public FortranFile(String name, ArrayList rawList) {
            this.name = new String(name);
            this.rawList = rawList;
            this.dependsOn = null;
        }

        public final void addDependsOn(String dep) {
            if (this.dependsOn == null) {
                this.dependsOn = new ArrayList();
            }
            for (int i = 0; i < this.dependsOn.size(); ++i) {
                if (!dep.equals(this.dependsOn.get(i))) continue;
                return;
            }
            this.dependsOn.add(dep);
        }

        public final ArrayList getDependsOn() {
            return this.dependsOn;
        }

        public final void setDependsOn(ArrayList<String> dependsOn) {
            this.dependsOn = dependsOn;
        }

        public final String getName() {
            return this.name;
        }

        public final ArrayList getRawList() {
            return this.rawList;
        }
    }
}

