/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.script.loaders;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.Format;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.queries.FileEncodingQuery;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.CreateFromTemplateHandler;
import org.openide.util.MapFormat;

public class ScriptCreateFromTemplateHandler
extends CreateFromTemplateHandler {
    protected boolean accept(FileObject orig) {
        String mimeType = orig.getMIMEType();
        return "text/sh".equals(mimeType) || "text/x-make".equals(mimeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileObject createFromTemplate(FileObject template, FileObject folder, String name, Map<String, Object> parameters) throws IOException {
        FileObject targetFile = folder.createData(name, template.getExt());
        Format format = this.createFormat(template, parameters);
        BufferedReader reader = new BufferedReader(new InputStreamReader(template.getInputStream(), FileEncodingQuery.getEncoding((FileObject)template)));
        try {
            FileLock lock = targetFile.lock();
            try {
                Charset targetEncoding = FileEncodingQuery.getEncoding((FileObject)targetFile);
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(targetFile.getOutputStream(lock), targetEncoding));
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        writer.write(format.format(line));
                        writer.write("\n");
                    }
                }
                finally {
                    writer.close();
                }
            }
            finally {
                lock.releaseLock();
            }
        }
        finally {
            reader.close();
        }
        return targetFile;
    }

    private Format createFormat(FileObject template, Map<String, Object> params) {
        HashMap<String, Object> enhancedParams = new HashMap<String, Object>(params);
        this.copyValueToUppercaseKey(enhancedParams, "name");
        this.copyValueToUppercaseKey(enhancedParams, "user");
        this.copyValueToUppercaseKey(enhancedParams, "date");
        this.copyValueToUppercaseKey(enhancedParams, "time");
        enhancedParams.put("EXTENSION", template.getExt());
        MapFormat format = new MapFormat(enhancedParams);
        format.setLeftBrace("%<%");
        format.setRightBrace("%>%");
        return format;
    }

    private void copyValueToUppercaseKey(Map<String, Object> params, String lowercaseKey) {
        String uppercaseKey = lowercaseKey.toUpperCase();
        if (params.containsKey(lowercaseKey) && !params.containsKey(uppercaseKey)) {
            params.put(uppercaseKey, params.get(lowercaseKey));
        }
    }
}

