/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project.deps.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.javacard.common.GuiUtils;
import org.netbeans.modules.javacard.project.deps.ui.ChooseOriginPanelVisual;
import org.netbeans.modules.javacard.project.deps.ui.IntermediatePanelKind;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class ChooseSigOrExpFilePanelVisual
extends JPanel
implements DocumentListener {
    private final WizardDescriptor wiz;
    private final ChangeSupport supp = new ChangeSupport((Object)this);
    private IntermediatePanelKind kind;
    private JButton browseFileButton;
    private JTextArea descriptionLabel;
    private JTextField fileField;
    private JLabel fileLabel;
    private JScrollPane jScrollPane1;

    public ChooseSigOrExpFilePanelVisual(WizardDescriptor desc) {
        this.wiz = desc;
        this.initComponents();
        GuiUtils.prepareContainer((Container)this);
        this.fileField.getDocument().addDocumentListener(this);
        this.descriptionLabel.getCaret().setVisible(false);
    }

    IntermediatePanelKind getKind() {
        return this.kind;
    }

    public void removeChangeListener(ChangeListener listener) {
        this.supp.removeChangeListener(listener);
    }

    public void addChangeListener(ChangeListener listener) {
        this.supp.addChangeListener(listener);
    }

    @Override
    public String getName() {
        String key = this.kind == null ? "NAME_EXP_FILE_PANEL" : (this.kind == IntermediatePanelKind.EXP_FILE ? "NAME_EXP_FILE_PANEL" : "NAME_SIG_FILE_PANEL");
        return NbBundle.getMessage(ChooseSigOrExpFilePanelVisual.class, (String)key);
    }

    void setKind(IntermediatePanelKind kind) {
        this.kind = kind;
        if (kind != null) {
            this.descriptionLabel.setText(kind.getDescription());
            switch (kind) {
                case EXP_FILE: {
                    this.fileLabel.setText(NbBundle.getMessage(ChooseSigOrExpFilePanelVisual.class, (String)"LBL_EXP_FILE"));
                    break;
                }
                case SIG_FILE: {
                    this.fileLabel.setText(NbBundle.getMessage(ChooseSigOrExpFilePanelVisual.class, (String)"LBL_SIG_FILE"));
                }
            }
        }
    }

    private void initComponents() {
        this.fileLabel = new JLabel();
        this.fileField = new JTextField();
        this.browseFileButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.descriptionLabel = new JTextArea();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setLayout(new GridBagLayout());
        this.fileLabel.setText(NbBundle.getMessage(ChooseSigOrExpFilePanelVisual.class, (String)"ChooseSigOrExpFilePanelVisual.fileLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 0, 12, 0);
        this.add((Component)this.fileLabel, gridBagConstraints);
        this.fileField.setText(NbBundle.getMessage(ChooseSigOrExpFilePanelVisual.class, (String)"ChooseSigOrExpFilePanelVisual.fileField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 140;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 5, 12, 5);
        this.add((Component)this.fileField, gridBagConstraints);
        this.browseFileButton.setText(NbBundle.getMessage(ChooseSigOrExpFilePanelVisual.class, (String)"ChooseSigOrExpFilePanelVisual.browseFileButton.text"));
        this.browseFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChooseSigOrExpFilePanelVisual.this.browseFileButtononBrowseOrigin(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 12, 0);
        this.add((Component)this.browseFileButton, gridBagConstraints);
        this.jScrollPane1.setBackground(UIManager.getDefaults().getColor("control"));
        this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jScrollPane1.setViewportBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.descriptionLabel.setBackground(UIManager.getDefaults().getColor("control"));
        this.descriptionLabel.setColumns(20);
        this.descriptionLabel.setEditable(false);
        this.descriptionLabel.setLineWrap(true);
        this.descriptionLabel.setRows(5);
        this.descriptionLabel.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.descriptionLabel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    boolean valid() {
        boolean result;
        String s = this.fileField.getText().trim();
        boolean bl = result = s.length() == 0 && this.kind == IntermediatePanelKind.EXP_FILE;
        if (!result) {
            switch (this.kind) {
                case EXP_FILE: {
                    File f = new File(s);
                    if (!f.exists()) {
                        result = false;
                        this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ChooseSigOrExpFilePanelVisual.class, (String)"ERR_FILE_DOES_NOT_EXIST", (Object)((Object)this.kind)));
                        break;
                    }
                    result = true;
                    break;
                }
                case SIG_FILE: {
                    if (s.length() == 0) {
                        result = false;
                        this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ChooseSigOrExpFilePanelVisual.class, (String)"ERR_SIG_FILE_NOT_SET", (Object)((Object)this.kind)));
                        break;
                    }
                    File f = new File(s);
                    if (!f.exists()) {
                        result = false;
                        this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ChooseSigOrExpFilePanelVisual.class, (String)"ERR_FILE_DOES_NOT_EXIST", (Object)((Object)this.kind)));
                        break;
                    }
                    if (f.isDirectory()) {
                        result = false;
                        this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ChooseSigOrExpFilePanelVisual.class, (String)"ERR_FILE_IS_A_DIRECTORY", (Object)((Object)this.kind)));
                        break;
                    }
                    result = true;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        if (result) {
            this.wiz.putProperty("WizardPanel_errorMessage", null);
        }
        return result;
    }

    public File getFile() {
        String s = this.fileField.getText().trim();
        if (s.length() == 0) {
            return null;
        }
        return new File(s);
    }

    public void setFile(File f) {
        this.fileField.setText(f == null ? "" : f.getAbsolutePath());
    }

    private void browseFileButtononBrowseOrigin(ActionEvent evt) {
        File f = new FileChooserBuilder(ChooseOriginPanelVisual.class).setDirectoriesOnly(this.kind == IntermediatePanelKind.EXP_FILE).setTitle(this.kind.toString()).showOpenDialog();
        if (f != null) {
            this.fileField.setText(f.getAbsolutePath());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.supp.fireChange();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.insertUpdate(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.insertUpdate(e);
    }
}

