/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.actions;

import java.io.File;
import org.netbeans.api.project.Project;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

public abstract class FileProxy {
    public abstract String getAbsolutePath();

    public abstract boolean exists();

    public abstract FileProxy getChild(String var1);

    public abstract FileProxy getParentFile();

    public abstract boolean canWrite();

    private FileProxy() {
    }

    public static FileProxy createAbsolute(FileProxy file, String absPath) {
        Parameters.notNull((CharSequence)"file", (Object)file);
        if (file instanceof FileProxyFile) {
            return new FileProxyFile(new File(absPath));
        }
        if (file instanceof FileProxyFileObject) {
            return FileProxy.createAbsolute(((FileProxyFileObject)file).getBase(), absPath);
        }
        throw new IllegalArgumentException("Unexpected FileProxy class: " + file.getClass().getName());
    }

    public static FileProxy createAbsolute(FileObject fo, String absPath) {
        File file = FileUtil.toFile((FileObject)fo);
        if (file == null) {
            try {
                return new FileProxyFileObject(fo.getFileSystem().getRoot(), absPath);
            }
            catch (FileStateInvalidException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return new FileProxyFile(file);
            }
        }
        return new FileProxyFile(file);
    }

    public static FileProxy create(FileObject fo) {
        File file = FileUtil.toFile((FileObject)fo);
        return file == null ? new FileProxyFileObject(fo, "") : new FileProxyFile(file);
    }

    public static FileProxy createRelative(FileObject fo, String relPath) {
        File file = FileUtil.toFile((FileObject)fo);
        if (file == null) {
            return new FileProxyFileObject(fo, relPath == null ? "" : relPath);
        }
        if (FileProxy.isEmptyPath(relPath)) {
            return new FileProxyFile(file);
        }
        return new FileProxyFile(new File(file, relPath));
    }

    public static FileProxy createAbsolute(Project project, String path) {
        FileObject projectFO = project.getProjectDirectory();
        File projectFile = FileUtil.toFile((FileObject)projectFO);
        if (projectFile == null) {
            try {
                return new FileProxyFileObject(projectFO.getFileSystem().getRoot(), path);
            }
            catch (FileStateInvalidException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return new FileProxyFile(new File(path));
            }
        }
        return new FileProxyFile(new File(path));
    }

    private static boolean isEmptyPath(String path) {
        return path == null || path.isEmpty() || path.equals("/") || path.equals(".");
    }

    public String toString() {
        return this.getClass().getSimpleName() + ' ' + this.getAbsolutePath();
    }

    private static class FileProxyFile
    extends FileProxy {
        private final File file;

        public FileProxyFile(File file) {
            this.file = file;
        }

        @Override
        public String getAbsolutePath() {
            return this.file.getAbsolutePath();
        }

        @Override
        public boolean exists() {
            return this.file.exists();
        }

        @Override
        public FileProxy getParentFile() {
            File parentFile = this.file.getParentFile();
            return parentFile == null ? null : new FileProxyFile(parentFile);
        }

        @Override
        public FileProxy getChild(String childPath) {
            return new FileProxyFile(new File(this.file, childPath));
        }

        @Override
        public boolean canWrite() {
            return this.file.canWrite();
        }
    }

    private static class FileProxyFileObject
    extends FileProxy {
        private final FileObject base;
        private final String relPath;

        public FileProxyFileObject(FileObject fo, String relPath) {
            this.base = fo;
            this.relPath = relPath;
        }

        @Override
        public String getAbsolutePath() {
            String basePath = this.base.getPath();
            if (!basePath.endsWith("/") && !this.relPath.startsWith("/")) {
                return this.base.getPath() + (basePath.endsWith("/") ? "" : "/") + this.relPath;
            }
            return this.base.getPath() + this.relPath;
        }

        @Override
        public boolean exists() {
            FileObject fo = this.base.getFileObject(this.relPath);
            return fo != null && fo.isValid();
        }

        @Override
        public boolean canWrite() {
            FileObject fo = this.base.getFileObject(this.relPath);
            return fo != null && fo.canWrite();
        }

        @Override
        public FileProxy getParentFile() {
            if (FileProxy.isEmptyPath(this.relPath)) {
                FileObject parent = this.base.getParent();
                return parent == null ? null : new FileProxyFileObject(parent, "");
            }
            String parentPath = this.getParentPath(this.relPath);
            if (FileProxy.isEmptyPath(this.relPath)) {
                return new FileProxyFileObject(this.base, "");
            }
            return new FileProxyFileObject(this.base, parentPath);
        }

        private String getParentPath(String path) {
            if (path != null) {
                int fromIndex;
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                for (fromIndex = path.length() - 1; fromIndex >= 0 && path.charAt(fromIndex) == '/'; --fromIndex) {
                }
                int sep = path.lastIndexOf(47, fromIndex);
                if (sep != -1) {
                    return path.substring(0, sep);
                }
            }
            return null;
        }

        @Override
        public FileProxy getChild(String childPath) {
            return new FileProxyFileObject(this.base, this.relPath + '/' + childPath);
        }

        private FileObject getBase() {
            return this.base;
        }
    }
}

