/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.configurations;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.api.CodeStyleWrapper;
import org.netbeans.modules.cnd.makeproject.api.MakeProject;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.ui.customizer.MakeContext;
import org.netbeans.modules.editor.indent.spi.CodeStylePreferences;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class FormattingPropPanel
extends JPanel
implements MakeContext.Savable {
    private static final String C_CODE_STYLES = "C_CodeStyles";
    private static final String CPP_CODE_STYLES = "CPP_CodeStyles";
    private static final String H_CODE_STYLES = "H_CodeStyles";
    private static final String LIST_OF_STYLES = "List_Of_Styles";
    private static final String CODE_STYLE = "CodeStyle";
    private static final String CUSTOM_STYLE_NAME_SUFFIX = "_Style_Name";
    private static final String PREDEFINED_STYLE_NAME_SUFFIX = "_Name";
    private static final String PREFERENCES_PROVIDER_CLASS = "org.netbeans.modules.cnd.editor.options.CodeStylePreferencesProvider";
    private static final String SEPARATOR = ",";
    private final Project project;
    private final MakeConfigurationDescriptor makeConfigurationDescriptor;
    private static final String APACHE_PROFILE = "Apache";
    private static final String DEFAULT_PROFILE = "Default";
    private static final String GNU_PROFILE = "GNU";
    private static final String LUNIX_PROFILE = "Linux";
    private static final String ANSI_PROFILE = "ANSI";
    private static final String OPEN_SOLARIS_PROFILE = "OpenSolaris";
    private static final String K_AND_R_PROFILE = "KandR";
    private static final String MYSQL_PROFILE = "MySQL";
    private static final String WHITESMITHS_PROFILE = "Whitesmiths";
    private static final String[] PREDEFINED_STYLES = new String[]{"Default", "Apache", "GNU", "Linux", "ANSI", "OpenSolaris", "KandR", "MySQL", "Whitesmiths"};
    private ButtonGroup buttonGroup1;
    private JComboBox cComboBox;
    private JLabel cLabel;
    private JComboBox cppComboBox;
    private JLabel cppLabel;
    private JRadioButton globalRadioButton;
    private JComboBox headerComboBox;
    private JLabel headerLabel;
    private JPanel jPanel1;
    private JRadioButton projectRadioButton;

    public FormattingPropPanel(Project project, ConfigurationDescriptor configurationDescriptor) {
        StylePresentation stylePresentation;
        this.project = project;
        this.makeConfigurationDescriptor = (MakeConfigurationDescriptor)configurationDescriptor;
        this.initComponents();
        CodeStyleWrapper style = ((MakeProject)project).getProjectFormattingStyle("text/x-c");
        StylePresentation def = null;
        for (Map.Entry<String, CodeStyleWrapper> s : FormattingPropPanel.getAllStyles("text/x-c").entrySet()) {
            stylePresentation = new StylePresentation(s);
            if (style != null && stylePresentation.key.getStyleId().equals(style.getStyleId())) {
                def = stylePresentation;
            }
            this.cComboBox.addItem(stylePresentation);
        }
        if (def != null) {
            this.cComboBox.setSelectedItem(def);
        }
        style = ((MakeProject)project).getProjectFormattingStyle("text/x-c++");
        def = null;
        for (Map.Entry<String, CodeStyleWrapper> s : FormattingPropPanel.getAllStyles("text/x-c++").entrySet()) {
            stylePresentation = new StylePresentation(s);
            if (style != null && stylePresentation.key.getStyleId().equals(style.getStyleId())) {
                def = stylePresentation;
            }
            this.cppComboBox.addItem(stylePresentation);
        }
        if (def != null) {
            this.cppComboBox.setSelectedItem(def);
        }
        style = ((MakeProject)project).getProjectFormattingStyle("text/x-h");
        def = null;
        for (Map.Entry<String, CodeStyleWrapper> s : FormattingPropPanel.getAllStyles("text/x-h").entrySet()) {
            stylePresentation = new StylePresentation(s);
            if (style != null && stylePresentation.key.getStyleId().equals(style.getStyleId())) {
                def = stylePresentation;
            }
            this.headerComboBox.addItem(stylePresentation);
        }
        if (def != null) {
            this.headerComboBox.setSelectedItem(def);
        }
        if (((MakeProject)project).isProjectFormattingStyle()) {
            this.projectRadioButton.setSelected(true);
            this.projectRadioButtonActionPerformed(null);
        } else {
            this.globalRadioButton.setSelected(true);
            this.globalRadioButtonActionPerformed(null);
        }
    }

    public static Map<String, CodeStyleWrapper> getAllStyles(String mimeType) {
        Preferences pref = null;
        CodeStylePreferences.Provider myProvider = null;
        for (CodeStylePreferences.Provider p : Lookup.getDefault().lookupAll(CodeStylePreferences.Provider.class)) {
            if (!p.getClass().getName().equals(PREFERENCES_PROVIDER_CLASS)) continue;
            myProvider = p;
            pref = p.forDocument(null, mimeType);
        }
        String styles = null;
        StringBuilder def = new StringBuilder();
        if (myProvider == null) {
            return new TreeMap<String, CodeStyleWrapper>();
        }
        for (String s : PREDEFINED_STYLES) {
            if (def.length() > 0) {
                def.append(SEPARATOR);
            }
            def.append(s);
        }
        styles = pref != null ? ("text/x-c".equals(mimeType) ? pref.node(C_CODE_STYLES).get(LIST_OF_STYLES, def.toString()) : ("text/x-c++".equals(mimeType) ? pref.node(CPP_CODE_STYLES).get(LIST_OF_STYLES, def.toString()) : ("text/x-h".equals(mimeType) ? pref.node(H_CODE_STYLES).get(LIST_OF_STYLES, def.toString()) : def.toString()))) : def.toString();
        TreeMap<String, CodeStyleWrapper> res = new TreeMap<String, CodeStyleWrapper>();
        StringTokenizer st = new StringTokenizer(styles, SEPARATOR);
        while (st.hasMoreTokens()) {
            String nextToken = st.nextToken();
            String styleDisplayName = FormattingPropPanel.getStyleDisplayName(pref, myProvider, nextToken);
            res.put(styleDisplayName, new CodeStyleWrapper(nextToken, styleDisplayName));
        }
        return res;
    }

    public static String getStyleDisplayName(String styleId, String mimeType) {
        Preferences pref = null;
        CodeStylePreferences.Provider myProvider = null;
        for (CodeStylePreferences.Provider p : Lookup.getDefault().lookupAll(CodeStylePreferences.Provider.class)) {
            if (!p.getClass().getName().equals(PREFERENCES_PROVIDER_CLASS)) continue;
            myProvider = p;
            pref = p.forDocument(null, mimeType);
        }
        if (myProvider == null) {
            return styleId;
        }
        return FormattingPropPanel.getStyleDisplayName(pref, myProvider, styleId);
    }

    private static String getStyleDisplayName(Preferences pref, CodeStylePreferences.Provider myProvider, String styleId) {
        for (String name : PREDEFINED_STYLES) {
            if (!styleId.equals(name)) continue;
            return NbBundle.getMessage(myProvider.getClass(), (String)(styleId + PREDEFINED_STYLE_NAME_SUFFIX));
        }
        return pref.node(CODE_STYLE).get(styleId + CUSTOM_STYLE_NAME_SUFFIX, styleId);
    }

    public static boolean createStyle(CodeStyleWrapper styleId, String mimeType) {
        String styles;
        Preferences pref = null;
        String[] myProvider = null;
        for (String[] p : Lookup.getDefault().lookupAll(CodeStylePreferences.Provider.class)) {
            if (!p.getClass().getName().equals(PREFERENCES_PROVIDER_CLASS)) continue;
            myProvider = p;
            pref = p.forDocument(null, mimeType);
        }
        if (pref == null || myProvider == null) {
            return false;
        }
        StringBuilder def = new StringBuilder();
        for (String s : PREDEFINED_STYLES) {
            if (def.length() > 0) {
                def.append(SEPARATOR);
            }
            def.append(s);
        }
        if ("text/x-c".equals(mimeType)) {
            styles = pref.node(C_CODE_STYLES).get(LIST_OF_STYLES, def.toString());
            pref.node(C_CODE_STYLES).put(LIST_OF_STYLES, styles + SEPARATOR + styleId.getStyleId());
            pref.node(CODE_STYLE).put(styleId + CUSTOM_STYLE_NAME_SUFFIX, styleId.getDisplayName());
        } else if ("text/x-c++".equals(mimeType)) {
            styles = pref.node(CPP_CODE_STYLES).get(LIST_OF_STYLES, def.toString());
            pref.node(CPP_CODE_STYLES).put(LIST_OF_STYLES, styles + SEPARATOR + styleId.getStyleId());
            pref.node(CODE_STYLE).put(styleId + CUSTOM_STYLE_NAME_SUFFIX, styleId.getDisplayName());
        } else if ("text/x-h".equals(mimeType)) {
            styles = pref.node(H_CODE_STYLES).get(LIST_OF_STYLES, def.toString());
            pref.node(H_CODE_STYLES).put(LIST_OF_STYLES, styles + SEPARATOR + styleId.getStyleId());
            pref.node(CODE_STYLE).put(styleId + CUSTOM_STYLE_NAME_SUFFIX, styleId.getDisplayName());
        }
        return true;
    }

    @Override
    public void save() {
        ((MakeProject)this.project).setProjectFormattingStyle(this.projectRadioButton.isSelected());
        ((MakeProject)this.project).setProjectFormattingStyle("text/x-c", ((StylePresentation)this.cComboBox.getSelectedItem()).key);
        ((MakeProject)this.project).setProjectFormattingStyle("text/x-c++", ((StylePresentation)this.cppComboBox.getSelectedItem()).key);
        ((MakeProject)this.project).setProjectFormattingStyle("text/x-h", ((StylePresentation)this.headerComboBox.getSelectedItem()).key);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.globalRadioButton = new JRadioButton();
        this.projectRadioButton = new JRadioButton();
        this.cLabel = new JLabel();
        this.cppLabel = new JLabel();
        this.headerLabel = new JLabel();
        this.cComboBox = new JComboBox();
        this.cppComboBox = new JComboBox();
        this.headerComboBox = new JComboBox();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.buttonGroup1.add(this.globalRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.globalRadioButton, (String)NbBundle.getMessage(FormattingPropPanel.class, (String)"FormattingPropPanel.globalRadioButton.text"));
        this.globalRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormattingPropPanel.this.globalRadioButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.globalRadioButton, gridBagConstraints);
        this.buttonGroup1.add(this.projectRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.projectRadioButton, (String)NbBundle.getMessage(FormattingPropPanel.class, (String)"FormattingPropPanel.projectRadioButton.text"));
        this.projectRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormattingPropPanel.this.projectRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.projectRadioButton, gridBagConstraints);
        this.cLabel.setLabelFor(this.cComboBox);
        Mnemonics.setLocalizedText((JLabel)this.cLabel, (String)NbBundle.getMessage(FormattingPropPanel.class, (String)"FormattingPropPanel.cLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 18, 0, 6);
        this.add((Component)this.cLabel, gridBagConstraints);
        this.cppLabel.setLabelFor(this.cppComboBox);
        Mnemonics.setLocalizedText((JLabel)this.cppLabel, (String)NbBundle.getMessage(FormattingPropPanel.class, (String)"FormattingPropPanel.cppLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 18, 0, 6);
        this.add((Component)this.cppLabel, gridBagConstraints);
        this.headerLabel.setLabelFor(this.headerComboBox);
        Mnemonics.setLocalizedText((JLabel)this.headerLabel, (String)NbBundle.getMessage(FormattingPropPanel.class, (String)"FormattingPropPanel.headerLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 18, 0, 6);
        this.add((Component)this.headerLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.add((Component)this.cComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.add((Component)this.cppComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.add((Component)this.headerComboBox, gridBagConstraints);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 403, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 132, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void globalRadioButtonActionPerformed(ActionEvent evt) {
        this.cComboBox.setEnabled(false);
        this.cppComboBox.setEnabled(false);
        this.headerComboBox.setEnabled(false);
    }

    private void projectRadioButtonActionPerformed(ActionEvent evt) {
        this.cComboBox.setEnabled(true);
        this.cppComboBox.setEnabled(true);
        this.headerComboBox.setEnabled(true);
    }

    private static final class StylePresentation {
        private CodeStyleWrapper key;
        private final String name;

        private StylePresentation(Map.Entry<String, CodeStyleWrapper> entry) {
            this.name = entry.getKey();
            this.key = entry.getValue();
        }

        public String toString() {
            return this.name;
        }
    }
}

