/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.customizer;

import java.util.ArrayList;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.FolderConfiguration;
import org.netbeans.modules.cnd.makeproject.api.ui.configurations.CustomizerNode;
import org.netbeans.modules.cnd.makeproject.ui.customizer.GeneralFolderCustomizerNode;
import org.netbeans.modules.cnd.makeproject.ui.customizer.ItemNodeFactory;
import org.netbeans.modules.cnd.makeproject.ui.customizer.LinkerGeneralCustomizerNode;
import org.netbeans.modules.cnd.makeproject.ui.customizer.MakeCustomizer;
import org.netbeans.modules.cnd.makeproject.ui.customizer.PropertyNode;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class FolderNodeFactory {
    private FolderNodeFactory() {
    }

    public static Node createRootNodeFolder(Lookup lookup) {
        ArrayList<CustomizerNode> descriptions = new ArrayList<CustomizerNode>();
        descriptions.add(FolderNodeFactory.createGeneralFolderDescription(lookup));
        descriptions.add(ItemNodeFactory.createCCompilerDescription(lookup));
        descriptions.add(ItemNodeFactory.createCCCompilerDescription(lookup));
        Folder[] folders = (Folder[])lookup.lookup(Folder[].class);
        boolean linker = true;
        for (Folder folder : folders) {
            if (folder != null && (folder.isTest() || folder.isTestLogicalFolder() || folder.isTestRootFolder())) continue;
            linker = false;
        }
        if (linker) {
            descriptions.add(FolderNodeFactory.createLinkerDescription(lookup));
        }
        CustomizerNode rootDescription = new CustomizerNode("Configuration Properties", FolderNodeFactory.getString("CONFIGURATION_PROPERTIES"), descriptions.toArray(new CustomizerNode[descriptions.size()]), lookup);
        return new PropertyNode(rootDescription);
    }

    private static CustomizerNode createGeneralFolderDescription(Lookup lookup) {
        return new GeneralFolderCustomizerNode("GeneralItem", FolderNodeFactory.getString("LBL_Config_General"), null, lookup);
    }

    private static CustomizerNode createLinkerDescription(Lookup lookup) {
        return new LinkerGeneralCustomizerNode("Linker", FolderNodeFactory.getString("LBL_LINKER_NODE"), null, lookup);
    }

    private static String getString(String s) {
        return NbBundle.getBundle(MakeCustomizer.class).getString(s);
    }

    public static Sheet getGeneralSheet(FolderConfiguration fc) {
        Sheet sheet = new Sheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("FolderConfiguration");
        set.setDisplayName(FolderNodeFactory.getString("FolderConfigurationTxt"));
        set.setShortDescription(FolderNodeFactory.getString("FolderConfigurationHint"));
        set.put((Node.Property)new StringRONodeProp(FolderNodeFactory.getString("NameTxt"), fc.getFolder().getDisplayName()));
        sheet.put(set);
        return sheet;
    }

    private static class StringRONodeProp
    extends PropertySupport<String> {
        private final String value;

        public StringRONodeProp(String name, String value) {
            super(name, String.class, name, name, true, false);
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String v) {
        }
    }
}

