/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.api.remote.RemoteProject;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ui.RemoteFileChooserUtil;
import org.netbeans.modules.cnd.makeproject.api.ui.wizard.WizardConstants;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;

public class NewProjectWizardUtils {
    public static boolean isFullRemote(WizardDescriptor wizardDescriptor) {
        return WizardConstants.PROPERTY_REMOTE_FILE_SYSTEM_ENV.get(wizardDescriptor) != null;
    }

    public static FileSystem getFileSystem(WizardDescriptor wizardDescriptor) {
        if (NewProjectWizardUtils.isFullRemote(wizardDescriptor)) {
            String hostUID = WizardConstants.PROPERTY_HOST_UID.get(wizardDescriptor);
            CndUtils.assertNotNull((Object)hostUID, (String)"Null host UID");
            ExecutionEnvironment env = ExecutionEnvironmentFactory.fromUniqueID((String)hostUID);
            return FileSystemProvider.getFileSystem((ExecutionEnvironment)env);
        }
        return FileSystemProvider.getFileSystem((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal());
    }

    public static FileObject getFileObject(String path, WizardDescriptor wizardDescriptor) {
        if (NewProjectWizardUtils.isFullRemote(wizardDescriptor)) {
            String hostUID = WizardConstants.PROPERTY_HOST_UID.get(wizardDescriptor);
            CndUtils.assertNotNull((Object)hostUID, (String)"Null host UID");
            ExecutionEnvironment env = ExecutionEnvironmentFactory.fromUniqueID((String)hostUID);
            return RemoteFileUtil.getFileObject((String)path, (ExecutionEnvironment)env);
        }
        return CndFileUtils.toFileObject((CharSequence)CndFileUtils.normalizeAbsolutePath((String)path));
    }

    public static ExecutionEnvironment getExecutionEnvironment(WizardDescriptor wizardDescriptor) {
        String hostUID = WizardConstants.PROPERTY_HOST_UID.get(wizardDescriptor);
        return hostUID == null ? ServerList.getDefaultRecord().getExecutionEnvironment() : ExecutionEnvironmentFactory.fromUniqueID((String)hostUID);
    }

    public static boolean fileExists(String absolutePath, WizardDescriptor wizardDescriptor) {
        if (NewProjectWizardUtils.isFullRemote(wizardDescriptor)) {
            return RemoteFileUtil.fileExists((String)absolutePath, (ExecutionEnvironment)NewProjectWizardUtils.getExecutionEnvironment(wizardDescriptor));
        }
        return new File(absolutePath).exists();
    }

    public static boolean isDirectory(String absolutePath, WizardDescriptor wizardDescriptor) {
        if (NewProjectWizardUtils.isFullRemote(wizardDescriptor)) {
            return RemoteFileUtil.isDirectory((String)absolutePath, (ExecutionEnvironment)NewProjectWizardUtils.getExecutionEnvironment(wizardDescriptor));
        }
        return new File(absolutePath).isDirectory();
    }

    public static JFileChooser createFileChooser(Project project, String titleText, String buttonText, int mode, FileFilter[] filters, String initialPath, boolean useParent) {
        RemoteProject remoteProject;
        ExecutionEnvironment execEnv = ExecutionEnvironmentFactory.getLocal();
        if (project != null && (remoteProject = (RemoteProject)project.getLookup().lookup(RemoteProject.class)) != null) {
            execEnv = remoteProject.getSourceFileSystemHost();
        }
        return RemoteFileChooserUtil.createFileChooser((ExecutionEnvironment)execEnv, (String)titleText, (String)buttonText, (int)mode, (FileFilter[])filters, (String)initialPath, (boolean)useParent);
    }

    public static ExecutionEnvironment getDefaultSourceEnvironment() {
        ExecutionEnvironment env;
        String externalForm = System.getProperty("cnd.default.project.source.env");
        if (externalForm != null && (env = ExecutionEnvironmentFactory.fromUniqueID((String)externalForm)) != null) {
            return env;
        }
        return ExecutionEnvironmentFactory.getLocal();
    }

    public static JFileChooser createFileChooser(WizardDescriptor wd, String titleText, String buttonText, int mode, FileFilter[] filters, String initialPath, boolean useParent) {
        String hostUID;
        ExecutionEnvironment execEnv = ExecutionEnvironmentFactory.getLocal();
        if (NewProjectWizardUtils.isFullRemote(wd) && (hostUID = WizardConstants.PROPERTY_HOST_UID.get(wd)) != null) {
            execEnv = ExecutionEnvironmentFactory.fromUniqueID((String)hostUID);
        }
        return RemoteFileChooserUtil.createFileChooser((ExecutionEnvironment)execEnv, (String)titleText, (String)buttonText, (int)mode, (FileFilter[])filters, (String)initialPath, (boolean)useParent);
    }
}

