/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.makeproject.api.wizards.BuildSupport;
import org.netbeans.modules.cnd.makeproject.ui.wizards.BjamScripSupport;
import org.netbeans.modules.cnd.makeproject.ui.wizards.SelectModePanel;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.FileAndFileObjectFilter;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class NinjaScriptSupport
implements BuildSupport.BuildFileProvider {
    public BuildSupport.BuildFile findBuildFileInFolder(FileObject folder, ExecutionEnvironment ee, CompilerSet compilerSet) {
        if (folder == null || !folder.isFolder() || !folder.canRead()) {
            return null;
        }
        FileObject[] listFiles = folder.getChildren();
        if (listFiles == null) {
            return null;
        }
        for (FileObject file : listFiles) {
            if (!file.getExt().equals("ninja")) continue;
            return new NinjaScriptArtifact(file.getPath());
        }
        return null;
    }

    public BuildSupport.BuildFile scriptToBuildFile(String script) {
        String name = CndPathUtilities.getBaseName((String)script);
        if (name != null && name.endsWith("ninja")) {
            return new NinjaScriptArtifact(script);
        }
        return null;
    }

    public boolean isSupported(BuildSupport.BuildFile script) {
        return script instanceof NinjaScriptArtifact;
    }

    public FileFilter[] getFileFilter() {
        return new FileFilter[]{new NinjaFileFilter()};
    }

    public String getHint() {
        return NbBundle.getMessage(SelectModePanel.class, (String)"SelectModeSimpleInstructionExtraText_Ninja");
    }

    private static final class NinjaFileFilter
    extends FileAndFileObjectFilter {
        private NinjaFileFilter() {
        }

        public String getDescription() {
            return NbBundle.getMessage(BjamScripSupport.class, (String)"NinjaFileFilter");
        }

        protected String[] getSuffixes() {
            return new String[]{"ninja"};
        }
    }

    private static final class NinjaScriptArtifact
    implements BuildSupport.BuildFile {
        private final String script;

        NinjaScriptArtifact(String script) {
            this.script = script;
        }

        public String getFile() {
            return this.script;
        }

        public String getCleanCommandLine(String arguments, String workingDir) {
            String res = "ninja -t clean";
            if (arguments != null && !arguments.isEmpty()) {
                res = res + " " + arguments;
            }
            return res;
        }

        public String getBuildCommandLine(String arguments, String workingDir) {
            String res = "ninja";
            if (arguments != null && !arguments.isEmpty()) {
                res = res + " " + arguments;
            }
            return res;
        }

        public String validate(ExecutionEnvironment ee, CompilerSet compilerSet) {
            return null;
        }
    }
}

