/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.io.File;
import java.io.InputStream;
import java.util.Locale;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.DConfigBeanVersionType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DConfigBeanVersionUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;

public class LazyDeploymentManager
implements DeploymentManager {
    private final DeploymentManagerProvider provider;
    private DeploymentManager dm;

    public LazyDeploymentManager(DeploymentManagerProvider provider) {
        this.provider = provider;
    }

    public static DeploymentManager getDeploymentManager(String url) {
        ServerRegistry registry = ServerRegistry.getInstance();
        ServerInstance inst = registry.getServerInstance(url);
        return inst.getDeploymentManager();
    }

    public ProgressObject undeploy(TargetModuleID[] tmids) throws IllegalStateException {
        return this.getDeploymentManager().undeploy(tmids);
    }

    public ProgressObject stop(TargetModuleID[] tmids) throws IllegalStateException {
        return this.getDeploymentManager().stop(tmids);
    }

    public ProgressObject start(TargetModuleID[] tmids) throws IllegalStateException {
        return this.getDeploymentManager().start(tmids);
    }

    public void setLocale(Locale locale) throws UnsupportedOperationException {
        this.getDeploymentManager().setLocale(locale);
    }

    public void setDConfigBeanVersion(DConfigBeanVersionType dcbvt) throws DConfigBeanVersionUnsupportedException {
        this.getDeploymentManager().setDConfigBeanVersion(dcbvt);
    }

    public void release() {
        this.getDeploymentManager().release();
    }

    public ProgressObject redeploy(TargetModuleID[] tmids, InputStream in, InputStream in1) throws UnsupportedOperationException, IllegalStateException {
        return this.getDeploymentManager().redeploy(tmids, in, in1);
    }

    public ProgressObject redeploy(TargetModuleID[] tmids, File file, File file1) throws UnsupportedOperationException, IllegalStateException {
        return this.getDeploymentManager().redeploy(tmids, file, file1);
    }

    public boolean isRedeploySupported() {
        return this.getDeploymentManager().isRedeploySupported();
    }

    public boolean isLocaleSupported(Locale locale) {
        return this.getDeploymentManager().isLocaleSupported(locale);
    }

    public boolean isDConfigBeanVersionSupported(DConfigBeanVersionType dcbvt) {
        return this.getDeploymentManager().isDConfigBeanVersionSupported(dcbvt);
    }

    public Target[] getTargets() throws IllegalStateException {
        return this.getDeploymentManager().getTargets();
    }

    public Locale[] getSupportedLocales() {
        return this.getDeploymentManager().getSupportedLocales();
    }

    public TargetModuleID[] getRunningModules(ModuleType mt, Target[] targets) throws TargetException, IllegalStateException {
        return this.getDeploymentManager().getRunningModules(mt, targets);
    }

    public TargetModuleID[] getNonRunningModules(ModuleType mt, Target[] targets) throws TargetException, IllegalStateException {
        return this.getDeploymentManager().getNonRunningModules(mt, targets);
    }

    public Locale getDefaultLocale() {
        return this.getDeploymentManager().getDefaultLocale();
    }

    public DConfigBeanVersionType getDConfigBeanVersion() {
        return this.getDeploymentManager().getDConfigBeanVersion();
    }

    public Locale getCurrentLocale() {
        return this.getDeploymentManager().getCurrentLocale();
    }

    public TargetModuleID[] getAvailableModules(ModuleType mt, Target[] targets) throws TargetException, IllegalStateException {
        return this.getDeploymentManager().getAvailableModules(mt, targets);
    }

    public ProgressObject distribute(Target[] targets, ModuleType mt, InputStream in, InputStream in1) throws IllegalStateException {
        return this.getDeploymentManager().distribute(targets, mt, in, in1);
    }

    public ProgressObject distribute(Target[] targets, InputStream in, InputStream in1) throws IllegalStateException {
        return this.getDeploymentManager().distribute(targets, in, in1);
    }

    public ProgressObject distribute(Target[] targets, File file, File file1) throws IllegalStateException {
        return this.getDeploymentManager().distribute(targets, file, file1);
    }

    public DeploymentConfiguration createConfiguration(DeployableObject d) throws InvalidModuleException {
        return this.getDeploymentManager().createConfiguration(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeploymentManager getDeploymentManager() {
        LazyDeploymentManager lazyDeploymentManager = this;
        synchronized (lazyDeploymentManager) {
            if (this.dm != null) {
                return this.dm;
            }
            this.dm = this.provider.getDeploymentManager();
            return this.dm;
        }
    }

    public static interface DeploymentManagerProvider {
        public DeploymentManager getDeploymentManager();
    }
}

