/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.impl;

import org.clang.basic.impl.Entry;
import org.clang.basic.impl.EntryKind;
import org.clang.basic.impl.FileWithFixedStatus;
import org.clang.basic.impl.RedirectingDirectoryEntry;
import org.clang.basic.impl.RedirectingFileEntry;
import org.clang.basic.impl.RedirectingFileSystemParser;
import org.clang.basic.impl.VFSFromYamlDirIterImpl;
import org.clang.basic.impl.VirtualFileSystemStatics;
import org.clang.basic.vfs.File;
import org.clang.basic.vfs.FileSystem;
import org.clang.basic.vfs.Status;
import org.clang.basic.vfs.detail.DirIterImpl;
import org.clang.basic.vfs.directory_iterator;
import org.clank.java.std;
import org.clank.java.std_errors;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.bool;
import org.llvm.adt.ADTFunctionPointers;
import org.llvm.adt.IntrusiveRefCntPtr;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.support.ErrorOr;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.SMLoc;
import org.llvm.support.SourceMgr;
import org.llvm.support.llvm;
import org.llvm.support.sys.fs;
import org.llvm.support.sys.path;
import org.llvm.support.yaml.Document;
import org.llvm.support.yaml.Node;
import org.llvm.support.yaml.Stream;
import org.llvm.support.yaml.document_iterator;

public class RedirectingFileSystem
extends FileSystem
implements Destructors.ClassWithDestructor {
    final std.vector<std_ptr.unique_ptr<Entry>> Roots;
    private IntrusiveRefCntPtr<FileSystem> ExternalFS;
    private std.string ExternalContentsPrefixDir;
    private boolean CaseSensitive;
    final bool.ref CaseSensitive$Ref = new bool.ref(){

        public boolean $deref() {
            return RedirectingFileSystem.this.CaseSensitive;
        }

        public boolean $set(boolean value) {
            return RedirectingFileSystem.this.CaseSensitive = value;
        }
    };
    private boolean IsRelativeOverlay;
    final bool.ref IsRelativeOverlay$Ref = new bool.ref(){

        public boolean $deref() {
            return RedirectingFileSystem.this.IsRelativeOverlay;
        }

        public boolean $set(boolean value) {
            return RedirectingFileSystem.this.IsRelativeOverlay = value;
        }
    };
    private boolean UseExternalNames;
    final bool.ref UseExternalNames$Ref = new bool.ref(){

        public boolean $deref() {
            return RedirectingFileSystem.this.UseExternalNames;
        }

        public boolean $set(boolean value) {
            return RedirectingFileSystem.this.UseExternalNames = value;
        }
    };
    final boolean UseCanonicalizedPaths;

    private RedirectingFileSystem(IntrusiveRefCntPtr<FileSystem> ExternalFS) {
        this.Roots = new std.vector((Object)new std_ptr.unique_ptr());
        this.ExternalFS = new IntrusiveRefCntPtr(JavaDifferentiators.JD.Move.INSTANCE, (IntrusiveRefCntPtr)std.move(ExternalFS));
        this.ExternalContentsPrefixDir = new std.string();
        this.CaseSensitive = true;
        this.IsRelativeOverlay = false;
        this.UseExternalNames = true;
        this.UseCanonicalizedPaths = true;
    }

    private ErrorOr<Entry> lookupPath(Twine Path_) {
        SmallString Path = new SmallString(256);
        Path_.toVector(Path);
        std_errors.error_code EC = this.makeAbsolute(Path);
        if (EC.$bool()) {
            return new ErrorOr(new std_errors.error_code(EC));
        }
        if (this.UseCanonicalizedPaths) {
            Path.$assign(path.remove_leading_dotslash((StringRef)Path.$StringRef()));
            path.remove_dots((SmallString)Path, (boolean)true);
        }
        if (Path.empty()) {
            return new ErrorOr(llvm.make_error_code((std_errors.errc)std_errors.errc.invalid_argument));
        }
        path.const_iterator Start = path.begin((StringRef)Path.$StringRef());
        path.const_iterator End = path.end((StringRef)Path.$StringRef());
        for (std_ptr.unique_ptr Root : this.Roots) {
            ErrorOr<Entry> Result = this.lookupPath(new path.const_iterator(Start), new path.const_iterator(End), (Entry)Root.get());
            if (!Result.$bool() && !std.$noteq_error_code((std_errors.error_code)Result.getError(), (std_errors.error_code)new std_errors.error_code(std_errors.errc.no_such_file_or_directory))) continue;
            return Result;
        }
        return new ErrorOr(llvm.make_error_code((std_errors.errc)std_errors.errc.no_such_file_or_directory));
    }

    private ErrorOr<Entry> lookupPath(path.const_iterator Start, path.const_iterator End, Entry From) {
        RedirectingDirectoryEntry DE;
        assert (!VirtualFileSystemStatics.isTraversalComponent(Start.$star()) && !VirtualFileSystemStatics.isTraversalComponent(From.getName())) : "Paths should not contain traversal components";
        StringRef FromName = From.getName();
        if (!FromName.empty()) {
            if (this.CaseSensitive ? !Start.$arrow().equals(FromName) : !Start.$arrow().equals_lower(FromName)) {
                return new ErrorOr(llvm.make_error_code((std_errors.errc)std_errors.errc.no_such_file_or_directory));
            }
            Start.$preInc();
            if (Start.$eq((Object)End)) {
                return new ErrorOr(JavaDifferentiators.JD$Convertible.INSTANCE, (Object)From);
            }
        }
        if ((DE = (RedirectingDirectoryEntry)llvm.dyn_cast(RedirectingDirectoryEntry.class, (Object)From)) == null) {
            return new ErrorOr(llvm.make_error_code((std_errors.errc)std_errors.errc.not_a_directory));
        }
        for (std_ptr.unique_ptr DirEntry : llvm.make_range(DE.contents_begin(), DE.contents_end())) {
            ErrorOr<Entry> Result = this.lookupPath(new path.const_iterator(Start), new path.const_iterator(End), (Entry)DirEntry.get());
            if (!Result.$bool() && !std.$noteq_error_code((std_errors.error_code)Result.getError(), (std_errors.error_code)new std_errors.error_code(std_errors.errc.no_such_file_or_directory))) continue;
            return Result;
        }
        return new ErrorOr(llvm.make_error_code((std_errors.errc)std_errors.errc.no_such_file_or_directory));
    }

    private ErrorOr<Status> status(Twine Path, Entry E) {
        assert (E != null);
        RedirectingFileEntry F = (RedirectingFileEntry)llvm.dyn_cast(RedirectingFileEntry.class, (Object)E);
        if (F != null) {
            ErrorOr<Status> S = ((FileSystem)((Object)this.ExternalFS.$arrow())).status(new Twine(F.getExternalContentsPath()));
            assert (!S.$bool() || llvm.$eq_StringRef((StringRef)((Status)S.$arrow()).getName(), (StringRef)F.getExternalContentsPath()));
            if (S.$bool()) {
                return new ErrorOr(JavaDifferentiators.JD$Convertible.INSTANCE, (Object)VirtualFileSystemStatics.getRedirectedFileStatus(Path, F.useExternalName(this.UseExternalNames), new Status((Status)S.$star())));
            }
            return S;
        }
        RedirectingDirectoryEntry DE = (RedirectingDirectoryEntry)llvm.cast(RedirectingDirectoryEntry.class, (Object)E);
        return new ErrorOr(JavaDifferentiators.JD$Convertible.INSTANCE, (Object)Status.copyWithNewName(DE.getStatus(), new StringRef(Path.str())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RedirectingFileSystem create(std_ptr.unique_ptr<MemoryBuffer> Buffer2, ADTFunctionPointers.DiagHandlerTy DiagHandler, StringRef YAMLFilePath, Object DiagContext, IntrusiveRefCntPtr<FileSystem> ExternalFS) {
        SourceMgr SM = null;
        Stream Stream2 = null;
        std_ptr.unique_ptr FS = null;
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            RedirectingFileSystem redirectingFileSystem;
            SM = new SourceMgr();
            Stream2 = new Stream(((MemoryBuffer)Buffer2.$arrow()).getMemBufferRef(), SM);
            SM.setDiagHandler(DiagHandler, DiagContext);
            document_iterator DI = Stream2.begin();
            Node Root = ((Document)DI.$arrow().$arrow()).getRoot();
            if (DI.$eq(Stream2.end()) || Root == null) {
                SM.PrintMessage(new SMLoc(), SourceMgr.DiagKind.DK_Error, new Twine("expected root node"));
                RedirectingFileSystem redirectingFileSystem2 = null;
                return redirectingFileSystem2;
            }
            RedirectingFileSystemParser P = new RedirectingFileSystemParser(Stream2);
            FS = (std_ptr.unique_ptr)$c$.clean((Object)new std_ptr.unique_ptr((Object)new RedirectingFileSystem((IntrusiveRefCntPtr<FileSystem>)((IntrusiveRefCntPtr)$c$.track((Object)new IntrusiveRefCntPtr(JavaDifferentiators.JD.Move.INSTANCE, (IntrusiveRefCntPtr)std.move(ExternalFS)))))));
            if (!YAMLFilePath.empty()) {
                SmallString OverlayAbsDir = new SmallString(path.parent_path((StringRef)YAMLFilePath), 256);
                std_errors.error_code EC = fs.make_absolute((SmallString)OverlayAbsDir);
                assert (!EC.$bool()) : "Overlay dir final path must be absolute";
                ((RedirectingFileSystem)((Object)FS.$arrow())).setExternalContentsPrefixDir(OverlayAbsDir.$StringRef());
            }
            if (!P.parse(Root, (RedirectingFileSystem)((Object)FS.get()))) {
                redirectingFileSystem = null;
                return redirectingFileSystem;
            }
            redirectingFileSystem = (RedirectingFileSystem)((Object)FS.release());
            return redirectingFileSystem;
        }
        finally {
            if (FS != null) {
                FS.$destroy();
            }
            if (Stream2 != null) {
                Stream2.$destroy();
            }
            if (SM != null) {
                SM.$destroy();
            }
            $c$.$destroy();
        }
    }

    @Override
    public ErrorOr<Status> status(Twine Path) {
        ErrorOr<Entry> Result = this.lookupPath(Path);
        if (!Result.$bool()) {
            return new ErrorOr(Result.getError());
        }
        return this.status(Path, (Entry)Result.$star());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ErrorOr<std_ptr.unique_ptr<File>> openFileForRead(Twine Path) {
        ErrorOr<std_ptr.unique_ptr<File>> Result = null;
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            ErrorOr<Entry> E = this.lookupPath(Path);
            if (!E.$bool()) {
                ErrorOr errorOr = new ErrorOr(E.getError());
                return errorOr;
            }
            RedirectingFileEntry F = (RedirectingFileEntry)llvm.dyn_cast(RedirectingFileEntry.class, (Object)E.$star());
            if (F == null) {
                ErrorOr errorOr = new ErrorOr(llvm.make_error_code((std_errors.errc)std_errors.errc.invalid_argument));
                return errorOr;
            }
            Result = ((FileSystem)((Object)this.ExternalFS.$arrow())).openFileForRead(new Twine(F.getExternalContentsPath()));
            if (!Result.$bool()) {
                ErrorOr errorOr = new ErrorOr(JavaDifferentiators.JD.Move.INSTANCE, Result);
                return errorOr;
            }
            ErrorOr<Status> ExternalStatus = ((File)((std_ptr.unique_ptr)Result.$star()).$arrow()).status();
            if (!ExternalStatus.$bool()) {
                ErrorOr errorOr = new ErrorOr(ExternalStatus.getError());
                return errorOr;
            }
            Status S = VirtualFileSystemStatics.getRedirectedFileStatus(Path, F.useExternalName(this.UseExternalNames), new Status((Status)ExternalStatus.$star()));
            ErrorOr errorOr = (ErrorOr)$c$.clean((Object)new ErrorOr(JavaDifferentiators.JD$Convertible.INSTANCE, (Object)$c$.track(new std_ptr.unique_ptr($c$.track(llvm.make_unique((Object)new FileWithFixedStatus((std_ptr.unique_ptr<File>)std.move((std_ptr.unique_ptr)((std_ptr.unique_ptr)Result.$star())), S)))))));
            return errorOr;
        }
        finally {
            if (Result != null) {
                Result.$destroy();
            }
            $c$.$destroy();
        }
    }

    @Override
    public ErrorOr<std.string> getCurrentWorkingDirectory() {
        return ((FileSystem)((Object)this.ExternalFS.$arrow())).getCurrentWorkingDirectory();
    }

    @Override
    public std_errors.error_code setCurrentWorkingDirectory(Twine Path) {
        return ((FileSystem)((Object)this.ExternalFS.$arrow())).setCurrentWorkingDirectory(Path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public directory_iterator dir_begin(Twine Dir, std_errors.error_code EC) {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            ErrorOr<Entry> E = this.lookupPath(Dir);
            if (!E.$bool()) {
                EC.$assignMove(E.getError());
                directory_iterator directory_iterator2 = new directory_iterator();
                return directory_iterator2;
            }
            ErrorOr<Status> S = this.status(Dir, (Entry)E.$star());
            if (!S.$bool()) {
                EC.$assignMove(S.getError());
                directory_iterator directory_iterator3 = new directory_iterator();
                return directory_iterator3;
            }
            if (!((Status)S.$arrow()).isDirectory()) {
                EC.$assignMove(new std_errors.error_code(std_errors.errc.not_a_directory.getValue(), std.system_category()));
                directory_iterator directory_iterator4 = new directory_iterator();
                return directory_iterator4;
            }
            RedirectingDirectoryEntry D = (RedirectingDirectoryEntry)llvm.cast(RedirectingDirectoryEntry.class, (Object)E.$star());
            directory_iterator directory_iterator5 = (directory_iterator)$c$.clean(new directory_iterator((std_ptr.shared_ptr<DirIterImpl>)((std_ptr.shared_ptr)$c$.track((Object)new std_ptr.shared_ptr((std_ptr.shared_ptr)$c$.track((Object)std.make_shared((Object)new VFSFromYamlDirIterImpl(Dir, this, D.contents_begin(), D.contents_end(), EC))))))));
            return directory_iterator5;
        }
        finally {
            $c$.$destroy();
        }
    }

    public void setExternalContentsPrefixDir(StringRef PrefixDir) {
        this.ExternalContentsPrefixDir.$assignMove(PrefixDir.str());
    }

    public StringRef getExternalContentsPrefixDir() {
        return new StringRef(this.ExternalContentsPrefixDir);
    }

    public void dump() {
        for (std_ptr.unique_ptr Root : this.Roots) {
            this.dumpEntry((Entry)Root.get());
        }
    }

    public void dumpEntry(Entry E) {
        this.dumpEntry(E, 0);
    }

    public void dumpEntry(Entry E, int NumSpaces) {
        StringRef Name = E.getName();
        int e = NumSpaces;
        for (int i = 0; i < e; ++i) {
            llvm.dbgs().$out(NativePointer.$SPACE);
        }
        llvm.dbgs().$out(NativePointer.$SGL_QUOTE).$out(Name.str().c_str()).$out(NativePointer.$SGL_QUOTE).$out(NativePointer.$LF);
        if (E.getKind() == EntryKind.EK_Directory) {
            RedirectingDirectoryEntry DE = (RedirectingDirectoryEntry)llvm.dyn_cast(RedirectingDirectoryEntry.class, (Object)E);
            assert (DE != null) : "Should be a directory";
            for (std_ptr.unique_ptr SubEntry : llvm.make_range(DE.contents_begin(), DE.contents_end())) {
                this.dumpEntry((Entry)SubEntry.get(), NumSpaces + 2);
            }
        }
    }

    @Override
    public void $destroy() {
        this.ExternalContentsPrefixDir.$destroy();
        this.ExternalFS.$destroy();
        this.Roots.$destroy();
        super.$destroy();
    }

    @Override
    public String toString() {
        return "Roots=" + this.Roots + ", ExternalFS=" + this.ExternalFS + ", ExternalContentsPrefixDir=" + this.ExternalContentsPrefixDir + ", CaseSensitive=" + this.CaseSensitive + ", IsRelativeOverlay=" + this.IsRelativeOverlay + ", UseExternalNames=" + this.UseExternalNames + ", UseCanonicalizedPaths=" + this.UseCanonicalizedPaths + super.toString();
    }
}

