/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.target.impl;

import org.clang.basic.LangOptions;
import org.clang.basic.MacroBuilder;
import org.clang.basic.target.TargetOptions;
import org.clang.basic.target.impl.OSTargetInfo;
import org.clang.basic.target.impl.TargetInfo;
import org.clang.basic.target.impl.TargetsStatics;
import org.clank.java.std;
import org.clank.support.NativePointer;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.uint;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.mc.MCSectionMachO;

public class DarwinTargetInfo<Target extends TargetInfo>
extends OSTargetInfo<Target> {
    @Override
    protected void getOSDefines(LangOptions Opts, Triple Triple2, MacroBuilder Builder2) {
        TargetsStatics.getDarwinDefines(Builder2, Opts, Triple2, this.tgt.PlatformName, this.tgt.PlatformMinVersion);
    }

    public DarwinTargetInfo(Target T, Triple _Triple, TargetOptions Opts) {
        super(T, _Triple, Opts);
        this.tgt.TLSSupported = false;
        if (_Triple.isMacOSX()) {
            this.tgt.TLSSupported = !_Triple.isMacOSXVersionLT(10, 7);
        } else if (_Triple.isiOS()) {
            if (_Triple.getArch() == Triple.ArchType.x86_64 || _Triple.getArch() == Triple.ArchType.aarch64) {
                this.tgt.TLSSupported = !_Triple.isOSVersionLT(8);
            } else if (_Triple.getArch() == Triple.ArchType.x86 || _Triple.getArch() == Triple.ArchType.arm || _Triple.getArch() == Triple.ArchType.thumb) {
                this.tgt.TLSSupported = !_Triple.isOSVersionLT(9);
            }
        } else if (_Triple.isWatchOS()) {
            this.tgt.TLSSupported = !_Triple.isOSVersionLT(2);
        }
        this.tgt.MCountName = NativePointer.$((String)"\u0001mcount");
    }

    @Override
    public std.string isValidSectionSpecifier(StringRef SR) {
        StringRef Segment = new StringRef();
        StringRef Section = new StringRef();
        uint.ref TAA = NativePointer.create_uint$ref();
        uint.ref StubSize = NativePointer.create_uint$ref();
        bool.ref HasTAA = NativePointer.create_bool$ref();
        return MCSectionMachO.ParseSectionSpecifier((StringRef)new StringRef(SR), (StringRef)Segment, (StringRef)Section, (uint.ref)TAA, (bool.ref)HasTAA, (uint.ref)StubSize);
    }

    @Override
    public char.ptr getStaticInitSectionSpecifier() {
        return NativePointer.$((String)"__TEXT,__StaticInit,regular,pure_instructions");
    }

    @Override
    public boolean hasProtectedVisibility() {
        return false;
    }

    @Override
    public int getExnObjectAlignment() {
        return 64;
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }
}

