/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.target.impl;

import org.clang.basic.LangOptions;
import org.clang.basic.MacroBuilder;
import org.clang.basic.target.TargetInfo;
import org.clang.basic.target.TargetOptions;
import org.clang.basic.target.impl.SparcTargetInfo;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.Unsigned;
import org.llvm.adt.APFloat;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;

public class SparcV9TargetInfo
extends SparcTargetInfo
implements Destructors.ClassWithDestructor {
    public SparcV9TargetInfo(Triple _Triple, TargetOptions Opts) {
        super(_Triple, Opts);
        this.resetDataLayout(new StringRef("E-m:e-i64:64-n32:64-S128"));
        this.PointerAlign = (byte)64;
        this.PointerWidth = (byte)64;
        this.LongAlign = (byte)64;
        this.LongWidth = (byte)64;
        this.IntMaxType = this.getTriple().getOS() == Triple.OSType.OpenBSD ? TargetInfo.IntType.SignedLongLong : TargetInfo.IntType.SignedLong;
        this.Int64Type = this.IntMaxType;
        this.LongDoubleWidth = Unsigned.$int2uchar((int)128);
        this.LongDoubleAlign = Unsigned.$int2uchar((int)128);
        this.LongDoubleFormat = APFloat.IEEEquad;
        this.MaxAtomicInlineWidth = (byte)64;
        this.MaxAtomicPromoteWidth = (byte)64;
    }

    @Override
    public void getTargetDefines(LangOptions Opts, MacroBuilder Builder2) {
        super.getTargetDefines(Opts, Builder2);
        Builder2.defineMacro(new Twine("__sparcv9"));
        Builder2.defineMacro(new Twine("__arch64__"));
        if (this.getTriple().getOS() != Triple.OSType.Solaris) {
            Builder2.defineMacro(new Twine("__sparc64__"));
            Builder2.defineMacro(new Twine("__sparc_v9__"));
            Builder2.defineMacro(new Twine("__sparcv9__"));
        }
    }

    @Override
    public boolean setCPU(std.string Name) {
        if (!super.setCPU(Name)) {
            return false;
        }
        return this.getCPUGeneration(this.CPU) == SparcTargetInfo.CPUGeneration.CG_V9;
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }
}

