/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.lexer;

import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppStringTokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

public class CppStringLexer
implements Lexer<CppStringTokenId> {
    private static final int INIT = 0;
    private static final int OTHER = 1;
    private static final int PREFIX = 2;
    private static final int START_DELIMETER = 3;
    private static final int AFTER_START_DELIMETER = 4;
    private static final int END_DELIMETER = 5;
    private static final int AFTER_END_DELIMETER = 6;
    private static final int EOF = -1;
    private LexerInput input;
    private TokenFactory<CppStringTokenId> tokenFactory;
    private boolean escapedLF = false;
    private final boolean dblQuoted;
    private final boolean rawString;
    private int state = 0;
    private String rawDelimeter = null;

    public CppStringLexer(LexerRestartInfo<CppStringTokenId> info, boolean doubleQuotedString, boolean raw) {
        this.input = info.input();
        this.tokenFactory = info.tokenFactory();
        this.dblQuoted = doubleQuotedString;
        this.rawString = raw;
        this.fromState(info.state());
    }

    public Object state() {
        if (this.rawString) {
            if (this.state == 0) {
                return null;
            }
            if (this.state == 2 || this.state == 3) {
                return this.state;
            }
            if (this.rawDelimeter != null && this.state == 1) {
                return this.rawDelimeter;
            }
            return new RawStringLexerState(this.state, this.rawDelimeter);
        }
        return this.state;
    }

    private void fromState(Object state) {
        if (state == null) {
            this.state = 0;
            return;
        }
        if (this.rawString) {
            if (state instanceof Integer) {
                this.state = (Integer)state;
                this.rawDelimeter = null;
            } else if (state instanceof String) {
                this.state = 1;
                this.rawDelimeter = (String)state;
            } else {
                RawStringLexerState lexerState = (RawStringLexerState)state;
                this.state = lexerState.state;
                this.rawDelimeter = lexerState.delimeter;
            }
        } else {
            this.state = (Integer)state;
        }
    }

    public Token<CppStringTokenId> nextToken() {
        int startState = this.state;
        this.state = 1;
        while (true) {
            int ch;
            if (startState == 3) {
                ch = this.input.read();
                StringBuilder delim = new StringBuilder();
                while (CppStringLexer.isRawStringDelimeterCharacter(ch)) {
                    delim.append((char)ch);
                    ch = this.input.read();
                }
                if (ch == 40) {
                    this.rawDelimeter = delim.toString();
                    if (this.rawDelimeter.length() > 0) {
                        this.input.backup(1);
                        this.state = 4;
                        return this.token(CppStringTokenId.START_DELIMETER);
                    }
                    return this.token(CppStringTokenId.START_DELIMETER_PAREN);
                }
                if (delim.length() > 0) {
                    this.input.backup(delim.length());
                    ch = this.read();
                }
            } else {
                if (startState == 5) {
                    int read = this.input.read();
                    for (int i = 0; i < this.rawDelimeter.length(); ++i) {
                        assert (read == this.rawDelimeter.charAt(i));
                        read = this.input.read();
                    }
                    assert (read == 34);
                    if (this.rawDelimeter.length() > 0) {
                        this.input.backup(1);
                        this.state = 6;
                        return this.token(CppStringTokenId.END_DELIMETER);
                    }
                    return this.token(CppStringTokenId.LAST_QUOTE);
                }
                ch = this.read();
            }
            switch (ch) {
                case 40: {
                    if (!this.rawString || startState != 4) break;
                    return this.token(CppStringTokenId.START_DELIMETER_PAREN);
                }
                case 41: {
                    if (!this.rawString || startState != 1 || this.rawDelimeter == null) break;
                    if (this.input.readLength() > 1) {
                        this.input.backup(1);
                        return this.token(CppStringTokenId.TEXT);
                    }
                    int backup = 1;
                    int read = this.input.read();
                    boolean ok = true;
                    for (int i = 0; i < this.rawDelimeter.length(); ++i) {
                        if (read == this.rawDelimeter.charAt(i)) {
                            read = this.input.read();
                            ++backup;
                            continue;
                        }
                        ok = false;
                        break;
                    }
                    if (read == 34) {
                        if (ok) {
                            this.input.backup(backup);
                            this.state = 5;
                            return this.token(CppStringTokenId.END_DELIMETER_PAREN);
                        }
                        return this.token(CppStringTokenId.TEXT);
                    }
                    if (read == -1) {
                        return this.token(CppStringTokenId.TEXT, null, PartType.START);
                    }
                    if (read != 41) break;
                    this.input.backup(1);
                    return this.token(CppStringTokenId.TEXT);
                }
                case 76: {
                    if (startState != 0) break;
                    this.state = 2;
                    int next = this.read();
                    if (next == 82) {
                        assert (this.rawString);
                        return this.token(CppStringTokenId.PREFIX_LR);
                    }
                    this.input.backup(1);
                    return this.token(CppStringTokenId.PREFIX_L);
                }
                case 85: {
                    if (startState != 0) break;
                    this.state = 2;
                    int next = this.read();
                    if (next == 82) {
                        assert (this.rawString);
                        return this.token(CppStringTokenId.PREFIX_UR);
                    }
                    this.input.backup(1);
                    return this.token(CppStringTokenId.PREFIX_U);
                }
                case 117: {
                    if (startState != 0) break;
                    this.state = 2;
                    int next = this.read();
                    if (next == 56) {
                        next = this.read();
                        if (next == 82) {
                            assert (this.rawString);
                            return this.token(CppStringTokenId.PREFIX_u8R);
                        }
                        this.input.backup(1);
                        return this.token(CppStringTokenId.PREFIX_u8);
                    }
                    if (next == 82) {
                        assert (this.rawString);
                        return this.token(CppStringTokenId.PREFIX_uR);
                    }
                    this.input.backup(1);
                    return this.token(CppStringTokenId.PREFIX_u);
                }
                case 82: {
                    if (startState != 0) break;
                    this.state = 2;
                    assert (this.rawString);
                    return this.token(CppStringTokenId.PREFIX_R);
                }
                case -1: {
                    if (this.input.readLength() > 0) {
                        return this.token(CppStringTokenId.TEXT);
                    }
                    return null;
                }
                case 39: {
                    if (this.input.readLength() > 1) {
                        this.input.backup(1);
                        return this.token(CppStringTokenId.TEXT);
                    }
                    return this.token(CppStringTokenId.SINGLE_QUOTE);
                }
                case 34: {
                    if (this.input.readLength() > 1) {
                        this.input.backup(1);
                        return this.token(CppStringTokenId.TEXT);
                    }
                    if (this.dblQuoted) {
                        if (startState == 2 || startState == 0) {
                            if (this.rawString) {
                                this.state = 3;
                            }
                            return this.token(CppStringTokenId.FIRST_QUOTE);
                        }
                        if (!this.rawString || startState == 6) {
                            return this.token(CppStringTokenId.LAST_QUOTE);
                        }
                        return this.token(CppStringTokenId.DOUBLE_QUOTE);
                    }
                    return this.token(CppStringTokenId.DOUBLE_QUOTE);
                }
                case 92: {
                    if (this.rawString) break;
                    if (this.input.readLength() > 1) {
                        this.input.backup(1);
                        return this.token(CppStringTokenId.TEXT);
                    }
                    ch = this.read();
                    switch (ch) {
                        case 97: {
                            return this.token(CppStringTokenId.BELL);
                        }
                        case 98: {
                            return this.token(CppStringTokenId.BACKSPACE);
                        }
                        case 101: {
                            return this.token(CppStringTokenId.ANSI_COLOR);
                        }
                        case 102: {
                            return this.token(CppStringTokenId.FORM_FEED);
                        }
                        case 110: {
                            return this.token(CppStringTokenId.NEWLINE);
                        }
                        case 114: {
                            return this.token(CppStringTokenId.CR);
                        }
                        case 116: {
                            return this.token(CppStringTokenId.TAB);
                        }
                        case 39: {
                            return this.token(CppStringTokenId.SINGLE_QUOTE_ESCAPE);
                        }
                        case 34: {
                            return this.token(CppStringTokenId.DOUBLE_QUOTE_ESCAPE);
                        }
                        case 92: {
                            return this.token(CppStringTokenId.BACKSLASH_ESCAPE);
                        }
                        case 117: {
                            while (117 == (ch = this.read())) {
                            }
                            int i = 0;
                            while (true) {
                                if (!((ch = Character.toLowerCase(ch)) >= 48 && ch <= 57 || ch >= 97 && ch <= 102)) {
                                    this.input.backup(1);
                                    return this.token(CppStringTokenId.UNICODE_ESCAPE_INVALID);
                                }
                                if (i == 3) {
                                    return this.token(CppStringTokenId.UNICODE_ESCAPE);
                                }
                                ch = this.read();
                                ++i;
                            }
                        }
                        case 120: {
                            int len = 0;
                            block42: while (true) {
                                switch (this.read()) {
                                    case 48: 
                                    case 49: 
                                    case 50: 
                                    case 51: 
                                    case 52: 
                                    case 53: 
                                    case 54: 
                                    case 55: 
                                    case 56: 
                                    case 57: 
                                    case 65: 
                                    case 66: 
                                    case 67: 
                                    case 68: 
                                    case 69: 
                                    case 70: 
                                    case 97: 
                                    case 98: 
                                    case 99: 
                                    case 100: 
                                    case 101: 
                                    case 102: {
                                        ++len;
                                        continue block42;
                                    }
                                }
                                break;
                            }
                            this.input.backup(1);
                            return this.token(len > 0 ? CppStringTokenId.HEX_ESCAPE : CppStringTokenId.HEX_ESCAPE_INVALID);
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: {
                            switch (this.read()) {
                                case 48: 
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: {
                                    switch (this.read()) {
                                        case 48: 
                                        case 49: 
                                        case 50: 
                                        case 51: 
                                        case 52: 
                                        case 53: 
                                        case 54: 
                                        case 55: {
                                            return this.token(CppStringTokenId.OCTAL_ESCAPE);
                                        }
                                    }
                                    this.input.backup(1);
                                    return this.token(CppStringTokenId.OCTAL_ESCAPE);
                                }
                            }
                            this.input.backup(1);
                            return this.token(CppStringTokenId.OCTAL_ESCAPE);
                        }
                    }
                    this.input.backup(1);
                    return this.token(CppStringTokenId.ESCAPE_SEQUENCE_INVALID);
                }
            }
        }
    }

    protected final Token<CppStringTokenId> token(CppStringTokenId id) {
        return this.token(id, id.fixedText(), PartType.COMPLETE);
    }

    private Token<CppStringTokenId> token(CppStringTokenId id, String fixedText, PartType part) {
        assert (id != null) : "id must be not null";
        Token token = fixedText != null && !this.escapedLF ? this.tokenFactory.getFlyweightToken((TokenId)id, fixedText) : (part != PartType.COMPLETE ? this.tokenFactory.createToken((TokenId)id, this.input.readLength(), part) : this.tokenFactory.createToken((TokenId)id));
        this.escapedLF = false;
        assert (token != null) : "token must be created as result for " + (Object)((Object)id);
        return token;
    }

    protected final int read() {
        boolean skipEscapedLF = true;
        int c = this.input.read();
        if (skipEscapedLF) {
            while (c == 92) {
                int next;
                switch (this.input.read()) {
                    case 13: {
                        this.input.consumeNewline();
                    }
                    case 10: {
                        this.escapedLF = true;
                        next = this.input.read();
                        break;
                    }
                    default: {
                        this.input.backup(1);
                        assert (c == 92) : "must be backslash " + (char)c;
                        return c;
                    }
                }
                c = next;
            }
        }
        return c;
    }

    public void release() {
    }

    protected static PartType finishRawString(LexerInput input) {
        RawStringLexingState state = RawStringLexingState.PREFIX_DELIMETER;
        StringBuilder delim = new StringBuilder("");
        String delimeter = "";
        while (true) {
            int read = input.read();
            switch (state) {
                case PREFIX_DELIMETER: {
                    if (CppStringLexer.isRawStringDelimeterCharacter(read)) {
                        delim.append((char)read);
                        break;
                    }
                    if (read == 40) {
                        delimeter = delim.toString();
                        state = RawStringLexingState.BODY;
                        break;
                    }
                    state = RawStringLexingState.ERROR;
                    break;
                }
                case BODY: {
                    if (read == -1) {
                        return PartType.START;
                    }
                    if (read != 41) break;
                    state = RawStringLexingState.POSTFIX_DELIMETER;
                    break;
                }
                case POSTFIX_DELIMETER: {
                    boolean ok = true;
                    for (int i = 0; i < delimeter.length(); ++i) {
                        if (delimeter.charAt(i) != (char)read) {
                            ok = false;
                            break;
                        }
                        read = input.read();
                    }
                    if (read == 34 && ok) {
                        return PartType.COMPLETE;
                    }
                    if (read == -1) {
                        return PartType.START;
                    }
                    if (read == 41) {
                        state = RawStringLexingState.POSTFIX_DELIMETER;
                        break;
                    }
                    state = RawStringLexingState.BODY;
                    break;
                }
                case ERROR: {
                    switch (read) {
                        case 34: {
                            return PartType.START;
                        }
                        case 10: 
                        case 13: {
                            input.backup(1);
                            return PartType.START;
                        }
                        case -1: {
                            return PartType.START;
                        }
                    }
                }
            }
        }
    }

    private static boolean isRawStringDelimeterCharacter(int c) {
        switch (c) {
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 91: 
            case 93: 
            case 94: 
            case 123: 
            case 124: 
            case 125: 
            case 126: {
                return true;
            }
        }
        return CndLexerUtilities.isCppIdentifierPart(c);
    }

    private static enum RawStringLexingState {
        PREFIX_DELIMETER,
        BODY,
        POSTFIX_DELIMETER,
        ERROR;

    }

    private static final class RawStringLexerState {
        private final int state;
        private final String delimeter;

        public RawStringLexerState(int state, String delimeter) {
            this.state = state;
            this.delimeter = delimeter;
        }

        public int hashCode() {
            int hash = 7;
            hash = 67 * hash + this.state;
            hash = 67 * hash + (this.delimeter != null ? this.delimeter.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RawStringLexerState other = (RawStringLexerState)obj;
            if (this.state != other.state) {
                return false;
            }
            return !(this.delimeter == null ? other.delimeter != null : !this.delimeter.equals(other.delimeter));
        }

        public String toString() {
            return "RAW_STR{state=" + this.state + ", delimeter=" + this.delimeter + '}';
        }
    }
}

