/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova.platforms.ios;

import com.dd.plist.BinaryPropertyListParser;
import com.dd.plist.NSObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONObject;
import org.netbeans.modules.cordova.platforms.api.WebKitDebuggingSupport;
import org.netbeans.modules.cordova.platforms.ios.IOSDebugTransport;

public class SimulatorDebugTransport
extends IOSDebugTransport {
    private static final String LOCALHOST_IPV6 = "::1";
    private static final int port = 27753;
    private static final Logger LOG = Logger.getLogger(SimulatorDebugTransport.class.getName());
    private Socket socket;

    @Override
    protected void sendCommand(JSONObject command) throws Exception {
        String cmd = this.createJSONCommand(command);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "\n\nSending:\n{0}\n{1}", new Object[]{command.toJSONString(), cmd});
        }
        this.sendBinaryMessage(this.plistXmlToBinary(cmd));
    }

    @Override
    protected void sendCommand(String xml) throws Exception {
        LOG.log(Level.FINEST, "\n\nSending:\n{0}", xml);
        this.sendBinaryMessage(this.plistXmlToBinary(xml));
    }

    private void sendBinaryMessage(byte[] bytes) throws IOException {
        if (this.socket == null || this.socket.isClosed()) {
            return;
        }
        OutputStream os = this.socket.getOutputStream();
        byte[] lenght = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(bytes.length).array();
        os.write(lenght);
        os.write(bytes);
    }

    @Override
    protected NSObject readData() throws Exception {
        int read;
        int count;
        InputStream is = this.socket.getInputStream();
        byte[] sizeBuffer = new byte[4];
        for (count = is.read(sizeBuffer); count < 4; count += is.read(sizeBuffer, count, 4 - count)) {
        }
        int size = ByteBuffer.wrap(sizeBuffer, 0, 4).getInt();
        byte[] content = new byte[size];
        for (count = is.read(content); count < size; count += read) {
            read = is.read(content, count, size - count);
            if (read != -1) continue;
            boolean s = this.keepGoing;
            this.stop();
            if (s) {
                WebKitDebuggingSupport.getDefault().stopDebugging(false);
            }
            return null;
        }
        assert (count == size);
        NSObject object = BinaryPropertyListParser.parse((byte[])content);
        return object;
    }

    @Override
    protected void stop() {
        super.stop();
        try {
            this.socket.close();
        }
        catch (Exception e) {
            LOG.log(Level.FINE, e.getMessage(), e);
        }
    }

    public String getConnectionName() {
        return "iOS Simulator";
    }

    public String getVersion() {
        return "1.0";
    }

    @Override
    protected void init() throws Exception {
        if (this.socket != null && (this.socket.isConnected() || !this.socket.isClosed())) {
            this.socket.close();
        }
        long stop = System.nanoTime() + TimeUnit.MINUTES.toNanos(2L);
        while (stop > System.nanoTime()) {
            try {
                this.socket = new Socket(LOCALHOST_IPV6, 27753);
                break;
            }
            catch (ConnectException ex) {
                Thread.sleep(5000L);
            }
        }
    }
}

