/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class HttpMethodsPanel
extends JPanel {
    private JCheckBox delete;
    private JCheckBox get;
    private JCheckBox head;
    private JCheckBox options;
    private JCheckBox post;
    private JCheckBox put;
    private Map<HttpMethods, JCheckBox> methods;

    public HttpMethodsPanel(Collection<HttpMethods> selectedMethods) {
        this.initComponents();
        this.methods = new LinkedHashMap<HttpMethods, JCheckBox>();
        this.methods.put(HttpMethods.GET, this.get);
        this.methods.put(HttpMethods.HEAD, this.head);
        this.methods.put(HttpMethods.POST, this.post);
        this.methods.put(HttpMethods.PUT, this.put);
        this.methods.put(HttpMethods.DELETE, this.delete);
        this.methods.put(HttpMethods.OPTIONS, this.options);
        for (HttpMethods method : selectedMethods) {
            this.methods.get((Object)method).setSelected(true);
        }
    }

    List<HttpMethods> getSelectedMethods() {
        ArrayList<HttpMethods> result = new ArrayList<HttpMethods>(HttpMethods.values().length);
        for (Map.Entry<HttpMethods, JCheckBox> entry : this.methods.entrySet()) {
            HttpMethods method = entry.getKey();
            JCheckBox checkBox = entry.getValue();
            if (!checkBox.isSelected()) continue;
            result.add(method);
        }
        return result;
    }

    private void initComponents() {
        this.get = new JCheckBox();
        this.head = new JCheckBox();
        this.post = new JCheckBox();
        this.put = new JCheckBox();
        this.delete = new JCheckBox();
        this.options = new JCheckBox();
        this.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(HttpMethodsPanel.class, (String)"TTL_HttpMethods")));
        Mnemonics.setLocalizedText((AbstractButton)this.get, (String)NbBundle.getMessage(HttpMethodsPanel.class, (String)"LBL_GetMethod"));
        Mnemonics.setLocalizedText((AbstractButton)this.head, (String)NbBundle.getMessage(HttpMethodsPanel.class, (String)"LBL_Head"));
        Mnemonics.setLocalizedText((AbstractButton)this.post, (String)NbBundle.getMessage(HttpMethodsPanel.class, (String)"LBL_Post"));
        Mnemonics.setLocalizedText((AbstractButton)this.put, (String)NbBundle.getMessage(HttpMethodsPanel.class, (String)"LBL_Put"));
        Mnemonics.setLocalizedText((AbstractButton)this.delete, (String)NbBundle.getMessage(HttpMethodsPanel.class, (String)"LBL_Delete"));
        Mnemonics.setLocalizedText((AbstractButton)this.options, (String)NbBundle.getMessage(HttpMethodsPanel.class, (String)"LBL_Options"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.get).addComponent(this.head).addComponent(this.post).addComponent(this.put).addComponent(this.delete).addComponent(this.options)).addContainerGap(55, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.get).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.head).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.post).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.put).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.delete).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.options)));
    }

    static enum HttpMethods {
        GET,
        HEAD,
        POST,
        PUT,
        DELETE,
        OPTIONS;

    }
}

