/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.config;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.deployment.plugins.spi.MessageDestinationDeployment;
import org.netbeans.modules.j2ee.weblogic9.ProgressObjectSupport;
import org.netbeans.modules.j2ee.weblogic9.WLPluginProperties;
import org.netbeans.modules.j2ee.weblogic9.config.WLDatasourceManager;
import org.netbeans.modules.j2ee.weblogic9.config.WLMessageDestination;
import org.netbeans.modules.j2ee.weblogic9.config.WLMessageDestinationSupport;
import org.netbeans.modules.j2ee.weblogic9.deploy.CommandBasedDeployer;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class WLMessageDestinationDeployment
implements MessageDestinationDeployment {
    private static final Logger LOGGER = Logger.getLogger(WLMessageDestinationDeployment.class.getName());
    private final WLDeploymentManager manager;

    public WLMessageDestinationDeployment(WLDeploymentManager manager) {
        this.manager = manager;
    }

    public void deployMessageDestinations(Set<MessageDestination> destinations) throws ConfigurationException {
        CommandBasedDeployer deployer;
        ProgressObject po;
        Set<MessageDestination> deployedDestinations = this.getMessageDestinations();
        Map<String, MessageDestination> deployed = this.createMap(deployedDestinations);
        HashMap<String, WLMessageDestination> toDeploy = new HashMap<String, WLMessageDestination>();
        LinkedList<MessageDestination> conflictJMS = new LinkedList<MessageDestination>();
        for (MessageDestination destination : destinations) {
            if (!(destination instanceof WLMessageDestination)) {
                LOGGER.log(Level.INFO, "Unable to deploy {0}", destination);
                continue;
            }
            WLMessageDestination wLMessageDestination = (WLMessageDestination)destination;
            String name = wLMessageDestination.getName();
            if (deployed.keySet().contains(name)) {
                MessageDestination deployedMessageDestination = deployed.get(name);
                if (deployed.get(name).equals(wLMessageDestination)) continue;
                if (!((WLMessageDestination)deployedMessageDestination).isSystem() && !wLMessageDestination.isSystem()) {
                    toDeploy.put(name, wLMessageDestination);
                    continue;
                }
                conflictJMS.add(deployed.get(name));
                continue;
            }
            if (name != null) {
                toDeploy.put(name, wLMessageDestination);
                continue;
            }
            LOGGER.log(Level.INFO, "JNDI name was null for {0}", destination);
        }
        if (!conflictJMS.isEmpty()) {
            // empty if block
        }
        if (!ProgressObjectSupport.waitFor(po = (deployer = new CommandBasedDeployer(this.manager)).deployMessageDestinations(toDeploy.values(), this.manager.getDeployTargets())) || po.getDeploymentStatus().isFailed()) {
            String msg = NbBundle.getMessage(WLDatasourceManager.class, (String)"MSG_FailedToDeployJMS", (Object)po.getDeploymentStatus().getMessage());
            throw new ConfigurationException(msg);
        }
    }

    public Set<MessageDestination> getMessageDestinations() throws ConfigurationException {
        if (this.manager.isRemote()) {
            return Collections.emptySet();
        }
        String domainDir = this.manager.getInstanceProperties().getProperty("domainRoot");
        File domainPath = FileUtil.normalizeFile((File)new File(domainDir));
        FileObject domainConfig = WLPluginProperties.getDomainConfigFileObject(this.manager);
        return new HashSet<MessageDestination>(WLMessageDestinationSupport.getMessageDestinations(domainPath, domainConfig, true));
    }

    private Map<String, MessageDestination> createMap(Set<MessageDestination> destinations) {
        if (destinations.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, MessageDestination> map = new HashMap<String, MessageDestination>();
        for (MessageDestination destination : destinations) {
            map.put(destination.getName(), destination);
        }
        return map;
    }
}

