/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;

final class ScanLocalVars
extends TreePathScanner<Void, Void> {
    private static final Set<ElementKind> LOCAL_VARIABLES = EnumSet.of(ElementKind.EXCEPTION_PARAMETER, ElementKind.LOCAL_VARIABLE, ElementKind.PARAMETER, ElementKind.RESOURCE_VARIABLE);
    private static final Set<ElementKind> FIELDS = EnumSet.of(ElementKind.FIELD);
    private final CompilationInfo info;
    private boolean hasReturns = false;
    private final Set<VariableElement> declaredVariables = new HashSet<VariableElement>();
    private final Set<VariableElement> referencedVariables = new LinkedHashSet<VariableElement>();
    private final StatementTree lastStatement;
    private final Set<TypeMirror> returnTypes = new HashSet<TypeMirror>();
    private int nesting;

    public ScanLocalVars(CompilationInfo info, StatementTree lastStatement) {
        this.info = info;
        this.lastStatement = lastStatement;
    }

    @Override
    public Void visitLambdaExpression(LambdaExpressionTree node, Void p) {
        ++this.nesting;
        super.visitLambdaExpression(node, p);
        --this.nesting;
        return null;
    }

    @Override
    public Void visitNewClass(NewClassTree node, Void p) {
        ++this.nesting;
        super.visitNewClass(node, p);
        --this.nesting;
        return null;
    }

    @Override
    public Void visitClass(ClassTree node, Void p) {
        ++this.nesting;
        super.visitClass(node, p);
        --this.nesting;
        return null;
    }

    @Override
    public Void visitVariable(VariableTree node, Void p) {
        Element e = this.info.getTrees().getElement(this.getCurrentPath());
        if (e != null && (LOCAL_VARIABLES.contains((Object)e.getKind()) || FIELDS.contains((Object)e.getKind()))) {
            this.declaredVariables.add((VariableElement)e);
        }
        return (Void)super.visitVariable(node, p);
    }

    @Override
    public Void visitIdentifier(IdentifierTree node, Void p) {
        Element e = this.info.getTrees().getElement(this.getCurrentPath());
        if (e != null && (LOCAL_VARIABLES.contains((Object)e.getKind()) || FIELDS.contains((Object)e.getKind()) && e.getModifiers().contains((Object)Modifier.PRIVATE)) && !this.declaredVariables.contains((VariableElement)e)) {
            this.referencedVariables.add((VariableElement)e);
        }
        return (Void)super.visitIdentifier(node, p);
    }

    private boolean isMethodCode() {
        return this.nesting == 0;
    }

    @Override
    public Void visitReturn(ReturnTree node, Void p) {
        if (this.isMethodCode()) {
            this.hasReturns = true;
            Element retExpElem = this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), node.getExpression()));
            if (retExpElem != null) {
                this.returnTypes.add(this.getElementType(retExpElem));
            } else {
                TypeElement object = this.info.getElements().getTypeElement("java.lang.Object");
                if (object != null) {
                    this.returnTypes.add(object.asType());
                }
            }
        }
        return (Void)super.visitReturn(node, p);
    }

    @Override
    public Void visitExpressionStatement(ExpressionStatementTree node, Void p) {
        if (node == this.lastStatement && !this.hasReturns) {
            ExpressionTree expression = node.getExpression();
            Element retExpElem = this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), expression));
            if (retExpElem == null) {
                TreePath elementPath = null;
                if (Tree.Kind.ASSIGNMENT.equals((Object)expression.getKind())) {
                    elementPath = new TreePath(this.getCurrentPath(), ((AssignmentTree)expression).getVariable());
                } else if (Tree.Kind.VARIABLE.equals((Object)expression.getKind())) {
                    elementPath = new TreePath(this.getCurrentPath(), (VariableTree)((Object)expression));
                }
                if (elementPath != null) {
                    retExpElem = this.info.getTrees().getElement(elementPath);
                }
            }
            if (retExpElem != null && !TypeKind.ERROR.equals((Object)retExpElem.asType().getKind())) {
                this.returnTypes.add(this.getElementType(retExpElem));
            }
        }
        return (Void)super.visitExpressionStatement(node, p);
    }

    private TypeMirror getElementType(Element element) {
        switch (element.getKind()) {
            case METHOD: 
            case CONSTRUCTOR: {
                return ((ExecutableElement)element).getReturnType();
            }
        }
        return element.asType();
    }

    Set<VariableElement> getReferencedVariables() {
        return this.referencedVariables;
    }

    String getReturnType() {
        if (this.returnTypes.isEmpty()) {
            return null;
        }
        return this.returnTypes.iterator().next().toString();
    }

    TypeMirror getReturnTypeMirror() {
        if (this.returnTypes.isEmpty()) {
            return null;
        }
        return this.returnTypes.iterator().next();
    }

    boolean hasReturns() {
        return this.hasReturns;
    }
}

