/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.hints;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.util.DocTrees;
import com.sun.source.util.TreePath;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.javadoc.hints.JavadocGenerator;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.util.NbBundle;

final class GenerateJavadocFix
extends JavaFix {
    private final String name;
    private final SourceVersion spec;

    public GenerateJavadocFix(String name, TreePathHandle handle, SourceVersion spec) {
        super(handle);
        this.name = name;
        this.spec = spec;
    }

    public String getText() {
        return NbBundle.getMessage(GenerateJavadocFix.class, (String)"MISSING_JAVADOC_HINT", (Object)this.name);
    }

    protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
        WorkingCopy javac = ctx.getWorkingCopy();
        TreeMaker make = javac.getTreeMaker();
        TreePath path = ctx.getPath();
        Element elm = javac.getTrees().getElement(path);
        if (elm != null) {
            JavadocGenerator gen = new JavadocGenerator(this.spec);
            DocCommentTree newDocCommentTree = gen.generateComment(elm, (CompilationInfo)javac, make);
            DocCommentTree docCommentTree = ((DocTrees)javac.getTrees()).getDocCommentTree(path);
            javac.rewrite(path.getLeaf(), (DocTree)docCommentTree, (DocTree)newDocCommentTree);
        }
    }
}

