/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.option;

import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.java.stdimpl.aliases.StdMap;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.clank.support.void;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSet;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.StringMapConstIteratorChar;
import org.llvm.adt.aliases.StringMapIteratorChar;
import org.llvm.option.Arg;
import org.llvm.option.ArgList;
import org.llvm.option.InputArgList;
import org.llvm.option.OptSpecifier;
import org.llvm.option.Option;
import org.llvm.option.impl.OptStatics;
import org.llvm.option.impl.OptTableStatics;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.raw_ostream;

public class OptTable
implements Destructors.ClassWithDestructor {
    private ArrayRef<Info> OptionInfos;
    private boolean IgnoreCase;
    private int TheInputOptionID;
    private int TheUnknownOptionID;
    private int FirstSearchableIndex;
    private StringSet PrefixesUnion;
    private std.string PrefixChars;

    private Info getInfo(OptSpecifier Opt) {
        int id = Opt.getID();
        assert (Unsigned.$greater_uint((int)id, (int)0) && Unsigned.$less_uint((int)(id - 1), (int)this.getNumOptions())) : "Invalid Option ID.";
        return (Info)this.OptionInfos.$at(id - 1);
    }

    protected OptTable(ArrayRef<Info> OptionInfos) {
        this(OptionInfos, false);
    }

    protected OptTable(ArrayRef<Info> OptionInfos, boolean IgnoreCase) {
        int Kind;
        int i;
        this.OptionInfos = new ArrayRef(OptionInfos);
        this.IgnoreCase = IgnoreCase;
        this.TheInputOptionID = 0;
        this.TheUnknownOptionID = 0;
        this.FirstSearchableIndex = 0;
        this.PrefixesUnion = new StringSet();
        this.PrefixChars = new std.string();
        int e = this.getNumOptions();
        for (i = 0; i != e; ++i) {
            Kind = Unsigned.$uchar2uint((byte)this.getInfo((OptSpecifier)new OptSpecifier((int)(i + 1))).Kind);
            if (Kind == 1) {
                assert (this.TheInputOptionID == 0) : "Cannot have multiple input options!";
                this.TheInputOptionID = this.getInfo((OptSpecifier)new OptSpecifier((int)(i + 1))).ID;
                continue;
            }
            if (Kind == 2) {
                assert (this.TheUnknownOptionID == 0) : "Cannot have multiple unknown options!";
                this.TheUnknownOptionID = this.getInfo((OptSpecifier)new OptSpecifier((int)(i + 1))).ID;
                continue;
            }
            if (Kind == 0) continue;
            this.FirstSearchableIndex = i;
            break;
        }
        assert (this.FirstSearchableIndex != 0) : "No searchable options?";
        e = this.getNumOptions();
        for (i = this.FirstSearchableIndex; i != e; ++i) {
            Kind = this.getInfo((OptSpecifier)new OptSpecifier((int)(i + 1))).Kind;
            assert (Kind != 1 && Kind != 2 && Kind != 0) : "Special options should be defined first!";
        }
        e = this.getNumOptions();
        for (i = this.FirstSearchableIndex + 1; i != e; ++i) {
            if (OptStatics.$less_Info(this.getInfo(new OptSpecifier(i)), this.getInfo(new OptSpecifier(i + 1)))) continue;
            this.getOption(new OptSpecifier(i)).dump();
            this.getOption(new OptSpecifier(i + 1)).dump();
            throw new llvm_unreachable("Options are not in order!");
        }
        e = this.getNumOptions() + 1;
        for (i = this.FirstSearchableIndex + 1; i != e; ++i) {
            type.ptr P = (type.ptr)Native.$tryClone(this.getInfo((OptSpecifier)new OptSpecifier((int)i)).Prefixes);
            if (P == null) continue;
            while (Native.$noteq_ptr((void.ptr)((void.ptr)P.$star()), null)) {
                this.PrefixesUnion.insert(new StringRef((char.ptr)P.$star()));
                P.$preInc();
            }
        }
        StringMapIteratorChar I = new StringMapIteratorChar(JavaDifferentiators.JD.Move.INSTANCE, this.PrefixesUnion.begin());
        StringMapIteratorChar E = new StringMapIteratorChar(JavaDifferentiators.JD.Move.INSTANCE, this.PrefixesUnion.end());
        while (I.$noteq((StringMapConstIteratorChar)E)) {
            StringRef Prefix = I.$arrow().getKey();
            char.ptr C = Native.$tryClone((char.ptr)Prefix.begin());
            char.ptr CE = Native.$tryClone((char.ptr)Prefix.end());
            while (Native.$noteq_ptr((void.ptr)C, (void.ptr)CE)) {
                if (std.$eq___normal_iterator$C((abstract_iterator)std.find((char.ptr)this.PrefixChars.begin(), (char.ptr)this.PrefixChars.end(), (byte)C.$star()), (abstract_iterator)this.PrefixChars.end())) {
                    this.PrefixChars.push_back(C.$star());
                }
                C.$preInc();
            }
            I.$preInc();
        }
    }

    public void $destroy() {
        this.PrefixChars.$destroy();
        this.PrefixesUnion.$destroy();
    }

    public int getNumOptions() {
        return this.OptionInfos.size();
    }

    public Option getOption(OptSpecifier Opt) {
        int id = Opt.getID();
        if (id == 0) {
            return new Option((Info)null, (OptTable)null);
        }
        assert (Unsigned.$less_uint((int)(id - 1), (int)this.getNumOptions())) : "Invalid ID.";
        return new Option(this.getInfo(new OptSpecifier(id)), this);
    }

    public char.ptr getOptionName(OptSpecifier id) {
        return this.getInfo((OptSpecifier)id).Name;
    }

    public int getOptionKind(OptSpecifier id) {
        return this.getInfo((OptSpecifier)id).Kind;
    }

    public int getOptionGroupID(OptSpecifier id) {
        return this.getInfo((OptSpecifier)id).GroupID;
    }

    public char.ptr getOptionHelpText(OptSpecifier id) {
        return this.getInfo((OptSpecifier)id).HelpText;
    }

    public char.ptr getOptionMetaVar(OptSpecifier id) {
        return this.getInfo((OptSpecifier)id).MetaVar;
    }

    public Arg ParseOneArg(ArgList Args, uint.ref Index) {
        return this.ParseOneArg(Args, Index, 0, 0);
    }

    public Arg ParseOneArg(ArgList Args, uint.ref Index, int FlagsToInclude) {
        return this.ParseOneArg(Args, Index, FlagsToInclude, 0);
    }

    public Arg ParseOneArg(ArgList Args, uint.ref Index, int FlagsToInclude, int FlagsToExclude) {
        int Prev = Index.$deref();
        char.ptr Str = Native.$tryClone((char.ptr)Args.getArgString(Index.$deref()));
        if (OptTableStatics.isInput(this.PrefixesUnion, new StringRef(Str))) {
            return new Arg(this.getOption(new OptSpecifier(this.TheInputOptionID)), new StringRef(Str), Index.$set$postInc(), Str);
        }
        type.ptr Start = (type.ptr)Native.$tryClone((NativeCloneable)this.OptionInfos.begin().$add(this.FirstSearchableIndex));
        type.ptr End = (type.ptr)Native.$tryClone((NativeCloneable)this.OptionInfos.end());
        StringRef Name = new StringRef(Str).ltrim(new StringRef(this.PrefixChars));
        Start = (type.ptr)Native.$tryClone((NativeCloneable)std.lower_bound((type.iterator)Start, (type.iterator)End, (Object)Name.data()));
        while (Native.$noteq_ptr((void.ptr)Start, (void.ptr)End)) {
            int ArgSize = 0;
            while (Native.$noteq_ptr((void.ptr)Start, (void.ptr)End) && (ArgSize = OptTableStatics.matchOption((type.ptr<Info>)Start, new StringRef(Str), this.IgnoreCase)) == 0) {
                Start.$preInc();
            }
            if (Native.$eq_ptr((void.ptr)Start, (void.ptr)End)) break;
            Option Opt = new Option((Info)Start.$star(), this);
            if ((FlagsToInclude == 0 || Opt.hasFlag(FlagsToInclude)) && !Opt.hasFlag(FlagsToExclude)) {
                Arg A = Opt.accept(Args, Index, ArgSize);
                if (A != null) {
                    return A;
                }
                if (Prev != Index.$deref()) {
                    return null;
                }
            }
            Start.$preInc();
        }
        if (Str.$at(0) == 47) {
            return new Arg(this.getOption(new OptSpecifier(this.TheInputOptionID)), new StringRef(Str), Index.$set$postInc(), Str);
        }
        return new Arg(this.getOption(new OptSpecifier(this.TheUnknownOptionID)), new StringRef(Str), Index.$set$postInc(), Str);
    }

    public InputArgList ParseArgs(ArrayRef<char.ptr> ArgArr, uint.ref MissingArgIndex, uint.ref MissingArgCount) {
        return this.ParseArgs(ArgArr, MissingArgIndex, MissingArgCount, 0, 0);
    }

    public InputArgList ParseArgs(ArrayRef<char.ptr> ArgArr, uint.ref MissingArgIndex, uint.ref MissingArgCount, int FlagsToInclude) {
        return this.ParseArgs(ArgArr, MissingArgIndex, MissingArgCount, FlagsToInclude, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputArgList ParseArgs(ArrayRef<char.ptr> ArgArr, uint.ref MissingArgIndex, uint.ref MissingArgCount, int FlagsToInclude, int FlagsToExclude) {
        InputArgList Args = null;
        try {
            Args = new InputArgList((type.ptr<char.ptr>)ArgArr.begin(), (type.ptr<char.ptr>)ArgArr.end());
            MissingArgIndex.$set(MissingArgCount.$set(0));
            uint.ref Index = NativePointer.create_uint$ref((int)0);
            int End = ArgArr.size();
            while (Unsigned.$less_uint((uint.ref)Index, (int)End)) {
                if (Native.$eq_ptr((void.ptr)Args.getArgString(Index.$deref()), null)) {
                    Index.$set$preInc();
                    continue;
                }
                StringRef Str = new StringRef(Args.getArgString(Index.$deref()));
                if (llvm.$eq_StringRef((StringRef)Str, (String)"")) {
                    Index.$set$preInc();
                    continue;
                }
                int Prev = Index.$deref();
                Arg A = this.ParseOneArg(Args, Index, FlagsToInclude, FlagsToExclude);
                assert (Unsigned.$greater_uint((uint.ref)Index, (int)Prev)) : "Parser failed to consume argument.";
                if (A == null) {
                    assert (Unsigned.$greatereq_uint((uint.ref)Index, (int)End)) : "Unexpected parser error.";
                    assert (Index.$deref() - Prev - 1 != 0) : "No missing arguments!";
                    MissingArgIndex.$set(Prev);
                    MissingArgCount.$set(Index.$deref() - Prev - 1);
                    break;
                }
                Args.append(A);
            }
            InputArgList inputArgList = new InputArgList(JavaDifferentiators.JD.Move.INSTANCE, Args);
            return inputArgList;
        }
        finally {
            if (Args != null) {
                Args.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void PrintHelp(raw_ostream OS, char.ptr Name, char.ptr Title, int FlagsToInclude, int FlagsToExclude) {
        std.map GroupedOptionHelp = null;
        try {
            OS.$out("OVERVIEW: ").$out(Title).$out(NativePointer.$LF);
            OS.$out_char((byte)10);
            OS.$out("USAGE: ").$out(Name).$out(" [options] <inputs>\n");
            OS.$out_char((byte)10);
            GroupedOptionHelp = new std.map((Object)new std.vector((Object)std.make_pair((Object)new std.string(), null)));
            int e = this.getNumOptions();
            for (int i = 0; i != e; ++i) {
                char.ptr Text;
                int Id = i + 1;
                if (this.getOptionKind(new OptSpecifier(Id)) == 0) continue;
                char Flags = this.getInfo((OptSpecifier)new OptSpecifier((int)Id)).Flags;
                if (FlagsToInclude != 0 && (Flags & FlagsToInclude) == 0 || (Flags & FlagsToExclude) != 0 || (Text = Native.$tryClone((char.ptr)this.getOptionHelpText(new OptSpecifier(Id)))) == null) continue;
                std.string OptName = null;
                try {
                    char.ptr HelpGroup = Native.$tryClone((char.ptr)OptTableStatics.getOptionHelpGroup(this, new OptSpecifier(Id)));
                    OptName = OptTableStatics.getOptionHelpName(this, new OptSpecifier(Id));
                    ((std.vector)GroupedOptionHelp.$at((Object)new std.string(HelpGroup))).push_back((Object)std.make_pair((Object)OptName, (Object)Text));
                    continue;
                }
                finally {
                    if (OptName != null) {
                        OptName.$destroy();
                    }
                }
            }
            StdMap.iterator it = GroupedOptionHelp.begin();
            StdMap.iterator ie = GroupedOptionHelp.end();
            while (it.$noteq((Object)ie)) {
                if (it.$noteq((Object)GroupedOptionHelp.begin())) {
                    OS.$out(NativePointer.$LF);
                }
                OptTableStatics.PrintHelpOptionList(OS, new StringRef((std.string)it.$arrow().first), (std.vector<std_pair.pair<std.string, char.ptr>>)((std.vector)it.$arrow().second));
                it.$preInc();
            }
            OS.flush();
        }
        finally {
            if (GroupedOptionHelp != null) {
                GroupedOptionHelp.$destroy();
            }
        }
    }

    public void PrintHelp(raw_ostream OS, char.ptr Name, char.ptr Title) {
        this.PrintHelp(OS, Name, Title, false);
    }

    public void PrintHelp(raw_ostream OS, char.ptr Name, char.ptr Title, boolean ShowHidden) {
        this.PrintHelp(OS, Name, Title, 0, ShowHidden ? 0 : 1);
    }

    public static class Info
    implements Native.OpCapable {
        public final type.ptr<char.ptr> Prefixes;
        public final char.ptr Name;
        public final char.ptr HelpText;
        public final char.ptr MetaVar;
        public final int ID;
        public final byte Kind;
        public final byte Param;
        public final char Flags;
        public final char GroupID;
        public final char AliasID;
        public final char.ptr AliasArgs;

        public Info(type.ptr<char.ptr> Prefixes, char.ptr Name, char.ptr HelpText, char.ptr MetaVar, int ID, byte Kind, int Param, int Flags, int GroupID, int AliasID, char.ptr AliasArgs) {
            this.Prefixes = Prefixes;
            this.Name = Name;
            this.HelpText = HelpText;
            this.MetaVar = MetaVar;
            this.ID = ID;
            this.Kind = Kind;
            this.Param = Unsigned.$int2uchar((int)Param);
            this.Flags = Unsigned.$int2ushort((int)Flags);
            this.GroupID = Unsigned.$int2ushort((int)GroupID);
            this.AliasID = Unsigned.$int2ushort((int)AliasID);
            this.AliasArgs = AliasArgs;
        }

        public Boolean $op(Native.OpCapable.Op k, Object obj) {
            if (k == Native.OpCapable.Op.LESS) {
                if (obj instanceof Info) {
                    return OptStatics.$less_Info(this, (Info)obj);
                }
                if (obj instanceof char.ptr) {
                    return OptStatics.$less_Info_char$ptr$C(this, (char.ptr)obj);
                }
            } else {
                assert (!(obj instanceof Info)) : "do we need Op.GREATEREQ impl?";
                assert (!(obj instanceof char.ptr)) : "do we need Op.GREATEREQ impl?";
            }
            return null;
        }

        public String toString() {
            return "Info{, Name=" + this.Name + "\nPrefixes=" + this.Prefixes + "\n, HelpText=" + this.HelpText + ", MetaVar=" + this.MetaVar + "\n, ID=" + this.ID + ", Kind=" + this.Kind + ", Param=" + this.Param + "\n, Flags=" + this.Flags + ", GroupID=" + this.GroupID + "\n, AliasID=" + this.AliasID + ", AliasArgs=" + this.AliasArgs + '}';
        }
    }
}

