/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeSet;
import org.apache.maven.index.ArtifactContext;
import org.apache.maven.index.ArtifactContextProducer;
import org.apache.maven.index.Scanner;
import org.apache.maven.index.ScanningRequest;
import org.apache.maven.index.ScanningResult;
import org.apache.maven.index.context.IndexingContext;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;

@Component(role=Scanner.class)
public class DefaultScanner
extends AbstractLogEnabled
implements Scanner {
    @Requirement
    private ArtifactContextProducer artifactContextProducer;

    public ScanningResult scan(ScanningRequest request) {
        request.getArtifactScanningListener().scanningStarted(request.getIndexingContext());
        ScanningResult result = new ScanningResult(request);
        this.scanDirectory(request.getStartingDirectory(), request);
        request.getArtifactScanningListener().scanningFinished(request.getIndexingContext(), result);
        return result;
    }

    private void scanDirectory(File dir, ScanningRequest request) {
        if (dir == null) {
            return;
        }
        File[] fileArray = dir.listFiles();
        if (fileArray != null) {
            TreeSet<File> files = new TreeSet<File>(new ScannerFileComparator());
            files.addAll(Arrays.asList(fileArray));
            for (File f : files) {
                if (f.getName().startsWith(".")) continue;
                if (f.isDirectory()) {
                    this.scanDirectory(f, request);
                    continue;
                }
                this.processFile(f, request);
            }
        }
    }

    private void processFile(File file, ScanningRequest request) {
        IndexingContext context = request.getIndexingContext();
        ArtifactContext ac = this.artifactContextProducer.getArtifactContext(context, file);
        if (ac != null) {
            request.getArtifactScanningListener().artifactDiscovered(ac);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ScannerFileComparator
    implements Comparator<File> {
        private ScannerFileComparator() {
        }

        @Override
        public int compare(File o1, File o2) {
            if (o1.getName().endsWith(".pom") && !o2.getName().endsWith(".pom")) {
                return 1;
            }
            if (!o1.getName().endsWith(".pom") && o2.getName().endsWith(".pom")) {
                return -1;
            }
            return o2.getName().compareTo(o1.getName());
        }
    }
}

