/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.beanvalidation;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class ConstraintPanelVisual
extends JPanel
implements DocumentListener {
    private TemplateWizard wizard;
    private static final String VALIDATOR = "Validator";
    private static final String METHOD = "METHOD";
    private static final String FIELD = "FIELD";
    private static final String ANNOTATION_TYPE = "ANNOTATION_TYPE";
    private final List<String> targetElements = new ArrayList<String>();
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);
    private JCheckBox cbGenerateValidator;
    private JLabel labelClassName;
    private JLabel labelType;
    private JTextField validatorClassName;
    private JTextField validatorType;

    public ConstraintPanelVisual(TemplateWizard wizard) {
        this.wizard = wizard;
        this.initComponents();
        this.setValidatorPropertiesVisible(false);
        this.validatorClassName.getDocument().addDocumentListener(this);
        this.validatorType.getDocument().addDocumentListener(this);
        this.targetElements.add(METHOD);
        this.targetElements.add(FIELD);
        this.targetElements.add(ANNOTATION_TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    private void fireChangeEvent() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : this.listeners) {
            l.stateChanged(e);
        }
    }

    private void initComponents() {
        this.cbGenerateValidator = new JCheckBox();
        this.labelClassName = new JLabel();
        this.validatorClassName = new JTextField();
        this.labelType = new JLabel();
        this.validatorType = new JTextField();
        this.cbGenerateValidator.setText(NbBundle.getMessage(ConstraintPanelVisual.class, (String)"ConstraintPanelVisual.cbGenerateValidator.text"));
        this.cbGenerateValidator.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ConstraintPanelVisual.this.cbGenerateValidatorItemStateChanged(evt);
            }
        });
        this.labelClassName.setText(NbBundle.getMessage(ConstraintPanelVisual.class, (String)"ConstraintPanelVisual.labelClassName.text"));
        this.validatorClassName.setColumns(20);
        this.labelType.setText(NbBundle.getMessage(ConstraintPanelVisual.class, (String)"ConstraintPanelVisual.labelType.text"));
        this.validatorType.setColumns(20);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbGenerateValidator).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelClassName).addComponent(this.labelType)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.validatorType, -1, 276, Short.MAX_VALUE).addComponent(this.validatorClassName, -1, 276, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.cbGenerateValidator).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelClassName).addComponent(this.validatorClassName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelType).addComponent(this.validatorType, -2, -1, -2)).addContainerGap(224, Short.MAX_VALUE)));
    }

    private void cbGenerateValidatorItemStateChanged(ItemEvent evt) {
        boolean visible = this.cbGenerateValidator.isSelected();
        this.setValidatorPropertiesVisible(visible);
        this.fireChangeEvent();
    }

    private void setValidatorPropertiesVisible(boolean visible) {
        this.labelClassName.setVisible(visible);
        this.labelType.setVisible(visible);
        this.validatorClassName.setVisible(visible);
        this.validatorType.setVisible(visible);
    }

    boolean validateTemplate(TemplateWizard wizard) {
        this.wizard = wizard;
        Object message = null;
        wizard.putProperty("WizardPanel_errorMessage", null);
        if (this.cbGenerateValidator.isSelected()) {
            if ("".equals(this.validatorClassName.getText().trim())) {
                wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ConstraintPanelVisual.class, (String)"ERR_Empty_validator_class"));
                return false;
            }
            String type = this.validatorType.getText().trim();
            if ("".equals(type)) {
                wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ConstraintPanelVisual.class, (String)"ERR_Empty_validator_type"));
                return false;
            }
            if (!this.isValidType(wizard, type)) {
                wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ConstraintPanelVisual.class, (String)"ERR_wrong_type"));
                return false;
            }
        }
        return true;
    }

    private boolean isValidType(TemplateWizard wizard, String type) {
        return true;
    }

    void updateValidatorClassName(String targetName) {
        String text = targetName + VALIDATOR;
        if (!text.equals(this.validatorClassName.getText().trim())) {
            this.validatorClassName.setText(targetName + VALIDATOR);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.fireChangeEvent();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.fireChangeEvent();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.fireChangeEvent();
    }

    void store(TemplateWizard settings) {
        settings.putProperty("targetElements", this.targetElements);
        if (this.cbGenerateValidator.isSelected()) {
            settings.putProperty("validator", (Object)this.validatorClassName.getText().trim());
            settings.putProperty("validatorType", (Object)this.validatorType.getText().trim());
        }
    }
}

