/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.netbeans.modules.mercurial.remote.HgException;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.remote.util.HgCommand;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.historystore.Storage;
import org.netbeans.modules.versioning.historystore.StorageManager;

public class VersionsCache {
    private static VersionsCache instance;

    private VersionsCache() {
    }

    public static synchronized VersionsCache getInstance() {
        if (instance == null) {
            instance = new VersionsCache();
        }
        return instance;
    }

    public VCSFileProxy getFileRevision(VCSFileProxy base, HgLogMessage.HgRevision revision) throws IOException {
        return this.getFileRevision(base, revision, true);
    }

    public VCSFileProxy getFileRevision(VCSFileProxy base, HgLogMessage.HgRevision revision, boolean tryHard) throws IOException {
        String revisionNumber = revision.getRevisionNumber();
        if ("-1".equals(revisionNumber)) {
            return null;
        }
        VCSFileProxy repository = Mercurial.getInstance().getRepositoryRoot(base);
        if (HgLogMessage.HgRevision.CURRENT.equals(revision)) {
            return base;
        }
        try {
            VCSFileProxy tempFile = VCSFileProxy.createFileProxy((VCSFileProxy)VCSFileProxySupport.getTempFolder((VCSFileProxy)repository, (boolean)true), (String)("nb-hg-" + base.getName()));
            if (HgLogMessage.HgRevision.BASE.equals(revision)) {
                HgCommand.doCat(repository, base, tempFile, null);
            } else if ("false".equals(System.getProperty("versioning.mercurial.historycache.enable", "true"))) {
                HgCommand.doCat(repository, base, tempFile, revisionNumber, null);
            } else {
                String relativePath;
                String changesetId = revision.getChangesetId();
                Storage cachedVersions = StorageManager.getInstance().getStorage(repository.getPath());
                File cachedFile = cachedVersions.getContent(relativePath = HgUtils.getRelativePath(base), base.getName(), changesetId);
                if (cachedFile.length() == 0L) {
                    HgCommand.doCat(repository, base, tempFile, revisionNumber, null, tryHard);
                    if (VCSFileProxySupport.length((VCSFileProxy)tempFile) != 0L) {
                        cachedVersions.setContent(relativePath, changesetId, tempFile.getInputStream(false));
                    }
                } else {
                    VCSFileProxySupport.copyStreamToFile((InputStream)new BufferedInputStream(new FileInputStream(cachedFile)), (VCSFileProxy)tempFile);
                }
            }
            if (VCSFileProxySupport.length((VCSFileProxy)tempFile) == 0L) {
                VCSFileProxySupport.delete((VCSFileProxy)tempFile);
                return null;
            }
            return tempFile;
        }
        catch (HgException e) {
            throw new IOException(e);
        }
    }
}

