/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.api.remote.ui.RemoteFileChooserUtil;
import org.netbeans.modules.cnd.discovery.api.ProviderProperty;
import org.netbeans.modules.cnd.discovery.api.ProviderPropertyType;
import org.netbeans.modules.cnd.discovery.wizard.AdditionalLibrariesListPanel;
import org.netbeans.modules.cnd.discovery.wizard.ExpandableEditableComboBox;
import org.netbeans.modules.cnd.discovery.wizard.api.DiscoveryDescriptor;
import org.netbeans.modules.cnd.spi.utils.CndFileSystemProvider;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.FileFilterFactory;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ProviderControl<T> {
    private final ProviderProperty property;
    private final String propertyKey;
    private final DiscoveryDescriptor wizardDescriptor;
    private final JPanel panel;
    private final ChangeListener listener;
    private FileSystem projectFileSystem;
    private JLabel label;
    private ExpandableEditableComboBox field;
    private JButton button;
    private int chooserMode = 0;
    private static final String LIST_LIST_DELIMITER = ";";

    public ProviderControl(String key, ProviderProperty<T> property, DiscoveryDescriptor wizardDescriptor, JPanel panel, ChangeListener listener) {
        this.propertyKey = key;
        this.property = property;
        this.panel = panel;
        this.listener = listener;
        this.wizardDescriptor = wizardDescriptor;
        try {
            this.projectFileSystem = wizardDescriptor.getProject().getProjectDirectory().getFileSystem();
        }
        catch (FileStateInvalidException ex) {
            this.projectFileSystem = CndFileSystemProvider.getLocalFileSystem();
        }
        this.label = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.label, (String)property.getName());
        switch (property.getPropertyType().kind()) {
            case MakeLogFile: {
                this.field = new ExpandableEditableComboBox();
                this.field.setEditable(true);
                this.chooserMode = 0;
                this.initBuildOrRoot(wizardDescriptor);
                this.button = new JButton();
                Mnemonics.setLocalizedText((AbstractButton)this.button, (String)this.getString("ROOT_DIR_BROWSE_BUTTON_TXT", new String[0]));
                this.layout(panel);
                this.button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        ProviderControl.this.rootFolderButtonActionPerformed(evt, ProviderControl.this.property.getPropertyType().kind() == ProviderPropertyType.PropertyKind.BinaryFile, ProviderControl.this.getString("LOG_FILE_CHOOSER_TITLE_TXT", new String[0]));
                    }
                });
                this.addListeners();
                break;
            }
            case BinaryFile: {
                this.field = new ExpandableEditableComboBox();
                this.field.setEditable(true);
                this.chooserMode = 0;
                this.initBuildOrRoot(wizardDescriptor);
                this.button = new JButton();
                Mnemonics.setLocalizedText((AbstractButton)this.button, (String)this.getString("ROOT_DIR_BROWSE_BUTTON_TXT", new String[0]));
                this.layout(panel);
                this.button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        ProviderControl.this.rootFolderButtonActionPerformed(evt, ProviderControl.this.property.getPropertyType().kind() == ProviderPropertyType.PropertyKind.BinaryFile, ProviderControl.this.getString("BINARY_FILE_CHOOSER_TITLE_TXT", new String[0]));
                    }
                });
                this.addListeners();
                break;
            }
            case Folder: {
                this.field = new ExpandableEditableComboBox();
                this.field.setEditable(true);
                this.chooserMode = 1;
                this.initRoot(wizardDescriptor);
                this.button = new JButton();
                Mnemonics.setLocalizedText((AbstractButton)this.button, (String)this.getString("ROOT_DIR_BROWSE_BUTTON_TXT", new String[0]));
                this.layout(panel);
                this.button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        ProviderControl.this.rootFolderButtonActionPerformed(evt, true, ProviderControl.this.getString("ROOT_DIR_CHOOSER_TITLE_TXT", new String[0]));
                    }
                });
                this.addListeners();
                break;
            }
            case BinaryFiles: {
                this.field = new ExpandableEditableComboBox();
                this.field.setEditable(true);
                this.chooserMode = 0;
                this.initArray();
                this.button = new JButton();
                Mnemonics.setLocalizedText((AbstractButton)this.button, (String)this.getString("ROOT_DIR_EDIT_BUTTON_TXT", new String[0]));
                this.layout(panel);
                this.button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        ProviderControl.this.additionalLibrariesButtonActionPerformed(evt);
                    }
                });
                this.addListeners();
                break;
            }
        }
    }

    private void initBuildOrRoot(DiscoveryDescriptor wizardDescriptor) {
        Object val = this.property.getValue();
        String output = null;
        if (val instanceof String) {
            output = (String)val;
        }
        if (output != null && output.length() > 0) {
            this.initFields(output);
            return;
        }
        output = wizardDescriptor.getBuildResult();
        if (output != null && output.length() > 0) {
            this.initFields(output);
            return;
        }
        this.initFields(wizardDescriptor.getRootFolder());
    }

    private void initRoot(DiscoveryDescriptor wizardDescriptor) {
        Object val = this.property.getValue();
        String output = null;
        if (val instanceof String) {
            output = (String)val;
        }
        if (output != null && output.length() > 0) {
            this.initFields(output);
            return;
        }
        this.initFields(wizardDescriptor.getRootFolder());
    }

    private void initArray() {
        Object val = this.property.getValue();
        if (val instanceof String[]) {
            StringBuilder buf = new StringBuilder();
            for (String s : (String[])val) {
                if (buf.length() > 0) {
                    buf.append(LIST_LIST_DELIMITER);
                }
                buf.append(s);
            }
            this.initFields(buf.toString());
        } else {
            this.initFields("");
        }
    }

    private void initComboBox(String root) {
        Preferences preferences = ProjectUtils.getPreferences((Project)this.wizardDescriptor.getProject(), ProviderControl.class, (boolean)false);
        this.field.setStorage(this.propertyKey, preferences);
        this.field.setEnv(FileSystemProvider.getExecutionEnvironment((FileSystem)this.projectFileSystem));
        this.field.read(root);
    }

    private void addListeners() {
        this.field.addChangeListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProviderControl.this.update();
            }
        });
    }

    private void update() {
        this.listener.stateChanged(null);
    }

    public void store() {
        switch (this.property.getPropertyType().kind()) {
            case MakeLogFile: 
            case BinaryFile: 
            case Folder: {
                this.property.setValue(this.getComboBoxText());
                this.storeHistory();
                break;
            }
            case BinaryFiles: {
                String text = this.getComboBoxText();
                StringTokenizer st = new StringTokenizer(text, LIST_LIST_DELIMITER);
                ArrayList<String> list = new ArrayList<String>();
                while (st.hasMoreTokens()) {
                    list.add(st.nextToken());
                }
                this.property.setValue(list.toArray(new String[list.size()]));
                this.storeHistory();
                break;
            }
        }
    }

    private void storeHistory() {
        Preferences preferences = ProjectUtils.getPreferences((Project)this.wizardDescriptor.getProject(), ProviderControl.class, (boolean)false);
        this.field.setStorage(this.propertyKey, preferences);
        this.field.store();
    }

    public boolean valid() {
        String path = this.getComboBoxText();
        switch (this.property.getPropertyType().kind()) {
            case Folder: {
                if (path.length() == 0) {
                    this.wizardDescriptor.setMessage(this.getString("ProviderControlFolderError", path));
                    return false;
                }
                FSPath file = new FSPath(this.projectFileSystem, path);
                FileObject fo = file.getFileObject();
                if (fo == null || !fo.isValid() || !fo.isFolder()) {
                    this.wizardDescriptor.setMessage(this.getString("ProviderControlFolderError", path));
                    return false;
                }
                return true;
            }
            case MakeLogFile: 
            case BinaryFile: {
                if (path.length() == 0) {
                    this.wizardDescriptor.setMessage(this.getString("ProviderControlFileError", path));
                    return false;
                }
                FSPath file = new FSPath(this.projectFileSystem, path);
                FileObject fo = file.getFileObject();
                if (fo == null || !fo.isValid() || !fo.isData()) {
                    this.wizardDescriptor.setMessage(this.getString("ProviderControlFileError", path));
                    return false;
                }
                return true;
            }
            case BinaryFiles: {
                String text = this.getComboBoxText();
                StringTokenizer st = new StringTokenizer(text, LIST_LIST_DELIMITER);
                while (st.hasMoreTokens()) {
                    path = st.nextToken();
                    if (path.length() == 0) {
                        this.wizardDescriptor.setMessage(this.getString("ProviderControlFileError", path));
                        return false;
                    }
                    FSPath file = new FSPath(this.projectFileSystem, path);
                    FileObject fo = file.getFileObject();
                    if (fo != null && fo.isValid() && fo.isData()) continue;
                    this.wizardDescriptor.setMessage(this.getString("ProviderControlFileError", path));
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private void layout(JPanel panel) {
        this.label.setLabelFor((Component)((Object)this.field));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        panel.add((Component)this.label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        panel.add((Component)((Object)this.field), gridBagConstraints);
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < 35; ++i) {
            buf.append("w");
        }
        this.field.setPrototypeDisplayValue(buf.toString());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        panel.add((Component)this.button, gridBagConstraints);
    }

    private void additionalLibrariesButtonActionPerformed(ActionEvent evt) {
        StringTokenizer tokenizer = new StringTokenizer(this.getComboBoxText(), LIST_LIST_DELIMITER);
        ArrayList<String> list = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        AdditionalLibrariesListPanel libPanel = new AdditionalLibrariesListPanel(list);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)AdditionalLibrariesListPanel.wrapPanel(libPanel), this.getString("ADDITIONAL_LIBRARIES_TXT", new String[0]));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            List newList = libPanel.getListData();
            StringBuilder includes = new StringBuilder();
            for (int i = 0; i < newList.size(); ++i) {
                if (i > 0) {
                    includes.append(LIST_LIST_DELIMITER);
                }
                includes.append((String)newList.get(i));
            }
            this.field.setSelectedItem(includes.toString());
        }
    }

    private void rootFolderButtonActionPerformed(ActionEvent evt, boolean isBinary, String title) {
        ExecutionEnvironment execEnv;
        JFileChooser fileChooser;
        int ret;
        FileFilter[] filters = null;
        if (this.chooserMode == 0) {
            filters = isBinary ? FileFilterFactory.getBinaryFilters() : new FileFilter[]{new LogFileFilter()};
        }
        if ((ret = (fileChooser = RemoteFileChooserUtil.createFileChooser((ExecutionEnvironment)(execEnv = FileSystemProvider.getExecutionEnvironment((FileSystem)this.projectFileSystem)), (String)title, (String)this.getString("ROOT_DIR_BUTTON_TXT", new String[0]), (int)this.chooserMode, (FileFilter[])filters, (String)this.getComboBoxText(), (boolean)false)).showOpenDialog(this.panel)) == 1) {
            return;
        }
        String path = fileChooser.getSelectedFile().getPath();
        this.field.setSelectedItem(path);
    }

    private String getComboBoxText() {
        return this.field.getText();
    }

    private void initFields(String path) {
        if (path == null) {
            this.initComboBox("");
        } else {
            if (CndFileUtils.isLocalFileSystem((FileSystem)this.projectFileSystem) && Utilities.isWindows()) {
                path = path.replace('/', CndFileUtils.getFileSeparatorChar((FileSystem)this.projectFileSystem));
            }
            this.initComboBox(path);
        }
    }

    private String getString(String key, String ... params) {
        return NbBundle.getMessage(ProviderControl.class, (String)key, (Object[])params);
    }

    private class LogFileFilter
    extends FileFilter {
        @Override
        public String getDescription() {
            return ProviderControl.this.getString("FILECHOOSER_MAK_LOG_FILEFILTER", new String[0]);
        }

        @Override
        public boolean accept(File f) {
            if (f != null) {
                if (f.isDirectory()) {
                    return true;
                }
                String name = f.getName();
                return name.endsWith(".log") || name.endsWith(".json");
            }
            return false;
        }
    }
}

