/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.util.Map;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.TagCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevObject;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitTag;
import org.netbeans.libs.git.jgit.DelegatingGitProgressMonitor;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.jgit.commands.ListTagCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class CreateTagCommand
extends GitCommand {
    private final boolean forceUpdate;
    private final String tagName;
    private final String taggedObject;
    private final String message;
    private final boolean signed;
    private GitTag tag;
    private final ProgressMonitor monitor;

    public CreateTagCommand(Repository repository, GitClassFactory gitFactory, String tagName, String taggedObject, String message, boolean signed, boolean forceUpdate, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.monitor = monitor;
        this.tagName = tagName;
        this.taggedObject = taggedObject;
        this.message = message;
        this.signed = signed;
        this.forceUpdate = forceUpdate;
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        try {
            RevObject obj = Utils.findObject(repository, this.taggedObject);
            TagCommand cmd = new Git(repository).tag();
            cmd.setName(this.tagName);
            cmd.setForceUpdate(this.forceUpdate);
            cmd.setObjectId(obj);
            cmd.setAnnotated(this.message != null && !this.message.isEmpty() || this.signed);
            if (cmd.isAnnotated()) {
                cmd.setMessage(this.message);
                cmd.setSigned(this.signed);
            }
            cmd.call();
            ListTagCommand tagCmd = new ListTagCommand(repository, this.getClassFactory(), false, new DelegatingGitProgressMonitor(this.monitor));
            tagCmd.run();
            Map<String, GitTag> tags = tagCmd.getTags();
            this.tag = tags.get(this.tagName);
        }
        catch (GitAPIException | JGitInternalException ex) {
            throw new GitException(ex);
        }
    }

    @Override
    protected String getCommandDescription() {
        StringBuilder sb = new StringBuilder("git tag");
        if (this.signed) {
            sb.append(" -s");
        }
        if (this.forceUpdate) {
            sb.append(" -f");
        }
        if (this.message != null && !this.message.isEmpty()) {
            sb.append(" -m ").append(this.message.replace("\n", "\\n"));
        }
        sb.append(' ').append(this.tagName);
        if (this.taggedObject != null) {
            sb.append(' ').append(this.taggedObject);
        }
        return sb.toString();
    }

    public GitTag getTag() {
        return this.tag;
    }
}

