/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.testng.ui.actions;

import java.io.IOException;
import java.net.URL;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.gsf.testrunner.ui.api.UICommonUtils;
import org.netbeans.modules.java.testrunner.CommonTestUtil;
import org.netbeans.modules.java.testrunner.JavaUtils;
import org.netbeans.modules.testng.ui.actions.TestClassInfoTask;
import org.netbeans.spi.project.SingleMethod;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.text.NbDocument;
import org.openide.util.Mutex;

public class TestSingleMethodSupport {
    private static final Logger LOGGER = Logger.getLogger(TestSingleMethodSupport.class.getName());

    private TestSingleMethodSupport() {
    }

    public static boolean isTestClass(Node activatedNode) {
        Project project;
        FileObject fileObject = UICommonUtils.getFileObjectFromNode((Node)activatedNode);
        if (fileObject != null && CommonTestUtil.isJavaFile((FileObject)fileObject) && (project = FileOwnerQuery.getOwner((FileObject)fileObject)) != null) {
            SourceGroup[] javaSGs = new JavaUtils(project).getJavaSourceGroups();
            for (int i = 0; i < javaSGs.length; ++i) {
                SourceGroup javaSG = javaSGs[i];
                FileObject rootFolder = javaSG.getRootFolder();
                URL[] testRoots = UnitTestForSourceQuery.findUnitTests((FileObject)rootFolder);
                URL[] sourceRoots = UnitTestForSourceQuery.findSources((FileObject)rootFolder);
                if (fileObject != rootFolder && !FileUtil.isParentOf((FileObject)rootFolder, (FileObject)fileObject) || !javaSG.contains(fileObject) || testRoots.length != 0 || sourceRoots.length <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public static SingleMethod getTestMethod(Document doc, int cursor) {
        SingleMethod sm = null;
        if (doc != null) {
            JavaSource js = JavaSource.forDocument((Document)doc);
            if (js == null) {
                return null;
            }
            TestClassInfoTask task = new TestClassInfoTask(cursor);
            try {
                Future f = js.runWhenScanFinished((Task)task, true);
                if (f.isDone() && task.getFileObject() != null && task.getMethodName() != null) {
                    sm = new SingleMethod(task.getFileObject(), task.getMethodName());
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, null, ex);
            }
        }
        return sm;
    }

    public static boolean canHandle(Node activatedNode) {
        String text;
        int index;
        JEditorPane pane;
        EditorCookie ec;
        FileObject fileO = UICommonUtils.getFileObjectFromNode((Node)activatedNode);
        return fileO != null && (ec = (EditorCookie)activatedNode.getLookup().lookup(EditorCookie.class)) != null && (pane = (JEditorPane)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<JEditorPane>(){

            public JEditorPane run() {
                return NbDocument.findRecentEditorPane((EditorCookie)ec);
            }
        })) != null && (index = (text = pane.getText()).indexOf("public")) != -1 && text.substring(0, index).contains("org.testng.");
    }
}

