/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phpunit.ui;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.php.phpunit.ui.Bundle;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public final class PhpUnitTestGroupsPanel
extends JPanel {
    private static final long serialVersionUID = 6576832132135L;
    private final Set<String> selectedGroups;
    private final GroupsTableModel tableModel;
    private JCheckBox selectAllTestGroupsCheckBox;
    private JLabel selectTestGroupLabel;
    private JScrollPane testGroupsScrollPane;
    private JTable testGroupsTable;

    private PhpUnitTestGroupsPanel(List<String> allGroups, List<String> selectedGroups) {
        assert (EventQueue.isDispatchThread());
        assert (allGroups != null);
        assert (selectedGroups != null);
        this.selectedGroups = new HashSet<String>(selectedGroups);
        this.tableModel = new GroupsTableModel(allGroups, this.selectedGroups);
        this.initComponents();
        this.init();
    }

    @CheckForNull
    public static List<String> showDialog(List<String> allGroups, List<String> selectedGroups) {
        final CopyOnWriteArrayList<String> allGroupsCopy = new CopyOnWriteArrayList<String>(allGroups);
        final CopyOnWriteArrayList<String> selectedGroupsCopy = new CopyOnWriteArrayList<String>(selectedGroups);
        return (List)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<List<String>>(){

            public List<String> run() {
                assert (EventQueue.isDispatchThread());
                PhpUnitTestGroupsPanel panel = new PhpUnitTestGroupsPanel(allGroupsCopy, selectedGroupsCopy);
                NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)panel, Bundle.PhpUnitTestGroupsPanel_dialog_title(), 2, -1, null, NotifyDescriptor.OK_OPTION);
                NotificationLineSupport notificationLineSupport = notifyDescriptor.createNotificationLineSupport();
                panel.tableModel.addTableModelListener(new TestGroupsTableModelListener(notificationLineSupport));
                if (DialogDisplayer.getDefault().notify(notifyDescriptor) != NotifyDescriptor.OK_OPTION) {
                    return null;
                }
                return panel.getSelectedGroups();
            }
        });
    }

    private void init() {
        assert (EventQueue.isDispatchThread());
        this.selectAllTestGroupsCheckBox.setText(Bundle.PhpUnitTestGroupsPanel_groups_select_all());
        this.testGroupsTable.setTableHeader(null);
        this.testGroupsTable.setModel(this.tableModel);
        this.setFocusable(true);
    }

    private List<String> getSelectedGroups() {
        assert (EventQueue.isDispatchThread());
        return new ArrayList<String>(this.selectedGroups);
    }

    private void initComponents() {
        this.testGroupsScrollPane = new JScrollPane();
        this.testGroupsTable = new JTable();
        this.selectTestGroupLabel = new JLabel();
        this.selectAllTestGroupsCheckBox = new JCheckBox();
        this.testGroupsTable.setAutoResizeMode(1);
        this.testGroupsTable.setSelectionMode(0);
        this.testGroupsScrollPane.setViewportView(this.testGroupsTable);
        this.selectTestGroupLabel.setText(NbBundle.getMessage(PhpUnitTestGroupsPanel.class, (String)"PhpUnitTestGroupsPanel.selectTestGroupLabel.text"));
        this.selectAllTestGroupsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhpUnitTestGroupsPanel.this.selectAllTestGroupsCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.testGroupsScrollPane, -1, 346, Short.MAX_VALUE).addComponent(this.selectTestGroupLabel).addComponent(this.selectAllTestGroupsCheckBox, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.selectTestGroupLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.testGroupsScrollPane, -1, 90, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectAllTestGroupsCheckBox)));
    }

    private void selectAllTestGroupsCheckBoxActionPerformed(ActionEvent evt) {
        String label;
        boolean selectAllGroups;
        assert (EventQueue.isDispatchThread());
        if (this.selectAllTestGroupsCheckBox.isSelected()) {
            selectAllGroups = true;
            label = Bundle.PhpUnitTestGroupsPanel_groups_select_none();
        } else {
            selectAllGroups = false;
            label = Bundle.PhpUnitTestGroupsPanel_groups_select_all();
        }
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            this.tableModel.setValueAt(selectAllGroups, i, 1);
        }
        this.selectAllTestGroupsCheckBox.setText(label);
    }

    private static final class TestGroupsTableModelListener
    implements TableModelListener {
        private final NotificationLineSupport notificationLineSupport;

        public TestGroupsTableModelListener(NotificationLineSupport notificationLineSupport) {
            this.notificationLineSupport = notificationLineSupport;
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            TableModel tableModel = (TableModel)e.getSource();
            for (int i = 0; i < tableModel.getRowCount(); ++i) {
                Boolean isRowChecked = (Boolean)tableModel.getValueAt(i, 1);
                if (!isRowChecked.booleanValue()) continue;
                this.notificationLineSupport.clearMessages();
                return;
            }
            this.notificationLineSupport.setInformationMessage(Bundle.PhpUnitTestGroupsPanel_groups_selected_none());
        }
    }

    private static final class GroupsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 2346465465423157L;
        private final Class<?>[] types = new Class[]{String.class, Boolean.class};
        private final List<String> allGroups;
        private final Set<String> selectedGroups;

        public GroupsTableModel(List<String> allGroups, Set<String> selectedGroups) {
            assert (EventQueue.isDispatchThread());
            this.allGroups = allGroups;
            this.selectedGroups = selectedGroups;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.types[columnIndex];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col != 0;
        }

        @Override
        public int getRowCount() {
            assert (EventQueue.isDispatchThread());
            return this.allGroups.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            assert (EventQueue.isDispatchThread());
            if (columnIndex == 0) {
                return this.allGroups.get(rowIndex);
            }
            if (columnIndex == 1) {
                return this.selectedGroups.contains(this.allGroups.get(rowIndex));
            }
            throw new IllegalStateException("Unknown column index: " + columnIndex);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            assert (EventQueue.isDispatchThread());
            if (columnIndex == 1) {
                Boolean selected = (Boolean)aValue;
                String group = this.allGroups.get(rowIndex);
                if (selected.booleanValue()) {
                    this.selectedGroups.add(group);
                } else {
                    this.selectedGroups.remove(group);
                }
                this.fireTableCellUpdated(rowIndex, columnIndex);
                return;
            }
            throw new IllegalStateException("Unknown column index: " + columnIndex);
        }
    }
}

