/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ant;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.jpda.DebuggerStartException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class KdpDebugTask
extends Task {
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.mobility.project.ant.KdpDebugTask");
    private long startTime;
    private long delay = 0L;
    private long timeout = 45000L;
    private long period = 500L;
    private String host = "localhost";
    private String address;
    private String name;
    private String transport = "dt_socket";

    public void setPeriod(long periodMS) {
        this.period = periodMS;
    }

    public void setTimeout(long timeoutMS) {
        this.timeout = timeoutMS;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public void setHost(String h) {
        this.host = h;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setTransport(String transport) {
        this.transport = transport;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void execute() throws BuildException {
        File jarFile;
        String src;
        Project project = this.getProject();
        if (this.name == null) {
            this.name = project.getProperty("app.codename");
        }
        if (this.name == null) {
            throw new BuildException(NbBundle.getMessage(KdpDebugTask.class, (String)"ERR_ANT_Session_name_missing"), this.getLocation());
        }
        if (this.address == null) {
            throw new BuildException(NbBundle.getMessage(KdpDebugTask.class, (String)"ERR_ANT_Address_missing"), this.getLocation());
        }
        int intAddr = 0;
        if (this.transport.equals("dt_socket")) {
            try {
                intAddr = Integer.parseInt(this.address);
            }
            catch (NumberFormatException nfe) {
                throw new BuildException(NbBundle.getMessage(KdpDebugTask.class, (String)"ERR_ANT_Address_missing"), this.getLocation());
            }
        }
        if ((src = project.getProperty("src.dir")) == null) {
            throw new BuildException(NbBundle.getMessage(KdpDebugTask.class, (String)"ERR_ANT_source_root_missing"), this.getLocation());
        }
        File srcFile = new File(project.getBaseDir(), src);
        if (!srcFile.isDirectory()) {
            srcFile = new File(src);
        }
        FileObject srcRoot = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)srcFile));
        if (!srcFile.isDirectory() || srcRoot == null) {
            throw new BuildException(NbBundle.getMessage(KdpDebugTask.class, (String)"ERR_ANT_source_root_missing"), this.getLocation());
        }
        String dist = project.getProperty("dist.dir");
        String jar = project.getProperty("dist.jar");
        if (dist != null && jar != null && (jarFile = new File(project.getBaseDir(), dist + '/' + jar)).isFile() && jarFile.length() > 50000L && this.timeout != 0L) {
            long newTimeoutAdd = jarFile.length() - 50000L;
            this.log(NbBundle.getMessage(KdpDebugTask.class, (String)"ERR_ANT_Debugger_Add_time_out", (Object)Long.toString(newTimeoutAdd / 1000L)));
            this.timeout = newTimeoutAdd + this.timeout;
        }
        ClassPath jdkSourcePath = JavaPlatformManager.getDefault().getDefaultPlatform().getSourceFolders();
        String platform = project.getProperty("platform.active");
        if (platform != null) {
            for (JavaPlatform p : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
                if (!platform.equals(p.getProperties().get("platform.ant.name"))) continue;
                jdkSourcePath = p.getSourceFolders();
            }
        }
        ClassPath sourcePath = ClassPath.getClassPath((FileObject)srcRoot, (String)"classpath/source");
        ClassPath libPath = ClassPath.getClassPath((FileObject)srcRoot, (String)"classpath/compile");
        if (libPath != null) {
            HashSet exist = new HashSet();
            HashSet<FileObject> resources = new HashSet<FileObject>();
            for (FileObject root : libPath.getRoots()) {
                try {
                    URL url = root.getURL();
                    for (FileObject fos : SourceForBinaryQuery.findSourceRoots((URL)url).getRoots()) {
                        if (FileUtil.isArchiveFile((FileObject)fos)) {
                            fos = FileUtil.getArchiveRoot((FileObject)fos);
                        }
                        resources.add(fos);
                    }
                }
                catch (IllegalArgumentException ex) {
                    ErrorManager.getDefault().notify(4096, (Throwable)ex);
                }
                catch (FileStateInvalidException fsie) {
                    ErrorManager.getDefault().notify(4096, (Throwable)fsie);
                }
            }
            if (!resources.isEmpty()) {
                if (sourcePath != null) {
                    resources.addAll(Arrays.asList(sourcePath.getRoots()));
                }
                sourcePath = ClassPathSupport.createClassPath((FileObject[])resources.toArray(new FileObject[resources.size()]));
            }
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("sourcepath", sourcePath);
        properties.put("name", this.name);
        properties.put("jdksources", jdkSourcePath);
        properties.put("SS_ACTION_STEPOUT", Boolean.TRUE);
        properties.put("J2ME_DEBUGGER", Boolean.TRUE);
        properties.put("baseDir", this.getProject().getBaseDir());
        if (this.delay > 0L) {
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
        }
        this.startTime = System.currentTimeMillis();
        int attemptCount = 0;
        boolean debuggerConnected = false;
        do {
            try {
                this.log(NbBundle.getMessage(KdpDebugTask.class, (String)"LBL_ANT_DebuggerConnecting", (Object)Integer.toString(++attemptCount)));
                JPDADebugger debugger = this.transport.equals("dt_socket") ? JPDADebugger.attach((String)this.host, (int)intAddr, (Object[])new Object[]{properties}) : JPDADebugger.attach((String)this.address, (Object[])new Object[]{properties});
                int state = debugger.getState();
                if (state != 2 && state != 3) {
                    this.sleep();
                    continue;
                }
                if (this.host == null) {
                    this.log(NbBundle.getMessage(KdpDebugTask.class, (String)"LBL_ANT_Debugger_attached", (Object)this.address));
                } else {
                    this.log(NbBundle.getMessage(KdpDebugTask.class, (String)"LBL_ANT_Debugger_attached_with_host", (Object)this.host, (Object)this.address));
                }
                debuggerConnected = true;
            }
            catch (DebuggerStartException e) {
                this.sleep();
            }
        } while (!debuggerConnected && System.currentTimeMillis() < this.startTime + this.timeout && this.timeout != 0L);
        if (!debuggerConnected && this.timeout != 0L) {
            int attemptTime = (int)((System.currentTimeMillis() - this.startTime) / 1000L);
            this.log(NbBundle.getMessage(KdpDebugTask.class, (String)"ERR_ANT_Debugger_timed_out", (Object)Integer.toString(attemptCount), (Object)Integer.toString(attemptTime)));
            throw new BuildException(NbBundle.getMessage(KdpDebugTask.class, (String)"ERR_ANT_Debugger_timed_out", (Object)Integer.toString(attemptCount), (Object)Integer.toString(attemptTime)));
        }
    }

    private void sleep() {
        try {
            Thread.sleep(this.period);
        }
        catch (InterruptedException ie) {
            this.log(ie, 3);
        }
    }

    private static class BreakManager
    extends DebuggerManagerAdapter
    implements JPDABreakpointListener {
        private Set<MethodBreakpoint> breakpoints;
        private Set debuggers = new HashSet();

        BreakManager(Set<MethodBreakpoint> breakpoints) {
            this.breakpoints = breakpoints;
            DebuggerManager dm = DebuggerManager.getDebuggerManager();
            dm.addDebuggerListener("debuggerEngines", (DebuggerManagerListener)this);
            for (MethodBreakpoint breakpoint : breakpoints) {
                breakpoint.addJPDABreakpointListener((JPDABreakpointListener)this);
                dm.addBreakpoint((Breakpoint)breakpoint);
            }
        }

        public void propertyChange(PropertyChangeEvent e) {
            int state;
            if (e.getPropertyName() == "state" && ((state = ((Integer)e.getNewValue()).intValue()) == 4 || state == 3)) {
                this.breakpointReached(null);
            }
        }

        public void engineAdded(DebuggerEngine engine) {
            JPDADebugger debugger = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
            if (debugger == null) {
                return;
            }
            debugger.addPropertyChangeListener("state", (PropertyChangeListener)((Object)this));
            this.debuggers.add(debugger);
        }

        public void engineRemoved(DebuggerEngine engine) {
            JPDADebugger debugger = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
            if (debugger == null) {
                return;
            }
            debugger.removePropertyChangeListener("state", (PropertyChangeListener)((Object)this));
            this.debuggers.remove(debugger);
        }

        public void breakpointReached(JPDABreakpointEvent event) {
            RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    DebuggerManager dm = DebuggerManager.getDebuggerManager();
                    Set set = breakpoints;
                    synchronized (set) {
                        for (MethodBreakpoint breakpoint : breakpoints) {
                            dm.removeBreakpoint((Breakpoint)breakpoint);
                        }
                        breakpoints.clear();
                    }
                }
            });
            DebuggerManager.getDebuggerManager().removeDebuggerListener("debuggerEngines", (DebuggerManagerListener)this);
            for (JPDADebugger d : this.debuggers) {
                d.removePropertyChangeListener("state", (PropertyChangeListener)((Object)this));
            }
        }
    }
}

