/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver.impl;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.ObjCRuntime;
import org.clang.basic.VersionTuple;
import org.clang.basic.codegenoptions.DebugInfoKind;
import org.clang.driver.Action;
import org.clang.driver.BackendJobAction;
import org.clang.driver.Command;
import org.clang.driver.Compilation;
import org.clang.driver.CompileJobAction;
import org.clang.driver.Driver;
import org.clang.driver.JobAction;
import org.clang.driver.SanitizerArgs;
import org.clang.driver.Tool;
import org.clang.driver.ToolChain;
import org.clang.driver.impl.EHFlags;
import org.clang.driver.impl.InputInfo;
import org.clang.driver.impl.OpenMPRuntimeKind;
import org.clang.driver.impl.ToolsStatics;
import org.clang.driver.java.JavaDriverSupport;
import org.clang.driver.options;
import org.clang.driver.toolchains.impl.FreeBSD;
import org.clang.driver.toolchains.impl.HexagonToolChain;
import org.clang.driver.toolchains.impl.MSVCToolChain;
import org.clang.driver.tools.impl.ArmStatics;
import org.clang.driver.tools.impl.MipsStatics;
import org.clang.driver.tools.impl.PpcStatics;
import org.clang.driver.tools.impl.SparcStatics;
import org.clang.driver.types;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.java.std_ptr;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.aliases.uint;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitch;
import org.llvm.adt.StringSwitchCharPtr;
import org.llvm.adt.StringSwitchStringRef;
import org.llvm.adt.StringSwitchUInt;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.aliases.SmallVectorImplChar;
import org.llvm.adt.aliases.StringMapBool;
import org.llvm.adt.aliases.StringMapConstIteratorBool;
import org.llvm.adt.aliases.StringMapConstIteratorUInt;
import org.llvm.adt.aliases.StringMapEntryBool;
import org.llvm.adt.aliases.StringMapIteratorBool;
import org.llvm.adt.aliases.StringMapIteratorUInt;
import org.llvm.adt.aliases.StringMapUInt;
import org.llvm.option.Arg;
import org.llvm.option.ArgList;
import org.llvm.option.ArgStringList;
import org.llvm.option.OptSpecifier;
import org.llvm.option.Option;
import org.llvm.support.ARM;
import org.llvm.support.Reloc;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.sys.fs;
import org.llvm.support.sys.path;
import org.llvm.support.sys.sys;
import org.llvm.support.zlib.ZlibGlobals;
import org.llvm.target.target.DebuggerKind;

public final class ToolsStatics {
    public static void handleTargetFeaturesGroup(ArgList Args, std.vectorCharPtr Features, OptSpecifier Group) {
        for (Arg A : Args.filtered(Group)) {
            StringRef Name = A.getOption().getName();
            A.claim();
            assert (Name.startswith("m")) : "Invalid feature name.";
            Name.$assignMove(Name.substr(1));
            boolean IsNegative = Name.startswith("no-");
            if (IsNegative) {
                Name.$assignMove(Name.substr(3));
            }
            Features.push_back(Args.MakeArgString(llvm.$add_char$ptr$C_StringRef((char.ptr)(IsNegative ? NativePointer.$MINUS : NativePointer.$PLUS), (StringRef)Name)));
        }
    }

    public static char.ptr getSparcAsmModeForCPU(StringRef Name, Triple _Triple) {
        if (_Triple.getArch() == Triple.ArchType.sparcv9) {
            return new StringSwitchCharPtr(Name).Case("niagara", "-Av9b").Case("niagara2", "-Av9b").Case("niagara3", "-Av9d").Case("niagara4", "-Av9d").Default("-Av9");
        }
        return new StringSwitchCharPtr(Name).Case("v8", "-Av8").Case("supersparc", "-Av8").Case("sparclite", "-Asparclite").Case("f934", "-Asparclite").Case("hypersparc", "-Av8").Case("sparclite86x", "-Asparclite").Case("sparclet", "-Asparclet").Case("tsc701", "-Asparclet").Case("v9", "-Av8plus").Case("ultrasparc", "-Av8plus").Case("ultrasparc3", "-Av8plus").Case("niagara", "-Av8plusb").Case("niagara2", "-Av8plusb").Case("niagara3", "-Av8plusd").Case("niagara4", "-Av8plusd").Case("leon2", "-Av8").Case("at697e", "-Av8").Case("at697f", "-Av8").Case("leon3", "-Av8").Case("ut699", "-Av8").Case("gr712rc", "-Av8").Case("leon4", "-Av8").Case("gr740", "-Av8").Default("-Av8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void CheckPreprocessingOptions(Driver D, ArgList Args) {
        Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_C.getValue()), new OptSpecifier(options.ID.OPT_CC.getValue()));
        if (!(A == null || Args.hasArg(new OptSpecifier(options.ID.OPT_E.getValue())) || Args.hasArg(new OptSpecifier(options.ID.OPT__SLASH_P.getValue())) || Args.hasArg(new OptSpecifier(options.ID.OPT__SLASH_EP.getValue())) || D.CCCIsCPP())) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(307))), (StringRef)new StringRef(A.getBaseArg().getAsString(Args))), (char.ptr)(D.IsCLMode() ? NativePointer.$((String)"/E, /P or /EP") : NativePointer.$((String)"-E"))));
            }
            finally {
                $c$.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void CheckCodeGenerationOptions(Driver D, ArgList Args) {
        Arg A;
        if (Args.hasArg(new OptSpecifier(options.ID.OPT_static.getValue())) && (A = Args.getLastArg(new OptSpecifier(options.ID.OPT_dynamic.getValue()), new OptSpecifier(options.ID.OPT_mdynamic_no_pic.getValue()))) != null) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(306))), (StringRef)new StringRef(A.getAsString(Args))), (String)"-static"));
            }
            finally {
                $c$.$destroy();
            }
        }
    }

    public static void EscapeSpacesAndBackslashes(char.ptr Arg2, SmallString Res) {
        while (Arg2.$star() != 0) {
            switch (Arg2.$star()) {
                default: {
                    break;
                }
                case 32: 
                case 92: {
                    Res.push_back((byte)92);
                }
            }
            Res.push_back(Arg2.$star());
            Arg2.$preInc();
        }
    }

    public static void QuoteTarget(StringRef Target2, SmallString Res) {
        int e = Target2.size();
        for (int i = 0; i != e; ++i) {
            switch (Target2.$at(i)) {
                case 9: 
                case 32: {
                    for (int j = i - 1; j >= 0 && Target2.$at(j) == 92; --j) {
                        Res.push_back((byte)92);
                    }
                    Res.push_back((byte)92);
                    break;
                }
                case 36: {
                    Res.push_back((byte)36);
                    break;
                }
                case 35: {
                    Res.push_back((byte)92);
                    break;
                }
            }
            Res.push_back(Target2.$at(i));
        }
    }

    public static void addDirectoryList(ArgList Args, ArgStringList CmdArgs, char.ptr ArgName, char.ptr EnvVar) {
        int Delim;
        StringRef Dirs;
        char.ptr DirList = Native.$tryClone((char.ptr)std.getenv((char.ptr)EnvVar));
        boolean CombinedArg = false;
        if (DirList == null) {
            return;
        }
        StringRef Name = new StringRef(ArgName);
        if (Name.equals("-I") || Name.equals("-L")) {
            CombinedArg = true;
        }
        if ((Dirs = new StringRef(DirList)).empty()) {
            return;
        }
        while ((Delim = Dirs.find(sys.EnvPathSeparator)) != StringRef.npos) {
            if (Delim == 0) {
                if (CombinedArg) {
                    CmdArgs.push_back((Object)Args.MakeArgString(new Twine(std.$add_string_T((std.string)new std.string(ArgName), (String)"."))));
                } else {
                    CmdArgs.push_back((Object)ArgName);
                    CmdArgs.push_back((Object)NativePointer.$DOT);
                }
            } else if (CombinedArg) {
                CmdArgs.push_back((Object)Args.MakeArgString(llvm.$add_Twine((Twine)new Twine(new std.string(ArgName)), (Twine)new Twine(Dirs.substr(0, Delim)))));
            } else {
                CmdArgs.push_back((Object)ArgName);
                CmdArgs.push_back((Object)Args.MakeArgString(new Twine(Dirs.substr(0, Delim))));
            }
            Dirs.$assignMove(Dirs.substr(Delim + 1));
        }
        if (Dirs.empty()) {
            if (CombinedArg) {
                CmdArgs.push_back((Object)Args.MakeArgString(new Twine(std.$add_string_T((std.string)new std.string(ArgName), (String)"."))));
            } else {
                CmdArgs.push_back((Object)ArgName);
                CmdArgs.push_back((Object)NativePointer.$DOT);
            }
        } else if (CombinedArg) {
            CmdArgs.push_back((Object)Args.MakeArgString(llvm.$add_Twine((Twine)new Twine(new std.string(ArgName)), (Twine)new Twine(Dirs))));
        } else {
            CmdArgs.push_back((Object)ArgName);
            CmdArgs.push_back((Object)Args.MakeArgString(new Twine(Dirs)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void AddLinkerInputs(ToolChain TC, SmallVector<InputInfo> Inputs, ArgList Args, ArgStringList CmdArgs) {
        Driver D = TC.getDriver();
        Args.AddAllArgValues(CmdArgs, new OptSpecifier(options.ID.OPT_Zlinker_input.getValue()));
        for (InputInfo II : Inputs) {
            if (!TC.HasNativeLLVMSupport() && types.isLLVMIR(II.getType())) {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(346))), (StringRef)new StringRef(TC.getTripleString())));
                }
                finally {
                    $c$.$destroy();
                }
            }
            if (II.isFilename()) {
                CmdArgs.push_back((Object)II.getFilename());
                continue;
            }
            Arg A = II.getInputArg();
            if (A.getOption().matches(new OptSpecifier(options.ID.OPT_Z_reserved_lib_stdcxx.getValue()))) {
                TC.AddCXXStdlibLibArgs(Args, CmdArgs);
                continue;
            }
            if (A.getOption().matches(new OptSpecifier(options.ID.OPT_Z_reserved_lib_cckext.getValue()))) {
                TC.AddCCKextLibArgs(Args, CmdArgs);
                continue;
            }
            if (A.getOption().matches(new OptSpecifier(options.ID.OPT_z.getValue()))) {
                A.claim();
                A.render(Args, CmdArgs);
                continue;
            }
            A.renderAsInput(Args, CmdArgs);
        }
        if (!TC.isCrossCompiling()) {
            ToolsStatics.addDirectoryList(Args, CmdArgs, NativePointer.$((String)"-L"), NativePointer.$((String)"LIBRARY_PATH"));
        }
    }

    public static boolean isObjCAutoRefCount(ArgList Args) {
        return Args.hasFlag(new OptSpecifier(options.ID.OPT_fobjc_arc.getValue()), new OptSpecifier(options.ID.OPT_fno_objc_arc.getValue()), false);
    }

    public static boolean isObjCRuntimeLinked(ArgList Args) {
        if (ToolsStatics.isObjCAutoRefCount(Args)) {
            Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_fobjc_link_runtime.getValue()));
            return true;
        }
        return Args.hasArg(new OptSpecifier(options.ID.OPT_fobjc_link_runtime.getValue()));
    }

    public static boolean forwardToGCC(Option O) {
        return O.getKind() != 1 && !O.hasFlag(16) && !O.hasFlag(32);
    }

    public static void addExtraOffloadCXXStdlibIncludeArgs(Compilation C, JobAction JA, ArgList Args, ArgStringList CmdArgs) {
        if (JA.isHostOffloading(2)) {
            C.getSingleOffloadToolChain(2).AddClangCXXStdlibIncludeArgs(Args, CmdArgs);
        } else if (JA.isDeviceOffloading(2)) {
            C.getSingleOffloadToolChain(1).AddClangCXXStdlibIncludeArgs(Args, CmdArgs);
        }
    }

    public static void addExtraOffloadSpecificIncludeArgs(Compilation C, JobAction JA, ArgList Args, ArgStringList CmdArgs) {
        if (JA.isHostOffloading(2)) {
            C.getSingleOffloadToolChain(1).AddCudaIncludeArgs(Args, CmdArgs);
        } else if (JA.isDeviceOffloading(2)) {
            C.getSingleOffloadToolChain(2).AddCudaIncludeArgs(Args, CmdArgs);
        }
    }

    public static boolean isSignedCharDefault(Triple _Triple) {
        switch (_Triple.getArch()) {
            default: {
                return true;
            }
            case aarch64: 
            case aarch64_be: 
            case arm: 
            case armeb: 
            case thumb: 
            case thumbeb: {
                return _Triple.isOSDarwin() || _Triple.isOSWindows();
            }
            case ppc: 
            case ppc64: {
                return _Triple.isOSDarwin();
            }
            case hexagon: 
            case ppc64le: 
            case systemz: 
            case xcore: 
        }
        return false;
    }

    public static boolean isNoCommonDefault(Triple _Triple) {
        switch (_Triple.getArch()) {
            default: {
                return false;
            }
            case xcore: 
            case wasm32: 
            case wasm64: 
        }
        return true;
    }

    public static int getARMSubArchVersionNumber(Triple _Triple) {
        StringRef Arch = _Triple.getArchName();
        return ARM.parseArchVersion((StringRef)Arch);
    }

    public static boolean isARMMProfile(Triple _Triple) {
        StringRef Arch = _Triple.getArchName();
        int Profile = ARM.parseArchProfile((StringRef)Arch);
        return Profile == ARM.ProfileKind.PK_M.getValue();
    }

    public static void getARMArchCPUFromArgs(ArgList Args, StringRef Arch, StringRef CPU) {
        ToolsStatics.getARMArchCPUFromArgs(Args, Arch, CPU, false);
    }

    public static void getARMArchCPUFromArgs(ArgList Args, StringRef Arch, StringRef CPU, boolean FromAs) {
        Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_mcpu_EQ.getValue()));
        if (A != null) {
            CPU.$assignMove(A.getValue());
        }
        if ((A = Args.getLastArg(new OptSpecifier(options.ID.OPT_march_EQ.getValue()))) != null) {
            Arch.$assignMove(A.getValue());
        }
        if (!FromAs) {
            return;
        }
        for (Arg A2 : Args.filtered(new OptSpecifier(options.ID.OPT_Wa_COMMA.getValue()), new OptSpecifier(options.ID.OPT_Xassembler.getValue()))) {
            StringRef Value = new StringRef(A2.getValue());
            if (Value.startswith("-mcpu=")) {
                CPU.$assignMove(Value.substr(6));
            }
            if (!Value.startswith("-march=")) continue;
            Arch.$assignMove(Value.substr(7));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getARMHWDivFeatures(Driver D, Arg A, ArgList Args, StringRef HWDiv, std.vectorCharPtr Features) {
        int HWDivID = ARM.parseHWDiv((StringRef)HWDiv);
        if (!ARM.getHWDivFeatures((int)HWDivID, (std.vectorCharPtr)Features)) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(310))), (StringRef)new StringRef(A.getAsString(Args))));
            }
            finally {
                $c$.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getARMFPUFeatures(Driver D, Arg A, ArgList Args, StringRef FPU, std.vectorCharPtr Features) {
        int FPUID = ARM.parseFPU((StringRef)FPU);
        if (!ARM.getFPUFeatures((int)FPUID, (std.vectorCharPtr)Features)) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(310))), (StringRef)new StringRef(A.getAsString(Args))));
            }
            finally {
                $c$.$destroy();
            }
        }
    }

    public static boolean DecodeARMFeatures(Driver D, StringRef text, std.vectorCharPtr Features) {
        SmallVector Split = new SmallVector(8, (Object)new StringRef());
        text.split((SmallVectorImpl)Split, "+", -1, false);
        for (StringRef Feature2 : Split) {
            char.ptr FeatureName = Native.$tryClone((char.ptr)ARM.getArchExtFeature((StringRef)Feature2));
            if (FeatureName != null) {
                Features.push_back(FeatureName);
                continue;
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkARMArchName(Driver D, Arg A, ArgList Args, StringRef ArchName, std.vectorCharPtr Features, Triple _Triple) {
        std_pair.pair Split = ArchName.split("+");
        std.string MArch = ArmStatics.getARMArch(new StringRef(ArchName), _Triple);
        if (ARM.parseArch((StringRef)new StringRef(MArch)) == ARM.ArchKind.AK_INVALID.getValue() || ((StringRef)Split.second).size() != 0 && !ToolsStatics.DecodeARMFeatures(D, new StringRef((StringRef)Split.second), Features)) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(310))), (StringRef)new StringRef(A.getAsString(Args))));
            }
            finally {
                $c$.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkARMCPUName(Driver D, Arg A, ArgList Args, StringRef CPUName, StringRef ArchName, std.vectorCharPtr Features, Triple _Triple) {
        std_pair.pair Split = CPUName.split("+");
        std.string CPU = ArmStatics.getARMTargetCPU(new StringRef(CPUName), new StringRef(ArchName), _Triple);
        if (ArmStatics.getLLVMArchSuffixForARM(new StringRef(CPU), new StringRef(ArchName), _Triple).empty() || ((StringRef)Split.second).size() != 0 && !ToolsStatics.DecodeARMFeatures(D, new StringRef((StringRef)Split.second), Features)) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(310))), (StringRef)new StringRef(A.getAsString(Args))));
            }
            finally {
                $c$.$destroy();
            }
        }
    }

    public static boolean useAAPCSForMachO(Triple T) {
        return T.getEnvironment() == Triple.EnvironmentType.EABI || T.getOS() == Triple.OSType.UnknownOS || ToolsStatics.isARMMProfile(T);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getARMTargetFeatures(ToolChain TC, Triple _Triple, ArgList Args, std.vectorCharPtr Features, boolean ForAS) {
        Arg A;
        Driver D = TC.getDriver();
        boolean KernelOrKext = Args.hasArg(new OptSpecifier(options.ID.OPT_mkernel.getValue()), new OptSpecifier(options.ID.OPT_fapple_kext.getValue()));
        ArmStatics.FloatABI ABI = ArmStatics.getARMFloatABI(TC, Args);
        Arg WaCPU = null;
        Arg WaFPU = null;
        Arg WaHDiv = null;
        Arg WaArch = null;
        if (!ForAS) {
            if (ABI == ArmStatics.FloatABI.Soft) {
                Features.push_back(NativePointer.$((String)"+soft-float"));
            }
            if (ABI != ArmStatics.FloatABI.Hard) {
                Features.push_back(NativePointer.$((String)"+soft-float-abi"));
            }
        } else {
            for (Arg A2 : Args.filtered(new OptSpecifier(options.ID.OPT_Wa_COMMA.getValue()), new OptSpecifier(options.ID.OPT_Xassembler.getValue()))) {
                StringRef Value = new StringRef(A2.getValue());
                if (Value.startswith("-mfpu=")) {
                    WaFPU = A2;
                    continue;
                }
                if (Value.startswith("-mcpu=")) {
                    WaCPU = A2;
                    continue;
                }
                if (Value.startswith("-mhwdiv=")) {
                    WaHDiv = A2;
                    continue;
                }
                if (!Value.startswith("-march=")) continue;
                WaArch = A2;
            }
        }
        Arg ArchArg = Args.getLastArg(new OptSpecifier(options.ID.OPT_march_EQ.getValue()));
        StringRef ArchName = new StringRef();
        if (WaArch != null) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                if (ArchArg != null) {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(400))), (StringRef)new StringRef(ArchArg.getAsString(Args))));
                }
                ArchName.$assignMove(new StringRef(WaArch.getValue()).substr(7));
                ToolsStatics.checkARMArchName(D, WaArch, Args, new StringRef(ArchName), Features, _Triple);
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(400))), (StringRef)new StringRef(WaArch.getAsString(Args))));
            }
            finally {
                $c$.$destroy();
            }
        } else if (ArchArg != null) {
            ArchName.$assignMove(ArchArg.getValue());
            ToolsStatics.checkARMArchName(D, ArchArg, Args, new StringRef(ArchName), Features, _Triple);
        }
        Arg CPUArg = Args.getLastArg(new OptSpecifier(options.ID.OPT_mcpu_EQ.getValue()));
        StringRef CPUName = new StringRef();
        if (WaCPU != null) {
            if (CPUArg != null) {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(400))), (StringRef)new StringRef(CPUArg.getAsString(Args))));
                }
                finally {
                    $c$.$destroy();
                }
            }
            CPUName.$assignMove(new StringRef(WaCPU.getValue()).substr(6));
            ToolsStatics.checkARMCPUName(D, WaCPU, Args, new StringRef(CPUName), new StringRef(ArchName), Features, _Triple);
        } else if (CPUArg != null) {
            CPUName.$assignMove(CPUArg.getValue());
            ToolsStatics.checkARMCPUName(D, CPUArg, Args, new StringRef(CPUName), new StringRef(ArchName), Features, _Triple);
        }
        if (llvm.$eq_StringRef((StringRef)CPUName, (String)"native")) {
            StringMapBool HostFeatures = null;
            try {
                HostFeatures = new StringMapBool(false);
                if (sys.getHostCPUFeatures((StringMapBool)HostFeatures)) {
                    for (StringMapEntryBool F : HostFeatures) {
                        Features.push_back(Args.MakeArgString(llvm.$add_char$ptr$C_StringRef((char.ptr)(F.second ? NativePointer.$PLUS : NativePointer.$MINUS), (StringRef)F.first())));
                    }
                }
            }
            finally {
                if (HostFeatures != null) {
                    HostFeatures.$destroy();
                }
            }
        }
        Arg FPUArg = Args.getLastArg(new OptSpecifier(options.ID.OPT_mfpu_EQ.getValue()));
        if (WaFPU != null) {
            if (FPUArg != null) {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(400))), (StringRef)new StringRef(FPUArg.getAsString(Args))));
                }
                finally {
                    $c$.$destroy();
                }
            }
            ToolsStatics.getARMFPUFeatures(D, WaFPU, Args, new StringRef(WaFPU.getValue()).substr(6), Features);
        } else if (FPUArg != null) {
            ToolsStatics.getARMFPUFeatures(D, FPUArg, Args, new StringRef(FPUArg.getValue()), Features);
        }
        Arg HDivArg = Args.getLastArg(new OptSpecifier(options.ID.OPT_mhwdiv_EQ.getValue()));
        if (WaHDiv != null) {
            if (HDivArg != null) {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(400))), (StringRef)new StringRef(HDivArg.getAsString(Args))));
                }
                finally {
                    $c$.$destroy();
                }
            }
            ToolsStatics.getARMHWDivFeatures(D, WaHDiv, Args, new StringRef(WaHDiv.getValue()).substr(8), Features);
        } else if (HDivArg != null) {
            ToolsStatics.getARMHWDivFeatures(D, HDivArg, Args, new StringRef(HDivArg.getValue()), Features);
        }
        if (ABI == ArmStatics.FloatABI.Soft) {
            Features.push_back(NativePointer.$((String)"-neon"));
            Features.push_back(NativePointer.$((String)"-crypto"));
        }
        if ((A = Args.getLastArg(new OptSpecifier(options.ID.OPT_mcrc.getValue()), new OptSpecifier(options.ID.OPT_mnocrc.getValue()))) != null) {
            if (A.getOption().matches(new OptSpecifier(options.ID.OPT_mcrc.getValue()))) {
                Features.push_back(NativePointer.$((String)"+crc"));
            } else {
                Features.push_back(NativePointer.$((String)"-crc"));
            }
        }
        if ((A = Args.getLastArg(new OptSpecifier(options.ID.OPT_mlong_calls.getValue()), new OptSpecifier(options.ID.OPT_mno_long_calls.getValue()))) != null) {
            if (A.getOption().matches(new OptSpecifier(options.ID.OPT_mlong_calls.getValue()))) {
                Features.push_back(NativePointer.$((String)"+long-calls"));
            }
        } else if (KernelOrKext && (!_Triple.isiOS() || _Triple.isOSVersionLT(6)) && !_Triple.isWatchOS()) {
            Features.push_back(NativePointer.$((String)"+long-calls"));
        }
        if (KernelOrKext) {
            Features.push_back(NativePointer.$((String)"+strict-align"));
        } else {
            A = Args.getLastArg(new OptSpecifier(options.ID.OPT_mno_unaligned_access.getValue()), new OptSpecifier(options.ID.OPT_munaligned_access.getValue()));
            if (A != null) {
                if (A.getOption().matches(new OptSpecifier(options.ID.OPT_munaligned_access.getValue()))) {
                    if (_Triple.getSubArch() == Triple.SubArchType.ARMSubArch_v6m) {
                        JavaCleaner $c$ = Native.$createJavaCleaner();
                        try {
                            $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(44))), (String)"v6m"));
                        }
                        finally {
                            $c$.$destroy();
                        }
                    } else if (_Triple.getSubArch() == Triple.SubArchType.ARMSubArch_v8m_baseline) {
                        JavaCleaner $c$ = Native.$createJavaCleaner();
                        try {
                            $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(44))), (String)"v8m.base"));
                        }
                        finally {
                            $c$.$destroy();
                        }
                    }
                } else {
                    Features.push_back(NativePointer.$((String)"+strict-align"));
                }
            } else {
                int VersionNum = ToolsStatics.getARMSubArchVersionNumber(_Triple);
                if (_Triple.isOSDarwin() || _Triple.isOSNetBSD()) {
                    if (VersionNum < 6 || _Triple.getSubArch() == Triple.SubArchType.ARMSubArch_v6m) {
                        Features.push_back(NativePointer.$((String)"+strict-align"));
                    }
                } else if (_Triple.isOSLinux() || _Triple.isOSNaCl()) {
                    if (VersionNum < 7) {
                        Features.push_back(NativePointer.$((String)"+strict-align"));
                    }
                } else {
                    Features.push_back(NativePointer.$((String)"+strict-align"));
                }
            }
        }
        if (Args.hasArg(new OptSpecifier(options.ID.OPT_ffixed_r9.getValue()))) {
            Features.push_back(NativePointer.$((String)"+reserve-r9"));
        }
        if (KernelOrKext || Args.hasArg(new OptSpecifier(options.ID.OPT_mno_movt.getValue()))) {
            Features.push_back(NativePointer.$((String)"+no-movt"));
        }
    }

    public static std.string getAArch64TargetCPU(ArgList Args) {
        std.string CPU = new std.string();
        Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_mtune_EQ.getValue()));
        if (A != null) {
            CPU.$assignMove(new StringRef(A.getValue()).lower());
        } else {
            A = Args.getLastArg(new OptSpecifier(options.ID.OPT_mcpu_EQ.getValue()));
            if (A != null) {
                StringRef Mcpu = new StringRef(A.getValue());
                CPU.$assignMove(((StringRef)Mcpu.split((String)"+").first).lower());
            }
        }
        if (std.$eq_string$C_T((std.string)CPU, (String)"native")) {
            return sys.getHostCPUName().$basic_string();
        }
        if (CPU.size() != 0) {
            return CPU;
        }
        if (Args.getLastArg(new OptSpecifier(options.ID.OPT_arch.getValue())) != null) {
            return new std.string((CharSequence)"cyclone");
        }
        return new std.string(NativePointer.$generic);
    }

    public static StringRef getGnuCompatibleMipsABIName(StringRef ABI) {
        return new StringSwitchStringRef(ABI).Case("o32", "32").Case("n64", "64").Default(ABI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MipsStatics.FloatABI getMipsFloatABI(Driver D, ArgList Args) {
        MipsStatics.FloatABI ABI = MipsStatics.FloatABI.Invalid;
        Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_msoft_float.getValue()), new OptSpecifier(options.ID.OPT_mhard_float.getValue()), new OptSpecifier(options.ID.OPT_mfloat_abi_EQ.getValue()));
        if (A != null) {
            if (A.getOption().matches(new OptSpecifier(options.ID.OPT_msoft_float.getValue()))) {
                ABI = MipsStatics.FloatABI.Soft;
            } else if (A.getOption().matches(new OptSpecifier(options.ID.OPT_mhard_float.getValue()))) {
                ABI = MipsStatics.FloatABI.Hard;
            } else {
                ABI = (MipsStatics.FloatABI)((Object)new StringSwitch(A.getValue()).Case("soft", (Object)MipsStatics.FloatABI.Soft).Case("hard", (Object)MipsStatics.FloatABI.Hard).Default((Object)MipsStatics.FloatABI.Invalid));
                if (ABI == MipsStatics.FloatABI.Invalid && !new StringRef(A.getValue()).empty()) {
                    JavaCleaner $c$ = Native.$createJavaCleaner();
                    try {
                        $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(329))), (StringRef)new StringRef(A.getAsString(Args))));
                        ABI = MipsStatics.FloatABI.Hard;
                    }
                    finally {
                        $c$.$destroy();
                    }
                }
            }
        }
        if (ABI == MipsStatics.FloatABI.Invalid) {
            ABI = MipsStatics.FloatABI.Hard;
        }
        assert (ABI != MipsStatics.FloatABI.Invalid) : "must select an ABI";
        return ABI;
    }

    public static void AddTargetFeature(ArgList Args, std.vectorCharPtr Features, OptSpecifier OnOpt, OptSpecifier OffOpt, StringRef FeatureName) {
        Arg A = Args.getLastArg(OnOpt, OffOpt);
        if (A != null) {
            if (A.getOption().matches(OnOpt)) {
                Features.push_back(Args.MakeArgString(llvm.$add_char$ptr$C_StringRef((char.ptr)NativePointer.$PLUS, (StringRef)FeatureName)));
            } else {
                Features.push_back(Args.MakeArgString(llvm.$add_char$ptr$C_StringRef((char.ptr)NativePointer.$MINUS, (StringRef)FeatureName)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getMIPSTargetFeatures(Driver D, Triple _Triple, ArgList Args, std.vectorCharPtr Features) {
        Arg A;
        StringRef CPUName = new StringRef();
        StringRef ABIName = new StringRef();
        MipsStatics.getMipsCPUAndABI(Args, _Triple, CPUName, ABIName);
        ABIName.$assignMove(ToolsStatics.getGnuCompatibleMipsABIName(ABIName));
        ToolsStatics.AddTargetFeature(Args, Features, new OptSpecifier(options.ID.OPT_mno_abicalls.getValue()), new OptSpecifier(options.ID.OPT_mabicalls.getValue()), new StringRef("noabicalls"));
        MipsStatics.FloatABI FloatABI2 = ToolsStatics.getMipsFloatABI(D, Args);
        if (FloatABI2 == MipsStatics.FloatABI.Soft) {
            Features.push_back(NativePointer.$((String)"+soft-float"));
        }
        if ((A = Args.getLastArg(new OptSpecifier(options.ID.OPT_mnan_EQ.getValue()))) != null) {
            StringRef Val = new StringRef(A.getValue());
            if (llvm.$eq_StringRef((StringRef)Val, (String)"2008")) {
                if ((MipsStatics.getSupportedNanEncoding(CPUName).getValue() & MipsStatics.NanEncoding.Nan2008.getValue()) != 0) {
                    Features.push_back(NativePointer.$((String)"+nan2008"));
                } else {
                    JavaCleaner $c$ = Native.$createJavaCleaner();
                    try {
                        Features.push_back(NativePointer.$((String)"-nan2008"));
                        $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(410))), (StringRef)CPUName));
                    }
                    finally {
                        $c$.$destroy();
                    }
                }
            } else if (llvm.$eq_StringRef((StringRef)Val, (String)"legacy")) {
                if ((MipsStatics.getSupportedNanEncoding(CPUName).getValue() & MipsStatics.NanEncoding.NanLegacy.getValue()) != 0) {
                    Features.push_back(NativePointer.$((String)"-nan2008"));
                } else {
                    JavaCleaner $c$ = Native.$createJavaCleaner();
                    try {
                        Features.push_back(NativePointer.$((String)"+nan2008"));
                        $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(411))), (StringRef)CPUName));
                    }
                    finally {
                        $c$.$destroy();
                    }
                }
            } else {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(366))), (StringRef)A.getOption().getName()), (StringRef)Val));
                }
                finally {
                    $c$.$destroy();
                }
            }
        }
        ToolsStatics.AddTargetFeature(Args, Features, new OptSpecifier(options.ID.OPT_msingle_float.getValue()), new OptSpecifier(options.ID.OPT_mdouble_float.getValue()), new StringRef("single-float"));
        ToolsStatics.AddTargetFeature(Args, Features, new OptSpecifier(options.ID.OPT_mips16.getValue()), new OptSpecifier(options.ID.OPT_mno_mips16.getValue()), new StringRef("mips16"));
        ToolsStatics.AddTargetFeature(Args, Features, new OptSpecifier(options.ID.OPT_mmicromips.getValue()), new OptSpecifier(options.ID.OPT_mno_micromips.getValue()), new StringRef("micromips"));
        ToolsStatics.AddTargetFeature(Args, Features, new OptSpecifier(options.ID.OPT_mdsp.getValue()), new OptSpecifier(options.ID.OPT_mno_dsp.getValue()), new StringRef("dsp"));
        ToolsStatics.AddTargetFeature(Args, Features, new OptSpecifier(options.ID.OPT_mdspr2.getValue()), new OptSpecifier(options.ID.OPT_mno_dspr2.getValue()), new StringRef("dspr2"));
        ToolsStatics.AddTargetFeature(Args, Features, new OptSpecifier(options.ID.OPT_mmsa.getValue()), new OptSpecifier(options.ID.OPT_mno_msa.getValue()), new StringRef("msa"));
        A = Args.getLastArg(new OptSpecifier(options.ID.OPT_mfp32.getValue()), new OptSpecifier(options.ID.OPT_mfpxx.getValue()), new OptSpecifier(options.ID.OPT_mfp64.getValue()));
        if (A != null) {
            if (A.getOption().matches(new OptSpecifier(options.ID.OPT_mfp32.getValue()))) {
                Features.push_back(Args.MakeArgString(new Twine("-fp64")));
            } else if (A.getOption().matches(new OptSpecifier(options.ID.OPT_mfpxx.getValue()))) {
                Features.push_back(Args.MakeArgString(new Twine("+fpxx")));
                Features.push_back(Args.MakeArgString(new Twine("+nooddspreg")));
            } else {
                Features.push_back(Args.MakeArgString(new Twine("+fp64")));
            }
        } else if (MipsStatics.shouldUseFPXX(Args, _Triple, new StringRef(CPUName), new StringRef(ABIName), FloatABI2)) {
            Features.push_back(Args.MakeArgString(new Twine("+fpxx")));
            Features.push_back(Args.MakeArgString(new Twine("+nooddspreg")));
        } else if (MipsStatics.isFP64ADefault(_Triple, new StringRef(CPUName))) {
            Features.push_back(Args.MakeArgString(new Twine("+fp64")));
            Features.push_back(Args.MakeArgString(new Twine("+nooddspreg")));
        }
        ToolsStatics.AddTargetFeature(Args, Features, new OptSpecifier(options.ID.OPT_mno_odd_spreg.getValue()), new OptSpecifier(options.ID.OPT_modd_spreg.getValue()), new StringRef("nooddspreg"));
    }

    public static std.string getPPCTargetCPU(ArgList Args) {
        Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_mcpu_EQ.getValue()));
        if (A != null) {
            StringRef CPUName = new StringRef(A.getValue());
            if (llvm.$eq_StringRef((StringRef)CPUName, (String)"native")) {
                std.string CPU = sys.getHostCPUName().$basic_string();
                if (!CPU.empty() && std.$noteq_string$C_T((std.string)CPU, (String)"generic")) {
                    return CPU;
                }
                return new std.string(NativePointer.$EMPTY);
            }
            return new std.string(new StringSwitchCharPtr(CPUName).Case("common", NativePointer.$generic).Case("440", "440").Case("440fp", "440").Case("450", "450").Case("601", "601").Case("602", "602").Case("603", "603").Case("603e", "603e").Case("603ev", "603ev").Case("604", "604").Case("604e", "604e").Case("620", "620").Case("630", "pwr3").Case("G3", "g3").Case("7400", "7400").Case("G4", "g4").Case("7450", "7450").Case("G4+", "g4+").Case("750", "750").Case("970", "970").Case("G5", "g5").Case("a2", "a2").Case("a2q", "a2q").Case("e500mc", "e500mc").Case("e5500", "e5500").Case("power3", "pwr3").Case("power4", "pwr4").Case("power5", "pwr5").Case("power5x", "pwr5x").Case("power6", "pwr6").Case("power6x", "pwr6x").Case("power7", "pwr7").Case("power8", "pwr8").Case("power9", "pwr9").Case("pwr3", "pwr3").Case("pwr4", "pwr4").Case("pwr5", "pwr5").Case("pwr5x", "pwr5x").Case("pwr6", "pwr6").Case("pwr6x", "pwr6x").Case("pwr7", "pwr7").Case("pwr8", "pwr8").Case("pwr9", "pwr9").Case("powerpc", "ppc").Case("powerpc64", "ppc64").Case("powerpc64le", "ppc64le").Default(NativePointer.$EMPTY));
        }
        return new std.string(NativePointer.$EMPTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getPPCTargetFeatures(Driver D, Triple _Triple, ArgList Args, std.vectorCharPtr Features) {
        ToolsStatics.handleTargetFeaturesGroup(Args, Features, new OptSpecifier(options.ID.OPT_m_ppc_Features_Group.getValue()));
        PpcStatics.FloatABI FloatABI2 = PpcStatics.getPPCFloatABI(D, Args);
        if (FloatABI2 == PpcStatics.FloatABI.Soft && _Triple.getArch() != Triple.ArchType.ppc64 && _Triple.getArch() != Triple.ArchType.ppc64le) {
            Features.push_back(NativePointer.$((String)"+soft-float"));
        } else if (FloatABI2 == PpcStatics.FloatABI.Soft && (_Triple.getArch() == Triple.ArchType.ppc64 || _Triple.getArch() == Triple.ArchType.ppc64le)) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(329))), (String)"soft float is not supported for ppc64"));
            }
            finally {
                $c$.$destroy();
            }
        }
        ToolsStatics.AddTargetFeature(Args, Features, new OptSpecifier(options.ID.OPT_faltivec.getValue()), new OptSpecifier(options.ID.OPT_fno_altivec.getValue()), new StringRef("altivec"));
    }

    public static std.string getR600TargetGPU(ArgList Args) {
        Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_mcpu_EQ.getValue()));
        if (A != null) {
            char.ptr GPUName = Native.$tryClone((char.ptr)A.getValue());
            return new std.string(new StringSwitchCharPtr(GPUName).Cases("rv630", "rv635", "r600").Cases("rv610", "rv620", "rs780", "rs880").Case("rv740", "rv770").Case("palm", "cedar").Cases("sumo", "sumo2", "sumo").Case("hemlock", "cypress").Case("aruba", "cayman").Default(GPUName));
        }
        return new std.string(NativePointer.$EMPTY);
    }

    public static std.string getLanaiTargetCPU(ArgList Args) {
        Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_mcpu_EQ.getValue()));
        if (A != null) {
            return new std.string(A.getValue());
        }
        return new std.string(NativePointer.$EMPTY);
    }

    public static void getSparcTargetFeatures(Driver D, ArgList Args, std.vectorCharPtr Features) {
        SparcStatics.FloatABI FloatABI2 = SparcStatics.getSparcFloatABI(D, Args);
        if (FloatABI2 == SparcStatics.FloatABI.Soft) {
            Features.push_back(NativePointer.$((String)"+soft-float"));
        }
    }

    public static char.ptr getSystemZTargetCPU(ArgList Args) {
        Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_march_EQ.getValue()));
        if (A != null) {
            return A.getValue();
        }
        return NativePointer.$((String)"z10");
    }

    public static void getSystemZTargetFeatures(ArgList Args, std.vectorCharPtr Features) {
        Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_mhtm.getValue()), new OptSpecifier(options.ID.OPT_mno_htm.getValue()));
        if (A != null) {
            if (A.getOption().matches(new OptSpecifier(options.ID.OPT_mhtm.getValue()))) {
                Features.push_back(NativePointer.$((String)"+transactional-execution"));
            } else {
                Features.push_back(NativePointer.$((String)"-transactional-execution"));
            }
        }
        if ((A = Args.getLastArg(new OptSpecifier(options.ID.OPT_mvx.getValue()), new OptSpecifier(options.ID.OPT_mno_vx.getValue()))) != null) {
            if (A.getOption().matches(new OptSpecifier(options.ID.OPT_mvx.getValue()))) {
                Features.push_back(NativePointer.$((String)"+vector"));
            } else {
                Features.push_back(NativePointer.$((String)"-vector"));
            }
        }
    }

    public static char.ptr getX86TargetCPU(ArgList Args, Triple _Triple) {
        boolean Is64Bit;
        Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_march_EQ.getValue()));
        if (A != null) {
            if (llvm.$noteq_StringRef((char.ptr)A.getValue(), (String)"native")) {
                if (_Triple.isOSDarwin() && llvm.$eq_StringRef((StringRef)_Triple.getArchName(), (String)"x86_64h")) {
                    return NativePointer.$((String)"core-avx2");
                }
                return A.getValue();
            }
            std.string CPU = sys.getHostCPUName().$basic_string();
            if (!CPU.empty() && std.$noteq_string$C_T((std.string)CPU, (String)"generic")) {
                return Args.MakeArgString(new Twine(CPU));
            }
        }
        if ((A = Args.getLastArg(new OptSpecifier(options.ID.OPT__SLASH_arch.getValue()))) != null) {
            StringRef Arch = new StringRef(A.getValue());
            char.ptr CPU = _Triple.getArch() == Triple.ArchType.x86 ? Native.$tryClone((char.ptr)new StringSwitchCharPtr(Arch).Case("IA32", "i386").Case("SSE", "pentium3").Case("SSE2", "pentium4").Case("AVX", "sandybridge").Case("AVX2", "haswell").Default((char.ptr)null)) : Native.$tryClone((char.ptr)new StringSwitchCharPtr(Arch).Case("AVX", "sandybridge").Case("AVX2", "haswell").Default((char.ptr)null));
            if (CPU != null) {
                return CPU;
            }
        }
        if (_Triple.getArch() != Triple.ArchType.x86_64 && _Triple.getArch() != Triple.ArchType.x86) {
            return null;
        }
        boolean bl = Is64Bit = _Triple.getArch() == Triple.ArchType.x86_64;
        if (_Triple.isOSDarwin()) {
            if (llvm.$eq_StringRef((StringRef)_Triple.getArchName(), (String)"x86_64h")) {
                return NativePointer.$((String)"core-avx2");
            }
            return Is64Bit ? NativePointer.$((String)"core2") : NativePointer.$((String)"yonah");
        }
        if (_Triple.isPS4CPU()) {
            return NativePointer.$((String)"btver2");
        }
        if (_Triple.isAndroid()) {
            return Is64Bit ? NativePointer.$((String)"x86-64") : NativePointer.$((String)"i686");
        }
        if (Is64Bit) {
            return NativePointer.$((String)"x86-64");
        }
        switch (_Triple.getOS()) {
            case FreeBSD: 
            case NetBSD: 
            case OpenBSD: {
                return NativePointer.$((String)"i486");
            }
            case Haiku: {
                return NativePointer.$((String)"i586");
            }
            case Bitrig: {
                return NativePointer.$((String)"i686");
            }
        }
        return NativePointer.$((String)"pentium4");
    }

    public static StringRef getWebAssemblyTargetCPU(ArgList Args) {
        Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_mcpu_EQ.getValue()));
        if (A != null) {
            StringRef CPU = new StringRef(A.getValue());
            return CPU;
        }
        return new StringRef(NativePointer.$generic);
    }

    public static std.string getCPUName(ArgList Args, Triple T) {
        return ToolsStatics.getCPUName(Args, T, false);
    }

    public static std.string getCPUName(ArgList Args, Triple T, boolean FromAs) {
        switch (T.getArch()) {
            default: {
                return new std.string(NativePointer.$EMPTY);
            }
            case aarch64: 
            case aarch64_be: {
                return ToolsStatics.getAArch64TargetCPU(Args);
            }
            case arm: 
            case armeb: 
            case thumb: 
            case thumbeb: {
                StringRef MArch = new StringRef();
                StringRef MCPU = new StringRef();
                ToolsStatics.getARMArchCPUFromArgs(Args, MArch, MCPU, FromAs);
                return ArmStatics.getARMTargetCPU(new StringRef(MCPU), new StringRef(MArch), T);
            }
            case mips: 
            case mipsel: 
            case mips64: 
            case mips64el: {
                StringRef CPUName = new StringRef();
                StringRef ABIName = new StringRef();
                MipsStatics.getMipsCPUAndABI(Args, T, CPUName, ABIName);
                return CPUName.$basic_string();
            }
            case nvptx: 
            case nvptx64: {
                Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_march_EQ.getValue()));
                if (A != null) {
                    return new std.string(A.getValue());
                }
                return new std.string(NativePointer.$EMPTY);
            }
            case ppc: 
            case ppc64: 
            case ppc64le: {
                std.string TargetCPUName = ToolsStatics.getPPCTargetCPU(Args);
                if (TargetCPUName.empty() && !T.isOSDarwin()) {
                    if (T.getArch() == Triple.ArchType.ppc64) {
                        TargetCPUName.$assign((CharSequence)"ppc64");
                    } else if (T.getArch() == Triple.ArchType.ppc64le) {
                        TargetCPUName.$assign((CharSequence)"ppc64le");
                    } else {
                        TargetCPUName.$assign((CharSequence)"ppc");
                    }
                }
                return TargetCPUName;
            }
            case sparc: 
            case sparcel: 
            case sparcv9: {
                Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_mcpu_EQ.getValue()));
                if (A != null) {
                    return new std.string(A.getValue());
                }
                return new std.string(NativePointer.$EMPTY);
            }
            case x86: 
            case x86_64: {
                return new std.string(ToolsStatics.getX86TargetCPU(Args, T));
            }
            case hexagon: {
                return std.$add_T_string((String)"hexagon", (std.string)HexagonToolChain.GetTargetCPUVersion(Args).str());
            }
            case lanai: {
                return ToolsStatics.getLanaiTargetCPU(Args);
            }
            case systemz: {
                return new std.string(ToolsStatics.getSystemZTargetCPU(Args));
            }
            case r600: 
            case amdgcn: {
                return ToolsStatics.getR600TargetGPU(Args);
            }
            case wasm32: 
            case wasm64: 
        }
        return ToolsStatics.getWebAssemblyTargetCPU(Args).$basic_string();
    }

    public static void AddGoldPlugin(ToolChain ToolChain2, ArgList Args, ArgStringList CmdArgs, boolean IsThinLTO) {
        Arg A;
        CmdArgs.push_back((Object)NativePointer.$((String)"-plugin"));
        std.string Plugin = std.$add_string$C_T((std.string)ToolChain2.getDriver().Dir, (String)"/../lib/LLVMgold.so");
        CmdArgs.push_back((Object)Args.MakeArgString(new Twine(Plugin)));
        std.string CPU = ToolsStatics.getCPUName(Args, ToolChain2.getTriple());
        if (!CPU.empty()) {
            CmdArgs.push_back((Object)Args.MakeArgString(llvm.$add_Twine((Twine)new Twine("-plugin-opt=mcpu="), (Twine)new Twine(CPU))));
        }
        if ((A = Args.getLastArg(new OptSpecifier(options.ID.OPT_O_Group.getValue()))) != null) {
            StringRef OOpt = new StringRef();
            if (A.getOption().matches(new OptSpecifier(options.ID.OPT_O4.getValue())) || A.getOption().matches(new OptSpecifier(options.ID.OPT_Ofast.getValue()))) {
                OOpt.$assignMove(NativePointer.$3);
            } else if (A.getOption().matches(new OptSpecifier(options.ID.OPT_O.getValue()))) {
                OOpt.$assignMove(A.getValue());
            } else if (A.getOption().matches(new OptSpecifier(options.ID.OPT_O0.getValue()))) {
                OOpt.$assignMove(NativePointer.$0);
            }
            if (!OOpt.empty()) {
                CmdArgs.push_back((Object)Args.MakeArgString(llvm.$add_Twine((Twine)new Twine("-plugin-opt=O"), (Twine)new Twine(OOpt))));
            }
        }
        if (IsThinLTO) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-plugin-opt=thinlto"));
        }
        if ((A = Args.getLastArg(new OptSpecifier(options.ID.OPT_gTune_Group.getValue()), new OptSpecifier(options.ID.OPT_ggdbN_Group.getValue()))) != null) {
            if (A.getOption().matches(new OptSpecifier(options.ID.OPT_glldb.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-plugin-opt=-debugger-tune=lldb"));
            } else if (A.getOption().matches(new OptSpecifier(options.ID.OPT_gsce.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-plugin-opt=-debugger-tune=sce"));
            } else {
                CmdArgs.push_back((Object)NativePointer.$((String)"-plugin-opt=-debugger-tune=gdb"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getRefinementStep(StringRef In, Driver D, Arg A, uint.ref Position) {
        byte RefinementStepToken = 58;
        Position.$set(In.find(RefinementStepToken));
        if (Position.$deref() != StringRef.npos) {
            StringRef Option2 = A.getOption().getName();
            StringRef RefStep = In.substr(Position.$deref() + 1);
            if (RefStep.size() != 1) {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(337))), (StringRef)Option2), (StringRef)RefStep));
                    boolean bl = false;
                    return bl;
                }
                finally {
                    $c$.$destroy();
                }
            }
            byte RefStepChar = RefStep.$at(0);
            if (RefStepChar < 48 || RefStepChar > 57) {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(337))), (StringRef)Option2), (StringRef)RefStep));
                    boolean bl = false;
                    return bl;
                }
                finally {
                    $c$.$destroy();
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void ParseMRecip(Driver D, ArgList Args, ArgStringList OutStrings) {
        StringMapBool OptionStrings = null;
        try {
            StringRef DisabledPrefixIn = new StringRef(NativePointer.$EXCLAIM);
            StringRef DisabledPrefixOut = new StringRef(NativePointer.$EXCLAIM);
            StringRef EnabledPrefixOut = new StringRef(NativePointer.$EMPTY);
            StringRef Out = new StringRef("-mrecip=");
            Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_mrecip.getValue()), new OptSpecifier(options.ID.OPT_mrecip_EQ.getValue()));
            if (A == null) {
                return;
            }
            int NumOptions = A.getNumValues();
            if (NumOptions == 0) {
                OutStrings.push_back((Object)Args.MakeArgString(llvm.$add_StringRef_char$ptr$C((StringRef)Out, (String)"all")));
                return;
            }
            if (NumOptions == 1) {
                uint.ref RefStepLoc;
                StringRef Val = new StringRef(A.getValue(0));
                if (!ToolsStatics.getRefinementStep(new StringRef(Val), D, A, RefStepLoc = NativePointer.create_uint$ref())) {
                    return;
                }
                StringRef ValBase = Val.slice(0, RefStepLoc.$deref());
                if (llvm.$eq_StringRef((StringRef)ValBase, (String)"all") || llvm.$eq_StringRef((StringRef)ValBase, (String)"none") || llvm.$eq_StringRef((StringRef)ValBase, (String)"default")) {
                    OutStrings.push_back((Object)Args.MakeArgString(llvm.$add_Twine((Twine)new Twine(Out), (Twine)new Twine(Val))));
                    return;
                }
            }
            OptionStrings = new StringMapBool(false);
            OptionStrings.$set("divd", false);
            OptionStrings.$set("divf", false);
            OptionStrings.$set("vec-divd", false);
            OptionStrings.$set("vec-divf", false);
            OptionStrings.$set("sqrtd", false);
            OptionStrings.$set("sqrtf", false);
            OptionStrings.$set("vec-sqrtd", false);
            OptionStrings.$set("vec-sqrtf", false);
            for (int i = 0; i != NumOptions; ++i) {
                JavaCleaner $c$;
                uint.ref RefStep;
                StringRef Val = new StringRef(A.getValue(i));
                boolean IsDisabled = Val.startswith(DisabledPrefixIn);
                if (IsDisabled) {
                    Val.$assignMove(Val.substr(1));
                }
                if (!ToolsStatics.getRefinementStep(new StringRef(Val), D, A, RefStep = NativePointer.create_uint$ref())) {
                    return;
                }
                StringRef ValBase = Val.slice(0, RefStep.$deref());
                StringMapIteratorBool OptionIter = OptionStrings.find(ValBase);
                if (OptionIter.$eq((StringMapConstIteratorBool)OptionStrings.end())) {
                    OptionIter.$assignMove(OptionStrings.find(new StringRef(std.$add_string_T((std.string)ValBase.str(), (byte)102))));
                    if (OptionIter.$eq((StringMapConstIteratorBool)OptionStrings.end())) {
                        $c$ = Native.$createJavaCleaner();
                        try {
                            $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(358))), (StringRef)Val));
                            return;
                        }
                        finally {
                            $c$.$destroy();
                        }
                    }
                    if (OptionStrings.$at(new StringRef(std.$add_string_T((std.string)ValBase.str(), (byte)100)))) {
                        $c$ = Native.$createJavaCleaner();
                        try {
                            $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(337))), (StringRef)A.getOption().getName()), (StringRef)Val));
                            return;
                        }
                        finally {
                            $c$.$destroy();
                        }
                    }
                }
                if (OptionIter.$arrow().second) {
                    $c$ = Native.$createJavaCleaner();
                    try {
                        $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(337))), (StringRef)A.getOption().getName()), (StringRef)Val));
                        return;
                    }
                    finally {
                        $c$.$destroy();
                    }
                }
                OptionIter.$arrow().second = true;
                if (ValBase.back() != 102 && ValBase.back() != 100) {
                    OptionStrings.$set(new StringRef(std.$add_string_T((std.string)ValBase.str(), (byte)100)), true);
                }
                StringRef Prefix = new StringRef(IsDisabled ? DisabledPrefixOut : EnabledPrefixOut);
                Out.$assignMove(Args.MakeArgString(llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)new Twine(Out), (Twine)new Twine(Prefix)), (Twine)new Twine(Val))));
                if (i == NumOptions - 1) continue;
                Out.$assignMove(Args.MakeArgString(llvm.$add_StringRef_char$ptr$C((StringRef)Out, (char.ptr)NativePointer.$COMMA)));
            }
            OutStrings.push_back((Object)Args.MakeArgString(new Twine(Out)));
            return;
        }
        finally {
            if (OptionStrings != null) {
                OptionStrings.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getX86TargetFeatures(Driver D, Triple _Triple, ArgList Args, std.vectorCharPtr Features) {
        Arg A;
        Arg A2 = Args.getLastArg(new OptSpecifier(options.ID.OPT_march_EQ.getValue()));
        if (A2 != null && llvm.$eq_StringRef((char.ptr)A2.getValue(), (String)"native")) {
            StringMapBool HostFeatures = null;
            try {
                HostFeatures = new StringMapBool(false);
                if (sys.getHostCPUFeatures((StringMapBool)HostFeatures)) {
                    for (StringMapEntryBool F : HostFeatures) {
                        Features.push_back(Args.MakeArgString(llvm.$add_char$ptr$C_StringRef((char.ptr)(F.second ? NativePointer.$PLUS : NativePointer.$MINUS), (StringRef)F.first())));
                    }
                }
            }
            finally {
                if (HostFeatures != null) {
                    HostFeatures.$destroy();
                }
            }
        }
        if (llvm.$eq_StringRef((StringRef)_Triple.getArchName(), (String)"x86_64h")) {
            Features.push_back(NativePointer.$((String)"-rdrnd"));
            Features.push_back(NativePointer.$((String)"-aes"));
            Features.push_back(NativePointer.$((String)"-pclmul"));
            Features.push_back(NativePointer.$((String)"-rtm"));
            Features.push_back(NativePointer.$((String)"-hle"));
            Features.push_back(NativePointer.$((String)"-fsgsbase"));
        }
        Triple.ArchType _ArchType = _Triple.getArch();
        if (_Triple.isAndroid()) {
            if (_ArchType == Triple.ArchType.x86_64) {
                Features.push_back(NativePointer.$((String)"+sse4.2"));
                Features.push_back(NativePointer.$((String)"+popcnt"));
            } else {
                Features.push_back(NativePointer.$((String)"+ssse3"));
            }
        }
        if ((A = Args.getLastArg(new OptSpecifier(options.ID.OPT__SLASH_arch.getValue()))) != null) {
            StringRef Arch = new StringRef(A.getValue());
            boolean ArchUsed = false;
            if ((_ArchType == Triple.ArchType.x86_64 || _ArchType == Triple.ArchType.x86) && (llvm.$eq_StringRef((StringRef)Arch, (String)"AVX") || llvm.$eq_StringRef((StringRef)Arch, (String)"AVX2"))) {
                ArchUsed = true;
                Features.push_back(Args.MakeArgString(new Twine(std.$add_T_string((String)"+", (std.string)Arch.lower()))));
            }
            if (_ArchType == Triple.ArchType.x86) {
                if (llvm.$eq_StringRef((StringRef)Arch, (String)"IA32")) {
                    ArchUsed = true;
                } else if (llvm.$eq_StringRef((StringRef)Arch, (String)"SSE") || llvm.$eq_StringRef((StringRef)Arch, (String)"SSE2")) {
                    ArchUsed = true;
                    Features.push_back(Args.MakeArgString(new Twine(std.$add_T_string((String)"+", (std.string)Arch.lower()))));
                }
            }
            if (!ArchUsed) {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(400))), (StringRef)new StringRef(A.getAsString(Args))));
                }
                finally {
                    $c$.$destroy();
                }
            }
        }
        ToolsStatics.handleTargetFeaturesGroup(Args, Features, new OptSpecifier(options.ID.OPT_m_x86_Features_Group.getValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean DecodeAArch64Features(Driver D, StringRef text, std.vectorCharPtr Features) {
        SmallVector Split = new SmallVector(8, (Object)new StringRef());
        text.split((SmallVectorImpl)Split, "+", -1, false);
        for (StringRef Feature2 : Split) {
            char.ptr result = Native.$tryClone((char.ptr)new StringSwitchCharPtr(Feature2).Case("fp", "+fp-armv8").Case("simd", "+neon").Case("crc", "+crc").Case("crypto", "+crypto").Case("fp16", "+fullfp16").Case("profile", "+spe").Case("ras", "+ras").Case("nofp", "-fp-armv8").Case("nosimd", "-neon").Case("nocrc", "-crc").Case("nocrypto", "-crypto").Case("nofp16", "-fullfp16").Case("noprofile", "-spe").Case("noras", "-ras").Default((char.ptr)null));
            if (result != null) {
                Features.push_back(result);
                continue;
            }
            if (llvm.$eq_StringRef((StringRef)Feature2, (String)"neon") || llvm.$eq_StringRef((StringRef)Feature2, (String)"noneon")) {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean($c$.track((Object)D.Diag(348)));
                    continue;
                }
                finally {
                    $c$.$destroy();
                    continue;
                }
            }
            return false;
        }
        return true;
    }

    public static boolean DecodeAArch64Mcpu(Driver D, StringRef Mcpu, StringRef CPU, std.vectorCharPtr Features) {
        std_pair.pair Split = Mcpu.split("+");
        CPU.$assign((StringRef)Split.first);
        if (llvm.$eq_StringRef((StringRef)CPU, (String)"cortex-a53") || llvm.$eq_StringRef((StringRef)CPU, (String)"cortex-a57") || llvm.$eq_StringRef((StringRef)CPU, (String)"cortex-a72") || llvm.$eq_StringRef((StringRef)CPU, (String)"cortex-a35") || llvm.$eq_StringRef((StringRef)CPU, (String)"exynos-m1") || llvm.$eq_StringRef((StringRef)CPU, (String)"kryo") || llvm.$eq_StringRef((StringRef)CPU, (String)"cortex-a73") || llvm.$eq_StringRef((StringRef)CPU, (String)"vulcan")) {
            Features.push_back(NativePointer.$((String)"+neon"));
            Features.push_back(NativePointer.$((String)"+crc"));
            Features.push_back(NativePointer.$((String)"+crypto"));
        } else if (llvm.$eq_StringRef((StringRef)CPU, (String)"cyclone")) {
            Features.push_back(NativePointer.$((String)"+neon"));
            Features.push_back(NativePointer.$((String)"+crypto"));
        } else if (llvm.$eq_StringRef((StringRef)CPU, (String)"generic")) {
            Features.push_back(NativePointer.$((String)"+neon"));
        } else {
            return false;
        }
        return ((StringRef)Split.second).size() == 0 || ToolsStatics.DecodeAArch64Features(D, new StringRef((StringRef)Split.second), Features);
    }

    public static boolean getAArch64ArchFeaturesFromMarch(Driver D, StringRef March, ArgList Args, std.vectorCharPtr Features) {
        std.string MarchLowerCase = March.lower();
        std_pair.pair Split = new StringRef(MarchLowerCase).split("+");
        if (!llvm.$eq_StringRef((StringRef)((StringRef)Split.first), (String)"armv8-a") && !llvm.$eq_StringRef((StringRef)((StringRef)Split.first), (String)"armv8a")) {
            if (llvm.$eq_StringRef((StringRef)((StringRef)Split.first), (String)"armv8.1-a") || llvm.$eq_StringRef((StringRef)((StringRef)Split.first), (String)"armv8.1a")) {
                Features.push_back(NativePointer.$((String)"+v8.1a"));
            } else if (llvm.$eq_StringRef((StringRef)((StringRef)Split.first), (String)"armv8.2-a") || llvm.$eq_StringRef((StringRef)((StringRef)Split.first), (String)"armv8.2a")) {
                Features.push_back(NativePointer.$((String)"+v8.2a"));
            } else {
                return false;
            }
        }
        return ((StringRef)Split.second).size() == 0 || ToolsStatics.DecodeAArch64Features(D, new StringRef((StringRef)Split.second), Features);
    }

    public static boolean getAArch64ArchFeaturesFromMcpu(Driver D, StringRef Mcpu, ArgList Args, std.vectorCharPtr Features) {
        StringRef CPU = new StringRef();
        std.string McpuLowerCase = Mcpu.lower();
        return ToolsStatics.DecodeAArch64Mcpu(D, new StringRef(McpuLowerCase), CPU, Features);
    }

    public static boolean getAArch64MicroArchFeaturesFromMtune(Driver D, StringRef Mtune, ArgList Args, std.vectorCharPtr Features) {
        std.string MtuneLowerCase = Mtune.lower();
        if (std.$eq_string$C_T((std.string)MtuneLowerCase, (String)"native")) {
            MtuneLowerCase.$assignMove(sys.getHostCPUName().$basic_string());
        }
        if (std.$eq_string$C_T((std.string)MtuneLowerCase, (String)"cyclone")) {
            Features.push_back(NativePointer.$((String)"+zcm"));
            Features.push_back(NativePointer.$((String)"+zcz"));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getAArch64MicroArchFeaturesFromMcpu(Driver D, StringRef Mcpu, ArgList Args, std.vectorCharPtr Features) {
        std.vectorCharPtr DecodedFeature = null;
        try {
            StringRef CPU = new StringRef();
            DecodedFeature = new std.vectorCharPtr();
            std.string McpuLowerCase = Mcpu.lower();
            if (!ToolsStatics.DecodeAArch64Mcpu(D, new StringRef(McpuLowerCase), CPU, DecodedFeature)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = ToolsStatics.getAArch64MicroArchFeaturesFromMtune(D, new StringRef(CPU), Args, Features);
            return bl;
        }
        finally {
            if (DecodedFeature != null) {
                DecodedFeature.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getAArch64TargetFeatures(Driver D, ArgList Args, std.vectorCharPtr Features) {
        boolean success = true;
        Features.push_back(NativePointer.$((String)"+neon"));
        Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_march_EQ.getValue()));
        if (A != null) {
            success = ToolsStatics.getAArch64ArchFeaturesFromMarch(D, new StringRef(A.getValue()), Args, Features);
        } else {
            A = Args.getLastArg(new OptSpecifier(options.ID.OPT_mcpu_EQ.getValue()));
            if (A != null) {
                success = ToolsStatics.getAArch64ArchFeaturesFromMcpu(D, new StringRef(A.getValue()), Args, Features);
            } else if (Args.hasArg(new OptSpecifier(options.ID.OPT_arch.getValue()))) {
                success = ToolsStatics.getAArch64ArchFeaturesFromMcpu(D, new StringRef(ToolsStatics.getAArch64TargetCPU(Args)), Args, Features);
            }
        }
        if (success && (A = Args.getLastArg(new OptSpecifier(options.ID.OPT_mtune_EQ.getValue()))) != null) {
            success = ToolsStatics.getAArch64MicroArchFeaturesFromMtune(D, new StringRef(A.getValue()), Args, Features);
        } else if (success && (A = Args.getLastArg(new OptSpecifier(options.ID.OPT_mcpu_EQ.getValue()))) != null) {
            success = ToolsStatics.getAArch64MicroArchFeaturesFromMcpu(D, new StringRef(A.getValue()), Args, Features);
        } else if (Args.hasArg(new OptSpecifier(options.ID.OPT_arch.getValue()))) {
            success = ToolsStatics.getAArch64MicroArchFeaturesFromMcpu(D, new StringRef(ToolsStatics.getAArch64TargetCPU(Args)), Args, Features);
        }
        if (!success) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(310))), (StringRef)new StringRef(A.getAsString(Args))));
            }
            finally {
                $c$.$destroy();
            }
        }
        if (Args.getLastArg(new OptSpecifier(options.ID.OPT_mgeneral_regs_only.getValue())) != null) {
            Features.push_back(NativePointer.$((String)"-fp-armv8"));
            Features.push_back(NativePointer.$((String)"-crypto"));
            Features.push_back(NativePointer.$((String)"-neon"));
        }
        if ((A = Args.getLastArg(new OptSpecifier(options.ID.OPT_mcrc.getValue()), new OptSpecifier(options.ID.OPT_mnocrc.getValue()))) != null) {
            if (A.getOption().matches(new OptSpecifier(options.ID.OPT_mcrc.getValue()))) {
                Features.push_back(NativePointer.$((String)"+crc"));
            } else {
                Features.push_back(NativePointer.$((String)"-crc"));
            }
        }
        if ((A = Args.getLastArg(new OptSpecifier(options.ID.OPT_mno_unaligned_access.getValue()), new OptSpecifier(options.ID.OPT_munaligned_access.getValue()))) != null && A.getOption().matches(new OptSpecifier(options.ID.OPT_mno_unaligned_access.getValue()))) {
            Features.push_back(NativePointer.$((String)"+strict-align"));
        }
        if (Args.hasArg(new OptSpecifier(options.ID.OPT_ffixed_x18.getValue()))) {
            Features.push_back(NativePointer.$((String)"+reserve-x18"));
        }
    }

    public static void getHexagonTargetFeatures(ArgList Args, std.vectorCharPtr Features) {
        boolean HasHVX = false;
        boolean HasHVXD = false;
        for (Arg A : Args) {
            Option Opt = A.getOption();
            if (Opt.matches(new OptSpecifier(options.ID.OPT_mhexagon_hvx.getValue()))) {
                HasHVX = true;
            } else if (Opt.matches(new OptSpecifier(options.ID.OPT_mno_hexagon_hvx.getValue()))) {
                HasHVX = false;
                HasHVXD = false;
            } else if (Opt.matches(new OptSpecifier(options.ID.OPT_mhexagon_hvx_double.getValue()))) {
                HasHVX = true;
                HasHVXD = true;
            } else {
                if (!Opt.matches(new OptSpecifier(options.ID.OPT_mno_hexagon_hvx_double.getValue()))) continue;
                HasHVXD = false;
            }
            A.claim();
        }
        Features.push_back(HasHVX ? NativePointer.$((String)"+hvx") : NativePointer.$((String)"-hvx"));
        Features.push_back(HasHVXD ? NativePointer.$((String)"+hvx-double") : NativePointer.$((String)"-hvx-double"));
    }

    public static void getWebAssemblyTargetFeatures(ArgList Args, std.vectorCharPtr Features) {
        ToolsStatics.handleTargetFeaturesGroup(Args, Features, new OptSpecifier(options.ID.OPT_m_wasm_Features_Group.getValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getAMDGPUTargetFeatures(Driver D, ArgList Args, std.vectorCharPtr Features) {
        Arg dAbi = Args.getLastArg(new OptSpecifier(options.ID.OPT_mamdgpu_debugger_abi.getValue()));
        if (dAbi != null) {
            StringRef value = new StringRef(dAbi.getValue());
            if (llvm.$eq_StringRef((StringRef)value, (String)"1.0")) {
                Features.push_back(NativePointer.$((String)"+amdgpu-debugger-insert-nops"));
                Features.push_back(NativePointer.$((String)"+amdgpu-debugger-reserve-regs"));
                Features.push_back(NativePointer.$((String)"+amdgpu-debugger-emit-prologue"));
            } else {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(310))), (StringRef)new StringRef(dAbi.getAsString(Args))));
                }
                finally {
                    $c$.$destroy();
                }
            }
        }
        ToolsStatics.handleTargetFeaturesGroup(Args, Features, new OptSpecifier(options.ID.OPT_m_amdgpu_Features_Group.getValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getTargetFeatures(ToolChain TC, Triple Triple2, ArgList Args, ArgStringList CmdArgs, boolean ForAS) {
        std.vectorCharPtr Features = null;
        StringMapUInt LastOpt = null;
        try {
            char.ptr Name;
            Driver D = TC.getDriver();
            Features = new std.vectorCharPtr();
            switch (Triple2.getArch()) {
                default: {
                    break;
                }
                case mips: 
                case mipsel: 
                case mips64: 
                case mips64el: {
                    ToolsStatics.getMIPSTargetFeatures(D, Triple2, Args, Features);
                    break;
                }
                case arm: 
                case armeb: 
                case thumb: 
                case thumbeb: {
                    ToolsStatics.getARMTargetFeatures(TC, Triple2, Args, Features, ForAS);
                    break;
                }
                case ppc: 
                case ppc64: 
                case ppc64le: {
                    ToolsStatics.getPPCTargetFeatures(D, Triple2, Args, Features);
                    break;
                }
                case systemz: {
                    ToolsStatics.getSystemZTargetFeatures(Args, Features);
                    break;
                }
                case aarch64: 
                case aarch64_be: {
                    ToolsStatics.getAArch64TargetFeatures(D, Args, Features);
                    break;
                }
                case x86: 
                case x86_64: {
                    ToolsStatics.getX86TargetFeatures(D, Triple2, Args, Features);
                    break;
                }
                case hexagon: {
                    ToolsStatics.getHexagonTargetFeatures(Args, Features);
                    break;
                }
                case wasm32: 
                case wasm64: {
                    ToolsStatics.getWebAssemblyTargetFeatures(Args, Features);
                    break;
                }
                case sparc: 
                case sparcel: 
                case sparcv9: {
                    ToolsStatics.getSparcTargetFeatures(D, Args, Features);
                    break;
                }
                case r600: 
                case amdgcn: {
                    ToolsStatics.getAMDGPUTargetFeatures(D, Args, Features);
                }
            }
            LastOpt = new StringMapUInt(0);
            int I = 0;
            int N = Features.size();
            while (Unsigned.$less_uint((int)I, (int)N)) {
                Name = Native.$tryClone((char.ptr)Features.$at(I));
                assert (Name.$at(0) == 45 || Name.$at(0) == 43);
                LastOpt.$set((char.ptr)Name.$add(1), I);
                ++I;
            }
            I = 0;
            N = Features.size();
            while (Unsigned.$less_uint((int)I, (int)N)) {
                Name = Native.$tryClone((char.ptr)Features.$at(I));
                StringMapIteratorUInt LastI = LastOpt.find((char.ptr)Name.$add(1));
                assert (LastI.$noteq((StringMapConstIteratorUInt)LastOpt.end()));
                int Last = LastI.$arrow().second;
                if (Last == I) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-target-feature"));
                    CmdArgs.push_back((Object)Name);
                }
                ++I;
            }
        }
        finally {
            if (LastOpt != null) {
                LastOpt.$destroy();
            }
            if (Features != null) {
                Features.$destroy();
            }
        }
    }

    public static boolean shouldUseExceptionTablesForObjCExceptions(ObjCRuntime runtime, Triple _Triple) {
        if (runtime.isNonFragile()) {
            return true;
        }
        if (!_Triple.isMacOSX()) {
            return false;
        }
        return !_Triple.isMacOSXVersionLT(10, 5) && (_Triple.getArch() == Triple.ArchType.x86_64 || _Triple.getArch() == Triple.ArchType.arm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addExceptionArgs(ArgList Args, types.ID InputType, ToolChain TC, boolean KernelOrKext, ObjCRuntime objcRuntime, ArgStringList CmdArgs) {
        Driver D = TC.getDriver();
        Triple _Triple = TC.getTriple();
        if (KernelOrKext) {
            Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_fexceptions.getValue()));
            Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_fno_exceptions.getValue()));
            Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_fobjc_exceptions.getValue()));
            Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_fno_objc_exceptions.getValue()));
            Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_fcxx_exceptions.getValue()));
            Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_fno_cxx_exceptions.getValue()));
            return;
        }
        boolean EH = Args.hasFlag(new OptSpecifier(options.ID.OPT_fexceptions.getValue()), new OptSpecifier(options.ID.OPT_fno_exceptions.getValue()), false);
        if (types.isObjC(InputType) && Args.hasFlag(new OptSpecifier(options.ID.OPT_fobjc_exceptions.getValue()), new OptSpecifier(options.ID.OPT_fno_objc_exceptions.getValue()), true)) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-fobjc-exceptions"));
            EH |= ToolsStatics.shouldUseExceptionTablesForObjCExceptions(objcRuntime, _Triple);
        }
        if (types.isCXX(InputType)) {
            boolean CXXExceptionsEnabled = _Triple.getArch() != Triple.ArchType.xcore && !_Triple.isPS4CPU();
            Arg ExceptionArg = Args.getLastArg(new OptSpecifier(options.ID.OPT_fcxx_exceptions.getValue()), new OptSpecifier(options.ID.OPT_fno_cxx_exceptions.getValue()), new OptSpecifier(options.ID.OPT_fexceptions.getValue()), new OptSpecifier(options.ID.OPT_fno_exceptions.getValue()));
            if (ExceptionArg != null) {
                boolean bl = CXXExceptionsEnabled = ExceptionArg.getOption().matches(new OptSpecifier(options.ID.OPT_fcxx_exceptions.getValue())) || ExceptionArg.getOption().matches(new OptSpecifier(options.ID.OPT_fexceptions.getValue()));
            }
            if (CXXExceptionsEnabled) {
                if (_Triple.isPS4CPU()) {
                    ToolChain.RTTIMode RTTIMode2 = TC.getRTTIMode();
                    assert (ExceptionArg != null) : "On the PS4 exceptions should only be enabled if passing an argument";
                    if (RTTIMode2 == ToolChain.RTTIMode.RM_DisabledExplicitly) {
                        JavaCleaner $c$ = Native.$createJavaCleaner();
                        try {
                            Arg RTTIArg = TC.getRTTIArg();
                            assert (RTTIArg != null) : "RTTI disabled explicitly but no RTTIArg!";
                            $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(306))), (StringRef)new StringRef(RTTIArg.getAsString(Args))), (StringRef)new StringRef(ExceptionArg.getAsString(Args))));
                        }
                        finally {
                            $c$.$destroy();
                        }
                    } else if (RTTIMode2 == ToolChain.RTTIMode.RM_EnabledImplicitly) {
                        JavaCleaner $c$ = Native.$createJavaCleaner();
                        try {
                            $c$.clean($c$.track((Object)D.Diag(385)));
                        }
                        finally {
                            $c$.$destroy();
                        }
                    }
                } else assert (TC.getRTTIMode() != ToolChain.RTTIMode.RM_DisabledImplicitly);
                CmdArgs.push_back((Object)NativePointer.$((String)"-fcxx-exceptions"));
                EH = true;
            }
        }
        if (EH) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-fexceptions"));
        }
    }

    public static boolean ShouldDisableAutolink(ArgList Args, ToolChain TC) {
        boolean Default = true;
        if (TC.getTriple().isOSDarwin()) {
            Default = TC.useIntegratedAs();
        }
        return !Args.hasFlag(new OptSpecifier(options.ID.OPT_fautolink.getValue()), new OptSpecifier(options.ID.OPT_fno_autolink.getValue()), Default);
    }

    public static boolean ShouldDisableDwarfDirectory(ArgList Args, ToolChain TC) {
        boolean UseDwarfDirectory = Args.hasFlag(new OptSpecifier(options.ID.OPT_fdwarf_directory_asm.getValue()), new OptSpecifier(options.ID.OPT_fno_dwarf_directory_asm.getValue()), TC.useIntegratedAs());
        return !UseDwarfDirectory;
    }

    public static boolean ContainsCompileAction(Action A) {
        if (llvm.isa(CompileJobAction.class, (Object)A) || llvm.isa(BackendJobAction.class, (Object)A)) {
            return true;
        }
        for (Action AI : A.inputs()) {
            if (!ToolsStatics.ContainsCompileAction(AI)) continue;
            return true;
        }
        return false;
    }

    public static boolean UseRelaxAll(Compilation C, ArgList Args) {
        boolean RelaxDefault = true;
        Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_O_Group.getValue()));
        if (A != null) {
            RelaxDefault = A.getOption().matches(new OptSpecifier(options.ID.OPT_O0.getValue()));
        }
        if (RelaxDefault) {
            RelaxDefault = false;
            for (Action Act : C.getActions()) {
                if (!ToolsStatics.ContainsCompileAction(Act)) continue;
                RelaxDefault = true;
                break;
            }
        }
        return Args.hasFlag(new OptSpecifier(options.ID.OPT_mrelax_all.getValue()), new OptSpecifier(options.ID.OPT_mno_relax_all.getValue()), RelaxDefault);
    }

    public static DebugInfoKind DebugLevelToInfoKind(Arg A) {
        assert (A.getOption().matches(new OptSpecifier(options.ID.OPT_gN_Group.getValue()))) : "Not a -g option that specifies a debug-info level";
        if (A.getOption().matches(new OptSpecifier(options.ID.OPT_g0.getValue())) || A.getOption().matches(new OptSpecifier(options.ID.OPT_ggdb0.getValue()))) {
            return DebugInfoKind.NoDebugInfo;
        }
        if (A.getOption().matches(new OptSpecifier(options.ID.OPT_gline_tables_only.getValue())) || A.getOption().matches(new OptSpecifier(options.ID.OPT_ggdb1.getValue()))) {
            return DebugInfoKind.DebugLineTablesOnly;
        }
        return DebugInfoKind.LimitedDebugInfo;
    }

    public static int DwarfVersionNum(StringRef ArgValue) {
        return new StringSwitchUInt(ArgValue).Case("-gdwarf-2", 2).Case("-gdwarf-3", 3).Case("-gdwarf-4", 4).Case("-gdwarf-5", 5).Default(0);
    }

    public static void RenderDebugEnablingArgs(ArgList Args, ArgStringList CmdArgs, DebugInfoKind DebugInfoKind2, int DwarfVersion, DebuggerKind DebuggerTuning) {
        switch (DebugInfoKind2) {
            case DebugLineTablesOnly: {
                CmdArgs.push_back((Object)NativePointer.$((String)"-debug-info-kind=line-tables-only"));
                break;
            }
            case LimitedDebugInfo: {
                CmdArgs.push_back((Object)NativePointer.$((String)"-debug-info-kind=limited"));
                break;
            }
            case FullDebugInfo: {
                CmdArgs.push_back((Object)NativePointer.$((String)"-debug-info-kind=standalone"));
                break;
            }
        }
        if (Unsigned.$greater_uint((int)DwarfVersion, (int)0)) {
            CmdArgs.push_back((Object)Args.MakeArgString(llvm.$add_Twine((Twine)new Twine("-dwarf-version="), (Twine)new Twine(JavaDifferentiators.JD$UInt.INSTANCE, DwarfVersion))));
        }
        switch (DebuggerTuning) {
            case GDB: {
                CmdArgs.push_back((Object)NativePointer.$((String)"-debugger-tuning=gdb"));
                break;
            }
            case LLDB: {
                CmdArgs.push_back((Object)NativePointer.$((String)"-debugger-tuning=lldb"));
                break;
            }
            case SCE: {
                CmdArgs.push_back((Object)NativePointer.$((String)"-debugger-tuning=sce"));
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void CollectArgsForIntegratedAssembler(Compilation C, ArgList Args, ArgStringList CmdArgs, Driver D) {
        if (ToolsStatics.UseRelaxAll(C, Args)) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-mrelax-all"));
        }
        boolean DefaultIncrementalLinkerCompatible = C.getDefaultToolChain().getTriple().isWindowsMSVCEnvironment();
        if (Args.hasFlag(new OptSpecifier(options.ID.OPT_mincremental_linker_compatible.getValue()), new OptSpecifier(options.ID.OPT_mno_incremental_linker_compatible.getValue()), DefaultIncrementalLinkerCompatible)) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-mincremental-linker-compatible"));
        }
        boolean TakeNextArg = false;
        boolean CompressDebugSections = false;
        boolean UseRelaxRelocations = false;
        char.ptr MipsTargetFeature = null;
        for (Arg A : Args.filtered(new OptSpecifier(options.ID.OPT_Wa_COMMA.getValue()), new OptSpecifier(options.ID.OPT_Xassembler.getValue()))) {
            A.claim();
            block10: for (char.ptr _Value : A.getValues()) {
                StringRef Value = new StringRef(_Value);
                if (TakeNextArg) {
                    CmdArgs.push_back((Object)Value.data());
                    TakeNextArg = false;
                    continue;
                }
                switch (C.getDefaultToolChain().getArch()) {
                    default: {
                        break;
                    }
                    case mips: 
                    case mipsel: 
                    case mips64: 
                    case mips64el: {
                        if (llvm.$eq_StringRef((StringRef)Value, (String)"--trap")) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-target-feature"));
                            CmdArgs.push_back((Object)NativePointer.$((String)"+use-tcc-in-div"));
                            continue block10;
                        }
                        if (llvm.$eq_StringRef((StringRef)Value, (String)"--break")) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-target-feature"));
                            CmdArgs.push_back((Object)NativePointer.$((String)"-use-tcc-in-div"));
                            continue block10;
                        }
                        if (Value.startswith("-msoft-float")) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-target-feature"));
                            CmdArgs.push_back((Object)NativePointer.$((String)"+soft-float"));
                            continue block10;
                        }
                        if (Value.startswith("-mhard-float")) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-target-feature"));
                            CmdArgs.push_back((Object)NativePointer.$((String)"-soft-float"));
                            continue block10;
                        }
                        MipsTargetFeature = Native.$tryClone((char.ptr)new StringSwitchCharPtr(Value).Case("-mips1", "+mips1").Case("-mips2", "+mips2").Case("-mips3", "+mips3").Case("-mips4", "+mips4").Case("-mips5", "+mips5").Case("-mips32", "+mips32").Case("-mips32r2", "+mips32r2").Case("-mips32r3", "+mips32r3").Case("-mips32r5", "+mips32r5").Case("-mips32r6", "+mips32r6").Case("-mips64", "+mips64").Case("-mips64r2", "+mips64r2").Case("-mips64r3", "+mips64r3").Case("-mips64r5", "+mips64r5").Case("-mips64r6", "+mips64r6").Default((char.ptr)null));
                        if (MipsTargetFeature != null) continue block10;
                    }
                }
                if (llvm.$eq_StringRef((StringRef)Value, (String)"-force_cpusubtype_ALL")) continue;
                if (llvm.$eq_StringRef((StringRef)Value, (String)"-L")) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-msave-temp-labels"));
                    continue;
                }
                if (llvm.$eq_StringRef((StringRef)Value, (String)"--fatal-warnings")) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-massembler-fatal-warnings"));
                    continue;
                }
                if (llvm.$eq_StringRef((StringRef)Value, (String)"--noexecstack")) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-mnoexecstack"));
                    continue;
                }
                if (llvm.$eq_StringRef((StringRef)Value, (String)"-compress-debug-sections") || llvm.$eq_StringRef((StringRef)Value, (String)"--compress-debug-sections")) {
                    CompressDebugSections = true;
                    continue;
                }
                if (llvm.$eq_StringRef((StringRef)Value, (String)"-nocompress-debug-sections") || llvm.$eq_StringRef((StringRef)Value, (String)"--nocompress-debug-sections")) {
                    CompressDebugSections = false;
                    continue;
                }
                if (llvm.$eq_StringRef((StringRef)Value, (String)"-mrelax-relocations=yes") || llvm.$eq_StringRef((StringRef)Value, (String)"--mrelax-relocations=yes")) {
                    UseRelaxRelocations = true;
                    continue;
                }
                if (llvm.$eq_StringRef((StringRef)Value, (String)"-mrelax-relocations=no") || llvm.$eq_StringRef((StringRef)Value, (String)"--mrelax-relocations=no")) {
                    UseRelaxRelocations = false;
                    continue;
                }
                if (Value.startswith("-I")) {
                    CmdArgs.push_back((Object)Value.data());
                    if (!llvm.$eq_StringRef((StringRef)Value, (String)"-I")) continue;
                    TakeNextArg = true;
                    continue;
                }
                if (Value.startswith("-gdwarf-")) {
                    int DwarfVersion = ToolsStatics.DwarfVersionNum(new StringRef(Value));
                    if (DwarfVersion == 0) {
                        CmdArgs.push_back((Object)Value.data());
                        continue;
                    }
                    ToolsStatics.RenderDebugEnablingArgs(Args, CmdArgs, DebugInfoKind.LimitedDebugInfo, DwarfVersion, DebuggerKind.Default);
                    continue;
                }
                if (Value.startswith("-mcpu") || Value.startswith("-mfpu") || Value.startswith("-mhwdiv") || Value.startswith("-march")) continue;
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(366))), (StringRef)A.getOption().getName()), (StringRef)Value));
                }
                finally {
                    $c$.$destroy();
                }
            }
        }
        if (CompressDebugSections) {
            if (ZlibGlobals.isAvailable()) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-compress-debug-sections"));
            } else {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean($c$.track((Object)D.Diag(379)));
                }
                finally {
                    $c$.$destroy();
                }
            }
        }
        if (UseRelaxRelocations) {
            CmdArgs.push_back((Object)NativePointer.$((String)"--mrelax-relocations"));
        }
        if (Native.$noteq_ptr(MipsTargetFeature, null)) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-target-feature"));
            CmdArgs.push_back(MipsTargetFeature);
        }
    }

    public static void addClangRT(ToolChain TC, ArgList Args, ArgStringList CmdArgs) {
        CmdArgs.push_back((Object)TC.getCompilerRTArgString(Args, new StringRef("builtins")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OpenMPRuntimeKind getOpenMPRuntime(ToolChain TC, ArgList Args) {
        OpenMPRuntimeKind RT;
        StringRef RuntimeName = new StringRef("libomp");
        Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_fopenmp_EQ.getValue()));
        if (A != null) {
            RuntimeName.$assignMove(A.getValue());
        }
        if ((RT = (OpenMPRuntimeKind)((Object)new StringSwitch(RuntimeName).Case("libomp", (Object)OpenMPRuntimeKind.OMPRT_OMP).Case("libgomp", (Object)OpenMPRuntimeKind.OMPRT_GOMP).Case("libiomp5", (Object)OpenMPRuntimeKind.OMPRT_IOMP5).Default((Object)OpenMPRuntimeKind.OMPRT_Unknown))) == OpenMPRuntimeKind.OMPRT_Unknown) {
            if (A != null) {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)TC.getDriver().Diag(366))), (StringRef)A.getOption().getName()), (char.ptr)A.getValue()));
                }
                finally {
                    $c$.$destroy();
                }
            }
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)TC.getDriver().Diag(364))), (String)"-fopenmp"));
            }
            finally {
                $c$.$destroy();
            }
        }
        return RT;
    }

    public static void addOpenMPRuntime(ArgStringList CmdArgs, ToolChain TC, ArgList Args) {
        if (!Args.hasFlag(new OptSpecifier(options.ID.OPT_fopenmp.getValue()), new OptSpecifier(options.ID.OPT_fopenmp_EQ.getValue()), new OptSpecifier(options.ID.OPT_fno_openmp.getValue()), false)) {
            return;
        }
        switch (ToolsStatics.getOpenMPRuntime(TC, Args)) {
            case OMPRT_OMP: {
                CmdArgs.push_back((Object)NativePointer.$((String)"-lomp"));
                break;
            }
            case OMPRT_GOMP: {
                CmdArgs.push_back((Object)NativePointer.$((String)"-lgomp"));
                break;
            }
            case OMPRT_IOMP5: {
                CmdArgs.push_back((Object)NativePointer.$((String)"-liomp5"));
                break;
            }
        }
    }

    public static void addSanitizerRuntime(ToolChain TC, ArgList Args, ArgStringList CmdArgs, StringRef Sanitizer, boolean IsShared, boolean IsWhole) {
        if (IsWhole) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-whole-archive"));
        }
        CmdArgs.push_back((Object)TC.getCompilerRTArgString(Args, new StringRef(Sanitizer), IsShared));
        if (IsWhole) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-no-whole-archive"));
        }
    }

    public static boolean addSanitizerDynamicList(ToolChain TC, ArgList Args, ArgStringList CmdArgs, StringRef Sanitizer) {
        SmallString SanRT = new SmallString(new StringRef(TC.getCompilerRT(Args, new StringRef(Sanitizer))), 128);
        if (fs.exists((Twine)llvm.$add_StringRef_char$ptr$C((StringRef)SanRT.$StringRef(), (String)".syms"))) {
            CmdArgs.push_back((Object)Args.MakeArgString(llvm.$add_Twine((Twine)llvm.$add_char$ptr$C_StringRef((String)"--dynamic-list=", (StringRef)SanRT.$StringRef()), (Twine)new Twine(".syms"))));
            return true;
        }
        return false;
    }

    public static void linkSanitizerRuntimeDeps(ToolChain TC, ArgStringList CmdArgs) {
        CmdArgs.push_back((Object)NativePointer.$((String)"--no-as-needed"));
        CmdArgs.push_back((Object)NativePointer.$((String)"-lpthread"));
        CmdArgs.push_back((Object)NativePointer.$((String)"-lrt"));
        CmdArgs.push_back((Object)NativePointer.$((String)"-lm"));
        if (TC.getTriple().getOS() != Triple.OSType.FreeBSD) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-ldl"));
        }
    }

    public static void collectSanitizerRuntimes(ToolChain TC, ArgList Args, SmallVectorImpl<StringRef> SharedRuntimes, SmallVectorImpl<StringRef> StaticRuntimes, SmallVectorImpl<StringRef> NonWholeStaticRuntimes, SmallVectorImpl<StringRef> HelperStaticRuntimes, SmallVectorImpl<StringRef> RequiredSymbols) {
        SanitizerArgs SanArgs = TC.getSanitizerArgs();
        if (SanArgs.needsAsanRt() && SanArgs.needsSharedAsanRt()) {
            SharedRuntimes.push_back((Object)new StringRef("asan"));
        }
        if (SanArgs.needsStatsRt()) {
            StaticRuntimes.push_back((Object)new StringRef("stats_client"));
        }
        if (Args.hasArg(new OptSpecifier(options.ID.OPT_shared.getValue())) || TC.getTriple().isAndroid()) {
            return;
        }
        if (SanArgs.needsAsanRt()) {
            if (SanArgs.needsSharedAsanRt()) {
                HelperStaticRuntimes.push_back((Object)new StringRef("asan-preinit"));
            } else {
                StaticRuntimes.push_back((Object)new StringRef("asan"));
                if (SanArgs.linkCXXRuntimes()) {
                    StaticRuntimes.push_back((Object)new StringRef("asan_cxx"));
                }
            }
        }
        if (SanArgs.needsDfsanRt()) {
            StaticRuntimes.push_back((Object)new StringRef("dfsan"));
        }
        if (SanArgs.needsLsanRt()) {
            StaticRuntimes.push_back((Object)new StringRef("lsan"));
        }
        if (SanArgs.needsMsanRt()) {
            StaticRuntimes.push_back((Object)new StringRef("msan"));
            if (SanArgs.linkCXXRuntimes()) {
                StaticRuntimes.push_back((Object)new StringRef("msan_cxx"));
            }
        }
        if (SanArgs.needsTsanRt()) {
            StaticRuntimes.push_back((Object)new StringRef("tsan"));
            if (SanArgs.linkCXXRuntimes()) {
                StaticRuntimes.push_back((Object)new StringRef("tsan_cxx"));
            }
        }
        if (SanArgs.needsUbsanRt()) {
            StaticRuntimes.push_back((Object)new StringRef("ubsan_standalone"));
            if (SanArgs.linkCXXRuntimes()) {
                StaticRuntimes.push_back((Object)new StringRef("ubsan_standalone_cxx"));
            }
        }
        if (SanArgs.needsSafeStackRt()) {
            StaticRuntimes.push_back((Object)new StringRef("safestack"));
        }
        if (SanArgs.needsCfiRt()) {
            StaticRuntimes.push_back((Object)new StringRef("cfi"));
        }
        if (SanArgs.needsCfiDiagRt()) {
            StaticRuntimes.push_back((Object)new StringRef("cfi_diag"));
            if (SanArgs.linkCXXRuntimes()) {
                StaticRuntimes.push_back((Object)new StringRef("ubsan_standalone_cxx"));
            }
        }
        if (SanArgs.needsStatsRt()) {
            NonWholeStaticRuntimes.push_back((Object)new StringRef("stats"));
            RequiredSymbols.push_back((Object)new StringRef("__sanitizer_stats_register"));
        }
        if (SanArgs.needsEsanRt()) {
            StaticRuntimes.push_back((Object)new StringRef("esan"));
        }
    }

    public static boolean addSanitizerRuntimes(ToolChain TC, ArgList Args, ArgStringList CmdArgs) {
        SmallVector SharedRuntimes = new SmallVector(4, (Object)new StringRef());
        SmallVector StaticRuntimes = new SmallVector(4, (Object)new StringRef());
        SmallVector NonWholeStaticRuntimes = new SmallVector(4, (Object)new StringRef());
        SmallVector HelperStaticRuntimes = new SmallVector(4, (Object)new StringRef());
        SmallVector RequiredSymbols = new SmallVector(4, (Object)new StringRef());
        ToolsStatics.collectSanitizerRuntimes(TC, Args, (SmallVectorImpl<StringRef>)SharedRuntimes, (SmallVectorImpl<StringRef>)StaticRuntimes, (SmallVectorImpl<StringRef>)NonWholeStaticRuntimes, (SmallVectorImpl<StringRef>)HelperStaticRuntimes, (SmallVectorImpl<StringRef>)RequiredSymbols);
        for (StringRef RT : SharedRuntimes) {
            ToolsStatics.addSanitizerRuntime(TC, Args, CmdArgs, new StringRef(RT), true, false);
        }
        for (StringRef RT : HelperStaticRuntimes) {
            ToolsStatics.addSanitizerRuntime(TC, Args, CmdArgs, new StringRef(RT), false, true);
        }
        boolean AddExportDynamic = false;
        for (StringRef RT : StaticRuntimes) {
            ToolsStatics.addSanitizerRuntime(TC, Args, CmdArgs, new StringRef(RT), false, true);
            AddExportDynamic |= !ToolsStatics.addSanitizerDynamicList(TC, Args, CmdArgs, new StringRef(RT));
        }
        for (StringRef RT : NonWholeStaticRuntimes) {
            ToolsStatics.addSanitizerRuntime(TC, Args, CmdArgs, new StringRef(RT), false, false);
            AddExportDynamic |= !ToolsStatics.addSanitizerDynamicList(TC, Args, CmdArgs, new StringRef(RT));
        }
        for (StringRef S : RequiredSymbols) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-u"));
            CmdArgs.push_back((Object)Args.MakeArgString(new Twine(S)));
        }
        if (AddExportDynamic) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-export-dynamic"));
        }
        return !StaticRuntimes.empty();
    }

    public static boolean addXRayRuntime(ToolChain TC, ArgList Args, ArgStringList CmdArgs) {
        if (Args.hasFlag(new OptSpecifier(options.ID.OPT_fxray_instrument.getValue()), new OptSpecifier(options.ID.OPT_fnoxray_instrument.getValue()), false)) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-whole-archive"));
            CmdArgs.push_back((Object)TC.getCompilerRTArgString(Args, new StringRef("xray"), false));
            CmdArgs.push_back((Object)NativePointer.$((String)"-no-whole-archive"));
            return true;
        }
        return false;
    }

    public static void linkXRayRuntimeDeps(ToolChain TC, ArgList Args, ArgStringList CmdArgs) {
        CmdArgs.push_back((Object)NativePointer.$((String)"--no-as-needed"));
        CmdArgs.push_back((Object)NativePointer.$((String)"-lpthread"));
        CmdArgs.push_back((Object)NativePointer.$((String)"-lrt"));
        CmdArgs.push_back((Object)NativePointer.$((String)"-lm"));
        CmdArgs.push_back((Object)NativePointer.$((String)"-latomic"));
        if (TC.GetCXXStdlibType(Args) == ToolChain.CXXStdlibType.CST_Libcxx) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-lc++"));
        } else {
            CmdArgs.push_back((Object)NativePointer.$((String)"-lstdc++"));
        }
        if (TC.getTriple().getOS() != Triple.OSType.FreeBSD) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-ldl"));
        }
    }

    public static boolean areOptimizationsEnabled(ArgList Args) {
        Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_O_Group.getValue()));
        if (A != null) {
            return !A.getOption().matches(new OptSpecifier(options.ID.OPT_O0.getValue()));
        }
        return false;
    }

    public static boolean shouldUseFramePointerForTarget(ArgList Args, Triple _Triple) {
        switch (_Triple.getArch()) {
            case xcore: 
            case wasm32: 
            case wasm64: {
                return false;
            }
        }
        if (_Triple.isOSLinux() || _Triple.getOS() == Triple.OSType.CloudABI) {
            switch (_Triple.getArch()) {
                case systemz: 
                case mips: 
                case mipsel: 
                case mips64: 
                case mips64el: 
                case x86: 
                case x86_64: {
                    return !ToolsStatics.areOptimizationsEnabled(Args);
                }
            }
            return true;
        }
        if (_Triple.isOSWindows()) {
            switch (_Triple.getArch()) {
                case x86: {
                    return !ToolsStatics.areOptimizationsEnabled(Args);
                }
                case x86_64: {
                    return _Triple.isOSBinFormatMachO();
                }
                case arm: 
                case thumb: {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public static boolean shouldUseFramePointer(ArgList Args, Triple Triple2) {
        Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_fno_omit_frame_pointer.getValue()), new OptSpecifier(options.ID.OPT_fomit_frame_pointer.getValue()));
        if (A != null) {
            return A.getOption().matches(new OptSpecifier(options.ID.OPT_fno_omit_frame_pointer.getValue()));
        }
        if (Args.hasArg(new OptSpecifier(options.ID.OPT_pg.getValue()))) {
            return true;
        }
        return ToolsStatics.shouldUseFramePointerForTarget(Args, Triple2);
    }

    public static boolean shouldUseLeafFramePointer(ArgList Args, Triple Triple2) {
        Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_mno_omit_leaf_frame_pointer.getValue()), new OptSpecifier(options.ID.OPT_momit_leaf_frame_pointer.getValue()));
        if (A != null) {
            return A.getOption().matches(new OptSpecifier(options.ID.OPT_mno_omit_leaf_frame_pointer.getValue()));
        }
        if (Args.hasArg(new OptSpecifier(options.ID.OPT_pg.getValue()))) {
            return true;
        }
        if (Triple2.isPS4CPU()) {
            return false;
        }
        return ToolsStatics.shouldUseFramePointerForTarget(Args, Triple2);
    }

    public static void addDebugCompDirArg(ArgList Args, ArgStringList CmdArgs) {
        SmallString cwd = new SmallString(128);
        if (!fs.current_path((SmallString)cwd).$bool()) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-fdebug-compilation-dir"));
            CmdArgs.push_back((Object)Args.MakeArgString(new Twine(cwd)));
        }
    }

    public static char.ptr SplitDebugName(ArgList Args, InputInfo Input) {
        Arg FinalOutput = Args.getLastArg(new OptSpecifier(options.ID.OPT_o.getValue()));
        if (FinalOutput != null && Args.hasArg(new OptSpecifier(options.ID.OPT_c.getValue()))) {
            SmallString T = new SmallString(new StringRef(FinalOutput.getValue()), 128);
            path.replace_extension((SmallString)T, (Twine)new Twine("dwo"));
            return Args.MakeArgString(new Twine(T));
        }
        SmallString T = new SmallString(Args.getLastArgValue(new OptSpecifier(options.ID.OPT_fdebug_compilation_dir.getValue())), 128);
        SmallString F = new SmallString(path.stem((StringRef)new StringRef(Input.getBaseInput())), 128);
        path.replace_extension((SmallString)F, (Twine)new Twine("dwo"));
        T.$addassign(F.$StringRef());
        return Args.MakeArgString(new Twine(F));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void SplitDebugInfo(ToolChain TC, Compilation C, Tool T, JobAction JA, ArgList Args, InputInfo Output, char.ptr OutFile) {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            ArgStringList ExtractArgs = new ArgStringList();
            ExtractArgs.push_back((Object)NativePointer.$((String)"--extract-dwo"));
            ArgStringList StripArgs = new ArgStringList();
            StripArgs.push_back((Object)NativePointer.$((String)"--strip-dwo"));
            StripArgs.push_back((Object)Output.getFilename());
            ExtractArgs.push_back((Object)Output.getFilename());
            ExtractArgs.push_back((Object)OutFile);
            char.ptr Exec = Native.$tryClone((char.ptr)Args.MakeArgString(new Twine(TC.GetProgramPath(NativePointer.$((String)"objcopy")))));
            InputInfo II = new InputInfo(types.ID.TY_Object, Output.getFilename(), Output.getFilename());
            C.addCommand((std_ptr.unique_ptr<Command>)$c$.track(llvm.make_unique((Object)new Command((Action)JA, T, Exec, ExtractArgs, II))));
            $c$.clean();
            C.addCommand((std_ptr.unique_ptr<Command>)$c$.track(llvm.make_unique((Object)new Command((Action)JA, T, Exec, StripArgs, II))));
            $c$.clean();
        }
        finally {
            $c$.$destroy();
        }
    }

    public static boolean shouldEnableVectorizerAtOLevel(ArgList Args, boolean isSlpVec) {
        Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_O_Group.getValue()));
        if (A != null) {
            if (A.getOption().matches(new OptSpecifier(options.ID.OPT_O4.getValue())) || A.getOption().matches(new OptSpecifier(options.ID.OPT_Ofast.getValue()))) {
                return true;
            }
            if (A.getOption().matches(new OptSpecifier(options.ID.OPT_O0.getValue()))) {
                return false;
            }
            assert (A.getOption().matches(new OptSpecifier(options.ID.OPT_O.getValue()))) : "Must have a -O flag";
            StringRef S = new StringRef(A.getValue());
            if (llvm.$eq_StringRef((StringRef)S, (String)"s")) {
                return true;
            }
            if (llvm.$eq_StringRef((StringRef)S, (String)"z")) {
                return isSlpVec;
            }
            uint.ref OptLevel = NativePointer.create_uint$ref((int)0);
            if (S.getAsInteger$NotSigned(10, OptLevel)) {
                return false;
            }
            return Unsigned.$greater_uint((uint.ref)OptLevel, (int)1);
        }
        return false;
    }

    public static void addDashXForInput(ArgList Args, InputInfo Input, ArgStringList CmdArgs) {
        if (Args.hasArg(new OptSpecifier(options.ID.OPT_verify_pch.getValue())) && Input.getType() == types.ID.TY_PCH) {
            return;
        }
        CmdArgs.push_back((Object)NativePointer.$((String)"-x"));
        if (Args.hasArg(new OptSpecifier(options.ID.OPT_rewrite_objc.getValue()))) {
            CmdArgs.push_back((Object)types.getTypeName(types.ID.TY_PP_ObjCXX));
        } else {
            CmdArgs.push_back((Object)types.getTypeName(Input.getType()));
        }
    }

    public static VersionTuple getMSCompatibilityVersion(int Version) {
        if (Unsigned.$less_uint((int)Version, (int)100)) {
            return new VersionTuple(Version);
        }
        if (Unsigned.$less_uint((int)Version, (int)10000)) {
            return new VersionTuple(Version / 100, Version % 100);
        }
        int Build = 0;
        int Factor = 1;
        while (Unsigned.$greater_uint((int)Version, (int)10000)) {
            Build += Version % 10 * Factor;
            Version /= 10;
            Factor *= 10;
        }
        return new VersionTuple(Version / 100, Version % 100, Build);
    }

    public static void claimNoWarnArgs(ArgList Args) {
        Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_flto_EQ.getValue()));
        Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_flto.getValue()));
        Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_fno_lto.getValue()));
    }

    public static void appendUserToPath(SmallString Result) {
        char.ptr Username = Native.$tryClone((char.ptr)std.getenv((char.ptr)NativePointer.$((String)"LOGNAME")));
        if (Username == null) {
            Username = NativePointer.create_char$ptr_utf8((CharSequence)System.getProperty("user.name"));
        }
        if (Username != null) {
            int Len = 0;
            char.ptr P = Native.$tryClone((char.ptr)Username);
            while (P.$star() != 0) {
                if (!BasicClangGlobals.isAlphanumeric((byte)P.$star()) && P.$star() != 95) {
                    Username = null;
                    break;
                }
                P.$preInc();
                ++Len;
            }
            if (Username != null && Unsigned.$greater_uint((int)Len, (int)0)) {
                Result.append(Username, (char.ptr)Username.$add(Len));
                return;
            }
        }
        std.string UID = llvm.utostr((long)Unsigned.$uid_t2ulong((int)std.getuid()));
        Result.append(UID.begin(), UID.end());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPGOAndCoverageFlags(Compilation C, Driver D, InputInfo Output, ArgList Args, ArgStringList CmdArgs) {
        SmallString Path;
        JavaCleaner $c$;
        Arg ProfileUseArg;
        Arg ProfileGenerateArg;
        Arg PGOGenerateArg = Args.getLastArg(new OptSpecifier(options.ID.OPT_fprofile_generate.getValue()), new OptSpecifier(options.ID.OPT_fprofile_generate_EQ.getValue()), new OptSpecifier(options.ID.OPT_fno_profile_generate.getValue()));
        if (PGOGenerateArg != null && PGOGenerateArg.getOption().matches(new OptSpecifier(options.ID.OPT_fno_profile_generate.getValue()))) {
            PGOGenerateArg = null;
        }
        if ((ProfileGenerateArg = Args.getLastArg(new OptSpecifier(options.ID.OPT_fprofile_instr_generate.getValue()), new OptSpecifier(options.ID.OPT_fprofile_instr_generate_EQ.getValue()), new OptSpecifier(options.ID.OPT_fno_profile_instr_generate.getValue()))) != null && ProfileGenerateArg.getOption().matches(new OptSpecifier(options.ID.OPT_fno_profile_instr_generate.getValue()))) {
            ProfileGenerateArg = null;
        }
        if (PGOGenerateArg != null && ProfileGenerateArg != null) {
            JavaCleaner $c$2 = Native.$createJavaCleaner();
            try {
                $c$2.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$2.track((Object)D.Diag(306))), (StringRef)PGOGenerateArg.getSpelling()), (StringRef)ProfileGenerateArg.getSpelling()));
            }
            finally {
                $c$2.$destroy();
            }
        }
        if ((ProfileUseArg = Args.getLastArg(new OptSpecifier(options.ID.OPT_fprofile_instr_use.getValue()), new OptSpecifier(options.ID.OPT_fprofile_instr_use_EQ.getValue()), new OptSpecifier(options.ID.OPT_fprofile_use.getValue()), new OptSpecifier(options.ID.OPT_fprofile_use_EQ.getValue()), new OptSpecifier(options.ID.OPT_fno_profile_instr_use.getValue()))) != null && ProfileUseArg.getOption().matches(new OptSpecifier(options.ID.OPT_fno_profile_instr_use.getValue()))) {
            ProfileUseArg = null;
        }
        if (PGOGenerateArg != null && ProfileUseArg != null) {
            $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(306))), (StringRef)ProfileUseArg.getSpelling()), (StringRef)PGOGenerateArg.getSpelling()));
            }
            finally {
                $c$.$destroy();
            }
        }
        if (ProfileGenerateArg != null && ProfileUseArg != null) {
            $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(306))), (StringRef)ProfileGenerateArg.getSpelling()), (StringRef)ProfileUseArg.getSpelling()));
            }
            finally {
                $c$.$destroy();
            }
        }
        if (ProfileGenerateArg != null) {
            if (ProfileGenerateArg.getOption().matches(new OptSpecifier(options.ID.OPT_fprofile_instr_generate_EQ.getValue()))) {
                CmdArgs.push_back((Object)Args.MakeArgString(llvm.$add_Twine((Twine)new Twine("-fprofile-instrument-path="), (Twine)new Twine(ProfileGenerateArg.getValue()))));
            }
            CmdArgs.push_back((Object)NativePointer.$((String)"-fprofile-instrument=clang"));
        }
        if (PGOGenerateArg != null) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-fprofile-instrument=llvm"));
            if (PGOGenerateArg.getOption().matches(new OptSpecifier(options.ID.OPT_fprofile_generate_EQ.getValue()))) {
                Path = new SmallString(new StringRef(PGOGenerateArg.getValue()), 128);
                path.append((SmallString)Path, (Twine)new Twine("default.profraw"));
                CmdArgs.push_back((Object)Args.MakeArgString(llvm.$add_Twine((Twine)new Twine("-fprofile-instrument-path="), (Twine)new Twine(Path))));
            }
        }
        if (ProfileUseArg != null) {
            if (ProfileUseArg.getOption().matches(new OptSpecifier(options.ID.OPT_fprofile_instr_use_EQ.getValue()))) {
                CmdArgs.push_back((Object)Args.MakeArgString(llvm.$add_Twine((Twine)new Twine("-fprofile-instrument-use-path="), (Twine)new Twine(ProfileUseArg.getValue()))));
            } else if (ProfileUseArg.getOption().matches(new OptSpecifier(options.ID.OPT_fprofile_use_EQ.getValue())) || ProfileUseArg.getOption().matches(new OptSpecifier(options.ID.OPT_fprofile_instr_use.getValue()))) {
                Path = new SmallString(new StringRef(ProfileUseArg.getNumValues() == 0 ? NativePointer.$EMPTY : ProfileUseArg.getValue()), 128);
                if (Path.empty() || fs.is_directory((Twine)new Twine(Path))) {
                    path.append((SmallString)Path, (Twine)new Twine("default.profdata"));
                }
                CmdArgs.push_back((Object)Args.MakeArgString(llvm.$add_Twine((Twine)new Twine("-fprofile-instrument-use-path="), (Twine)new Twine(Path))));
            }
        }
        if (Args.hasArg(new OptSpecifier(options.ID.OPT_ftest_coverage.getValue())) || Args.hasArg(new OptSpecifier(options.ID.OPT_coverage.getValue()))) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-femit-coverage-notes"));
        }
        if (Args.hasFlag(new OptSpecifier(options.ID.OPT_fprofile_arcs.getValue()), new OptSpecifier(options.ID.OPT_fno_profile_arcs.getValue()), false) || Args.hasArg(new OptSpecifier(options.ID.OPT_coverage.getValue()))) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-femit-coverage-data"));
        }
        if (Args.hasFlag(new OptSpecifier(options.ID.OPT_fcoverage_mapping.getValue()), new OptSpecifier(options.ID.OPT_fno_coverage_mapping.getValue()), false) && ProfileGenerateArg == null) {
            $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(307))), (String)"-fcoverage-mapping"), (String)"-fprofile-instr-generate"));
            }
            finally {
                $c$.$destroy();
            }
        }
        if (Args.hasFlag(new OptSpecifier(options.ID.OPT_fcoverage_mapping.getValue()), new OptSpecifier(options.ID.OPT_fno_coverage_mapping.getValue()), false)) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-fcoverage-mapping"));
        }
        if ((C.getArgs().hasArg(new OptSpecifier(options.ID.OPT_c.getValue())) || C.getArgs().hasArg(new OptSpecifier(options.ID.OPT_S.getValue()))) && Output.isFilename()) {
            SmallString Pwd;
            CmdArgs.push_back((Object)NativePointer.$((String)"-coverage-file"));
            SmallString CoverageFilename = new SmallString(128);
            Arg FinalOutput = C.getArgs().getLastArg(new OptSpecifier(options.ID.OPT_o.getValue()));
            if (FinalOutput != null) {
                CoverageFilename.$assign(FinalOutput.getValue());
            } else {
                CoverageFilename.$assign(path.filename((StringRef)new StringRef(Output.getBaseInput())));
            }
            if (path.is_relative((Twine)new Twine(CoverageFilename)) && !fs.current_path((SmallString)(Pwd = new SmallString(128))).$bool()) {
                path.append((SmallString)Pwd, (Twine)new Twine(CoverageFilename));
                CoverageFilename.swap((SmallVectorImplChar)Pwd);
            }
            CmdArgs.push_back((Object)Args.MakeArgString(new Twine(CoverageFilename)));
        }
    }

    public static void addPS4ProfileRTArgs(ToolChain TC, ArgList Args, ArgStringList CmdArgs) {
        if (Args.hasFlag(new OptSpecifier(options.ID.OPT_fprofile_arcs.getValue()), new OptSpecifier(options.ID.OPT_fno_profile_arcs.getValue()), false) || Args.hasFlag(new OptSpecifier(options.ID.OPT_fprofile_generate.getValue()), new OptSpecifier(options.ID.OPT_fno_profile_instr_generate.getValue()), false) || Args.hasFlag(new OptSpecifier(options.ID.OPT_fprofile_generate_EQ.getValue()), new OptSpecifier(options.ID.OPT_fno_profile_instr_generate.getValue()), false) || Args.hasFlag(new OptSpecifier(options.ID.OPT_fprofile_instr_generate.getValue()), new OptSpecifier(options.ID.OPT_fno_profile_instr_generate.getValue()), false) || Args.hasFlag(new OptSpecifier(options.ID.OPT_fprofile_instr_generate_EQ.getValue()), new OptSpecifier(options.ID.OPT_fno_profile_instr_generate.getValue()), false) || Args.hasArg(new OptSpecifier(options.ID.OPT_fcreate_profile.getValue())) || Args.hasArg(new OptSpecifier(options.ID.OPT_coverage.getValue()))) {
            CmdArgs.push_back((Object)NativePointer.$((String)"--dependent-lib=libclang_rt.profile-x86_64.a"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static std.tuple ParsePICArgs(ToolChain ToolChain2, Triple _Triple, ArgList Args) {
        Arg A;
        boolean PIC;
        boolean PIE = ToolChain2.isPIEDefault();
        boolean bl = PIC = PIE || ToolChain2.isPICDefault();
        if (ToolChain2.getTriple().isOSBinFormatMachO() && Args.hasArg(new OptSpecifier(options.ID.OPT_static.getValue()))) {
            PIC = false;
            PIE = false;
        }
        boolean IsPICLevelTwo = PIC;
        boolean KernelOrKext = Args.hasArg(new OptSpecifier(options.ID.OPT_mkernel.getValue()), new OptSpecifier(options.ID.OPT_fapple_kext.getValue()));
        if (ToolChain2.getTriple().isAndroid()) {
            switch (ToolChain2.getArch()) {
                case aarch64: 
                case arm: 
                case armeb: 
                case thumb: 
                case thumbeb: 
                case mips: 
                case mipsel: 
                case mips64: 
                case mips64el: {
                    PIC = true;
                    break;
                }
                case x86: 
                case x86_64: {
                    PIC = true;
                    IsPICLevelTwo = true;
                    break;
                }
            }
        }
        if (ToolChain2.getTriple().getOS() == Triple.OSType.OpenBSD) {
            switch (ToolChain2.getArch()) {
                case mips64: 
                case mips64el: 
                case sparcel: 
                case x86: 
                case x86_64: {
                    IsPICLevelTwo = false;
                    break;
                }
                case ppc: 
                case sparc: 
                case sparcv9: {
                    IsPICLevelTwo = true;
                    break;
                }
            }
        }
        Arg LastPICArg = Args.getLastArg(new OptSpecifier(options.ID.OPT_fPIC.getValue()), new OptSpecifier(options.ID.OPT_fno_PIC.getValue()), new OptSpecifier(options.ID.OPT_fpic.getValue()), new OptSpecifier(options.ID.OPT_fno_pic.getValue()), new OptSpecifier(options.ID.OPT_fPIE.getValue()), new OptSpecifier(options.ID.OPT_fno_PIE.getValue()), new OptSpecifier(options.ID.OPT_fpie.getValue()), new OptSpecifier(options.ID.OPT_fno_pie.getValue()));
        if (!ToolChain2.isPICDefaultForced() && LastPICArg != null) {
            Option O = new Option(LastPICArg.getOption());
            if (O.matches(new OptSpecifier(options.ID.OPT_fPIC.getValue())) || O.matches(new OptSpecifier(options.ID.OPT_fpic.getValue())) || O.matches(new OptSpecifier(options.ID.OPT_fPIE.getValue())) || O.matches(new OptSpecifier(options.ID.OPT_fpie.getValue()))) {
                PIE = O.matches(new OptSpecifier(options.ID.OPT_fPIE.getValue())) || O.matches(new OptSpecifier(options.ID.OPT_fpie.getValue()));
                PIC = PIE || O.matches(new OptSpecifier(options.ID.OPT_fPIC.getValue())) || O.matches(new OptSpecifier(options.ID.OPT_fpic.getValue()));
                IsPICLevelTwo = O.matches(new OptSpecifier(options.ID.OPT_fPIE.getValue())) || O.matches(new OptSpecifier(options.ID.OPT_fPIC.getValue()));
            } else {
                Arg ModelArg;
                StringRef Model2;
                PIC = false;
                PIE = false;
                if (_Triple.isPS4CPU() && llvm.$noteq_StringRef((StringRef)(Model2 = new StringRef((ModelArg = Args.getLastArg(new OptSpecifier(options.ID.OPT_mcmodel_EQ.getValue()))) != null ? ModelArg.getValue() : NativePointer.$EMPTY)), (String)"kernel")) {
                    JavaCleaner $c$ = Native.$createJavaCleaner();
                    try {
                        PIC = true;
                        $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)ToolChain2.getDriver().Diag(395))), (StringRef)LastPICArg.getSpelling()));
                    }
                    finally {
                        $c$.$destroy();
                    }
                }
            }
        }
        if (PIC && (ToolChain2.getTriple().isOSDarwin() || _Triple.isPS4CPU())) {
            IsPICLevelTwo |= ToolChain2.isPICDefault();
        }
        if (KernelOrKext && (!_Triple.isiOS() || _Triple.isOSVersionLT(6)) && !_Triple.isWatchOS()) {
            PIE = false;
            PIC = false;
        }
        if ((A = Args.getLastArg(new OptSpecifier(options.ID.OPT_mdynamic_no_pic.getValue()))) != null) {
            if (!ToolChain2.getTriple().isOSDarwin()) {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)ToolChain2.getDriver().Diag(365))), (StringRef)A.getSpelling()), (StringRef)new StringRef(ToolChain2.getTriple().str())));
                }
                finally {
                    $c$.$destroy();
                }
            }
            PIC = ToolChain2.isPICDefault() && ToolChain2.isPICDefaultForced();
            return new std.tuple(std.make_tuple((Object[])new Object[]{Reloc.Model.DynamicNoPIC, PIC ? 2 : 0, false}));
        }
        if (PIC) {
            return new std.tuple(std.make_tuple((Object[])new Object[]{Reloc.Model.PIC_, IsPICLevelTwo ? 2 : 1, PIE}));
        }
        return new std.tuple(std.make_tuple((Object[])new Object[]{Reloc.Model.Static, 0, false}));
    }

    public static char.ptr RelocationModelName(Reloc.Model Model2) {
        switch (Model2) {
            case Static: {
                return NativePointer.$static;
            }
            case PIC_: {
                return NativePointer.$((String)"pic");
            }
            case DynamicNoPIC: {
                return NativePointer.$((String)"dynamic-no-pic");
            }
        }
        throw new llvm_unreachable("Unknown Reloc::Model kind");
    }

    public static void AddAssemblerKPIC(ToolChain ToolChain2, ArgList Args, ArgStringList CmdArgs) {
        std.tuple ParsePICArgs = ToolsStatics.ParsePICArgs(ToolChain2, ToolChain2.getTriple(), Args);
        Reloc.Model RelocationModel = (Reloc.Model)ParsePICArgs.$getAt(0);
        int PICLevel = (Integer)ParsePICArgs.$getAt(1);
        boolean IsPIE = (Boolean)ParsePICArgs.$getAt(2);
        if (RelocationModel != Reloc.Model.Static) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-KPIC"));
        }
    }

    public static boolean maybeConsumeDash(std.string EH, uint.ref I) {
        boolean HaveDash = Unsigned.$less_uint((int)(I.$deref() + 1), (int)EH.size()) && EH.$at(I.$deref() + 1) == 45;
        I.$set$addassign(HaveDash ? 1 : 0);
        return !HaveDash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EHFlags parseClangCLEHFlags(Driver D, ArgList Args) {
        std.vectorString EHArgs = null;
        try {
            EHFlags EH = new EHFlags();
            EHArgs = Args.getAllArgValues(new OptSpecifier(options.ID.OPT__SLASH_EH.getValue()));
            block14: for (std.string EHVal : EHArgs) {
                int E = EHVal.size();
                uint.ref I = NativePointer.create_uint$ref((int)0);
                while (I.$deref() != E) {
                    JavaCleaner $c$ = Native.$createJavaCleaner();
                    try {
                        switch (EHVal.$at(I.$deref())) {
                            case 97: {
                                EH.Asynch = ToolsStatics.maybeConsumeDash(EHVal, I);
                                if (!EH.Asynch) break;
                                EH.Synch = false;
                                break;
                            }
                            case 99: {
                                EH.NoUnwindC = ToolsStatics.maybeConsumeDash(EHVal, I);
                                break;
                            }
                            case 115: {
                                EH.Synch = ToolsStatics.maybeConsumeDash(EHVal, I);
                                if (!EH.Synch) break;
                                EH.Asynch = false;
                                break;
                            }
                            default: {
                                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(337))), (String)"/EH"), (StringRef)new StringRef(EHVal)));
                                continue block14;
                            }
                        }
                    }
                    finally {
                        $c$.$destroy();
                        continue block14;
                    }
                    I.$set$preInc();
                }
            }
            if (EHArgs.empty() && Args.hasFlag(new OptSpecifier(options.ID.OPT__SLASH_GX.getValue()), new OptSpecifier(options.ID.OPT__SLASH_GX_.getValue()), false)) {
                EH.Synch = true;
                EH.NoUnwindC = true;
            }
            EHFlags eHFlags = EH;
            return eHFlags;
        }
        finally {
            if (EHArgs != null) {
                EHArgs.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void constructHexagonLinkArgs(Compilation C, JobAction JA, HexagonToolChain HTC, InputInfo Output, SmallVector<InputInfo> Inputs, ArgList Args, ArgStringList CmdArgs, char.ptr LinkingOutput) {
        std.vectorString OsLibs = null;
        try {
            ADTAliases.OptionalUInt G;
            Driver D = HTC.getDriver();
            boolean IsStatic = Args.hasArg(new OptSpecifier(options.ID.OPT_static.getValue()));
            boolean IsShared = Args.hasArg(new OptSpecifier(options.ID.OPT_shared.getValue()));
            boolean IsPIE = Args.hasArg(new OptSpecifier(options.ID.OPT_pie.getValue()));
            boolean IncStdLib = !Args.hasArg(new OptSpecifier(options.ID.OPT_nostdlib.getValue()));
            boolean IncStartFiles = !Args.hasArg(new OptSpecifier(options.ID.OPT_nostartfiles.getValue()));
            boolean IncDefLibs = !Args.hasArg(new OptSpecifier(options.ID.OPT_nodefaultlibs.getValue()));
            boolean UseG0 = false;
            boolean UseShared = IsShared && !IsStatic;
            Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_g_Group.getValue()));
            Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_emit_llvm.getValue()));
            Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_w.getValue()));
            Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_static_libgcc.getValue()));
            if (Args.hasArg(new OptSpecifier(options.ID.OPT_s.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-s"));
            }
            if (Args.hasArg(new OptSpecifier(options.ID.OPT_r.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-r"));
            }
            for (std.string Opt : HTC.ExtraOpts) {
                CmdArgs.push_back((Object)Opt.c_str());
            }
            CmdArgs.push_back((Object)NativePointer.$((String)"-march=hexagon"));
            std.string CpuVer = HexagonToolChain.GetTargetCPUVersion(Args).str();
            std.string MCpuString = std.$add_T_string$C((String)"-mcpu=hexagon", (std.string)CpuVer);
            CmdArgs.push_back((Object)Args.MakeArgString(new Twine(MCpuString)));
            if (IsShared) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-shared"));
                CmdArgs.push_back((Object)NativePointer.$((String)"-call_shared"));
            }
            if (IsStatic) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-static"));
            }
            if (IsPIE && !IsShared) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-pie"));
            }
            if ((G = HexagonToolChain.getSmallDataThreshold(Args)).$bool()) {
                std.string N = llvm.utostr((long)Unsigned.$uint2ulong((int)G.getValue()));
                CmdArgs.push_back((Object)Args.MakeArgString(new Twine(std.$add_string_string$C((std.string)new std.string((CharSequence)"-G"), (std.string)N))));
                UseG0 = G.getValue() == 0;
            }
            CmdArgs.push_back((Object)NativePointer.$((String)"-o"));
            CmdArgs.push_back((Object)Output.getFilename());
            OsLibs = new std.vectorString(std.string.EMPTY);
            boolean HasStandalone = false;
            for (Arg A : Args.filtered(new OptSpecifier(options.ID.OPT_moslib_EQ.getValue()))) {
                A.claim();
                OsLibs.emplace_back(A.getValue());
                HasStandalone = HasStandalone || std.$eq_string$C_T((std.string)OsLibs.back(), (String)"standalone");
            }
            if (OsLibs.empty()) {
                OsLibs.push_back(new std.string((CharSequence)"standalone"));
                HasStandalone = true;
            }
            std.string MCpuSuffix = std.$add_T_string$C((String)"/", (std.string)CpuVer);
            std.string MCpuG0Suffix = std.$add_string$C_T((std.string)MCpuSuffix, (String)"/G0");
            std.string RootDir = std.$add_string_T((std.string)HTC.getHexagonTargetDir(D.InstalledDir, (SmallVectorImpl<std.string>)D.PrefixDirs), (String)"/");
            std.string StartSubDir = std.$add_T_string$C((String)"hexagon/lib", (std.string)(UseG0 ? MCpuG0Suffix : MCpuSuffix));
            Find.Lambda Find2 = (_RootDir, SubDir, Name) -> {
                std.string RelName = std.$add_string$C_T((std.string)SubDir, (char.ptr)Name);
                std.string P = HTC.GetFilePath(RelName.c_str());
                if (fs.exists((Twine)new Twine(P))) {
                    return P;
                }
                return std.$add_string$C((std.string)_RootDir, (std.string)RelName);
            };
            if (IncStdLib && IncStartFiles) {
                if (!IsShared) {
                    if (HasStandalone) {
                        std.string Crt0SA = Find2.$call(RootDir, StartSubDir, "/crt0_standalone.o");
                        CmdArgs.push_back((Object)Args.MakeArgString(new Twine(Crt0SA)));
                    }
                    std.string Crt0 = Find2.$call(RootDir, StartSubDir, "/crt0.o");
                    CmdArgs.push_back((Object)Args.MakeArgString(new Twine(Crt0)));
                }
                std.string Init = UseShared ? Find2.$call(RootDir, std.$add_string$C_T((std.string)StartSubDir, (String)"/pic"), "/initS.o") : Find2.$call(RootDir, StartSubDir, "/init.o");
                CmdArgs.push_back((Object)Args.MakeArgString(new Twine(Init)));
            }
            SmallVector<std.string> LibPaths = HTC.getFilePaths();
            for (std.string LibPath : LibPaths) {
                CmdArgs.push_back((Object)Args.MakeArgString(llvm.$add_Twine((Twine)new Twine("-L"), (Twine)new Twine(LibPath))));
            }
            Args.AddAllArgs(CmdArgs, new ArrayRef((Object[])JavaDriverSupport.$IDsToOptSpecifiers(new options.ID[]{options.ID.OPT_T_Group, options.ID.OPT_e, options.ID.OPT_s, options.ID.OPT_t, options.ID.OPT_u_Group})));
            ToolsStatics.AddLinkerInputs(HTC, Inputs, Args, CmdArgs);
            if (IncStdLib && IncDefLibs) {
                if (D.CCCIsCXX()) {
                    HTC.AddCXXStdlibLibArgs(Args, CmdArgs);
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lm"));
                }
                CmdArgs.push_back((Object)NativePointer.$((String)"--start-group"));
                if (!IsShared) {
                    for (std.string Lib : OsLibs) {
                        CmdArgs.push_back((Object)Args.MakeArgString(new Twine(std.$add_T_string$C((String)"-l", (std.string)Lib))));
                    }
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lc"));
                }
                CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc"));
                CmdArgs.push_back((Object)NativePointer.$((String)"--end-group"));
            }
            if (IncStdLib && IncStartFiles) {
                std.string Fini = UseShared ? Find2.$call(RootDir, std.$add_string$C_T((std.string)StartSubDir, (String)"/pic"), "/finiS.o") : Find2.$call(RootDir, StartSubDir, "/fini.o");
                CmdArgs.push_back((Object)Args.MakeArgString(new Twine(Fini)));
            }
        }
        finally {
            if (OsLibs != null) {
                OsLibs.$destroy();
            }
        }
    }

    public static void AddLibgcc(Triple Triple2, Driver D, ArgStringList CmdArgs, ArgList Args) {
        boolean StaticLibgcc;
        boolean isAndroid = Triple2.isAndroid();
        boolean isCygMing = Triple2.isOSCygMing();
        boolean IsIAMCU = Triple2.isOSIAMCU();
        boolean bl = StaticLibgcc = Args.hasArg(new OptSpecifier(options.ID.OPT_static_libgcc.getValue())) || Args.hasArg(new OptSpecifier(options.ID.OPT_static.getValue()));
        if (!D.CCCIsCXX()) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc"));
        }
        if (StaticLibgcc || isAndroid) {
            if (D.CCCIsCXX()) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc"));
            }
        } else {
            if (!D.CCCIsCXX() && !isCygMing) {
                CmdArgs.push_back((Object)NativePointer.$((String)"--as-needed"));
            }
            CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc_s"));
            if (!D.CCCIsCXX() && !isCygMing) {
                CmdArgs.push_back((Object)NativePointer.$((String)"--no-as-needed"));
            }
        }
        if (StaticLibgcc && !isAndroid && !IsIAMCU) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc_eh"));
        } else if (!Args.hasArg(new OptSpecifier(options.ID.OPT_shared.getValue())) && D.CCCIsCXX()) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc"));
        }
        if (isAndroid && !StaticLibgcc) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-ldl"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void AddRunTimeLibs(ToolChain TC, Driver D, ArgStringList CmdArgs, ArgList Args) {
        ToolChain.RuntimeLibType RLT = TC.GetRuntimeLibType(Args);
        switch (RLT) {
            case RLT_CompilerRT: {
                switch (TC.getTriple().getOS()) {
                    default: {
                        throw new llvm_unreachable("unsupported OS");
                    }
                    case Win32: 
                    case Linux: 
                }
                ToolsStatics.addClangRT(TC, Args, CmdArgs);
                break;
            }
            case RLT_Libgcc: {
                if (TC.getTriple().isKnownWindowsMSVCEnvironment()) {
                    if (!Args.hasArg(new OptSpecifier(options.ID.OPT_rtlib_EQ.getValue()))) break;
                    JavaCleaner $c$ = Native.$createJavaCleaner();
                    try {
                        $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)TC.getDriver().Diag(367))), (char.ptr)Args.getLastArg(new OptSpecifier(options.ID.OPT_rtlib_EQ.getValue())).getValue()), (String)"MSVC"));
                        break;
                    }
                    finally {
                        $c$.$destroy();
                    }
                }
                ToolsStatics.AddLibgcc(TC.getTriple(), D, CmdArgs, Args);
            }
        }
    }

    public static char.ptr getLDMOption(Triple T, ArgList Args) {
        switch (T.getArch()) {
            case x86: {
                if (T.isOSIAMCU()) {
                    return NativePointer.$((String)"elf_iamcu");
                }
                return NativePointer.$((String)"elf_i386");
            }
            case aarch64: {
                return NativePointer.$((String)"aarch64linux");
            }
            case aarch64_be: {
                return NativePointer.$((String)"aarch64_be_linux");
            }
            case arm: 
            case thumb: {
                return NativePointer.$((String)"armelf_linux_eabi");
            }
            case armeb: 
            case thumbeb: {
                return NativePointer.$((String)"armelfb_linux_eabi");
            }
            case ppc: {
                return NativePointer.$((String)"elf32ppclinux");
            }
            case ppc64: {
                return NativePointer.$((String)"elf64ppc");
            }
            case ppc64le: {
                return NativePointer.$((String)"elf64lppc");
            }
            case sparc: 
            case sparcel: {
                return NativePointer.$((String)"elf32_sparc");
            }
            case sparcv9: {
                return NativePointer.$((String)"elf64_sparc");
            }
            case mips: {
                return NativePointer.$((String)"elf32btsmip");
            }
            case mipsel: {
                return NativePointer.$((String)"elf32ltsmip");
            }
            case mips64: {
                if (MipsStatics.hasMipsAbiArg(Args, NativePointer.$((String)"n32"))) {
                    return NativePointer.$((String)"elf32btsmipn32");
                }
                return NativePointer.$((String)"elf64btsmip");
            }
            case mips64el: {
                if (MipsStatics.hasMipsAbiArg(Args, NativePointer.$((String)"n32"))) {
                    return NativePointer.$((String)"elf32ltsmipn32");
                }
                return NativePointer.$((String)"elf64ltsmip");
            }
            case systemz: {
                return NativePointer.$((String)"elf64_s390");
            }
            case x86_64: {
                if (T.getEnvironment() == Triple.EnvironmentType.GNUX32) {
                    return NativePointer.$((String)"elf32_x86_64");
                }
                return NativePointer.$((String)"elf_x86_64");
            }
        }
        throw new llvm_unreachable("Unexpected arch");
    }

    public static std.string FindVisualStudioExecutable(ToolChain TC, char.ptr Exe, char.ptr ClangProgramPath) {
        MSVCToolChain MSVC = (MSVCToolChain)TC;
        std.string visualStudioBinDir = new std.string();
        if (MSVC.getVisualStudioBinariesFolder(ClangProgramPath, visualStudioBinDir)) {
            SmallString FilePath = new SmallString(new StringRef(visualStudioBinDir), 128);
            path.append((SmallString)FilePath, (Twine)new Twine(Exe));
            if (fs.can_execute((Twine)new Twine(FilePath.c_str()))) {
                return FilePath.str().$basic_string();
            }
        }
        return new std.string(Exe);
    }

    public static void AddPS4SanitizerArgs(ToolChain TC, ArgStringList CmdArgs) {
        SanitizerArgs SanArgs = TC.getSanitizerArgs();
        if (SanArgs.needsUbsanRt()) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-lSceDbgUBSanitizer_stub_weak"));
        }
        if (SanArgs.needsAsanRt()) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-lSceDbgAddressSanitizer_stub_weak"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ConstructPS4LinkJob(Tool T, Compilation C, JobAction JA, InputInfo Output, SmallVector<InputInfo> Inputs, ArgList Args, char.ptr LinkingOutput) {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            FreeBSD ToolChain2 = (FreeBSD)T.getToolChain();
            Driver D = ToolChain2.getDriver();
            ArgStringList CmdArgs = new ArgStringList();
            Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_g_Group.getValue()));
            Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_emit_llvm.getValue()));
            Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_w.getValue()));
            if (!D.SysRoot.empty()) {
                CmdArgs.push_back((Object)Args.MakeArgString(new Twine(std.$add_T_string$C((String)"--sysroot=", (std.string)D.SysRoot))));
            }
            if (Args.hasArg(new OptSpecifier(options.ID.OPT_pie.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-pie"));
            }
            if (Args.hasArg(new OptSpecifier(options.ID.OPT_rdynamic.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-export-dynamic"));
            }
            if (Args.hasArg(new OptSpecifier(options.ID.OPT_shared.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"--oformat=so"));
            }
            if (Output.isFilename()) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-o"));
                CmdArgs.push_back((Object)Output.getFilename());
            } else assert (Output.isNothing()) : "Invalid output.";
            ToolsStatics.AddPS4SanitizerArgs(ToolChain2, CmdArgs);
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_L.getValue()));
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_T_Group.getValue()));
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_e.getValue()));
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_s.getValue()));
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_t.getValue()));
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_r.getValue()));
            if (Args.hasArg(new OptSpecifier(options.ID.OPT_Z_Xlinker__no_demangle.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"--no-demangle"));
            }
            ToolsStatics.AddLinkerInputs(ToolChain2, Inputs, Args, CmdArgs);
            if (Args.hasArg(new OptSpecifier(options.ID.OPT_pthread.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-lpthread"));
            }
            char.ptr Exec = Native.$tryClone((char.ptr)Args.MakeArgString(new Twine(ToolChain2.GetProgramPath(NativePointer.$((String)"orbis-ld")))));
            C.addCommand((std_ptr.unique_ptr<Command>)$c$.track(llvm.make_unique((Object)new Command((Action)JA, T, Exec, CmdArgs, Inputs))));
            $c$.clean();
        }
        finally {
            $c$.$destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ConstructGoldLinkJob(Tool T, Compilation C, JobAction JA, InputInfo Output, SmallVector<InputInfo> Inputs, ArgList Args, char.ptr LinkingOutput) {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            FreeBSD ToolChain2 = (FreeBSD)T.getToolChain();
            Driver D = ToolChain2.getDriver();
            ArgStringList CmdArgs = new ArgStringList();
            Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_g_Group.getValue()));
            Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_emit_llvm.getValue()));
            Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_w.getValue()));
            if (!D.SysRoot.empty()) {
                CmdArgs.push_back((Object)Args.MakeArgString(new Twine(std.$add_T_string$C((String)"--sysroot=", (std.string)D.SysRoot))));
            }
            if (Args.hasArg(new OptSpecifier(options.ID.OPT_pie.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-pie"));
            }
            if (Args.hasArg(new OptSpecifier(options.ID.OPT_static.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-Bstatic"));
            } else {
                if (Args.hasArg(new OptSpecifier(options.ID.OPT_rdynamic.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-export-dynamic"));
                }
                CmdArgs.push_back((Object)NativePointer.$((String)"--eh-frame-hdr"));
                if (Args.hasArg(new OptSpecifier(options.ID.OPT_shared.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-Bshareable"));
                } else {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-dynamic-linker"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"/libexec/ld-elf.so.1"));
                }
                CmdArgs.push_back((Object)NativePointer.$((String)"--enable-new-dtags"));
            }
            if (Output.isFilename()) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-o"));
                CmdArgs.push_back((Object)Output.getFilename());
            } else assert (Output.isNothing()) : "Invalid output.";
            ToolsStatics.AddPS4SanitizerArgs(ToolChain2, CmdArgs);
            if (!Args.hasArg(new OptSpecifier(options.ID.OPT_nostdlib.getValue()), new OptSpecifier(options.ID.OPT_nostartfiles.getValue()))) {
                char.ptr crt1 = null;
                if (!Args.hasArg(new OptSpecifier(options.ID.OPT_shared.getValue()))) {
                    crt1 = Args.hasArg(new OptSpecifier(options.ID.OPT_pg.getValue())) ? Native.$tryClone((char.ptr)NativePointer.$((String)"gcrt1.o")) : (Args.hasArg(new OptSpecifier(options.ID.OPT_pie.getValue())) ? Native.$tryClone((char.ptr)NativePointer.$((String)"Scrt1.o")) : Native.$tryClone((char.ptr)NativePointer.$((String)"crt1.o")));
                }
                if (crt1 != null) {
                    CmdArgs.push_back((Object)Args.MakeArgString(new Twine(ToolChain2.GetFilePath(crt1))));
                }
                CmdArgs.push_back((Object)Args.MakeArgString(new Twine(ToolChain2.GetFilePath(NativePointer.$((String)"crti.o")))));
                char.ptr crtbegin = null;
                crtbegin = Args.hasArg(new OptSpecifier(options.ID.OPT_static.getValue())) ? Native.$tryClone((char.ptr)NativePointer.$((String)"crtbeginT.o")) : (Args.hasArg(new OptSpecifier(options.ID.OPT_shared.getValue())) || Args.hasArg(new OptSpecifier(options.ID.OPT_pie.getValue())) ? Native.$tryClone((char.ptr)NativePointer.$((String)"crtbeginS.o")) : Native.$tryClone((char.ptr)NativePointer.$((String)"crtbegin.o")));
                CmdArgs.push_back((Object)Args.MakeArgString(new Twine(ToolChain2.GetFilePath(crtbegin))));
            }
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_L.getValue()));
            ToolChain2.AddFilePathLibArgs(Args, CmdArgs);
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_T_Group.getValue()));
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_e.getValue()));
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_s.getValue()));
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_t.getValue()));
            Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_r.getValue()));
            if (Args.hasArg(new OptSpecifier(options.ID.OPT_Z_Xlinker__no_demangle.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"--no-demangle"));
            }
            ToolsStatics.AddLinkerInputs(ToolChain2, Inputs, Args, CmdArgs);
            if (!Args.hasArg(new OptSpecifier(options.ID.OPT_nostdlib.getValue()), new OptSpecifier(options.ID.OPT_nodefaultlibs.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-lkernel"));
                if (D.CCCIsCXX()) {
                    ToolChain2.AddCXXStdlibLibArgs(Args, CmdArgs);
                    if (Args.hasArg(new OptSpecifier(options.ID.OPT_pg.getValue()))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lm_p"));
                    } else {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lm"));
                    }
                }
                if (Args.hasArg(new OptSpecifier(options.ID.OPT_pg.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc_p"));
                } else {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lcompiler_rt"));
                }
                if (Args.hasArg(new OptSpecifier(options.ID.OPT_static.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lstdc++"));
                } else if (Args.hasArg(new OptSpecifier(options.ID.OPT_pg.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc_eh_p"));
                } else {
                    CmdArgs.push_back((Object)NativePointer.$((String)"--as-needed"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lstdc++"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"--no-as-needed"));
                }
                if (Args.hasArg(new OptSpecifier(options.ID.OPT_pthread.getValue()))) {
                    if (Args.hasArg(new OptSpecifier(options.ID.OPT_pg.getValue()))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lpthread_p"));
                    } else {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lpthread"));
                    }
                }
                if (Args.hasArg(new OptSpecifier(options.ID.OPT_pg.getValue()))) {
                    if (Args.hasArg(new OptSpecifier(options.ID.OPT_shared.getValue()))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lc"));
                    } else if (Args.hasArg(new OptSpecifier(options.ID.OPT_static.getValue()))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"--start-group"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lc_p"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lpthread_p"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"--end-group"));
                    } else {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lc_p"));
                    }
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc_p"));
                } else {
                    if (Args.hasArg(new OptSpecifier(options.ID.OPT_static.getValue()))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"--start-group"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lc"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lpthread"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"--end-group"));
                    } else {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lc"));
                    }
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lcompiler_rt"));
                }
                if (Args.hasArg(new OptSpecifier(options.ID.OPT_static.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lstdc++"));
                } else if (Args.hasArg(new OptSpecifier(options.ID.OPT_pg.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc_eh_p"));
                } else {
                    CmdArgs.push_back((Object)NativePointer.$((String)"--as-needed"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lstdc++"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"--no-as-needed"));
                }
            }
            if (!Args.hasArg(new OptSpecifier(options.ID.OPT_nostdlib.getValue()), new OptSpecifier(options.ID.OPT_nostartfiles.getValue()))) {
                if (Args.hasArg(new OptSpecifier(options.ID.OPT_shared.getValue())) || Args.hasArg(new OptSpecifier(options.ID.OPT_pie.getValue()))) {
                    CmdArgs.push_back((Object)Args.MakeArgString(new Twine(ToolChain2.GetFilePath(NativePointer.$((String)"crtendS.o")))));
                } else {
                    CmdArgs.push_back((Object)Args.MakeArgString(new Twine(ToolChain2.GetFilePath(NativePointer.$((String)"crtend.o")))));
                }
                CmdArgs.push_back((Object)Args.MakeArgString(new Twine(ToolChain2.GetFilePath(NativePointer.$((String)"crtn.o")))));
            }
            char.ptr Exec = Native.$tryClone((char.ptr)Args.MakeArgString(new Twine(ToolChain2.GetProgramPath(NativePointer.$((String)"orbis-ld")))));
            C.addCommand((std_ptr.unique_ptr<Command>)$c$.track(llvm.make_unique((Object)new Command((Action)JA, T, Exec, CmdArgs, Inputs))));
            $c$.clean();
        }
        finally {
            $c$.$destroy();
        }
    }
}

