/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver.tools.impl;

import org.clang.driver.impl.ToolsStatics;
import org.clang.driver.options;
import org.clank.java.std;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitch;
import org.llvm.adt.StringSwitchBool;
import org.llvm.adt.StringSwitchCharPtr;
import org.llvm.adt.StringSwitchInt;
import org.llvm.adt.StringSwitchStringRef;
import org.llvm.adt.Triple;
import org.llvm.option.Arg;
import org.llvm.option.ArgList;
import org.llvm.option.OptSpecifier;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;

public final class MipsStatics {
    public static NanEncoding getSupportedNanEncoding(StringRef CPU) {
        return NanEncoding.valueOf(new StringSwitchInt(CPU).Case("mips1", NanEncoding.NanLegacy.getValue()).Case("mips2", NanEncoding.NanLegacy.getValue()).Case("mips3", NanEncoding.NanLegacy.getValue()).Case("mips4", NanEncoding.NanLegacy.getValue()).Case("mips5", NanEncoding.NanLegacy.getValue()).Case("mips32", NanEncoding.NanLegacy.getValue()).Case("mips32r2", NanEncoding.NanLegacy.getValue() | NanEncoding.Nan2008.getValue()).Case("mips32r3", NanEncoding.NanLegacy.getValue() | NanEncoding.Nan2008.getValue()).Case("mips32r5", NanEncoding.NanLegacy.getValue() | NanEncoding.Nan2008.getValue()).Case("mips32r6", NanEncoding.Nan2008.getValue()).Case("mips64", NanEncoding.NanLegacy.getValue()).Case("mips64r2", NanEncoding.NanLegacy.getValue() | NanEncoding.Nan2008.getValue()).Case("mips64r3", NanEncoding.NanLegacy.getValue() | NanEncoding.Nan2008.getValue()).Case("mips64r5", NanEncoding.NanLegacy.getValue() | NanEncoding.Nan2008.getValue()).Case("mips64r6", NanEncoding.Nan2008.getValue()).Default(NanEncoding.NanLegacy.getValue()));
    }

    public static boolean hasCompactBranches(StringRef CPU) {
        return new StringSwitchBool(CPU).Case("mips32r6", true).Case("mips64r6", true).Default(false);
    }

    public static void getMipsCPUAndABI(ArgList Args, Triple _Triple, StringRef CPUName, StringRef ABIName) {
        Arg A;
        char.ptr DefMips32CPU = NativePointer.$((String)"mips32r2");
        char.ptr DefMips64CPU = NativePointer.$((String)"mips64r2");
        if (_Triple.getVendor() == Triple.VendorType.ImaginationTechnologies && _Triple.getEnvironment() == Triple.EnvironmentType.GNU) {
            DefMips32CPU = Native.$tryClone((char.ptr)NativePointer.$((String)"mips32r6"));
            DefMips64CPU = Native.$tryClone((char.ptr)NativePointer.$((String)"mips64r6"));
        }
        if (_Triple.isAndroid()) {
            DefMips32CPU = Native.$tryClone((char.ptr)NativePointer.$((String)"mips32"));
            DefMips64CPU = Native.$tryClone((char.ptr)NativePointer.$((String)"mips64r6"));
        }
        if (_Triple.getOS() == Triple.OSType.OpenBSD) {
            DefMips64CPU = Native.$tryClone((char.ptr)NativePointer.$((String)"mips3"));
        }
        if ((A = Args.getLastArg(new OptSpecifier(options.ID.OPT_march_EQ.getValue()), new OptSpecifier(options.ID.OPT_mcpu_EQ.getValue()))) != null) {
            CPUName.$assignMove(A.getValue());
        }
        if ((A = Args.getLastArg(new OptSpecifier(options.ID.OPT_mabi_EQ.getValue()))) != null) {
            ABIName.$assignMove(A.getValue());
            ABIName.$assignMove(new StringSwitchStringRef(ABIName).Case("32", "o32").Case("64", "n64").Default(ABIName));
        }
        if (CPUName.empty() && ABIName.empty()) {
            switch (_Triple.getArch()) {
                default: {
                    throw new llvm_unreachable("Unexpected triple arch name");
                }
                case mips: 
                case mipsel: {
                    CPUName.$assignMove(DefMips32CPU);
                    break;
                }
                case mips64: 
                case mips64el: {
                    CPUName.$assignMove(DefMips64CPU);
                }
            }
        }
        if (ABIName.empty() && (_Triple.getVendor() == Triple.VendorType.MipsTechnologies || _Triple.getVendor() == Triple.VendorType.ImaginationTechnologies)) {
            ABIName.$assignMove(new StringSwitchCharPtr(CPUName).Case("mips1", "o32").Case("mips2", "o32").Case("mips3", "n64").Case("mips4", "n64").Case("mips5", "n64").Case("mips32", "o32").Case("mips32r2", "o32").Case("mips32r3", "o32").Case("mips32r5", "o32").Case("mips32r6", "o32").Case("mips64", "n64").Case("mips64r2", "n64").Case("mips64r3", "n64").Case("mips64r5", "n64").Case("mips64r6", "n64").Case("octeon", "n64").Case("p5600", "o32").Default(NativePointer.$EMPTY));
        }
        if (ABIName.empty()) {
            if (_Triple.getArch() == Triple.ArchType.mips || _Triple.getArch() == Triple.ArchType.mipsel) {
                ABIName.$assignMove("o32");
            } else {
                ABIName.$assignMove("n64");
            }
        }
        if (CPUName.empty()) {
            CPUName.$assignMove(new StringSwitchCharPtr(ABIName).Case("o32", DefMips32CPU).Cases("n32", "n64", DefMips64CPU).Default(NativePointer.$EMPTY));
        }
    }

    public static std.string getMipsABILibSuffix(ArgList Args, Triple Triple2) {
        StringRef CPUName = new StringRef();
        StringRef ABIName = new StringRef();
        MipsStatics.getMipsCPUAndABI(Args, Triple2, CPUName, ABIName);
        return (std.string)new StringSwitch(ABIName).Case("o32", (Object)new std.string(NativePointer.$EMPTY)).Case("n32", (Object)new std.string((CharSequence)"32")).Case("n64", (Object)new std.string((CharSequence)"64")).$T_0_1();
    }

    public static boolean hasMipsAbiArg(ArgList Args, char.ptr Value) {
        Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_mabi_EQ.getValue()));
        return A != null && llvm.$eq_StringRef((char.ptr)A.getValue(), (char.ptr)Value);
    }

    public static boolean isUCLibc(ArgList Args) {
        Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_m_libc_Group.getValue()));
        return A != null && A.getOption().matches(new OptSpecifier(options.ID.OPT_muclibc.getValue()));
    }

    public static boolean isNaN2008(ArgList Args, Triple Triple2) {
        Arg NaNArg = Args.getLastArg(new OptSpecifier(options.ID.OPT_mnan_EQ.getValue()));
        if (NaNArg != null) {
            return new StringSwitchBool(NaNArg.getValue()).Case("2008", true).Case("legacy", false).Default(false);
        }
        return new StringSwitchBool(new StringRef(ToolsStatics.getCPUName(Args, Triple2))).Cases("mips32r6", "mips64r6", true).Default(false);
    }

    public static boolean isFP64ADefault(Triple Triple2, StringRef CPUName) {
        if (!Triple2.isAndroid()) {
            return false;
        }
        return new StringSwitchBool(CPUName).Case("mips32r6", true).Default(false);
    }

    public static boolean isFPXXDefault(Triple _Triple, StringRef CPUName, StringRef ABIName, FloatABI FloatABI2) {
        if (_Triple.getVendor() != Triple.VendorType.ImaginationTechnologies && _Triple.getVendor() != Triple.VendorType.MipsTechnologies && !_Triple.isAndroid()) {
            return false;
        }
        if (llvm.$noteq_StringRef((StringRef)ABIName, (String)"32")) {
            return false;
        }
        if (FloatABI2 == FloatABI.Soft) {
            return false;
        }
        return new StringSwitchBool(CPUName).Cases("mips2", "mips3", "mips4", "mips5", true).Cases("mips32", "mips32r2", "mips32r3", "mips32r5", true).Cases("mips64", "mips64r2", "mips64r3", "mips64r5", true).Default(false);
    }

    public static boolean shouldUseFPXX(ArgList Args, Triple Triple2, StringRef CPUName, StringRef ABIName, FloatABI FloatABI2) {
        boolean UseFPXX = MipsStatics.isFPXXDefault(Triple2, new StringRef(CPUName), new StringRef(ABIName), FloatABI2);
        Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_msingle_float.getValue()), new OptSpecifier(options.ID.OPT_mdouble_float.getValue()));
        if (A != null && A.getOption().matches(new OptSpecifier(options.ID.OPT_msingle_float.getValue()))) {
            UseFPXX = false;
        }
        return UseFPXX;
    }

    public static final class FloatABI
    extends Enum<FloatABI>
    implements Native.ComparableLower {
        public static final /* enum */ FloatABI Invalid = new FloatABI(0);
        public static final /* enum */ FloatABI Soft = new FloatABI(Invalid.getValue() + 1);
        public static final /* enum */ FloatABI Hard = new FloatABI(Soft.getValue() + 1);
        private final int value;
        private static final /* synthetic */ FloatABI[] $VALUES;

        public static FloatABI[] values() {
            return (FloatABI[])$VALUES.clone();
        }

        public static FloatABI valueOf(String name) {
            return Enum.valueOf(FloatABI.class, name);
        }

        public static FloatABI valueOf(int val) {
            FloatABI out;
            FloatABI floatABI = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private FloatABI(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_int((int)this.value, (int)((FloatABI)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_int((int)this.value, (int)((FloatABI)((Object)obj)).value);
        }

        static {
            $VALUES = new FloatABI[]{Invalid, Soft, Hard};
        }

        private static final class Values {
            private static final FloatABI[] VALUES;
            private static final FloatABI[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (FloatABI kind : FloatABI.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new FloatABI[min < 0 ? 1 - min : 0];
                VALUES = new FloatABI[max >= 0 ? 1 + max : 0];
                for (FloatABI kind : FloatABI.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((FloatABI)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((FloatABI)kind).value] = kind;
                }
            }
        }
    }

    public static final class NanEncoding
    extends Enum<NanEncoding>
    implements Native.ComparableLower {
        public static final /* enum */ NanEncoding NanLegacy = new NanEncoding(1);
        public static final /* enum */ NanEncoding Nan2008 = new NanEncoding(2);
        private final int value;
        private static final /* synthetic */ NanEncoding[] $VALUES;

        public static NanEncoding[] values() {
            return (NanEncoding[])$VALUES.clone();
        }

        public static NanEncoding valueOf(String name) {
            return Enum.valueOf(NanEncoding.class, name);
        }

        public static NanEncoding valueOf(int val) {
            NanEncoding out;
            NanEncoding nanEncoding = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private NanEncoding(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((NanEncoding)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((NanEncoding)((Object)obj)).value);
        }

        static {
            $VALUES = new NanEncoding[]{NanLegacy, Nan2008};
        }

        private static final class Values {
            private static final NanEncoding[] VALUES;
            private static final NanEncoding[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (NanEncoding kind : NanEncoding.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new NanEncoding[min < 0 ? 1 - min : 0];
                VALUES = new NanEncoding[max >= 0 ? 1 + max : 0];
                for (NanEncoding kind : NanEncoding.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((NanEncoding)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((NanEncoding)kind).value] = kind;
                }
            }
        }
    }
}

