/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.apisupport.project.ModuleDependency;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.NbModuleType;
import org.netbeans.modules.apisupport.project.ProjectXMLManager;
import org.netbeans.modules.apisupport.project.SuiteProvider;
import org.netbeans.modules.apisupport.project.api.ManifestManager;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.customizer.ClusterInfo;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.universe.LocalizedBundleInfo;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.TestModuleDependency;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.SpecificationVersion;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class ApisupportAntUtils {
    public static final String CPEXT_BINARY_PATH = "release/modules/ext/";
    public static final String CPEXT_RUNTIME_RELATIVE_PATH = "ext/";

    private ApisupportAntUtils() {
    }

    public static String getDisplayName(FileObject projectDir) {
        if (projectDir.isFolder()) {
            try {
                Project p = ProjectManager.getDefault().findProject(projectDir);
                if (p != null) {
                    return ProjectUtils.getInformation((Project)p).getDisplayName();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return FileUtil.getFileDisplayName((FileObject)projectDir);
    }

    public static boolean isValidJavaFQN(String name) {
        if (name.length() == 0) {
            return false;
        }
        StringTokenizer tk = new StringTokenizer(name, ".", true);
        boolean delimExpected = false;
        while (tk.hasMoreTokens()) {
            String namePart = tk.nextToken();
            if (delimExpected ^ namePart.equals(".")) {
                return false;
            }
            if (!delimExpected && !Utilities.isJavaIdentifier((String)namePart)) {
                return false;
            }
            delimExpected = !delimExpected;
        }
        return delimExpected;
    }

    public static boolean isValidFilePath(String name) {
        if (name.length() == 0) {
            return false;
        }
        name = name.substring(0, name.lastIndexOf("."));
        StringTokenizer tk = new StringTokenizer(name, "/", true);
        boolean delimExpected = false;
        while (tk.hasMoreTokens()) {
            String namePart = tk.nextToken();
            if (delimExpected ^ namePart.equals("/")) {
                return false;
            }
            if (!delimExpected && !Utilities.isJavaIdentifier((String)namePart)) {
                return false;
            }
            delimExpected = !delimExpected;
        }
        return delimExpected;
    }

    public static LocalizedBundleInfo findLocalizedBundleInfo(FileObject sourceDir, Manifest manifest) {
        String locBundleResource = ManifestManager.getInstance((Manifest)manifest, (boolean)false).getLocalizingBundle();
        try {
            if (locBundleResource != null) {
                ArrayList<FileObject> bundleFOs = new ArrayList<FileObject>();
                for (String resource : ApisupportAntUtils.getPossibleResources(locBundleResource)) {
                    FileObject bundleFO = sourceDir.getFileObject(resource);
                    if (bundleFO == null) continue;
                    bundleFOs.add(bundleFO);
                }
                if (!bundleFOs.isEmpty()) {
                    Collections.reverse(bundleFOs);
                    return LocalizedBundleInfo.load(bundleFOs.toArray(new FileObject[bundleFOs.size()]));
                }
            }
        }
        catch (IOException e) {
            Util.err.notify(1, (Throwable)e);
        }
        return null;
    }

    public static LocalizedBundleInfo findLocalizedBundleInfo(File projectDir) {
        NbModuleProject p;
        FileObject projectDirFO = FileUtil.toFileObject((File)projectDir);
        if (projectDirFO == null) {
            return null;
        }
        try {
            p = (NbModuleProject)ProjectManager.getDefault().findProject(projectDirFO);
        }
        catch (IOException e) {
            return null;
        }
        if (p == null) {
            return null;
        }
        String src = p.evaluator().getProperty("src.dir");
        if (src == null) {
            return null;
        }
        File srcF = FileUtil.normalizeFile((File)new File(projectDir, src));
        FileObject sourceDir = FileUtil.toFileObject((File)srcF);
        FileObject manifestFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(projectDir, "manifest.mf")));
        LocalizedBundleInfo locInfo = null;
        Manifest mf = Util.getManifest((FileObject)manifestFO);
        if (sourceDir != null && mf != null) {
            locInfo = ApisupportAntUtils.findLocalizedBundleInfo(sourceDir, mf);
        }
        return locInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LocalizedBundleInfo findLocalizedBundleInfoFromJAR(File binaryProject) {
        try {
            JarFile main = new JarFile(binaryProject, false);
            try {
                Manifest mf = main.getManifest();
                String locBundleResource = ManifestManager.getInstance((Manifest)mf, (boolean)false).getLocalizingBundle();
                if (locBundleResource != null) {
                    ArrayList<InputStream> bundleISs = new ArrayList<InputStream>();
                    ArrayList<JarFile> extraJarFiles = new ArrayList<JarFile>();
                    try {
                        Iterator name = binaryProject.getName();
                        int dot = ((String)((Object)name)).lastIndexOf(46);
                        if (dot == -1) {
                            dot = ((String)((Object)name)).length();
                        }
                        String base = ((String)((Object)name)).substring(0, dot);
                        String suffix = ((String)((Object)name)).substring(dot);
                        for (String infix : NbCollections.iterable((Iterator)NbBundle.getLocalizingSuffixes())) {
                            File variant = new File(binaryProject.getParentFile(), "locale" + File.separatorChar + base + infix + suffix);
                            if (!variant.isFile()) continue;
                            JarFile jf = new JarFile(variant, false);
                            extraJarFiles.add(jf);
                            ApisupportAntUtils.addBundlesFromJar(jf, bundleISs, locBundleResource);
                        }
                        ApisupportAntUtils.addBundlesFromJar(main, bundleISs, locBundleResource);
                        if (!bundleISs.isEmpty()) {
                            Collections.reverse(bundleISs);
                            LocalizedBundleInfo localizedBundleInfo = LocalizedBundleInfo.load(bundleISs.toArray(new InputStream[bundleISs.size()]));
                            return localizedBundleInfo;
                        }
                    }
                    finally {
                        for (InputStream bundleIS : bundleISs) {
                            bundleIS.close();
                        }
                        Iterator iterator = extraJarFiles.iterator();
                        while (true) {
                            if (!iterator.hasNext()) {
                            }
                            JarFile jarFile = (JarFile)iterator.next();
                            jarFile.close();
                        }
                    }
                }
                if (mf.getMainAttributes().getValue("Bundle-SymbolicName") == null) return null;
                Properties p = new Properties();
                String[] from = new String[]{"Bundle-Name", "Bundle-Category", "Bundle-Description", "Bundle-Description"};
                String[] to = new String[]{"OpenIDE-Module-Name", "OpenIDE-Module-Display-Category", "OpenIDE-Module-Short-Description", "OpenIDE-Module-Long-Description"};
                for (int i = 0; i < from.length; ++i) {
                    String v = mf.getMainAttributes().getValue(from[i]);
                    if (v == null) continue;
                    p.setProperty(to[i], v);
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                p.store(baos, null);
                LocalizedBundleInfo localizedBundleInfo = LocalizedBundleInfo.load(new InputStream[]{new ByteArrayInputStream(baos.toByteArray())});
                return localizedBundleInfo;
            }
            finally {
                main.close();
            }
        }
        catch (IOException e) {
            Util.err.notify(1, (Throwable)e);
        }
        return null;
    }

    private static void addBundlesFromJar(JarFile jf, List<InputStream> bundleISs, String locBundleResource) throws IOException {
        for (String resource : ApisupportAntUtils.getPossibleResources(locBundleResource)) {
            ZipEntry entry = jf.getEntry(resource);
            if (entry == null) continue;
            InputStream bundleIS = jf.getInputStream(entry);
            bundleISs.add(bundleIS);
        }
    }

    private static Iterable<String> getPossibleResources(String locBundleResource) {
        String locBundleResourceExt;
        String locBundleResourceBase;
        int idx = locBundleResource.lastIndexOf(46);
        if (idx != -1 && idx > locBundleResource.lastIndexOf(47)) {
            locBundleResourceBase = locBundleResource.substring(0, idx);
            locBundleResourceExt = locBundleResource.substring(idx);
        } else {
            locBundleResourceBase = locBundleResource;
            locBundleResourceExt = "";
        }
        LinkedHashSet<String> resources = new LinkedHashSet<String>();
        for (String suffix : NbCollections.iterable((Iterator)NbBundle.getLocalizingSuffixes())) {
            String resource = locBundleResourceBase + suffix + locBundleResourceExt;
            resources.add(resource);
            resources.add(resource);
        }
        return resources;
    }

    public static boolean addDependency(NbModuleProject target, String codeNameBase, @NullAllowed String releaseVersion, @NullAllowed SpecificationVersion version, boolean useInCompiler, String clusterName) throws IOException {
        ModuleEntry me;
        Project suiteProject;
        if (target.getModuleType() == NbModuleType.SUITE_COMPONENT && clusterName != null && (suiteProject = ApisupportAntUtils.getSuiteProject(target)) != null) {
            SuiteProperties suiteProps = ApisupportAntUtils.getSuiteProperties((SuiteProject)suiteProject);
            boolean isClusterIncludedInTargetPlatform = ApisupportAntUtils.isClusterIncludedInTargetPlatform(suiteProps, clusterName);
            if (isClusterIncludedInTargetPlatform && !ApisupportAntUtils.isModuleIncludedInTargetPlatform(suiteProps, codeNameBase)) {
                ApisupportAntUtils.addModuleToTargetPlatform(suiteProject, suiteProps, codeNameBase);
            } else if (!isClusterIncludedInTargetPlatform) {
                ApisupportAntUtils.addClusterToTargetPlatform(suiteProject, suiteProps, clusterName, codeNameBase);
            }
        }
        if ((me = target.getModuleList().getEntry(codeNameBase)) == null) {
            Util.err.log(1, "Trying to add " + codeNameBase + " which cannot be found in the module's universe.");
            return false;
        }
        ProjectXMLManager pxm = new ProjectXMLManager(target);
        for (ModuleDependency md : pxm.getDirectDependencies()) {
            String old;
            if (!codeNameBase.equals(md.getModuleEntry().getCodeNameBase())) continue;
            if (!(version == null || md.hasImplementationDependency() || (old = md.getSpecificationVersion()) != null && version.compareTo((Object)new SpecificationVersion(old)) <= 0)) {
                pxm.removeDependency(codeNameBase);
                break;
            }
            Util.err.log(1, codeNameBase + " already added");
            return false;
        }
        ModuleDependency md = new ModuleDependency(me, releaseVersion == null ? me.getReleaseVersion() : releaseVersion, version == null ? me.getSpecificationVersion() : version.toString(), useInCompiler, false);
        try {
            pxm.addDependency(md);
        }
        catch (ProjectXMLManager.CyclicDependencyException ex) {
            Util.err.log(1, ex.getLocalizedMessage());
            return false;
        }
        return true;
    }

    static void addTestDependency(NbModuleProject prj, String codeNameBase, String clusterName) throws IOException {
        ModuleEntry me;
        Project suiteProject;
        if (prj.getModuleType() == NbModuleType.SUITE_COMPONENT && clusterName != null && (suiteProject = ApisupportAntUtils.getSuiteProject(prj)) != null) {
            SuiteProperties suiteProps = ApisupportAntUtils.getSuiteProperties((SuiteProject)suiteProject);
            boolean isClusterIncludedInTargetPlatform = ApisupportAntUtils.isClusterIncludedInTargetPlatform(suiteProps, clusterName);
            if (isClusterIncludedInTargetPlatform && !ApisupportAntUtils.isModuleIncludedInTargetPlatform(suiteProps, codeNameBase)) {
                ApisupportAntUtils.addModuleToTargetPlatform(suiteProject, suiteProps, codeNameBase);
            } else if (!isClusterIncludedInTargetPlatform) {
                ApisupportAntUtils.addClusterToTargetPlatform(suiteProject, suiteProps, clusterName, codeNameBase);
            }
        }
        if ((me = prj.getModuleList().getEntry(codeNameBase)) == null) {
            Util.err.log(1, "Trying to add " + codeNameBase + " which cannot be found in the module's universe.");
            return;
        }
        ProjectXMLManager pxm = new ProjectXMLManager(prj);
        Map<String, Set<TestModuleDependency>> map = pxm.getTestDependencies(prj.getModuleList());
        if (map != null && map.get("unit") != null) {
            for (TestModuleDependency md : map.get("unit")) {
                if (!codeNameBase.equals(md.getModule().getCodeNameBase())) continue;
                Util.err.log(1, codeNameBase + " already added");
                return;
            }
        }
        TestModuleDependency md = new TestModuleDependency(me, true, true, true);
        pxm.addTestDependency("unit", md);
    }

    public static URL findJavadocURL(String cnbdashes, URL[] roots) {
        URL indexURL = null;
        for (int i = 0; i < roots.length; ++i) {
            URL root = roots[i];
            try {
                indexURL = ApisupportAntUtils.normalizeURL(new URL(root, cnbdashes + "/index.html"));
                if (indexURL == null && root.toExternalForm().indexOf(cnbdashes) != -1) {
                    indexURL = ApisupportAntUtils.normalizeURL(new URL(root, "index.html"));
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (indexURL != null) break;
        }
        return indexURL;
    }

    private static URL normalizeURL(URL url) {
        FileObject fo = URLMapper.findFileObject((URL)url);
        if (fo != null) {
            return URLMapper.findURL((FileObject)fo, (int)1);
        }
        return null;
    }

    public static SortedSet<String> scanProjectForPackageNames(File prjDir) {
        return ApisupportAntUtils.scanProjectForPackageNames(prjDir, true);
    }

    public static SortedSet<String> scanProjectForPackageNames(File prjDir, boolean withCPExt) {
        NbModuleProject project = null;
        FileObject source = FileUtil.toFileObject((File)prjDir);
        if (source != null) {
            try {
                project = (NbModuleProject)ProjectManager.getDefault().findProject(source);
            }
            catch (IOException e) {
                Util.err.notify(1, (Throwable)e);
            }
        }
        if (project == null) {
            return new TreeSet<String>(Collections.emptySet());
        }
        TreeSet<String> availablePublicPackages = new TreeSet<String>();
        HashSet<FileObject> pkgs = new HashSet<FileObject>();
        FileObject srcDirFO = project.getSourceDirectory();
        ApisupportAntUtils.scanForPackages(pkgs, srcDirFO, "java");
        for (FileObject pkg : pkgs) {
            if (srcDirFO.equals(pkg)) continue;
            String pkgS = PropertyUtils.relativizeFile((File)FileUtil.toFile((FileObject)srcDirFO), (File)FileUtil.toFile((FileObject)pkg));
            availablePublicPackages.add(pkgS.replace('/', '.'));
        }
        if (withCPExt) {
            String[] libsPaths = new ProjectXMLManager(project).getBinaryOrigins();
            for (int i = 0; i < libsPaths.length; ++i) {
                ApisupportAntUtils.scanJarForPackageNames(availablePublicPackages, project.getHelper().resolveFile(libsPaths[i]));
            }
        }
        Iterator it = availablePublicPackages.iterator();
        while (it.hasNext()) {
            String pkg = (String)it.next();
            if (ApisupportAntUtils.isValidJavaFQN(pkg)) continue;
            it.remove();
        }
        return availablePublicPackages;
    }

    public static void scanJarForPackageNames(Set<String> packages, File jarFile) {
        FileObject jarFileFO = FileUtil.toFileObject((File)jarFile);
        if (jarFileFO == null) {
            return;
        }
        FileObject root = FileUtil.getArchiveRoot((FileObject)jarFileFO);
        if (root == null) {
            return;
        }
        HashSet<FileObject> pkgs = new HashSet<FileObject>();
        ApisupportAntUtils.scanForPackages(pkgs, root, "class");
        for (FileObject pkg : pkgs) {
            String pkgS;
            if (root.equals(pkg) || !ApisupportAntUtils.isValidJavaFQN(pkgS = pkg.getPath().replace('/', '.'))) continue;
            packages.add(pkgS);
        }
    }

    private static void scanForPackages(Set<FileObject> validPkgs, FileObject dir, String ext) {
        if (dir == null) {
            return;
        }
        Enumeration en1 = dir.getFolders(false);
        while (en1.hasMoreElements()) {
            FileObject subDir = (FileObject)en1.nextElement();
            if (!VisibilityQuery.getDefault().isVisible(subDir)) continue;
            ApisupportAntUtils.scanForPackages(validPkgs, subDir, ext);
        }
        Enumeration en2 = dir.getData(false);
        while (en2.hasMoreElements()) {
            FileObject kid = (FileObject)en2.nextElement();
            if (!kid.hasExt(ext) || !Utilities.isJavaIdentifier((String)kid.getName())) continue;
            validPkgs.add(dir);
            break;
        }
    }

    public static String urlsToAntPath(URL[] urls) {
        return ClassPathSupport.createClassPath((URL[])urls).toString(ClassPath.PathConversionMode.WARN);
    }

    public static URL[] findURLs(String path) {
        if (path == null) {
            return new URL[0];
        }
        String[] pieces = PropertyUtils.tokenizePath((String)path);
        URL[] urls = new URL[pieces.length];
        for (int i = 0; i < pieces.length; ++i) {
            urls[i] = FileUtil.urlForArchiveOrDir((File)FileUtil.normalizeFile((File)new File(pieces[i])));
        }
        return urls;
    }

    public static String[] copyClassPathExtensionJar(File projectDir, File jar) throws IOException {
        String[] ret = null;
        File releaseDir = new File(projectDir, CPEXT_BINARY_PATH);
        if (!releaseDir.isDirectory() && !releaseDir.mkdirs()) {
            throw new IOException("cannot create release directory '" + releaseDir + "'.");
        }
        FileObject relDirFo = FileUtil.toFileObject((File)releaseDir);
        FileObject orig = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)jar));
        if (orig != null) {
            FileObject existing = relDirFo.getFileObject(orig.getName(), orig.getExt());
            if (existing != null) {
                existing.delete();
            }
            FileUtil.copyFile((FileObject)orig, (FileObject)relDirFo, (String)orig.getName());
            ret = new String[]{CPEXT_RUNTIME_RELATIVE_PATH + orig.getNameExt(), CPEXT_BINARY_PATH + orig.getNameExt()};
        }
        return ret;
    }

    static SuiteProperties getSuiteProperties(NbModuleProject target) {
        Project suiteProject = ApisupportAntUtils.getSuiteProject(target);
        if (suiteProject != null) {
            return ApisupportAntUtils.getSuiteProperties((SuiteProject)suiteProject);
        }
        return null;
    }

    static SuiteProperties getSuiteProperties(SuiteProject suiteProject) {
        if (suiteProject != null) {
            Set<NbModuleProject> subModules = SuiteUtils.getSubProjects(suiteProject);
            return new SuiteProperties(suiteProject, suiteProject.getHelper(), suiteProject.getEvaluator(), subModules);
        }
        return null;
    }

    static Project getSuiteProject(NbModuleProject target) {
        FileObject suiteDirectoryFO;
        File suiteDirectory = ((SuiteProvider)target.getLookup().lookup(SuiteProvider.class)).getSuiteDirectory();
        if (suiteDirectory != null && (suiteDirectoryFO = FileUtil.toFileObject((File)suiteDirectory)) != null) {
            try {
                return ProjectManager.getDefault().findProject(suiteDirectoryFO);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IllegalArgumentException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    static boolean isModuleIncludedInTargetPlatform(SuiteProperties suiteProps, String codeNameBase) {
        if (suiteProps != null) {
            for (String disabledModuleIter : suiteProps.getDisabledModules()) {
                if (!disabledModuleIter.equals(codeNameBase)) continue;
                return false;
            }
        }
        return true;
    }

    static boolean isClusterIncludedInTargetPlatform(SuiteProperties suiteProps, String clusterName) {
        Set<ClusterInfo> clusterInfoSet;
        if (suiteProps != null && (clusterInfoSet = suiteProps.getClusterPath()) != null) {
            for (ClusterInfo infoIter : clusterInfoSet) {
                if (!infoIter.getClusterDir().getName().equals(clusterName)) continue;
                return true;
            }
        }
        return false;
    }

    static void addModuleToTargetPlatform(final Project suiteProject, final SuiteProperties suiteProps, String codeNameBase) {
        if (suiteProps != null) {
            HashSet<String> disabledModules = new HashSet<String>(Arrays.asList(suiteProps.getDisabledModules()));
            for (String disableModuleIter : disabledModules) {
                if (!codeNameBase.equals(disableModuleIter)) continue;
                disabledModules.remove(codeNameBase);
                break;
            }
            String[] updatedDiasabledModules = new String[disabledModules.size()];
            disabledModules.toArray(updatedDiasabledModules);
            suiteProps.setDisabledModules(updatedDiasabledModules);
            ProjectManager.mutex().writeAccess(new Runnable(){

                @Override
                public void run() {
                    try {
                        suiteProps.storeProperties();
                        ProjectManager.getDefault().saveProject(suiteProject);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        }
    }

    static void addClusterToTargetPlatform(final Project suiteProject, final SuiteProperties suiteProps, String clusterName, String codeNameBase) {
        if (suiteProps != null) {
            ArrayList<ClusterInfo> clusterInfoSet = new ArrayList<ClusterInfo>(suiteProps.getClusterPath());
            if (suiteProps.getActivePlatform() != null) {
                File clusterDirectory = null;
                Set<ModuleEntry> moduleList = suiteProps.getActivePlatform().getModules();
                for (ModuleEntry entryIter : moduleList) {
                    if (!entryIter.getClusterDirectory().getName().equals(clusterName)) continue;
                    clusterDirectory = entryIter.getClusterDirectory();
                    break;
                }
                if (clusterDirectory != null) {
                    ClusterInfo newClusterInfo = ClusterInfo.create(clusterDirectory, true, true);
                    clusterInfoSet.add(newClusterInfo);
                    HashSet<String> disabledModules = new HashSet<String>(Arrays.asList(suiteProps.getDisabledModules()));
                    for (ModuleEntry entryIter : moduleList) {
                        if (!entryIter.getClusterDirectory().equals(clusterDirectory)) continue;
                        disabledModules.add(entryIter.getCodeNameBase());
                    }
                    suiteProps.setClusterPath(clusterInfoSet);
                    disabledModules.remove(codeNameBase);
                    String[] updatedDiasabledModules = new String[disabledModules.size()];
                    disabledModules.toArray(updatedDiasabledModules);
                    suiteProps.setDisabledModules(updatedDiasabledModules);
                    ProjectManager.mutex().writeAccess(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                suiteProps.storeProperties();
                                ProjectManager.getDefault().saveProject(suiteProject);
                            }
                            catch (IOException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    });
                }
            }
        }
    }

    public static final class UserPropertiesFileProvider
    implements PropertyProvider,
    PropertyChangeListener,
    ChangeListener {
        private final PropertyEvaluator eval;
        private final File basedir;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private final ChangeListener listener = WeakListeners.change((ChangeListener)this, null);
        private PropertyProvider delegate;

        public UserPropertiesFileProvider(PropertyEvaluator eval, File basedir) {
            this.eval = eval;
            this.basedir = basedir;
            eval.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)eval));
            this.computeDelegate();
        }

        private void computeDelegate() {
            String buildS;
            if (this.delegate != null) {
                this.delegate.removeChangeListener(this.listener);
            }
            this.delegate = (buildS = this.eval.getProperty("user.properties.file")) != null ? PropertyUtils.propertiesFilePropertyProvider((File)PropertyUtils.resolveFile((File)this.basedir, (String)buildS)) : PropertyUtils.globalPropertyProvider();
            this.delegate.addChangeListener(this.listener);
        }

        public Map<String, String> getProperties() {
            if (this.delegate != null) {
                return this.delegate.getProperties();
            }
            return Collections.emptyMap();
        }

        public void addChangeListener(ChangeListener l) {
            this.changeSupport.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.changeSupport.removeChangeListener(l);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String p = evt.getPropertyName();
            if (p == null || p.equals("user.properties.file")) {
                this.computeDelegate();
                this.changeSupport.fireChange();
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.changeSupport.fireChange();
        }
    }

    public static abstract class ComputedPropertyProvider
    implements PropertyProvider,
    PropertyChangeListener {
        private final PropertyEvaluator eval;
        private final ChangeSupport cs = new ChangeSupport((Object)this);

        protected ComputedPropertyProvider(PropertyEvaluator eval) {
            this.eval = eval;
            eval.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)eval));
        }

        protected abstract Map<String, String> getProperties(Map<String, String> var1);

        protected abstract Collection<String> inputProperties();

        public final Map<String, String> getProperties() {
            HashMap<String, String> vals = new HashMap<String, String>();
            for (String k : this.inputProperties()) {
                vals.put(k, this.eval.getProperty(k));
            }
            return this.getProperties(vals);
        }

        public final void addChangeListener(ChangeListener l) {
            this.cs.addChangeListener(l);
        }

        public final void removeChangeListener(ChangeListener l) {
            this.cs.removeChangeListener(l);
        }

        @Override
        public final void propertyChange(PropertyChangeEvent evt) {
            String p = evt.getPropertyName();
            if (p != null && !this.inputProperties().contains(p)) {
                return;
            }
            this.cs.fireChange();
        }
    }
}

