/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.actions;

import java.beans.PropertyChangeEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.web.javascript.debugger.MiscEditorUtil;
import org.netbeans.modules.web.javascript.debugger.actions.Bundle;
import org.netbeans.modules.web.webkit.debugging.api.Debugger;
import org.netbeans.modules.web.webkit.debugging.api.debugger.CallFrame;
import org.netbeans.modules.web.webkit.debugging.spi.JavaScriptDebuggerFactory;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.CodeEvaluator;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class DebuggerActionsProvider
extends ActionsProviderSupport
implements Debugger.Listener {
    private static final Set<Object> ACTIONS = Collections.unmodifiableSet(new HashSet<Object>(Arrays.asList(ActionsManager.ACTION_CONTINUE, ActionsManager.ACTION_STEP_INTO, ActionsManager.ACTION_STEP_OVER, ActionsManager.ACTION_STEP_OUT, ActionsManager.ACTION_EVALUATE)));
    private static final Logger USG_LOGGER = Logger.getLogger("org.netbeans.ui.metrics.debugger");
    private static final String USG_LOG_MSG = "USG_DEBUG_HTML5_JS";
    private Debugger debugger;
    private static boolean usgLogged = false;

    private void updateDebuggerState() {
        if (!this.debugger.isEnabled()) {
            this.setEnabled(ActionsManager.ACTION_CONTINUE, false);
            this.setEnabled(ActionsManager.ACTION_STEP_INTO, false);
            this.setEnabled(ActionsManager.ACTION_STEP_OVER, false);
            this.setEnabled(ActionsManager.ACTION_STEP_OUT, false);
            this.setEnabled(ActionsManager.ACTION_EVALUATE, false);
        } else if (this.debugger.isSuspended()) {
            this.setEnabled(ActionsManager.ACTION_CONTINUE, true);
            this.setEnabled(ActionsManager.ACTION_STEP_INTO, true);
            this.setEnabled(ActionsManager.ACTION_STEP_OVER, true);
            this.setEnabled(ActionsManager.ACTION_STEP_OUT, true);
            this.setEnabled(ActionsManager.ACTION_EVALUATE, true);
        } else {
            this.setEnabled(ActionsManager.ACTION_CONTINUE, false);
            this.setEnabled(ActionsManager.ACTION_STEP_INTO, false);
            this.setEnabled(ActionsManager.ACTION_STEP_OVER, false);
            this.setEnabled(ActionsManager.ACTION_STEP_OUT, false);
            this.setEnabled(ActionsManager.ACTION_EVALUATE, false);
        }
    }

    public DebuggerActionsProvider(ContextProvider contextProvider) {
        this.debugger = (Debugger)contextProvider.lookupFirst(null, Debugger.class);
        this.debugger.addListener((Debugger.Listener)this);
    }

    public Set<Object> getActions() {
        return ACTIONS;
    }

    public void postAction(Object action, Runnable actionPerformedNotifier) {
        if (action == ActionsManager.ACTION_EVALUATE) {
            CodeEvaluator.getDefault().open();
            actionPerformedNotifier.run();
        } else {
            super.postAction(action, actionPerformedNotifier);
        }
    }

    public void doAction(Object action) {
        if (!usgLogged) {
            this.logJSDebugAction();
            usgLogged = true;
        }
        if (action != ActionsManager.ACTION_START) {
            if (action == ActionsManager.ACTION_KILL) {
                JavaScriptDebuggerFactory factory;
                if (this.debugger.isEnabled() && (factory = (JavaScriptDebuggerFactory)Lookup.getDefault().lookup(JavaScriptDebuggerFactory.class)) != null) {
                    factory.stopDebuggingSession(DebuggerManager.getDebuggerManager().getCurrentSession());
                }
            } else if (action == ActionsManager.ACTION_CONTINUE) {
                this.debugger.resume();
            } else if (action == ActionsManager.ACTION_PAUSE) {
                this.debugger.pause();
                StatusDisplayer.getDefault().setStatusText(Bundle.MSG_WILL_PAUSE());
                this.setEnabled(ActionsManager.ACTION_PAUSE, false);
            } else if (action == ActionsManager.ACTION_STEP_OVER) {
                this.debugger.stepOver();
            } else if (action == ActionsManager.ACTION_STEP_INTO) {
                this.debugger.stepInto();
            } else if (action == ActionsManager.ACTION_STEP_OUT) {
                this.debugger.stepOut();
            } else if (action == ActionsManager.ACTION_RUN_TO_CURSOR) {
                // empty if block
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.handleRunToCursor();
    }

    private void handleRunToCursor() {
        JEditorPane editorPane = EditorContextDispatcher.getDefault().getCurrentEditor();
        this.setEnabled(ActionsManager.ACTION_RUN_TO_CURSOR, editorPane != null && DebuggerActionsProvider.getActionsManager().isEnabled(ActionsManager.ACTION_CONTINUE) && EditorContextDispatcher.getDefault().getCurrentLineNumber() >= 0 && MiscEditorUtil.isJSOrWrapperMIMEType(editorPane.getContentType()));
    }

    static ActionsManager getActionsManager() {
        return DebuggerManager.getDebuggerManager().getCurrentEngine() == null ? DebuggerManager.getDebuggerManager().getActionsManager() : DebuggerManager.getDebuggerManager().getCurrentEngine().getActionsManager();
    }

    public void paused(List<CallFrame> callStack, String reason) {
        this.updateDebuggerState();
    }

    public void resumed() {
        this.updateDebuggerState();
    }

    public void reset() {
    }

    public void enabled(boolean enabled) {
        this.updateDebuggerState();
    }

    private void logJSDebugAction() {
        LogRecord record = new LogRecord(Level.INFO, USG_LOG_MSG);
        record.setResourceBundle(NbBundle.getBundle(DebuggerActionsProvider.class));
        record.setResourceBundleName(DebuggerActionsProvider.class.getPackage().getName() + ".Bundle");
        record.setLoggerName(USG_LOGGER.getName());
        boolean inLiveHTML = this.debugger.isInLiveHTMLMode();
        record.setParameters(new Object[]{inLiveHTML});
        USG_LOGGER.log(record);
    }
}

