/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.impl.RemoteLogger;
import org.netbeans.modules.remote.impl.fs.RemoteExceptions;
import org.netbeans.modules.remote.impl.fs.RemoteFileObject;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemUtils;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.util.NbBundle;

public abstract class RemoteLinkBase
extends RemoteFileObjectBase
implements FileChangeListener {
    protected RemoteLinkBase(RemoteFileObject wrapper, RemoteFileSystem fileSystem, ExecutionEnvironment execEnv, RemoteFileObjectBase parent, String remotePath) {
        super(wrapper, fileSystem, execEnv, parent, remotePath);
    }

    protected void initListeners(boolean add) {
        if (add) {
            this.getFileSystem().getFactory().addFileChangeListener(this.getDelegateNormalizedPath(), this);
        } else {
            this.getFileSystem().getFactory().removeFileChangeListener(this.getDelegateNormalizedPath(), this);
        }
    }

    public abstract RemoteFileObjectBase getCanonicalDelegate();

    protected abstract String getDelegateNormalizedPath();

    protected abstract RemoteFileObjectBase getDelegateImpl();

    protected FileNotFoundException fileNotFoundException(String operation) {
        return RemoteExceptions.createFileNotFoundException(NbBundle.getMessage(RemoteLinkBase.class, (String)"EXC_CantPerformOpOnDeadLink", (Object)operation, (Object)this.getDisplayName()));
    }

    @Override
    public RemoteFileObject[] getChildren() {
        RemoteFileObjectBase delegate = this.getCanonicalDelegate();
        if (delegate != null) {
            RemoteFileObject[] children = delegate.getChildren();
            for (int i = 0; i < children.length; ++i) {
                children[i] = this.wrapFileObject(children[i], null);
            }
            return children;
        }
        return new RemoteFileObject[0];
    }

    @Override
    public final boolean isSymbolicLink() {
        return true;
    }

    private RemoteFileObject wrapFileObject(RemoteFileObject fo, String relativePath) {
        String childAbsPath = relativePath == null ? this.getPath() + '/' + fo.getNameExt() : RemoteFileSystemUtils.normalize(this.getPath() + '/' + relativePath);
        if (relativePath != null && (relativePath.contains("/") || relativePath.contains(".."))) {
            return fo;
        }
        RemoteFileObjectBase result = this.getFileSystem().getFactory().createRemoteLinkChild(this, childAbsPath, fo.getImplementor());
        return result.getOwnerFileObject();
    }

    @Override
    public long getSize() {
        RemoteFileObjectBase delegate = this.getCanonicalDelegate();
        return delegate == null ? 0L : delegate.getSize();
    }

    @Override
    public boolean hasCache() {
        RemoteFileObjectBase delegate = this.getCanonicalDelegate();
        return delegate == null ? false : delegate.hasCache();
    }

    @Override
    public RemoteFileObject getFileObject(String name, String ext, @NonNull Set<String> antiLoop) {
        RemoteFileObjectBase delegate = this.getCanonicalDelegate();
        if (delegate != null) {
            RemoteFileObject fo = delegate.getFileObject(name, ext, antiLoop);
            if (fo != null && fo.getImplementor().getParent() == delegate) {
                fo = this.wrapFileObject(fo, null);
            }
            return fo;
        }
        return null;
    }

    @Override
    public RemoteFileObject getFileObject(String relativePath, @NonNull Set<String> antiLoop) {
        RemoteFileObjectBase delegate = this.getCanonicalDelegate();
        if (delegate != null) {
            RemoteFileObject fo = delegate.getFileObject(relativePath, antiLoop);
            if (fo != null && fo.getImplementor().getParent() == delegate) {
                fo = this.wrapFileObject(fo, relativePath);
            }
            return fo;
        }
        return null;
    }

    @Override
    public boolean isFolder() {
        RemoteFileObjectBase delegate = this.getCanonicalDelegate();
        return delegate == null ? false : delegate.isFolder();
    }

    @Override
    public boolean isData() {
        RemoteFileObjectBase delegate = this.getCanonicalDelegate();
        return delegate == null ? true : delegate.isData();
    }

    @Override
    public InputStream getInputStream(boolean checkLock) throws FileNotFoundException {
        RemoteFileObjectBase delegate = this.getCanonicalDelegate();
        if (delegate == null) {
            throw this.fileNotFoundException("read");
        }
        return delegate.getInputStream(checkLock);
    }

    @Override
    public boolean canRead() {
        RemoteFileObjectBase delegate = this.getCanonicalDelegate();
        return delegate == null ? false : delegate.canRead();
    }

    @Override
    protected FileLock lockImpl(RemoteFileObjectBase orig) throws IOException {
        RemoteFileObjectBase delegate = this.getCanonicalDelegate();
        if (delegate != null) {
            return delegate.lockImpl(orig);
        }
        return super.lockImpl(orig);
    }

    @Override
    public Date lastModified() {
        RemoteFileObjectBase delegate = this.getCanonicalDelegate();
        if (delegate != null) {
            return delegate.lastModified();
        }
        return new Date(0L);
    }

    @Override
    protected boolean checkLock(FileLock aLock) throws IOException {
        RemoteFileObjectBase delegate = this.getCanonicalDelegate();
        if (delegate != null) {
            return delegate.checkLock(aLock);
        }
        return super.checkLock(aLock);
    }

    @Override
    protected boolean isReadOnlyImpl(RemoteFileObjectBase orig) {
        RemoteFileObjectBase delegate = this.getCanonicalDelegate();
        return delegate == null ? true : delegate.isReadOnlyImpl(orig);
    }

    @Override
    protected OutputStream getOutputStreamImpl(FileLock lock, RemoteFileObjectBase orig) throws IOException {
        RemoteFileObjectBase delegate = this.getCanonicalDelegate();
        if (delegate != null) {
            return delegate.getOutputStreamImpl(lock, orig);
        }
        throw this.fileNotFoundException("write");
    }

    @Override
    protected final void refreshThisFileMetadataImpl(boolean recursive, Set<String> antiLoop, boolean expected, RemoteFileObjectBase.RefreshMode refreshMode, int timeoutMillis) throws TimeoutException, ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        if (this.getParent() != null) {
            this.getParent().refreshImpl(false, antiLoop, expected, refreshMode, timeoutMillis);
        }
    }

    @Override
    public final void refreshImpl(boolean recursive, Set<String> antiLoop, boolean expected, RemoteFileObjectBase.RefreshMode refreshMode, int timeoutMillis) throws TimeoutException, ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        if (antiLoop == null) {
            antiLoop = new HashSet<String>();
        }
        if (antiLoop.contains(this.getPath())) {
            return;
        }
        antiLoop.add(this.getPath());
        RemoteFileObjectBase delegate = this.getCanonicalDelegate();
        if (refreshMode != RemoteFileObjectBase.RefreshMode.FROM_PARENT) {
            this.refreshThisFileMetadataImpl(recursive, antiLoop, expected, refreshMode, timeoutMillis);
        }
        if (delegate != null) {
            delegate.refreshImpl(recursive, antiLoop, expected, refreshMode, timeoutMillis);
        } else {
            RemoteLogger.log(Level.FINEST, "Null delegate for link {0}", this);
        }
    }

    @Override
    protected void renameChild(FileLock lock, RemoteFileObjectBase toRename, String newNameExt, RemoteFileObjectBase orig) throws ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        RemoteLogger.assertTrueInConsole(false, "renameChild is not supported on " + this.getClass() + " path=" + this.getPath(), new Object[0]);
    }

    @Override
    protected RemoteFileObject createFolderImpl(String name, RemoteFileObjectBase orig) throws IOException {
        RemoteFileObjectBase delegate = this.getCanonicalDelegate();
        if (delegate != null) {
            return this.wrapFileObject(delegate.createFolderImpl(name, orig), null);
        }
        throw this.fileNotFoundException("create a folder in");
    }

    @Override
    protected RemoteFileObject createDataImpl(String name, String ext, RemoteFileObjectBase orig) throws IOException {
        RemoteFileObjectBase delegate = this.getCanonicalDelegate();
        if (delegate != null) {
            return this.wrapFileObject(delegate.createDataImpl(name, ext, orig), null);
        }
        throw this.fileNotFoundException("create a file in");
    }

    @Override
    public boolean canWriteImpl(RemoteFileObjectBase orig) {
        RemoteFileObjectBase delegate = this.getCanonicalDelegate();
        return delegate == null ? super.canWriteImpl(orig) : delegate.canWriteImpl(orig);
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
        this.fireFileAttributeChangedEvent(this.getListeners(), (FileAttributeEvent)this.transform((FileEvent)fe));
    }

    public void fileChanged(FileEvent fe) {
        this.fireFileChangedEvent(this.getListeners(), this.transform(fe));
    }

    public void fileDataCreated(FileEvent fe) {
        this.fireFileDataCreatedEvent(this.getListeners(), this.transform(fe));
    }

    public void fileDeleted(FileEvent fe) {
        if (!this.isCyclicLink()) {
            this.fireFileDeletedEvent(this.getListeners(), this.transform(fe));
        }
    }

    public void fileFolderCreated(FileEvent fe) {
        this.fireFileFolderCreatedEvent(this.getListeners(), this.transform(fe));
    }

    public void fileRenamed(FileRenameEvent fe) {
        this.fireFileRenamedEvent(this.getListeners(), (FileRenameEvent)this.transform((FileEvent)fe));
    }

    private boolean isCyclicLink() {
        HashSet<RemoteFileObjectBase> antiCycle = new HashSet<RemoteFileObjectBase>();
        RemoteFileObjectBase delegate = this.getCanonicalDelegate();
        if (delegate == null && this.getPath() != null) {
            return true;
        }
        while (delegate != null && delegate instanceof RemoteLinkBase) {
            if (antiCycle.contains(delegate)) {
                return true;
            }
            antiCycle.add(delegate);
            delegate = ((RemoteLinkBase)delegate).getCanonicalDelegate();
        }
        return false;
    }

    private FileEvent transform(FileEvent fe) {
        RemoteFileObjectBase delegate = this.getCanonicalDelegate();
        if (delegate != null) {
            FileObject src = this.transform((FileObject)fe.getSource(), delegate);
            FileObject file = this.transform(fe.getFile(), delegate);
            if (file != fe.getFile() || src != fe.getSource()) {
                if (fe instanceof FileRenameEvent) {
                    FileRenameEvent fre = (FileRenameEvent)fe;
                    fe = new FileRenameEvent(src, file, fre.getName(), fre.getExt(), fe.isExpected());
                } else if (fe instanceof FileAttributeEvent) {
                    FileAttributeEvent fae = (FileAttributeEvent)fe;
                    fe = new FileAttributeEvent(src, file, fae.getName(), fae.getOldValue(), fae.getNewValue(), fe.isExpected());
                } else {
                    fe = new FileEvent(src, file, fe.isExpected(), fe.getTime());
                }
            }
        }
        return fe;
    }

    private FileObject transform(FileObject fo, RemoteFileObjectBase delegate) {
        if (fo instanceof RemoteFileObject) {
            RemoteFileObjectBase originalFO = ((RemoteFileObject)fo).getImplementor();
            if (originalFO == delegate) {
                return this.getOwnerFileObject();
            }
            if (originalFO.getParent() == delegate) {
                String path = this.getPath() + '/' + fo.getNameExt();
                RemoteFileObjectBase linkChild = this.getFileSystem().getFactory().createRemoteLinkChild(this, path, originalFO);
                return linkChild.getOwnerFileObject();
            }
        }
        return fo;
    }

    @Override
    protected byte[] getMagic() {
        RemoteFileObjectBase delegate = this.getCanonicalDelegate();
        if (delegate != null) {
            return delegate.getMagic();
        }
        return null;
    }

    @Override
    public void warmup(FileSystemProvider.WarmupMode mode, Collection<String> extensions) {
        RemoteFileObjectBase delegate = this.getCanonicalDelegate();
        if (delegate != null) {
            delegate.warmup(mode, extensions);
        }
    }

    @Override
    public Object getAttribute(String attrName) {
        RemoteFileObjectBase delegate = this.getCanonicalDelegate();
        return delegate == null ? null : delegate.getAttribute(attrName);
    }

    @Override
    public Enumeration<String> getAttributes() {
        RemoteFileObjectBase delegate = this.getCanonicalDelegate();
        return delegate == null ? Collections.emptyEnumeration() : delegate.getAttributes();
    }

    @Override
    public void setAttribute(String attrName, Object value) throws IOException {
        RemoteFileObjectBase delegate = this.getCanonicalDelegate();
        if (delegate != null) {
            delegate.setAttribute(attrName, value);
        }
    }
}

