/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.FixedSizeInputStream;
import org.tmatesoft.svn.core.internal.wc.IOExceptionWrapper;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class ChunkedInputStream
extends InputStream {
    private String myCharset;
    private InputStream myInputStream;
    private int myChunkSize;
    private int myPosition;
    private boolean myIsBOF = true;
    private boolean myIsEOF = false;
    private boolean myIsClosed = false;

    public ChunkedInputStream(InputStream in, String charset) {
        this.myInputStream = in;
        this.myPosition = 0;
        this.myCharset = charset;
    }

    @Override
    public int read() throws IOException {
        if (this.myIsClosed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.myIsEOF) {
            return -1;
        }
        if (this.myPosition >= this.myChunkSize) {
            this.nextChunk();
            if (this.myIsEOF) {
                return -1;
            }
        }
        ++this.myPosition;
        return this.myInputStream.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.myIsClosed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.myIsEOF) {
            return -1;
        }
        if (this.myPosition >= this.myChunkSize) {
            this.nextChunk();
            if (this.myIsEOF) {
                return -1;
            }
        }
        len = Math.min(len, this.myChunkSize - this.myPosition);
        int count = this.myInputStream.read(b, off, len);
        this.myPosition += count;
        return count;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    private void readCRLF() throws IOException {
        int cr = this.myInputStream.read();
        int lf = this.myInputStream.read();
        if (cr != 13 || lf != 10) {
            throw new IOException("CRLF expected at end of chunk: " + cr + "/" + lf);
        }
    }

    private void nextChunk() throws IOException {
        if (!this.myIsBOF) {
            this.readCRLF();
        }
        this.myChunkSize = ChunkedInputStream.getChunkSizeFromInputStream(this.myInputStream, this.myCharset);
        this.myIsBOF = false;
        this.myPosition = 0;
        if (this.myChunkSize == 0) {
            this.myIsEOF = true;
        }
    }

    private static int getChunkSizeFromInputStream(InputStream in, String charset) throws IOException {
        int result;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int state = 0;
        block17: while (state != -1) {
            int b = in.read();
            if (b == -1) {
                throw new IOException("chunked stream ended unexpectedly");
            }
            switch (state) {
                case 0: {
                    switch (b) {
                        case 13: {
                            state = 1;
                            continue block17;
                        }
                        case 34: {
                            state = 2;
                        }
                    }
                    baos.write(b);
                    continue block17;
                }
                case 1: {
                    if (b == 10) {
                        state = -1;
                        continue block17;
                    }
                    throw new IOException("Protocol violation: Unexpected single newline character in chunk size");
                }
                case 2: {
                    switch (b) {
                        case 92: {
                            b = in.read();
                            baos.write(b);
                            continue block17;
                        }
                        case 34: {
                            state = 0;
                        }
                    }
                    baos.write(b);
                    continue block17;
                }
            }
            try {
                SVNErrorManager.assertionFailure(false, null, SVNLogType.NETWORK);
            }
            catch (SVNException svne) {
                throw new IOExceptionWrapper(svne);
            }
        }
        String dataString = new String(baos.toByteArray(), charset);
        int separator = dataString.indexOf(59);
        dataString = separator > 0 ? dataString.substring(0, separator).trim() : dataString.trim();
        try {
            result = Integer.parseInt(dataString.trim(), 16);
        }
        catch (NumberFormatException e) {
            throw new IOException("Bad chunk size: " + dataString);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.myIsClosed) {
            try {
                if (!this.myIsEOF) {
                    FixedSizeInputStream.consumeRemaining(this);
                }
            }
            finally {
                this.myIsEOF = true;
                this.myIsClosed = true;
            }
        }
    }
}

