/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.util.Map;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNTreeConflictUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;

public class SVNEntry16
extends SVNEntry {
    private SVNAdminArea myAdminArea;

    public SVNEntry16(SVNAdminArea adminArea, String name) {
        this(null, adminArea, name);
    }

    public SVNEntry16(Map attributes, SVNAdminArea adminArea, String name) {
        this.myAdminArea = adminArea;
        this.setName(name);
        this.setWorkingSize(-1L);
        this.setCommittedRevision(-1L);
        this.setRevision(-1L);
        this.setCopyFromRevision(-1L);
        this.setDepth(SVNDepth.INFINITY);
        if (attributes != null) {
            this.applyChanges(attributes);
        }
    }

    @Override
    public boolean isThisDir() {
        if (this.myAdminArea != null) {
            return this.myAdminArea.getThisDirName().equals(this.getName());
        }
        return "".equals(this.getName());
    }

    public Map getTreeConflicts() throws SVNException {
        String conflictData = this.getTreeConflictData();
        return SVNTreeConflictUtil.readTreeConflicts(this.getAdminArea().getRoot(), conflictData);
    }

    @Override
    public SVNAdminArea getAdminArea() {
        return this.myAdminArea;
    }
}

