/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.tree;

import java.util.ArrayDeque;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;

public final class TreeModelListenerList
implements TreeModelListener {
    private static final TreeModelListener[] EMPTY_ARRAY = new TreeModelListener[0];
    private final ArrayDeque<TreeModelListener> myDeque = new ArrayDeque();
    private volatile boolean myDequeEmpty = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TreeModelListener listener) {
        if (listener != null) {
            ArrayDeque<TreeModelListener> arrayDeque = this.myDeque;
            synchronized (arrayDeque) {
                this.myDeque.addFirst(listener);
                this.myDequeEmpty = this.myDeque.isEmpty();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(TreeModelListener listener) {
        if (listener != null && !this.myDequeEmpty) {
            ArrayDeque<TreeModelListener> arrayDeque = this.myDeque;
            synchronized (arrayDeque) {
                this.myDeque.remove(listener);
                this.myDequeEmpty = this.myDeque.isEmpty();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (!this.myDequeEmpty) {
            ArrayDeque<TreeModelListener> arrayDeque = this.myDeque;
            synchronized (arrayDeque) {
                this.myDeque.clear();
                this.myDequeEmpty = true;
            }
        }
    }

    public boolean isEmpty() {
        return this.myDequeEmpty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeModelListener[] get() {
        if (this.myDequeEmpty) {
            return EMPTY_ARRAY;
        }
        ArrayDeque<TreeModelListener> arrayDeque = this.myDeque;
        synchronized (arrayDeque) {
            return this.myDeque.toArray(EMPTY_ARRAY);
        }
    }

    @Override
    public void treeStructureChanged(TreeModelEvent event) {
        for (TreeModelListener listener : this.get()) {
            listener.treeStructureChanged(event);
        }
    }

    @Override
    public void treeNodesChanged(TreeModelEvent event) {
        for (TreeModelListener listener : this.get()) {
            listener.treeNodesChanged(event);
        }
    }

    @Override
    public void treeNodesInserted(TreeModelEvent event) {
        for (TreeModelListener listener : this.get()) {
            listener.treeNodesInserted(event);
        }
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent event) {
        for (TreeModelListener listener : this.get()) {
            listener.treeNodesRemoved(event);
        }
    }
}

