/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.editor.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.FileEditor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ipnb.editor.IpnbFileEditor;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbEditablePanel;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbFilePanel;
import org.jetbrains.plugins.ipnb.format.cells.IpnbCell;
import org.jetbrains.plugins.ipnb.format.cells.IpnbEditableCell;
import org.jetbrains.plugins.ipnb.format.cells.IpnbHeadingCell;

public class IpnbHeadingCellActionBase
extends AnAction {
    private final int myLevel;

    public IpnbHeadingCellActionBase(int level) {
        this.myLevel = level;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        DataContext context;
        FileEditor editor;
        if (event == null) {
            IpnbHeadingCellActionBase.$$$reportNull$$$0(0);
        }
        if ((editor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(context = event.getDataContext())) instanceof IpnbFileEditor) {
            this.changeTypeToHeading((IpnbFileEditor)editor);
        }
    }

    private void changeTypeToHeading(@NotNull IpnbFileEditor editor) {
        IpnbFilePanel filePanel;
        IpnbEditablePanel selectedCellPanel;
        if (editor == null) {
            IpnbHeadingCellActionBase.$$$reportNull$$$0(1);
        }
        if ((selectedCellPanel = (filePanel = editor.getIpnbFilePanel()).getSelectedCellPanel()) == null) {
            return;
        }
        IpnbCell cell = selectedCellPanel.getCell();
        List<IpnbCell> cells = filePanel.getIpnbFile().getCells();
        int index = cells.indexOf(selectedCellPanel.getCell());
        IpnbHeadingCell heading = new IpnbHeadingCell(((IpnbEditableCell)cell).getSource(), this.myLevel, ((IpnbEditableCell)cell).getMetadata());
        filePanel.executeUndoableCommand(() -> {
            if (index >= 0) {
                cells.set(index, heading);
            }
            filePanel.replaceComponent(selectedCellPanel, heading);
        }, "Change Cell Type To Heading " + this.myLevel);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ipnb/editor/actions/IpnbHeadingCellActionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "changeTypeToHeading";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

