/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy;

import com.github.markusbernhardt.proxy.ProxySearchStrategy;
import com.github.markusbernhardt.proxy.search.browser.firefox.FirefoxProxySearchStrategy;
import com.github.markusbernhardt.proxy.search.browser.ie.IEProxySearchStrategy;
import com.github.markusbernhardt.proxy.search.desktop.DesktopProxySearchStrategy;
import com.github.markusbernhardt.proxy.search.desktop.gnome.GnomeDConfProxySearchStrategy;
import com.github.markusbernhardt.proxy.search.desktop.gnome.GnomeProxySearchStrategy;
import com.github.markusbernhardt.proxy.search.desktop.kde.KdeProxySearchStrategy;
import com.github.markusbernhardt.proxy.search.desktop.win.WinProxySearchStrategy;
import com.github.markusbernhardt.proxy.search.env.EnvProxySearchStrategy;
import com.github.markusbernhardt.proxy.search.java.JavaProxySearchStrategy;
import com.github.markusbernhardt.proxy.selector.misc.BufferedProxySelector;
import com.github.markusbernhardt.proxy.selector.misc.ProxyListFallbackSelector;
import com.github.markusbernhardt.proxy.selector.pac.PacProxySelector;
import com.github.markusbernhardt.proxy.util.Logger;
import com.github.markusbernhardt.proxy.util.PlatformUtil;
import com.github.markusbernhardt.proxy.util.ProxyException;
import java.awt.GraphicsEnvironment;
import java.net.ProxySelector;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class ProxySearch
implements ProxySearchStrategy {
    private static final int DEFAULT_PAC_CACHE_SIZE = 20;
    private static final long DEFAULT_PAC_CACHE_TTL = 600000L;
    private static final BufferedProxySelector.CacheScope DEFAULT_PAC_CACHE_SCOPE = BufferedProxySelector.CacheScope.CACHE_SCOPE_HOST;
    private List<ProxySearchStrategy> strategies = new ArrayList<ProxySearchStrategy>();
    private int pacCacheSize = 20;
    private long pacCacheTTL = 600000L;
    private BufferedProxySelector.CacheScope pacCacheScope = DEFAULT_PAC_CACHE_SCOPE;

    public static ProxySearch getDefaultProxySearch() {
        ProxySearch s = new ProxySearch();
        boolean headless = GraphicsEnvironment.isHeadless();
        if (headless) {
            s.addStrategy(Strategy.JAVA);
            s.addStrategy(Strategy.OS_DEFAULT);
            s.addStrategy(Strategy.ENV_VAR);
        } else {
            s.addStrategy(Strategy.JAVA);
            s.addStrategy(Strategy.BROWSER);
            s.addStrategy(Strategy.OS_DEFAULT);
            s.addStrategy(Strategy.ENV_VAR);
        }
        Logger.log(ProxySearch.class, Logger.LogLevel.TRACE, "Using default search priority: {0}", s);
        return s;
    }

    public void addStrategy(Strategy strategy) {
        switch (strategy) {
            case OS_DEFAULT: {
                this.strategies.add(new DesktopProxySearchStrategy());
                break;
            }
            case BROWSER: {
                this.strategies.add(this.getDefaultBrowserStrategy());
                break;
            }
            case FIREFOX: {
                this.strategies.add(new FirefoxProxySearchStrategy());
                break;
            }
            case IE: {
                this.strategies.add(new IEProxySearchStrategy());
                break;
            }
            case ENV_VAR: {
                this.strategies.add(new EnvProxySearchStrategy());
                break;
            }
            case WIN: {
                this.strategies.add(new WinProxySearchStrategy());
                break;
            }
            case KDE: {
                this.strategies.add(new KdeProxySearchStrategy());
                break;
            }
            case GNOME: {
                this.strategies.add(new GnomeDConfProxySearchStrategy());
                this.strategies.add(new GnomeProxySearchStrategy());
                break;
            }
            case JAVA: {
                this.strategies.add(new JavaProxySearchStrategy());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown strategy code!");
            }
        }
    }

    public void setPacCacheSettings(int size, long ttl, BufferedProxySelector.CacheScope cacheScope) {
        this.pacCacheSize = size;
        this.pacCacheTTL = ttl;
        this.pacCacheScope = cacheScope;
    }

    private ProxySearchStrategy getDefaultBrowserStrategy() {
        switch (PlatformUtil.getDefaultBrowser()) {
            case IE: {
                return new IEProxySearchStrategy();
            }
            case FIREFOX: {
                return new FirefoxProxySearchStrategy();
            }
        }
        return null;
    }

    @Override
    public ProxySelector getProxySelector() {
        Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Executing search strategies to find proxy selector", new Object[0]);
        for (ProxySearchStrategy strat : this.strategies) {
            try {
                ProxySelector selector = strat.getProxySelector();
                if (selector != null) {
                    selector = this.installBufferingAndFallbackBehaviour(selector);
                    Logger.log(this.getClass(), Logger.LogLevel.INFO, "Proxy found for " + strat.getName(), new Object[0]);
                    return selector;
                }
                Logger.log(this.getClass(), Logger.LogLevel.INFO, "No proxy found for " + strat.getName() + ". Trying next one.", new Object[0]);
            }
            catch (ProxyException e) {
                Logger.log(this.getClass(), Logger.LogLevel.DEBUG, "Strategy {0} failed trying next one.", e);
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return "default";
    }

    private ProxySelector installBufferingAndFallbackBehaviour(ProxySelector selector) {
        if (selector instanceof PacProxySelector) {
            if (this.pacCacheSize > 0) {
                selector = new BufferedProxySelector(this.pacCacheSize, this.pacCacheTTL, selector, this.pacCacheScope);
            }
            selector = new ProxyListFallbackSelector(selector);
        }
        return selector;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Proxy search: ");
        for (ProxySearchStrategy strat : this.strategies) {
            sb.append(strat);
            sb.append(" ");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        ProxySearch ps = ProxySearch.getDefaultProxySearch();
        Logger.setBackend(new Logger.LogBackEnd(){

            @Override
            public void log(Class<?> clazz, Logger.LogLevel loglevel, String msg, Object ... params) {
                System.out.println(MessageFormat.format(msg, params));
            }

            @Override
            public boolean isLogginEnabled(Logger.LogLevel logLevel) {
                return true;
            }
        });
        ps.getProxySelector();
    }

    public static enum Strategy {
        OS_DEFAULT,
        BROWSER,
        FIREFOX,
        IE,
        ENV_VAR,
        WIN,
        KDE,
        GNOME,
        JAVA;

    }
}

