/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.diagnostic.logging.LogConsole;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.configurations.AdditionalTabComponentManager;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.LogFileOptions;
import com.intellij.execution.configurations.PredefinedLogFile;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.TargetAwareRunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.SmartList;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RunConfigurationBase
extends UserDataHolderBase
implements RunConfiguration,
TargetAwareRunProfile {
    private static final String LOG_FILE = "log_file";
    private static final String PREDEFINED_LOG_FILE_ELEMENT = "predefined_log_file";
    private static final String FILE_OUTPUT = "output_file";
    private static final String SAVE = "is_save";
    private static final String OUTPUT_FILE = "path";
    private static final String SHOW_CONSOLE_ON_STD_OUT = "show_console_on_std_out";
    private static final String SHOW_CONSOLE_ON_STD_ERR = "show_console_on_std_err";
    private final ConfigurationFactory myFactory;
    private final Project myProject;
    private String myName;
    private final Icon myIcon;
    private List<LogFileOptions> myLogFiles;
    private List<PredefinedLogFile> myPredefinedLogFiles;
    private boolean mySaveOutput;
    private boolean myShowConsoleOnStdOut;
    private boolean myShowConsoleOnStdErr;
    private String myFileOutputPath;
    private List<BeforeRunTask> myBeforeRunTasks;

    protected RunConfigurationBase(@NotNull Project project, @NotNull ConfigurationFactory factory, String name) {
        if (project == null) {
            RunConfigurationBase.$$$reportNull$$$0(0);
        }
        if (factory == null) {
            RunConfigurationBase.$$$reportNull$$$0(1);
        }
        this.myName = "";
        this.myLogFiles = new SmartList();
        this.myPredefinedLogFiles = new SmartList();
        this.mySaveOutput = false;
        this.myShowConsoleOnStdOut = false;
        this.myShowConsoleOnStdErr = false;
        this.myFileOutputPath = null;
        this.myBeforeRunTasks = Collections.emptyList();
        this.myProject = project;
        this.myFactory = factory;
        this.myName = name;
        this.myIcon = factory.getIcon();
    }

    @Override
    @Transient
    @NotNull
    public List<BeforeRunTask> getBeforeRunTasks() {
        List<BeforeRunTask> list = this.myBeforeRunTasks;
        if (list == null) {
            RunConfigurationBase.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    public void setBeforeRunTasks(@NotNull List<BeforeRunTask> value) {
        if (value == null) {
            RunConfigurationBase.$$$reportNull$$$0(3);
        }
        this.myBeforeRunTasks = value;
    }

    @Override
    public final ConfigurationFactory getFactory() {
        return this.myFactory;
    }

    @Override
    public final void setName(String name) {
        this.myName = name;
    }

    @Override
    @NotNull
    public final Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            RunConfigurationBase.$$$reportNull$$$0(4);
        }
        return project;
    }

    @Override
    public Icon getIcon() {
        return this.myIcon;
    }

    @Override
    @Transient
    public final String getName() {
        return this.myName;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public void checkRunnerSettings(@NotNull ProgramRunner runner, @Nullable RunnerSettings runnerSettings, @Nullable ConfigurationPerRunnerSettings configurationPerRunnerSettings) throws RuntimeConfigurationException {
        if (runner == null) {
            RunConfigurationBase.$$$reportNull$$$0(5);
        }
    }

    public void checkSettingsBeforeRun() throws RuntimeConfigurationException {
    }

    @Override
    public boolean canRunOn(@NotNull ExecutionTarget target) {
        if (target == null) {
            RunConfigurationBase.$$$reportNull$$$0(6);
        }
        return true;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public RunConfiguration clone() {
        RunConfigurationBase runConfiguration = (RunConfigurationBase)super.clone();
        runConfiguration.myLogFiles = new ArrayList<LogFileOptions>(this.myLogFiles);
        runConfiguration.myPredefinedLogFiles = new ArrayList<PredefinedLogFile>(this.myPredefinedLogFiles);
        runConfiguration.myFileOutputPath = this.myFileOutputPath;
        runConfiguration.mySaveOutput = this.mySaveOutput;
        runConfiguration.myShowConsoleOnStdOut = this.myShowConsoleOnStdOut;
        runConfiguration.myShowConsoleOnStdErr = this.myShowConsoleOnStdErr;
        this.copyCopyableDataTo(runConfiguration);
        this.myBeforeRunTasks = this.myBeforeRunTasks.isEmpty() ? Collections.emptyList() : new SmartList(this.myBeforeRunTasks);
        return runConfiguration;
    }

    @Nullable
    public LogFileOptions getOptionsForPredefinedLogFile(PredefinedLogFile predefinedLogFile) {
        return null;
    }

    public void removeAllPredefinedLogFiles() {
        this.myPredefinedLogFiles.clear();
    }

    public void addPredefinedLogFile(@NotNull PredefinedLogFile predefinedLogFile) {
        if (predefinedLogFile == null) {
            RunConfigurationBase.$$$reportNull$$$0(7);
        }
        this.myPredefinedLogFiles.add(predefinedLogFile);
    }

    @NotNull
    public List<PredefinedLogFile> getPredefinedLogFiles() {
        List<PredefinedLogFile> list = this.myPredefinedLogFiles;
        if (list == null) {
            RunConfigurationBase.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public ArrayList<LogFileOptions> getAllLogFiles() {
        ArrayList<LogFileOptions> list = new ArrayList<LogFileOptions>(this.myLogFiles);
        for (PredefinedLogFile predefinedLogFile : this.myPredefinedLogFiles) {
            LogFileOptions options = this.getOptionsForPredefinedLogFile(predefinedLogFile);
            if (options == null) continue;
            list.add(options);
        }
        ArrayList<LogFileOptions> arrayList = list;
        if (arrayList == null) {
            RunConfigurationBase.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    public List<LogFileOptions> getLogFiles() {
        List<LogFileOptions> list = this.myLogFiles;
        if (list == null) {
            RunConfigurationBase.$$$reportNull$$$0(10);
        }
        return list;
    }

    public void addLogFile(String file, String alias, boolean checked) {
        this.myLogFiles.add(new LogFileOptions(alias, file, checked, true, false));
    }

    public void addLogFile(String file, String alias, boolean checked, boolean skipContent, boolean showAll) {
        this.myLogFiles.add(new LogFileOptions(alias, file, checked, skipContent, showAll));
    }

    public void removeAllLogFiles() {
        this.myLogFiles.clear();
    }

    public void createAdditionalTabComponents(AdditionalTabComponentManager manager, ProcessHandler startedProcess) {
    }

    public void customizeLogConsole(LogConsole console) {
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        this.myLogFiles.clear();
        for (Element o : element.getChildren(LOG_FILE)) {
            LogFileOptions logFileOptions = new LogFileOptions();
            logFileOptions.readExternal(o);
            this.myLogFiles.add(logFileOptions);
        }
        this.myPredefinedLogFiles.clear();
        for (Element fileElement : element.getChildren(PREDEFINED_LOG_FILE_ELEMENT)) {
            PredefinedLogFile logFile = new PredefinedLogFile();
            logFile.readExternal(fileElement);
            this.myPredefinedLogFiles.add(logFile);
        }
        Element fileOutputElement = element.getChild(FILE_OUTPUT);
        if (fileOutputElement != null) {
            this.myFileOutputPath = fileOutputElement.getAttributeValue(OUTPUT_FILE);
            String isSave = fileOutputElement.getAttributeValue(SAVE);
            boolean bl = this.mySaveOutput = isSave != null && Boolean.parseBoolean(isSave);
        }
        if (!this.isNewSerializationUsed()) {
            this.myShowConsoleOnStdOut = Boolean.parseBoolean(element.getAttributeValue(SHOW_CONSOLE_ON_STD_OUT));
            this.myShowConsoleOnStdErr = Boolean.parseBoolean(element.getAttributeValue(SHOW_CONSOLE_ON_STD_ERR));
        }
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        JDOMExternalizerUtil.addChildren((Element)element, (String)LOG_FILE, this.myLogFiles);
        JDOMExternalizerUtil.addChildren((Element)element, (String)PREDEFINED_LOG_FILE_ELEMENT, this.myPredefinedLogFiles);
        if (this.myFileOutputPath != null || this.mySaveOutput) {
            Element fileOutputPathElement = new Element(FILE_OUTPUT);
            if (this.myFileOutputPath != null) {
                fileOutputPathElement.setAttribute(OUTPUT_FILE, this.myFileOutputPath);
            }
            if (this.mySaveOutput) {
                fileOutputPathElement.setAttribute(SAVE, String.valueOf(this.mySaveOutput));
            }
            element.addContent(fileOutputPathElement);
        }
        if (!this.isNewSerializationUsed()) {
            if (this.myShowConsoleOnStdOut) {
                element.setAttribute(SHOW_CONSOLE_ON_STD_OUT, String.valueOf(true));
            }
            if (this.myShowConsoleOnStdErr) {
                element.setAttribute(SHOW_CONSOLE_ON_STD_ERR, String.valueOf(true));
            }
        }
    }

    protected boolean isNewSerializationUsed() {
        return false;
    }

    @Transient
    public boolean isSaveOutputToFile() {
        return this.mySaveOutput;
    }

    public void setSaveOutputToFile(boolean redirectOutput) {
        this.mySaveOutput = redirectOutput;
    }

    @Attribute(value="show_console_on_std_out")
    public boolean isShowConsoleOnStdOut() {
        return this.myShowConsoleOnStdOut;
    }

    public void setShowConsoleOnStdOut(boolean showConsoleOnStdOut) {
        this.myShowConsoleOnStdOut = showConsoleOnStdOut;
    }

    @Attribute(value="show_console_on_std_err")
    public boolean isShowConsoleOnStdErr() {
        return this.myShowConsoleOnStdErr;
    }

    public void setShowConsoleOnStdErr(boolean showConsoleOnStdErr) {
        this.myShowConsoleOnStdErr = showConsoleOnStdErr;
    }

    @Transient
    public String getOutputFilePath() {
        return this.myFileOutputPath;
    }

    public void setFileOutputPath(String fileOutputPath) {
        this.myFileOutputPath = fileOutputPath;
    }

    public boolean collectOutputFromProcessHandler() {
        return true;
    }

    public boolean excludeCompileBeforeLaunchOption() {
        return false;
    }

    public boolean isCompileBeforeLaunchAddedByDefault() {
        return true;
    }

    public String toString() {
        return this.getType().getDisplayName() + ": " + this.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/RunConfigurationBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predefinedLogFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/RunConfigurationBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeforeRunTasks";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedLogFiles";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLogFiles";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setBeforeRunTasks";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkRunnerSettings";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canRunOn";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addPredefinedLogFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

