/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionGroupUtil {
    private static Presentation getPresentation(AnAction action, Map<AnAction, Presentation> action2presentation) {
        return action2presentation.computeIfAbsent(action, k -> action.getTemplatePresentation().clone());
    }

    @Deprecated
    public static boolean isGroupEmpty(@NotNull ActionGroup actionGroup, @NotNull AnActionEvent e) {
        if (actionGroup == null) {
            ActionGroupUtil.$$$reportNull$$$0(0);
        }
        if (e == null) {
            ActionGroupUtil.$$$reportNull$$$0(1);
        }
        return ActionGroupUtil.isGroupEmpty(actionGroup, e, new HashMap<AnAction, Presentation>(), false);
    }

    public static boolean isGroupEmpty(@NotNull ActionGroup actionGroup, @NotNull AnActionEvent e, boolean isInModalContext) {
        if (actionGroup == null) {
            ActionGroupUtil.$$$reportNull$$$0(2);
        }
        if (e == null) {
            ActionGroupUtil.$$$reportNull$$$0(3);
        }
        return ActionGroupUtil.isGroupEmpty(actionGroup, e, new HashMap<AnAction, Presentation>(), isInModalContext);
    }

    private static boolean isGroupEmpty(@NotNull ActionGroup actionGroup, @NotNull AnActionEvent e, @NotNull Map<AnAction, Presentation> action2presentation, boolean inModalContext) {
        AnAction[] actions;
        if (actionGroup == null) {
            ActionGroupUtil.$$$reportNull$$$0(4);
        }
        if (e == null) {
            ActionGroupUtil.$$$reportNull$$$0(5);
        }
        if (action2presentation == null) {
            ActionGroupUtil.$$$reportNull$$$0(6);
        }
        for (AnAction action : actions = actionGroup.getChildren(e)) {
            if (action instanceof Separator || !ActionGroupUtil.isActionEnabledAndVisible(action, e, inModalContext, action2presentation)) continue;
            if (action instanceof ActionGroup) {
                if (ActionGroupUtil.isGroupEmpty((ActionGroup)action, e, action2presentation, inModalContext)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Nullable
    public static AnAction getSingleActiveAction(@NotNull ActionGroup actionGroup, @NotNull AnActionEvent e, boolean isInModalContext) {
        List<AnAction> children;
        if (actionGroup == null) {
            ActionGroupUtil.$$$reportNull$$$0(7);
        }
        if (e == null) {
            ActionGroupUtil.$$$reportNull$$$0(8);
        }
        if ((children = ActionGroupUtil.getEnabledChildren(actionGroup, e, new HashMap<AnAction, Presentation>(), isInModalContext)).size() == 1) {
            return children.get(0);
        }
        return null;
    }

    private static List<AnAction> getEnabledChildren(@NotNull ActionGroup actionGroup, @NotNull AnActionEvent e, @NotNull Map<AnAction, Presentation> action2presentation, boolean isInModalContext) {
        AnAction[] actions;
        if (actionGroup == null) {
            ActionGroupUtil.$$$reportNull$$$0(9);
        }
        if (e == null) {
            ActionGroupUtil.$$$reportNull$$$0(10);
        }
        if (action2presentation == null) {
            ActionGroupUtil.$$$reportNull$$$0(11);
        }
        ArrayList<AnAction> result = new ArrayList<AnAction>();
        for (AnAction action : actions = actionGroup.getChildren(e)) {
            if (action instanceof ActionGroup) {
                if (!ActionGroupUtil.isActionEnabledAndVisible(action, e, isInModalContext, action2presentation)) continue;
                result.addAll(ActionGroupUtil.getEnabledChildren((ActionGroup)action, e, action2presentation, isInModalContext));
                continue;
            }
            if (action instanceof Separator || !ActionGroupUtil.isActionEnabledAndVisible(action, e, isInModalContext, action2presentation)) continue;
            result.add(action);
        }
        return result;
    }

    private static boolean isActionEnabledAndVisible(@NotNull AnAction action, @NotNull AnActionEvent e, boolean isInModalContext, @NotNull Map<AnAction, Presentation> action2presentation) {
        if (action == null) {
            ActionGroupUtil.$$$reportNull$$$0(12);
        }
        if (e == null) {
            ActionGroupUtil.$$$reportNull$$$0(13);
        }
        if (action2presentation == null) {
            ActionGroupUtil.$$$reportNull$$$0(14);
        }
        Presentation presentation = ActionGroupUtil.getPresentation(action, action2presentation);
        AnActionEvent event = new AnActionEvent(e.getInputEvent(), e.getDataContext(), e.getPlace(), presentation, ActionManager.getInstance(), e.getModifiers());
        event.setInjectedContext(action.isInInjectedContext());
        ActionUtil.performDumbAwareUpdate(isInModalContext, action, event, false);
        return presentation.isEnabled() && presentation.isVisible();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action2presentation";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/actionSystem/ActionGroupUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isGroupEmpty";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getSingleActiveAction";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getEnabledChildren";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "isActionEnabledAndVisible";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

